<?php

function create_Obj($arrConfig)
{
  $aFile = array_keys($arrConfig);
  $nFile = "css/" . $aFile[0] . ".css";
  
  /**
   *  verifica se  box
   */
  if(substr($aFile[0], 0, 3) == "box")
  {
   
    /**
     *  criar o css
     */
    $fp = fopen( $nFile , "wb");

    fwrite($fp, "<style type='text/css'>\n");

    fwrite($fp, "#" . $aFile[0] . "{\n");
    fwrite($fp, "  position: absolute;\n");
    foreach( $arrConfig[$aFile[0]] as $ind => $val )
    {
      fwrite($fp, "  " . $ind . ":" . $val .";\n");
    }
    fwrite($fp, "}\n");

    $arrLabel = $arrConfig['label'];
    foreach($arrLabel as $ind => $val)
    {
      //echo("<pre>");print_r( $arrConfig[ $ind ]); //exit;
      fwrite($fp, "#" . $aFile[0] . "_" . $ind ."{\n");
      fwrite($fp, "  position: absolute;\n");

      $arrPro = $arrConfig[ $ind ];
      foreach($arrPro as $ind_ => $val_)
      {
        fwrite($fp, "  " .$ind_ ." = ". $val_ . ";\n");
      }

      fwrite($fp, "}\n");
    }
    fwrite($fp, "</style>\n");

    fclose($fp);

    /**
     *  Criar o template
     */
    $nFile = "tpl/" . $aFile[0] . ".tpl.php";

    $fp = fopen( $nFile , "wb");
    //echo("<pre>");print_r( $arrConfig[$aFile[0]]); exit;
    fwrite($fp, "<div id=\"". $aFile[0] . "\">\n");

    $arrLabel = $arrConfig['label'];
    foreach($arrLabel as $ind => $val)
    {
      fwrite($fp, "  <label id=\"". $aFile[0] . "_" . $ind . "\">\n");
      fwrite($fp, "  " .$val. "\n");
      fwrite($fp, "  </label>\n");
    }

    fwrite($fp, "</div>\n");
    fclose($fp);

  }//End if(substr($aFile[0], 0, 3) == "box")

  
  /**
   *  verifica se  seta
   */
  if(substr($aFile[0], 0, 3) == "set")
  {
    //print_r($);exit;
    /**
     *  criar o css
     */
    $fp = fopen( $nFile , "wb");

    fwrite($fp, "<style type=\"text/css\">\n");

    fwrite($fp, "#" . $aFile[0] . "{\n");
    fwrite($fp, "  position: absolute;\n");

    $origem = $arrConfig[ $aFile[0] ]['origem'];
    $destino = $arrConfig[ $aFile[0] ]['destino'];

    $pad =   $arrConfig[ $aFile[0] ]['padding'];
    $arrPad = explode(":", $pad);
    $cor =   $arrConfig[ $aFile[0] ]['cor'];
    $tpo =   $arrConfig[ $aFile[0] ]['tipo'];
    $linha = $arrConfig[ $aFile[0] ]['linha'];
    $dir =   $arrConfig[ $aFile[0] ]['dir'];

    $boxOrig = readINIFile($origem . ".ini");
    $boxDest = readINIFile($destino . ".ini");

    $top1 = $boxOrig[$origem]['top'];
    $left1 = $boxOrig[$origem]['left'];
    $width1 = $boxOrig[$origem]['width'];
    $height1 = $boxOrig[$origem]['height'];

    $top2 = $boxDest[$destino]['top'];
    $left2 = $boxDest[$destino]['left'];
    $width2 = $boxDest[$destino]['width'];
    $height2 = $boxDest[$destino]['height'];

    
    if ($i = strpos($top1, "px")  !== false)
    {
      $top1 = substr( $top1, 0, (strlen($top1) - $i) +1 );
    }// End if ($i = strpos($top1, "px")  !== false)

    if ($i = strpos($top2, "px")  !== false)
    {
      $top2 = substr( $top2, 0, (strlen($top2) - $i) +1 );
    }// End if ($i = strpos($top2, "px")  !== false)

    if ($i = strpos($left1, "px")  !== false)
    {
      $left1 = substr( $left1, 0, (strlen($left1) - $i) +1 );
    }// End if ($i = strpos($left1, "px")  !== false)

    if ($i = strpos($left2, "px")  !== false)
    {
      $left2 = substr( $left2, 0, (strlen($left2) - $i) +1 );
    }// End if ($i = strpos($left2, "px")  !== false)

    if ($i = strpos($width1, "px")  !== false)
    {
      $width1 = substr( $width1, 0, (strlen($width1) - $i) +1 );
    }// End if ($i = strpos($width, "px")  !== false)

    if ($i = strpos($width2, "px")  !== false)
    {
      $width2 = substr( $width2, 0, (strlen($width2) - $i) +1 );
    }// End if ($i = strpos($width2, "px")  !== false)

    if ($i = strpos($height1, "px")  !== false)
    {
      $height1 = substr( $height1, 0, (strlen($height1) - $i) +1 );
    }// End if ($i = strpos($height1, "px")  !== false)

    if ($i = strpos($height2, "px")  !== false)
    {
      $height2 = substr( $height2, 0, (strlen($height2) - $i) +1 );
    }// End if ($i = strpos($height2, "px")  !== false)


    switch ($linha)
    {
      case 'media':
        $linha = "2px";
        break;
        
      case 'grossa':
        $linha = "3px";
        break;
        
      default:
        $linha = "1px";
    }//End switch ($linha)


    switch ($dir)
    {
      case 'top:top':
        break;
        
      case 'top:down':
        $l_t = "0px";
        $l_l = $linha;
        $l_r = "0px";
        $l_b = "0px";
        
        $top_seta = ($top2 + $height2);
        $left_seta = ($left1 + ($width1 * $arrPad[0] / 100));
        $width_seta = "1";
        
        if ($top_seta >= $top1)
        {
          $height_seta = ($top_seta - $top1);
        }else {
          $height_seta = ($top1 - $top_seta);
        }//End if ($top_seta >= $top2)
        
        break;

      case 'top:left':
        $l_t = $linha;
        $l_l = "0px";
        $l_r = $linha;
        $l_b = "0px";

        $top_seta = ($top1 + ($height1 * $arrPad[0] / 100));
        $left_seta = ($left1 + $width1);

        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2 + ($width2 * $arrPad[1] / 100));
        }else {
          $width_seta = ($left2 - $left_seta + ($width2 * $arrPad[1] / 100));
        }//End if($left_seta >= $left2)

        if($top_seta >= $top2)
        {
          $height_seta = ($top_seta - $top2);
        }else {
          $height_seta = ($top2 - $top_seta);
        }//End if($top_seta >= $top2)

        break;
        
      case 'top:right':
        $l_t = $linha;
        $l_l = $linha;
        $l_r = "0px";
        $l_b = "0px";

        $top_seta = ($top2 + ($height2 * $arrPad[1] / 100));
        $left_seta = ($left1 + ($width1 * $arrPad[0]/ 100));

        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2);
        }else {
          $width_seta = ($left2 - $left_seta);
        }//End if($left_seta >= $left2)


        if($top_seta >= $top1)
        {
          $height_seta = ($top_seta - $top1);
        }else {
           $height_seta = ($top1 - $top_seta);
        }//End if($top_seta - ($top2 / 2))

        break;

      case 'left:left':
        break;

      case 'left:right':
        $l_t = $linha;
        $l_l = "0px";
        $l_r = "0px";
        $l_b = "0px";

        $top_seta = ($top1 + ($height1 * $arrPad[0] / 100));
        $left_seta = ($left1 + $width1);

        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2);
        }else {
          $width_seta = ($left2 - $left_seta);
        }//End if($left_seta >= $left2)
        
        $height_seta = "1";
        break;

      case 'left:top':
        $l_t = $linha;
        $l_l = "0px";
        $l_r = $linha;
        $l_b = "0px";

        $top_seta = ($top1 + ($height1 * $arrPad[0] / 100));
        $left_seta = ($left1 + $width1);

        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2 + ($width2 * $arrPad[1] / 100));
        }else {
          $width_seta = ($left2 - $left_seta + ($width2 * $arrPad[1] / 100));
        }//End if($left_seta >= $left2)

        if($top_seta >= $top2)
        {
          $height_seta = ($top_seta - $top2);
        }else {
          $height_seta = ($top2 - $top_seta);
        }//End if($top_seta >= $top2)

        break;

      case 'left:down':
        $l_t = "0px";
        $l_l = "0px";
        $l_r = $linha;
        $l_b = $linha;

        $top_seta = ($top2 + $height1);
        $left_seta = ($left1 + $width1);
        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2 + ($width2 * $arrPad[0] / 100));
        }else {
          $width_seta = ($left2 - $left_seta + ($width2 * $arrPad[0] / 100));
        }//End if($left_seta >= $left2)
        
        if($top_seta >= $top1)
        {
          $height_seta = ($top_seta - $top1 + ($height1 * $arrPad[1] / 100));
        }else {
          $height_seta = ($top1 - $top_seta + ($height1 * $arrPad[1] / 100));
        }//End if($top_seta >= $top1)
        
        break;

      case 'right:right':
        break;

      case 'right:left':
        $l_t = $linha;
        $l_l = "0px";
        $l_r = "0px";
        $l_b = "0px";

        $top_seta = ($top1 + ($height1 * $arrPad[0] / 100));
        $left_seta = ($left1 + $width1);
      
        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2);
        }else {
          $width_seta = ($left2 - $left_seta);
        }//End if($left_seta >= $left2)

        $height_seta = "1";

        break;

      case 'right:top':
        $l_t = $linha;
        $l_l = $linha;
        $l_r = "0px";
        $l_b = "0px";

        $top_seta = ($top1 + ($height1 * $arrPad[0] / 100));
        $left_seta = ($left2 + ($width2 * $arrPad[1]/ 100));

        if($left_seta >= $left1)
        {
          $width_seta = ($left_seta - $left1);
        }else {
          $width_seta = ($left1 - $left_seta);
        }//End if($left_seta >= $left2)


        if($top_seta >= $top2)
        {
          $height_seta = ($top_seta - $top2);
        }else {
           $height_seta = ($top2 - $top_seta);
        }//End if($top_seta - ($top2 / 2))

        break;

      case 'right:down':
        $l_t = "0px";
        $l_l = $linha;
        $l_r = "0px";
        $l_b = $linha;

        $top_seta = ($top1 + $height1);
        $left_seta = ($left1 + ($width1 * $arrPad[0] / 100));

        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2);
        }else {
          $width_seta = ($left2 - $left_seta);
        }//End if($left_seta >= $left1)

        if($top_seta >= $top2)
        {
          $height_seta = ($top_seta - $top2 + ($height2 * $arrPad[1] / 100));
        }else {
          $height_seta = ($top2 - $top_seta + ($height2 * $arrPad[1] / 100));
        }//End if($top_seta >= $top1)

        break;

      case 'down:down':
        break;
        
      case 'down:top':
        $l_t = "0px";
        $l_l = $linha;
        $l_r = "0px";
        $l_b = "0px";

        $top_seta = ($top1 + $height1);
        $left_seta = ($left1 + ($width1 * $arrPad[0] / 100));
        $width_seta = "1";

        if ($top_seta >= $top2)
        {
          $height_seta = ($top_seta - $top2);
        }else {
          $height_seta = ($top2 - $top_seta);
        }//End if ($top_seta >= $top2)

        break;

      case 'down:left':
        $l_t = "0px";
        $l_l = "0px";
        $l_r = $linha;
        $l_b = $linha;

        $top_seta = ($top2 + $height1);
        $left_seta = ($left1 + $width1);

        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2 + ($width2 * $arrPad[0] / 100));
        }else {
          $width_seta = ($left2 - $left_seta + ($width2 * $arrPad[0] / 100));
        }//End if($left_seta >= $left2)
        
        if($top_seta >= $top1)
        {
          $height_seta = ($top_seta - $top1 + ($height1 * $arrPad[1] / 100));
        }else {
          $height_seta = ($top1 - $top_seta + ($height1 * $arrPad[0] / 100));
        }//End if($top_seta >= $top1)

        break;

      case 'down:right':
        $l_t = "0px";
        $l_l = $linha;
        $l_r = "0px";
        $l_b = $linha;

        $top_seta = ($top1 + $height1);
        $left_seta = ($left1 + ($width1 * $arrPad[0] / 100));
        
        if($left_seta >= $left2)
        {
          $width_seta = ($left_seta - $left2);
        }else {
          $width_seta = ($left2 - $left_seta);
        }//End if($left_seta >= $left1)
        
        if($top_seta >= $top2)
        {
          $height_seta = ($top_seta - $top2 + ($height2 * $arrPad[1] / 100));
        }else {
          $height_seta = ($top2 - $top_seta + ($height2 * $arrPad[1] / 100));
        }//End if($top_seta >= $top1)

        break;
        
        
      default:
        $l_t = "0px";
        $l_l = "0px";
        $l_r = "0px";
        $l_b = "0px";

        $top_seta = "0";
        $left_seta = "0";
        $width_seta = "0";
        $height_seta = "0";
        break;
        
    }//End switch ($dir)

   
    fwrite($fp, "  top: ". $top_seta ."px;\n");
    fwrite($fp, "  left: ". $left_seta ."px;\n");
    fwrite($fp, "  width: ". $width_seta ."px;\n");
    fwrite($fp, "  height: ". $height_seta ."px;\n");
//    fwrite($fp, "  background-color: #FFFFEC;\n");

    fwrite($fp, "  border-top: " . $l_t . " " . $tpo . " " . $cor . ";\n");
    fwrite($fp, "  border-right: " . $l_r . " " . $tpo . " " . $cor . ";\n");
    fwrite($fp, "  border-bottom: " . $l_b . " " . $tpo . " " . $cor . ";\n");
    fwrite($fp, "  border-left: " . $l_l . " " . $tpo . " " . $cor . ";\n");

    fwrite($fp, "}\n");
    fwrite($fp, "\n");

    fwrite($fp, "</style>\n");

    fclose($fp);


    /**
     *  Criar o template
     */
    $nFile = "tpl/" . $aFile[0] . ".tpl.php";

    $fp = fopen( $nFile , "wb");
    //echo("<pre>");print_r( $arrConfig['label']); exit;
    fwrite($fp, "<div id=\"". $aFile[0] . "\">\n");
    fwrite($fp, "</div>\n");
    fclose($fp);

  }//End if(substr($aFile[0], 0, 3) == "set")

}// End function create_Obj($var)



/**
 *  Le o arquivo .ini para um array associativo
 */
function readINIfile ( $filename, $commentchar = ';' )
{
  $filename = "config/" . $filename;
  if( file_exists( $filename ) )
  {
    $array1  = @file( $filename );
    $section = '';
    foreach ( $array1 as $filedata )
    {
     $dataline  = trim($filedata);
     $firstchar = substr($dataline, 0, 1);

     if ( $firstchar != $commentchar && $dataline != '' )
     {
       //It's an entry (not a comment and not a blank line)
       if ($firstchar == '[' && substr($dataline, -1, 1) == ']')
       {
         //It's a section
         $section = strtolower( substr( $dataline, 1, -1 ) );
       }else
       {
         //It's a key...
         $delimiter = strpos($dataline, '=');

         if ($delimiter > 0)
         {
           //...with a value
           $key   = strtolower( trim( substr($dataline, 0, $delimiter) ) );
           $value = trim( substr( $dataline, $delimiter + 1) );

           if ( substr($value, 1, 1) == '"' &&
                substr($value, -1, 1) == '"')
           {
             $value = substr($value, 1, -1);
           }
           $array2[$section][$key] = stripcslashes($value);
         }else
         {
           //...without a value
           $array2[$section][strtolower(trim($dataline))] = '';
         }
       }
     }else{
       //It's a comment or blank line.  Ignore.
     }
    }
  }else
  {
    $array2 = array();
  }
  return $array2;
}// End function();


function readFiles()
{
  $nDir = "config/";
  $arrFile = array();
  if ( file_exists( $nDir ) &&
       is_dir( $nDir )
     )
  {
    if ( $handle = opendir( $nDir ) )
    {
      $max = 0;
      while (false !== ($file = readdir($handle)))
      {
        if ( !is_dir( $nDir . $file ) )
        {
          $var = strpos($file, ".ini");
          if($var !== false)
          {
            $arrFile[] = $file;
          }
          
        }// End if()
      }// End while()
      closedir($handle);
      
    }// End if()
  }// End if ( file_exists($nDir) && is_dir($nDir) )

  return( $arrFile );
}// End function()

/**
 *  Cria objetos .ini
 */
function createConfig()
{
  $arr = read_File("config/", ".ini");
//  echo("<pre>");
//  print_r($arr);exit;
  foreach($arr as $ind => $nFile)
  {
/*
    switch( $nFile )
    {
      case "box0.ini":
      case "box1.ini":
      case "box2.ini":
      case "box3.ini":
      case "box4.ini":
      case "box5.ini":
      case "box6.ini":
      case "box7.ini":
      case "box8.ini":
      case "box9.ini":
      case "box10.ini":
      case "box11.ini":
      case "box12.ini":
      case "box13.ini":
      case "box14.ini":
      case "box15.ini":
      case "box16.ini":

      case "seta1.ini":
      case "seta2.ini":
      case "seta3.ini":
      case "seta4.ini":
      case "seta5.ini":
      case "seta6.ini":
      case "seta7.ini":
      case "seta8.ini":

      case "seta10.ini":
      case "seta11.ini":
      case "seta12.ini":
      case "seta13.ini":
      case "seta14.ini":

      case "seta15.ini":
*/
      create_Obj( readINIfile ( $nFile ) );
//    }
  }// End foreach($arr as $ind => $nFile)
  
}//End function createConfig()

/**
 *  Pega os arquivos .css
 */
function getCSS()
{
//  echo("<pre>");
  $arr_css = read_File("css/", ".css");
//  print_r($arr_css);

  foreach($arr_css as $ind => $nFile)
  {
    include( "css/" . $nFile );
  }
}//End function getCSS()

/**
 *  Pega os arquivos .tpl.php
 */
function getTemplate()
{
//  echo("<pre>");
  $arr = read_File("tpl/", ".tpl.php");
//  print_r($arr);

  foreach($arr as $ind => $nFile)
  {
    include( "tpl/" . $nFile );
  }
}//End function getTemplate()


function read_File( $nDir, $tpo)
{
  $arrFile = array();
  if ( file_exists( $nDir ) &&
       is_dir( $nDir )
     )
  {
    if ( $handle = opendir( $nDir ) )
    {
      $max = 0;
      while (false !== ($file = readdir($handle)))
      {
        if ( !is_dir( $nDir . $file ) )
        {
          $var = strpos($file, $tpo );
          if($var !== false)
          {
            $arrFile[] = $file;
          }//End if($var !== false)
        }// End if(!is_dir( $nDir . $file) )
      }// End while(false !== ($file = readdir($handle)))
      closedir($handle);

    }// End if( $handle = opendir( $nDir ) )
  }// End if ( file_exists($nDir) && is_dir($nDir) )

  return( $arrFile );
}// End function()
?>
