<?php 
/**
 *  create_dbGrid()
 *  ======================================================================= //
 */
function create_dbGrid( $dbgrid,
                        $dbgrid_Conf )
{
  global $modo_RAD;

  $path  = ( $modo_RAD )? _CFG_ : _CFG_;
  $dataSet = '';
  $nFile   = $path . $dbgrid . ".config.data.ini";
    
  $flagINI    = false; // indica se config.data.ini foi lido com sucesso
  $flagDTS    = false; // indica se dataSet foi lido com sucesso
  $flagConect = false; // indica se conexo com a tabela foi feita com sucesso
  $flagQuery  = false; // indica se a query foi executada com sucesso

  /**
   *  verifica se esta conectado a um dataSet
   *  ( a uma Table ou a uma Query )
   */
  if( empty($dbgrid_Conf['data_set'] ) )
  {
    /**
     *  dataSet padro  o Table
     */
    $dataSet = 'table';
      
    /**
     *  inicializa o dbGrid vazio
     */
    $arrINI = reset_arrINI_dbGrid( $dbgrid );
    writeINIfile( $nFile, $arrINI, ";", "");
  }else
  {
    /**
     *  verifica se o dataSet possui .config.data.ini configurado
     */
    $dataSet = $dbgrid_Conf['data_set'];
    $nFile_dataSet = $path . $dataSet . ".config.data.ini";
    
    if( file_exists( $nFile_dataSet ) )
    {
      $arrINI_dataSet = readINIfile( $nFile_dataSet );
      if( empty( $arrINI_dataSet[ $dataSet . '_data' ]['datasource'] ) )
      {
        echo('erro: dataSet no Configurado..');exit;
      }else
      {
        $flagDTS = true;
        $_dataSource_ = $arrINI_dataSet[ $dataSet . '_data' ]['datasource'];
        $_dataTabela_ = $arrINI_dataSet[ $dataSet . '_data' ]['tabela'];
//createConfigINI_dbGrid( $dbgrid, $dbgrid_Conf, $dataSet, $path );

        if( file_exists( $nFile ) )
        {
          $arrINI = readINIfile( $nFile );
          //echo"\n<pre>";print_r( $arrINI );exit;
          if( $arrINI[ $dbgrid . "_data" ][ 'datasource' ] != $_dataSource_ ||
              $arrINI[ $dbgrid . "_data" ][ 'tabela' ]     != $_dataTabela_
            )
          {
            //echo"erro: ".$arrINI[ $dbgrid . "_data" ][ 'datasource' ];exit;
            createConfigINI_dbGrid( $dbgrid, $dbgrid_Conf, $dataSet, $path );
          }// End
        }else
        {
          createConfigINI_dbGrid( $dbgrid, $dbgrid_Conf, $dataSet, $path );
        }// End if( file_exists( $nFile ) )
      }// End if( empty( $arrINI[ $dataSet . '_data' ]['datasource'] ) )
    }else
    {

    }// End if( file_exists( $nFile_dataSet ) )
  }// End if( empty($dbgrid_Conf['data_set'] ) )

  if( file_exists( $nFile ) )
  {
    $arrINI = readINIfile( $nFile );
    $flagINI = true;
  }// End if( file_exists( $nFile ) )
    
//echo("<pre>[$flagINI][$flagDTS] ".$nFile);print_r($arrINI_dataSet);exit;
  if( $flagINI )
  {
    /**
     *  Conexo com o Servidor MySql
     */
    if( $flagDTS )
    {
      $nFile_dataSource = $path . $_dataSource_ . ".config.data.ini";
      $arrINI_dataSource = readINIfile( $nFile_dataSource );
      /**
       *  tenta Conexo com o Banco
       */
      $host  = $arrINI_dataSource['db_conect']['host'];
      $user  = $arrINI_dataSource['db_conect']['user'];
      $pass  = $arrINI_dataSource['db_conect']['pass'];
      $dbase = $arrINI_dataSource['db_conect']['dbase'];

      /**
       *  Conecta com o SGDB
       */
      $flagConect = true;
      $con = mysql_connect( $host, $user )
        or $flagConect = false;
      $db = mysql_select_db( $dbase, $con)
        or $flagConect = false;
    }// End if( $flagDTS )

    if( $flagConect )
    {
      /**
       *  cria o SELECT de acordo com o config.data.ini
       */
      $arrField = $arrINI[ $dbgrid . '_field' ];
      $campos = '';
      $idx    = 1;
      $max    = count( $arrField );
      foreach( $arrField as $ind => $val )
      {
        if( $val == 'field' )
        {
          if( $idx > 1 )
            $campos .= ',';
          $ixField = $dbgrid . '_' . $ind;
          $campos .= $arrINI[ $ixField ][ 'field' ];
          $idx ++;
        }// End if( $val == 'field' )
      }// end foreach( $arrField as $ind => $val )
      
      //echo($idx.' : '.$max."\n");
      //echo($campos);exit;
      //$query = "SELECT " . $campos . " FROM " . $dbgrid_Conf['tabela'];
      $query = "SELECT " . $campos . " FROM " . $arrINI_dataSet[ $dataSet.'_data' ][ 'tabela' ];
          
      $result = mysql_query($query);
      $flagQuery = true;
    }// End if( $flagConect )
  }// End if( $flagINI )

  $nrLin = $dbgrid_Conf['linhas'];
  $nrCol = $dbgrid_Conf['colunas'];
    
  writeTO( '  ' );
  writeTO( '  <table id="' . $dbgrid . '_table" cellpadding="2" cellspacing="1">' );

  $arrCol = $arrINI[ $dbgrid . '_field' ];
/**
 *  Desenha a linha de Titulos
 *  ------------------------------------------------------------------------  //
 */
  if( $dbgrid_Conf['tipo'] == 'vertical' )
  {
    $ix = 1;
//echo("\n<pre>");print_r($arrCol);exit;
    foreach( $arrCol as $ind => $nome_ )
    {
      if( $arrINI[ $dbgrid . '_' . $ind ]['grid'] == 'visible' )
      {
        $nome = $arrINI[ $dbgrid . '_' . $ind ]['caption'];

        writeTO( '  <tr id="' . $dbgrid . '_tit">' );

        writeTO( '    <th id="' . $dbgrid . '_th_' . $ix . '" class="' . $dbgrid . '_tit">' );
        writeTO( '      <input id="' . $dbgrid . '_tit_' . $ix . '" ' );
        writeTO( '             type="text" readOnly="true" ' );
        writeTO( '             value="' . $nome . '" ' );
        writeTO( '              class="' . $dbgrid . '_col_'.$ix.'">'  );
        writeTO( '    </th>' );


//          writeTO( '    <td id="' . $dbgrid . '_th_' . $ix . '" class="' . $dbgrid . '_tit">' );
        writeTO( '    <td id="' . $dbgrid . '_td_' . $ix . '">' );
        writeTO( '      <input id="' . $dbgrid . '_col_' . $ix .  '"' );
        writeTO( '             type="text" readOnly="false" ' );
        writeTO( '             class="' . $dbgrid . '_col_' . $ix . '" ' );
//          writeTO( '             colName="'.$col_name . '" ' );
//          writeTO( '             value="'.$col_value . '" ' );
//          writeTO( '             tipoDado="'.$tipo_dado . '" ' );
        writeTO( '             />' );
        writeTO( '    </td>' );


        writeTO( '  </tr>' );
        $ix ++;
      }// End if( $arrINI[ $dataSet . '_' . $ind ]['grid'] == 'visible' )
    }// End foreach( $arrCol as $ind => $nome_ )
  }else
  {
    /**
     *  dbGrid tipo Horizontal  (default)
     */
    writeTO( '  <thead>' );
    writeTO( '  <tr id="' . $dbgrid . '_tit">' );
    writeTO( '    <th id="' . $dbgrid . '_th" class="' . $dbgrid . '_tit">' );
    writeTO( '      <span id="' . $dbgrid . '_num"' );
    writeTO( '            class="' . $dbgrid . '_col"> &nbsp; &nbsp; </span>' );
    writeTO( '    </th>' );

    $ix = 1;
    /**
     *  monta as colunas
     *  --------------------------------------------------------------------  //
     */
    foreach( $arrCol as $ind => $nome_ )
    {
      if( $arrINI[ $dbgrid . '_' . $ind ]['grid'] == 'visible' )
      {
        $nome = $arrINI[ $dbgrid . '_' . $ind ]['caption'];
        writeTO( '    <th id="' . $dbgrid . '_th_' . $ix . '" class="' . $dbgrid . '_tit">' );
        writeTO( '      <input id="' . $dbgrid . '_tit_' . $ix . '" ' );
        writeTO( '             type="text" readOnly="true" ' );
        writeTO( '             value="' . $nome . '" ' );
        writeTO( '              class="' . $dbgrid . '_col_'.$ix.'">'  );
        writeTO( '    </th>' );
        $ix ++;
      }// End if( $arrINI[ $dataSet . '_' . $ind ]['grid'] == 'visible' )
    }// End foreach( $arrCol as $ind => $nome_ )
    writeTO( '  </tr>' );
    writeTO( '  </thead>' );


  }
  writeTO( '  ' );

/**
 *  Desenha as linhas da Grid
 *  ------------------------------------------------------------------------  //
 */
//echo"$flagConect :: $flagQuery";exit;
  if( $flagConect )
  {
    if( $flagQuery )
    {
      $lin_ = 0;
      $tipo_dado = "texto";
//echo"\n<pre>";print_r($arrINI);exit;
      if( $dbgrid_Conf['tipo'] == 'vertical' )
      {

      }else
      {
        writeTO( '  <tbody id="' . $dbgrid . '_tBody">' );
        while ($line = mysql_fetch_array($result, MYSQL_ASSOC))
        {
          $lin_ ++;
          writeTO( '    <tr id="' . $dbgrid . '_lin_'.$lin_.'">' );
          /**
           *  coluna da numerao
           */
          writeTO( '      <th id="' . $dbgrid . '_th_'.$lin_.'" class="' . $dbgrid . '_tit">' );
          writeTO( '        <span id="' . $dbgrid . '_num_'.$lin_.'"' );
          writeTO( '              class="' . $dbgrid . '_col">' . $lin_ . '</span>' );
          writeTO( '      </th>' );

          $ix = 1;
          // foreach ($line as $col_name=>$col_value)
          foreach( $arrCol as $ind => $nome_ )
          {
            if( $arrINI[ $dbgrid . '_' . $ind ]['grid'] == 'visible' )
            {
              $col_name  = $arrINI[ $dbgrid . '_' . $ind ]['field'];

              switch( $arrINI[ $dbgrid . '_field' ][$ind] )
              {
                case 'field':
                  $col_value = $line[$col_name];
                  break;
                case 'calculado':
                  $col_value = 'calc';
                  break;
                case 'lookup':
                  $nTab = $arrINI[ $dataSet . '_' . $ind ]['tabela'];
                  $nKey = $arrINI[ $dataSet . '_' . $ind ]['field_key'];
                  $nVal = $line[ $nKey ];
                  $nGet = $arrINI[ $dataSet . '_' . $ind ]['field'];
                  $col_value = lookUP( $nTab, $nKey, $nVal, $nGet );
                  break;
                default:
                  $col_value = ' ';
                  break;
              }// End switch( $arrINI[ $dataSet . '_field' ][$ind] )
            
              writeTO( '      <td id="' . $dbgrid . '_td_'.$lin_.'_' . $ix . '">' );
              writeTO( '        <input id="' . $dbgrid . '_col_' . $lin_ . '_' . $ix .  '"' );
              writeTO( '               type="text" readOnly="true" ' );
              writeTO( '               class="' . $dbgrid . '_col_' . $ix . '" ' );
              writeTO( '               colName="'.$col_name . '" ' );
              writeTO( '               value="'.$col_value . '" ' );
              writeTO( '               tipoDado="'.$tipo_dado . '" ' );
              writeTO( '               />' );
              writeTO( '      </td>' );
              $ix ++;
            }// End if( $arrINI[ $dataSet . '_' . $ind ]['grid'] == 'visible' )
          }// End foreach ($line as $col_name=>$col_value)
      
          writeTO( '    </tr>' );
          writeTO( '  ' );
        }// End while ($line = mysql_fetch_array($result, MYSQL_ASSOC))
        writeTO( '  </tbody>' );
      }// End if( $dbgrid_Conf['tipo'] == 'vertical' )
      
      
      
      
      
    }// End if( $flagQuery )
  }// End if( $flagConect)
  writeTO( '  </table>' );
  writeTO( '  ' );
}// End create_dbGrid()
  
  
/**
 *  create_dbGrid_css()
 *  ------------------------------------------------------------------------  //
 */
  function create_dbGrid_css( $dbgrid,
                              $dbgrid_Global,
                              $dbgrid_Style,
                              $dbgrid_Conf,
                              $flag_dbGrid )
  {
    global $projeto,
           $esquema,
           $modo_RAD;
    $nrCol = $dbgrid_Conf['colunas'];
    $path  = ( $modo_RAD )? _CFG_ : _CFG_;
    $nFile = $path . $dbgrid . ".config.data.ini";

    if( $dbgrid_Global['visibility'] == 'visible' )
    {
      $visible = 'inherit';
    }else
    {
      $visible = 'hidden';
    }// End
    
    if( empty($dbgrid_Conf['data_set'] ) )
    {
      /**
       *  inicializa o dbGrid vazio
       */
      $arrINI = reset_arrINI_dbGrid( $dbgrid );
    }else
    {
      $nFile = $path . $dbgrid . ".config.data.ini";
      //echo"com data_set";//exit;
      if( file_exists( $nFile ) )
      {
        $arrINI = readINIfile( $nFile );
        $flagINI = true;
        //echo('<pre>');print_r($arrINI);exit;
      }// End

    }// End

/**
 *  declara o CSS do dbGrid
 *  ------------------------------------------------------------------------  //
 */
    writeTO( '  #' . $dbgrid . '{ '                           );
    writeTO( '    position:absolute; '                        );
    writeTO( '    top:' . $dbgrid_Global['top'] . 'px;'       );
    writeTO( '    left:' . $dbgrid_Global['left'] . 'px;'     );
    writeTO( '    '                                           );
    writeTO( '    z-index:100;'                               );
    writeTO( '    '                                           );
    writeTO( '    width:' . $dbgrid_Global['width'] . 'px;'   );
    writeTO( '    height:' . $dbgrid_Global['height'] . 'px;' );
    writeTO( '    '                                                   );
    writeTO( '    visibility:' . $visible . ';'   );
    writeTO( '    overflow:auto;'                                     );
    writeTO( '    padding:1px;'                                       );
    writeTO( '    padding-bottom:0px;'                                );
    writeTO( '    '                                                   );
    writeTO( '    background-color:' . $dbgrid_Style['BgColor'] . ';' );
    writeTO( '    '                                                   );
    writeTO( '    border-top:'   .$dbgrid_Style['boxTop'].';'         );
    writeTO( '    border-bottom:'.$dbgrid_Style['boxBottom'].';'      );
    writeTO( '    border-left:'  .$dbgrid_Style['boxLeft'].';'        );
    writeTO( '    border-right:' .$dbgrid_Style['boxRight'].';'       );
    writeTO( '    }'                                                  );
    writeTO( '    '                                                   );
    writeTO( '  #' . $dbgrid . '_table { '                            );
    writeTO( '    background-color:'.$dbgrid_Style['boxBgColor'].';'  );
//    writeTO( '    width:' . $dbgrid_Global['width'] . 'px;'   );
//    writeTO( '    height:' . $dbgrid_Global['height'] . 'px;' );
    writeTO( '    }'                                                  );
    writeTO( '  #' . $dbgrid . '_table th{ '                          );
    writeTO( '    padding:0px;'                                         );
    writeTO( '    font:' . $dbgrid_Global['fontFamily'] . ';'         );
    writeTO( '    font-size:' . $dbgrid_Global['fontSize'] . 'px;'    );
    writeTO( '    background-color:' . $dbgrid_Style['borderBgColor'] . ';' );
    writeTO( '    }'                                                        );
    writeTO( '    '                                                         );
    writeTO( '  #' . $dbgrid . '_table tr{ '                                );
    writeTO( '    font-size:' . $dbgrid_Global['fontSize'] . 'px;'          );
    writeTO( '    background-color:'.$dbgrid_Style['borderBgColor'].';'     );
    writeTO( '    }'                                                        );
    writeTO( '    '                                                         );
    writeTO( '  #' . $dbgrid . '_table td{ '                                );
//    writeTO( '    margin:10px;'                                             );
    writeTO( '    padding:0px;'                                         );
//    writeTO( '    padding-left:5px;'                                        );
//    writeTO( '    padding-bottom:1px;'                                      );
//    writeTO( '    padding-right:5px;'                                       );
    writeTO( '    }'                                                        );
    writeTO( '    '                                                         );

/**
 *  declara a definio das colunas
 *  ------------------------------------------------------------------------  //
 */
    if( $dbgrid_Conf['tipo'] == 'vertical' )
    {
    }else
    {
      writeTO( '  .' . $dbgrid . '_col{ '                                );
      writeTO( '    width:50px;'                                              );
      writeTO( '    text-align:right;'                                        );
      writeTO( '    overflow:hidden;'                                         );
      writeTO( '    }'                                                        );

      $arrCol = $arrINI[ $dbgrid . '_field' ];
      $ix = 1;
      foreach( $arrCol as $ind => $nome_ )
      {
        if( $arrINI[ $dbgrid . '_' . $ind ]['grid'] == 'visible' )
        {
          $len = $arrINI[ $dbgrid . '_' . $ind ]['size'];
          $align = $arrINI[ $dbgrid . '_' . $ind ]['align'];

          writeTO( '  .' . $dbgrid . '_col_' . $ix . '{ '                         );
          writeTO( '    width:' . $len . 'px;'                                    );
          writeTO( '    text-align:' . $align . ';'                               );
          writeTO( '    overflow:hidden;'                                         );
          writeTO( '    background-color:#FFFFFF;'                                );
          writeTO( '    padding:1px;'                                             );
          writeTO( '    padding-left:5px;'                                        );
          writeTO( '    padding-bottom:1px;'                                      );
          writeTO( '    padding-right:5px;'                                       );
          writeTO( '    border:0px;'                                              );
          writeTO( '    }'                                                        );
          writeTO( '    '                                                         );

          writeTO( '  #' . $dbgrid . '_tit_'.$ix.'{ '                                      );
          writeTO( '    height:15px;' );
          writeTO( '    color:#0000FF;'                                             );
          writeTO( '    text-align:center;'                                         );
          writeTO( '    background-color:'.$dbgrid_Style['borderBgColor'].';'     );

          writeTO( '    padding:0px;'                                         );
          writeTO( '    font:' . $dbgrid_Global['fontFamily'] . ';'         );
          writeTO( '    font-size:' . $dbgrid_Global['fontSize'] . 'px;'    );
          writeTO( '    font-weight:bold;'    );
          writeTO( '    }'                                                          );

          $ix ++;
        }// End if( $arrINI[ $dbgrid . '_' . $ind ]['grid'] == 'visible' )
      }// End foreach( $arrCol as $ind => $nome_ )
    
      writeTO( '  .' . $dbgrid . '_tit_{ '                                      );
      writeTO( '    color:#0000FF;'                                             );
      writeTO( '    text-align:center;'                                         );
      writeTO( '    }'                                                          );
      writeTO( '  .' . $dbgrid . '_tit{ '                                       );
      writeTO( '    border-top:'   .$dbgrid_Style['borderTop'].';'              );
      writeTO( '    border-bottom:'.$dbgrid_Style['borderBottom'].';'           );
      writeTO( '    border-left:'  .$dbgrid_Style['borderLeft'].';'             );
      writeTO( '    border-right:' .$dbgrid_Style['borderRight'].';'            );
      writeTO( '    }'                                                          );
    }// End if( $dbgrid_Conf[] == 'vertical' )
  }// End create_dbGrid_css()
  

/**
 *  create_dbGrid_control()
 *  ------------------------------------------------------------------------  //
 */
function create_dbGrid_control( $modo_RAD )
{
  global $componentes_no_Prj,
         $projeto,
         $esquema;

  $path  = ( defined('STUDIO') )? _CFG_ : _CFG_;

  $nDest = $path . "dbgrid.control.js.php";
  $comp  = $componentes_no_Prj;

  $arrPK = array();
  $arrDataSet = array();

  $fp = @fopen( $nDest, 'wb' );
  foreach( $comp as $comp_ => $obj_ )
  {
    if( $comp_ == 'dbgrid' )
    {
      $nrObj  = 0;
      $arrObj = array();
      $arrConf = array();

      /**
       *  Lista das Propriedades
       */
      $dbgrid_colunas = array();

/**
 *  conta o numero de objetos dbGrid no projeto e armazena:
 *  -> nome de cada Objetos no array $arrObj
 *  -> numero de colunas do objeto no array $dbgrid_colunas
 */
        // conta objetos dbGrid
        foreach( $obj_ as $i_nObj => $v_ )
        {
          $arrObj[ $nrObj ] = $i_nObj;
          /**
           *  inclui o arquivo .config.def.php de cada Objeto
           */
          include( $path . $i_nObj . ".config.def.php" );
          $nConf_ = $i_nObj . "_Conf";
          $arrConf[ $i_nObj ] = $$nConf_;
          
          //le o arquivo .config.data.ini
          $nFile = $path . $i_nObj . ".config.data.ini";
          if( file_exists( $nFile ) )
          {
            $arrINI = readINIfile( $nFile );
          }else
          {
            /**
             *  inicializa o dbGrid vazio
             */
            $arrINI = reset_arrINI_dbGrid( $dbgrid );
          }// End
//echo"\n<pre>".count($arrINI[ $i_ . '_field'])."\n";
//echo"\n<pre>";
//print_r($arrINI);exit;
//print_r($arrINI[ $dataSet."_field" ]);
//print_r($arrINI[ $i_nObj . '_field']);exit;
          $arrField = $arrINI[ $i_nObj . '_field'];
          $nro = 0;
          foreach( $arrField as $_ii_ => $_vv_ )
          {
//print_r( $arrINI[$i_nObj . '_' . $_ii_ ][ 'grid' ] );exit;
//print_r( $arrField[$i_nObj . '_' . $_ii_ ][ 'grid' ] );exit;
            if( $arrINI[$i_nObj . '_' . $_ii_ ][ 'grid' ] == 'visible'  )
            {
              $nro ++;
            }
          }
          $dbgrid_colunas[ $i_nObj ] = $nro;
          $arrPK[ $nrObj ]           = $arrINI[ $i_nObj . '_data']['pk'];
          $arrDataSet[ $nrObj ]      = $arrINI[ $i_nObj . '_data']['dataset'];

          $nrObj ++;
        }// End
//exit;

/**
 * escreve o cabealho do .config.data.ini  --------------------------------  //
 */
        writeTO( 'dbgrid_obj = '. $nrObj .';',           $fp );
        writeTO( ' ',                                    $fp );
        writeTO( 'dbgrid_dataset = new Array();',        $fp );
        writeTO( 'dbgrid_enabled = new Array();',        $fp );
        writeTO( 'dbgrid_edit = new Array();',           $fp );
        writeTO( 'dbgrid_pk = new Array();',             $fp );
        writeTO( ' ',                                    $fp );
        writeTO( 'dbgrid_linha_corrente = new Array();', $fp );
        writeTO( 'dbgrid_modo_edit = new Array();',      $fp );
        writeTO( 'dbgrid_nr_coluna = new Array();',      $fp );
        writeTO( ' ',                                    $fp );

/**
 *  escreve propriedade enable  --------------------------------------------  //
 */
        $idx = 0;
        foreach( $arrConf as $ind => $val)
        {
          writeTO( 'dbgrid_enabled['.$idx . '] = '  . $val['enable'] .';', $fp );
          $idx ++;
        }// End foreach($arrConf as $ind => $val)
        writeTO( " ", $fp );

/**
 *  propriedade dataSet  ---------------------------------------------------  //
 */
        $idx = 0;
        foreach( $arrDataSet as $ind => $val)
        {
          writeTO( 'dbgrid_dataset['.$idx . '] = "'  . $val .'";', $fp );
          $idx ++;
        }// End foreach($arrConf as $ind => $val)
        writeTO( " ", $fp );


/**
 *  propriedade edit
 *  ------------------------------------------------------------------------  //
 */
        $idx = 0;
        foreach( $arrConf as $ind => $val)
        {
          writeTO( 'dbgrid_edit['.$idx . '] = '  . $val['edit'] .';', $fp );
          $idx ++;
        }// End foreach($arrConf as $ind => $val)
        writeTO( " ", $fp );

/**
 *  propriedade PK (Primary Key)
 *  ------------------------------------------------------------------------  //
 */
        $idx = 0;
        foreach( $arrPK as $ind => $val)
        {
          writeTO( 'dbgrid_pk['.$idx . '] = "'  . $val .'";', $fp );
          $idx ++;
        }// End foreach($arrConf as $ind => $val)
        writeTO( " ", $fp );

/**
 *  numero da linha corrente
 *  ------------------------------------------------------------------------  //
 *  =0 => indica sem linha corrente
 *  >0 => indica numero da linha
 */
        $idx = 0;
        foreach( $arrObj as $ind => $val)
        {
          writeTO( 'dbgrid_linha_corrente['.$idx . '] = 0;', $fp );
          $idx ++;
        }// End foreach($arrConf as $ind => $val)
        writeTO( " ", $fp );

        /**
         *  modo de edio
         *  =0 => indica modo list
         *  >0 => indica numero da coluna em edio
         */
        $idx = 0;
        foreach( $arrObj as $ind => $val)
        {
          writeTO( 'dbgrid_modo_edit['.$idx . '] = 0;', $fp );
          $idx ++;
        }// End foreach($arrConf as $ind => $val)
        writeTO( " ", $fp );

        /**
         *  numero de colunas na grid
         */

//echo("\n<pre>");print_r($dbgrid_colunas);exit;
/**
 *  numero de Colunas da Grid
 *  ------------------------------------------------------------------------  //
 */
        $idx = 0;
        foreach( $arrObj as $ind => $val)
        {
          writeTO( 'dbgrid_nr_coluna[' . $idx . '] = ' . $dbgrid_colunas[$val] . ';', $fp );
          $idx ++;
        }// End foreach($arrConf as $ind => $val)
        writeTO( " ", $fp );

      }// End
    }// End

  fclose( $fp );

  return( $nDest );
}// End


/**
 *  Funes Auxiliares
 *  ------------------------------------------------------------------------  //
 */
function lookUP( $nTab, $nKey, $nVal, $nGet )
{
  $query = "SELECT " . $nGet . " FROM " . $nTab . " WHERE " . $nKey . " = '" . $nVal . "'";
  $result = mysql_query($query);
  if( $result )
  {
    $line = mysql_fetch_array($result, MYSQL_ASSOC);
  }
//echo $line[ $nGet ];exit;
  return( $line[ $nGet ] );
}// End function lookUP( $nTab, $nKey, $nVal )

/**
 *  Conta o numero de Colunas na Grid
 */
function countCol( $arrINI, $dataSet )
{
  $nrCol = 0;
  $arrField = $arrINI[ $dataSet . "_field" ];
  foreach( $arrField as $_i_ => $_v_ )
  {
    $grid = $arrINI[$dataSet.'_'.$_i_]['grid'];
    if( $grid == 'visible' )
    {
      $nrCol ++;
    }// End if( $grid == 'visible' )
  }// End foreach( $arrField as $_i_ => $_v_ )
  return $nrCol;
}// End function countCol( $arrField )


/**
 *  createConfigINI_dbGrid()
 *  ------------------------------------------------------------------------  //
 *  cria o arquivo .config.data.ini
 *  ------------------------------------------------------------------------  //
 */
function createConfigINI_dbGrid( $dbgrid_, $dbgrid_Conf_, $dataSet_, $path_ )
{
  $arrINI         = array();
  $nFile          = $path_ . $dbgrid_  . ".config.data.ini";
  $nFile_dataSet  = $path_ . $dataSet_ . ".config.data.ini";
  $arrINI_dataSet = readINIfile( $nFile_dataSet );
//echo("\n<pre>".$nFile_dataSet);print_r( $arrINI_dataSet );exit;

  $_ix_ = $dataSet_ . "_field";
  $_id_ = $dataSet_ . "_data";
  
  $arrINI[ $dbgrid_ . '_data' ][ 'dataset' ] = $dataSet_;
  //writeINIfile( $nFile, $arrINI, ";", "");
  //exit;
  $arrINI[ $dbgrid_ . '_data' ][ 'datasource' ] = $arrINI_dataSet[ $_id_ ][ 'datasource' ];
  $arrINI[ $dbgrid_ . '_data' ][ 'tabela' ] = $arrINI_dataSet[ $_id_ ][ 'tabela' ];
  $arrINI[ $dbgrid_ . '_data' ][ 'pk' ] = $arrINI_dataSet[ $_id_ ][ 'pk' ];
  $a_field = $arrINI_dataSet[ $_ix_ ];
//echo("\n$dataSet_<pre>");print_r($a_field);exit;
  foreach( $a_field as $i => $field_ )
  {
    $_ii_ = $dataSet_ . '_' . $field_;
    //echo("\n$i \n");
    //print_r( $fields );
    $arrINI[ $dbgrid_ . '_field'][ $field_ ] = 'field';
//    $arrINI[ $table . '_field'][$nx_] = $fields['Field'];
    $arrINI[ $dbgrid_ . '_' . $field_ ]['field']   = $arrINI_dataSet[$_ii_]['field'];
    $arrINI[ $dbgrid_ . '_' . $field_ ]['grid']    = 'visible';
    $arrINI[ $dbgrid_ . '_' . $field_ ]['caption'] = $arrINI_dataSet[$_ii_]['field'];
    $arrINI[ $dbgrid_ . '_' . $field_ ]['size']    = '100';
    $arrINI[ $dbgrid_ . '_' . $field_ ]['align']   = 'left';
    $arrINI[ $dbgrid_ . '_' . $field_ ]['type']    = $arrINI_dataSet[$_ii_]['type'];
  }// End foreach( $arrDescTable['fields'] as $i=>$fields )
  writeINIfile( $nFile, $arrINI, ";", "");
  
}// End function createConfigINI_dbGrid( $nTabela, $nFile, $table, $table_Conf )


/**
 *  reset_arrINI_dbGrid()
 *  ------------------------------------------------------------------------  //
 */
function reset_arrINI_dbGrid( $dbgrid_ )
{
  $arrINI = array();
  $arrINI[ $dbgrid_ . '_data']['dataset'] = ' ' ;
  $arrINI[ $dbgrid_ . '_data']['datasource'] = ' ' ;
  $arrINI[ $dbgrid_ . '_data']['tabela'] = ' ' ;
  $arrINI[ $dbgrid_ . '_data']['pk'] = ' ' ;
  $arrINI[ $dbgrid_ . '_field']['field1'] = 'field' ;

  $arrINI[ $dbgrid_ . '_field1']['field']   = ' ';
  $arrINI[ $dbgrid_ . '_field1']['grid']    = ' visible ';
  $arrINI[ $dbgrid_ . '_field1']['caption'] = ' &nbsp;&nbsp; &nbsp;&nbsp; ';
  $arrINI[ $dbgrid_ . '_field1']['size']    = '100';
  $arrINI[ $dbgrid_ . '_field1']['align']   = 'left';
  $arrINI[ $dbgrid_ . '_field1']['type']    = 'texto';
  return( $arrINI );
}// End


?> 
