CREATE TABLE st_browser (
   ID int(5) DEFAULT '0' NOT NULL,
   browser varchar(25) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (browser, ID)
);

CREATE TABLE st_colors (
   ID int(5) DEFAULT '0' NOT NULL,
   colors varchar(6) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (colors, ID)
);

CREATE TABLE st_day (
   ID int(5) DEFAULT '0' NOT NULL,
   day int(2) DEFAULT '0' NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (day, ID)
);

CREATE TABLE st_host (
   ID int(5) DEFAULT '0' NOT NULL,
   host varchar(100) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (ID, host)
);

CREATE TABLE st_hour (
   ID int(5) DEFAULT '0' NOT NULL,
   hour int(2) DEFAULT '0' NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (hour, ID)
);

CREATE TABLE st_ip (
   ID int(5) DEFAULT '0' NOT NULL,
   IPBereich varchar(11) NOT NULL,
   UserAgent text NOT NULL,
   time int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (IPBereich, ID)
);

CREATE TABLE st_last (
   ID int(5) DEFAULT '0' NOT NULL,
   time int(10) DEFAULT '0' NOT NULL,
   IP varchar(15) DEFAULT '0' NOT NULL,
   hostname varchar(40) NOT NULL,
   language varchar(10) NOT NULL,
   browser varchar(20) NOT NULL,
   system varchar(20) NOT NULL,
   referer varchar(100) NOT NULL,
   link int(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (time, IP, ID)
);

CREATE TABLE st_month (
   ID int(5) DEFAULT '0' NOT NULL,
   month int(2) DEFAULT '0' NOT NULL,
   year int(4) DEFAULT '0' NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (month, ID, year)
);

CREATE TABLE st_query (
   ID int(5) DEFAULT '0' NOT NULL,
   query varchar(250) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (ID, query)
);

CREATE TABLE st_referer (
   ID int(5) DEFAULT '0' NOT NULL,
   referer varchar(100) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (referer, ID)
);

CREATE TABLE st_resolution (
   ID int(5) DEFAULT '0' NOT NULL,
   resolution varchar(6) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (resolution, ID)
);

CREATE TABLE st_search (
   ID int(5) DEFAULT '0' NOT NULL,
   search varchar(40) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (search, ID)
);

CREATE TABLE st_sengine (
   sengine varchar(70) NOT NULL,
   keystring varchar(20) NOT NULL,
   PRIMARY KEY (sengine)
);

CREATE TABLE st_site (
   ID int(5) DEFAULT '0' NOT NULL,
   month int(2) DEFAULT '0' NOT NULL,
   year int(4) DEFAULT '0' NOT NULL,
   site varchar(100) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (month, site, year, ID)
);

CREATE TABLE st_stat (
   ID int(5) DEFAULT '0' NOT NULL,
   aktmonth int(2) DEFAULT '0' NOT NULL,
   uni int(10) DEFAULT '0' NOT NULL,
   total int(10) DEFAULT '0' NOT NULL,
   javascript int(10) DEFAULT '0' NOT NULL,
   nojavascript int(10) DEFAULT '0' NOT NULL,
   tophitsd int(10) DEFAULT '0' NOT NULL,
   topday varchar(10) NOT NULL,
   tophitsm int(2) DEFAULT '0' NOT NULL,
   topmonth varchar(7) DEFAULT '0' NOT NULL,
   PRIMARY KEY (ID)
);

CREATE TABLE st_system (
   ID int(5) DEFAULT '0' NOT NULL,
   system varchar(25) NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (system, ID)
);

CREATE TABLE st_tld (
   ID int(5) DEFAULT '0' NOT NULL,
   tld varchar(10) NOT NULL,
   kontinent char(3) DEFAULT '0' NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (tld, ID)
);

CREATE TABLE st_wday (
   ID int(5) DEFAULT '0' NOT NULL,
   wday int(2) DEFAULT '0' NOT NULL,
   hits int(10) DEFAULT '0' NOT NULL,
   PRIMARY KEY (wday, ID)
);

CREATE TABLE st_listdomains (
  kontinent char(11) NOT NULL default '',
  domain char(20) NOT NULL default '',
  description char(50) NOT NULL default '',
  PRIMARY KEY  (domain)
) TYPE=MyISAM;

INSERT INTO st_listdomains VALUES ('AFR', 'ac', 'Ascension Island');
INSERT INTO st_listdomains VALUES ('EUR', 'ad', 'Andorra');
INSERT INTO st_listdomains VALUES ('ASI', 'ae', 'United Arab\r\nEmirates');
INSERT INTO st_listdomains VALUES ('ASI', 'af', 'Afghanistan');
INSERT INTO st_listdomains VALUES ('AME', 'ag', 'Antigua and\r\nBarbuda');
INSERT INTO st_listdomains VALUES ('AME', 'ai', 'Anguilla');
INSERT INTO st_listdomains VALUES ('EUR', 'al', 'Albania');
INSERT INTO st_listdomains VALUES ('GUS', 'am', 'Armenia');
INSERT INTO st_listdomains VALUES ('AME', 'an', 'Netherlands\r\nAntilles');
INSERT INTO st_listdomains VALUES ('AFR', 'ao', 'Angola');
INSERT INTO st_listdomains VALUES ('ANT', 'aq', 'Antartica');
INSERT INTO st_listdomains VALUES ('AME', 'ar', 'Argentina');
INSERT INTO st_listdomains VALUES ('OZE', 'as', 'American Samoa');
INSERT INTO st_listdomains VALUES ('EUR', 'at', 'Austria');
INSERT INTO st_listdomains VALUES ('OZE', 'au', 'Australia');
INSERT INTO st_listdomains VALUES ('AME', 'aw', 'Aruba');
INSERT INTO st_listdomains VALUES ('GUS', 'az', 'Azerbaijan');
INSERT INTO st_listdomains VALUES ('EUR', 'ba', 'Bosnia and\r\nHerzegovina');
INSERT INTO st_listdomains VALUES ('AME', 'bb', 'Barbados');
INSERT INTO st_listdomains VALUES ('ASI', 'bd', 'Bangladesh');
INSERT INTO st_listdomains VALUES ('EUR', 'be', 'Belgium');
INSERT INTO st_listdomains VALUES ('AFR', 'bf', 'Burkina Faso');
INSERT INTO st_listdomains VALUES ('EUR', 'bg', 'Bulgaria');
INSERT INTO st_listdomains VALUES ('ASI', 'bh', 'Bahrain');
INSERT INTO st_listdomains VALUES ('AFR', 'bi', 'Burundi');
INSERT INTO st_listdomains VALUES ('AFR', 'bj', 'Benin');
INSERT INTO st_listdomains VALUES ('AME', 'bm', 'Bermuda');
INSERT INTO st_listdomains VALUES ('ASI', 'bn', 'Brunei Darussalam');
INSERT INTO st_listdomains VALUES ('AME', 'bo', 'Bolivia');
INSERT INTO st_listdomains VALUES ('AME', 'br', 'Brazil');
INSERT INTO st_listdomains VALUES ('AME', 'bs', 'Bahamas');
INSERT INTO st_listdomains VALUES ('ASI', 'bt', 'Bhutan');
INSERT INTO st_listdomains VALUES ('ANT', 'bv', 'Bouvet Island');
INSERT INTO st_listdomains VALUES ('AFR', 'bw', 'Botswana');
INSERT INTO st_listdomains VALUES ('GUS', 'by', 'Belarus');
INSERT INTO st_listdomains VALUES ('AME', 'bz', 'Belize');
INSERT INTO st_listdomains VALUES ('AME', 'ca', 'Canada');
INSERT INTO st_listdomains VALUES ('OZE', 'cc', 'Cocos (Keeling)\r\nIslands');
INSERT INTO st_listdomains VALUES ('AFR', 'cd', 'Congo, Democratic\r\nPeople\'s Republic');
INSERT INTO st_listdomains VALUES ('AFR', 'cf', 'Central African\r\nRepublic');
INSERT INTO st_listdomains VALUES ('AFR', 'cg', 'Congo, Republic of');
INSERT INTO st_listdomains VALUES ('EUR', 'ch', 'Switzerland');
INSERT INTO st_listdomains VALUES ('AFR', 'ci', 'Cote d\'Ivoire');
INSERT INTO st_listdomains VALUES ('OZE', 'ck', 'Cook Islands');
INSERT INTO st_listdomains VALUES ('AME', 'cl', 'Chile');
INSERT INTO st_listdomains VALUES ('AFR', 'cm', 'Cameroon');
INSERT INTO st_listdomains VALUES ('ASI', 'cn', 'China');
INSERT INTO st_listdomains VALUES ('AME', 'co', 'Colombia');
INSERT INTO st_listdomains VALUES ('AME', 'cr', 'Costa Rica');
INSERT INTO st_listdomains VALUES ('AME', 'cu', 'Cuba');
INSERT INTO st_listdomains VALUES ('AFR', 'cv', 'Cap Verde');
INSERT INTO st_listdomains VALUES ('OZE', 'cx', 'Christmas Island');
INSERT INTO st_listdomains VALUES ('EUR', 'cy', 'Cyprus');
INSERT INTO st_listdomains VALUES ('EUR', 'cz', 'Czeck Republic');
INSERT INTO st_listdomains VALUES ('EUR', 'de', 'Germany');
INSERT INTO st_listdomains VALUES ('AFR', 'dj', 'Djibouti');
INSERT INTO st_listdomains VALUES ('EUR', 'dk', 'Denmark');
INSERT INTO st_listdomains VALUES ('AME', 'dm', 'Dominica');
INSERT INTO st_listdomains VALUES ('AME', 'do', 'Dominican\r\nRepublic');
INSERT INTO st_listdomains VALUES ('AFR', 'dz', 'Algeria');
INSERT INTO st_listdomains VALUES ('AME', 'ec', 'Ecuador');
INSERT INTO st_listdomains VALUES ('EUR', 'ee', 'Estonia');
INSERT INTO st_listdomains VALUES ('AFR', 'eg', 'Egypt');
INSERT INTO st_listdomains VALUES ('AFR', 'eh', 'Western Sahara');
INSERT INTO st_listdomains VALUES ('AFR', 'er', 'Eritrea');
INSERT INTO st_listdomains VALUES ('EUR', 'es', 'Spain');
INSERT INTO st_listdomains VALUES ('AFR', 'et', 'Ethiopia');
INSERT INTO st_listdomains VALUES ('EUR', 'fi', 'Finland');
INSERT INTO st_listdomains VALUES ('OZE', 'fj', 'Fiji');
INSERT INTO st_listdomains VALUES ('AME', 'fk', 'Falkland Islands\r\n(Malvina)');
INSERT INTO st_listdomains VALUES ('OZE', 'fm', 'Micronesia, Federal\r\nState of');
INSERT INTO st_listdomains VALUES ('EUR', 'fo', 'Faroe Islands');
INSERT INTO st_listdomains VALUES ('EUR', 'fr', 'France');
INSERT INTO st_listdomains VALUES ('EUR', 'fx', 'France\r\nMetropolitan');
INSERT INTO st_listdomains VALUES ('AFR', 'ga', 'Gabon');
INSERT INTO st_listdomains VALUES ('EUR', 'gb', 'United Kingdom');
INSERT INTO st_listdomains VALUES ('AME', 'gd', 'Grenada');
INSERT INTO st_listdomains VALUES ('GUS', 'ge', 'Georgia');
INSERT INTO st_listdomains VALUES ('AME', 'gf', 'French Guiana');
INSERT INTO st_listdomains VALUES ('EUR', 'gg', 'Guernsey');
INSERT INTO st_listdomains VALUES ('AFR', 'gh', 'Ghana');
INSERT INTO st_listdomains VALUES ('EUR', 'gi', 'Gibraltar');
INSERT INTO st_listdomains VALUES ('EUR', 'gl', 'Greenland');
INSERT INTO st_listdomains VALUES ('AFR', 'gm', 'Gambia');
INSERT INTO st_listdomains VALUES ('AFR', 'gn', 'Guinea');
INSERT INTO st_listdomains VALUES ('AME', 'gp', 'Guadeloupe');
INSERT INTO st_listdomains VALUES ('AFR', 'gq', 'Equatorial Guinea');
INSERT INTO st_listdomains VALUES ('EUR', 'gr', 'Greece');
INSERT INTO st_listdomains VALUES ('ANT', 'gs', 'South Georgia and\r\nthe South Sandwich Islands');
INSERT INTO st_listdomains VALUES ('AME', 'gt', 'Guatemala');
INSERT INTO st_listdomains VALUES ('OZE', 'gu', 'Guam');
INSERT INTO st_listdomains VALUES ('AFR', 'gw', 'Guinea-Bissau');
INSERT INTO st_listdomains VALUES ('AME', 'gy', 'Guyana');
INSERT INTO st_listdomains VALUES ('ASI', 'hk', 'Hong Kong');
INSERT INTO st_listdomains VALUES ('OZE', 'hm', 'Heard and McDonald\r\nIslands');
INSERT INTO st_listdomains VALUES ('AME', 'hn', 'Honduras');
INSERT INTO st_listdomains VALUES ('EUR', 'hr', 'Croatia/Hrvatska');
INSERT INTO st_listdomains VALUES ('AME', 'ht', 'Haiti');
INSERT INTO st_listdomains VALUES ('EUR', 'hu', 'Hungary');
INSERT INTO st_listdomains VALUES ('ASI', 'id', 'Indonesia');
INSERT INTO st_listdomains VALUES ('EUR', 'ie', 'Ireland');
INSERT INTO st_listdomains VALUES ('ASI', 'il', 'Israel');
INSERT INTO st_listdomains VALUES ('EUR', 'im', 'Isle of Man');
INSERT INTO st_listdomains VALUES ('ASI', 'in', 'India');
INSERT INTO st_listdomains VALUES ('ASI', 'io', 'British Indian Ocean\r\nTerritory');
INSERT INTO st_listdomains VALUES ('ASI', 'iq', 'Iraq');
INSERT INTO st_listdomains VALUES ('ASI', 'ir', 'Iran (Islamic Republic\r\nof)');
INSERT INTO st_listdomains VALUES ('EUR', 'is', 'Iceland');
INSERT INTO st_listdomains VALUES ('EUR', 'it', 'Italy');
INSERT INTO st_listdomains VALUES ('EUR', 'je', 'Jersey');
INSERT INTO st_listdomains VALUES ('AME', 'jm', 'Jamaica');
INSERT INTO st_listdomains VALUES ('ASI', 'jo', 'Jordan');
INSERT INTO st_listdomains VALUES ('ASI', 'jp', 'Japan');
INSERT INTO st_listdomains VALUES ('AFR', 'ke', 'Kenya');
INSERT INTO st_listdomains VALUES ('GUS', 'kg', 'Kyrgyzstan');
INSERT INTO st_listdomains VALUES ('ASI', 'kh', 'Cambodia');
INSERT INTO st_listdomains VALUES ('OZE', 'ki', 'Kiribati');
INSERT INTO st_listdomains VALUES ('AFR', 'km', 'Comoros');
INSERT INTO st_listdomains VALUES ('AME', 'kn', 'Saint Kitts and\r\nNevis');
INSERT INTO st_listdomains VALUES ('ASI', 'kp', 'Korea, Democratic\r\nPeople\'s Republic');
INSERT INTO st_listdomains VALUES ('ASI', 'kr', 'Korea, Republic of');
INSERT INTO st_listdomains VALUES ('ASI', 'kw', 'Kuwait');
INSERT INTO st_listdomains VALUES ('AME', 'ky', 'Cayman Islands');
INSERT INTO st_listdomains VALUES ('GUS', 'kz', 'Kazakhstan');
INSERT INTO st_listdomains VALUES ('ASI', 'la', 'Lao, People\'s\r\nDemocratic Republic');
INSERT INTO st_listdomains VALUES ('ASI', 'lb', 'Lebanon');
INSERT INTO st_listdomains VALUES ('AME', 'lc', 'Saint Lucia');
INSERT INTO st_listdomains VALUES ('EUR', 'li', 'Liechtenstein');
INSERT INTO st_listdomains VALUES ('ASI', 'lk', 'Sri Lanka');
INSERT INTO st_listdomains VALUES ('AFR', 'lr', 'Liberia');
INSERT INTO st_listdomains VALUES ('AFR', 'ls', 'Lesotho');
INSERT INTO st_listdomains VALUES ('EUR', 'lt', 'Lithuania');
INSERT INTO st_listdomains VALUES ('EUR', 'lu', 'Luxembourg');
INSERT INTO st_listdomains VALUES ('EUR', 'lv', 'Latvia');
INSERT INTO st_listdomains VALUES ('AFR', 'ly', 'Libyan Arab\r\nJamahiriya');
INSERT INTO st_listdomains VALUES ('AFR', 'ma', 'Morocco');
INSERT INTO st_listdomains VALUES ('EUR', 'mc', 'Monaco');
INSERT INTO st_listdomains VALUES ('GUS', 'md', 'Moldova,\r\nRepublic of');
INSERT INTO st_listdomains VALUES ('AFR', 'mg', 'Madagascar');
INSERT INTO st_listdomains VALUES ('OZE', 'mh', 'Marshall Islands');
INSERT INTO st_listdomains VALUES ('EUR', 'mk', 'Macedonia, Former\r\nYugoslav Republic');
INSERT INTO st_listdomains VALUES ('AFR', 'ml', 'Mali');
INSERT INTO st_listdomains VALUES ('ASI', 'mm', 'Myanmar');
INSERT INTO st_listdomains VALUES ('ASI', 'mn', 'Mongolia');
INSERT INTO st_listdomains VALUES ('ASI', 'mo', 'Macau');
INSERT INTO st_listdomains VALUES ('OZE', 'mp', 'Northern Mariana\r\nIslands');
INSERT INTO st_listdomains VALUES ('AME', 'mq', 'Martinique');
INSERT INTO st_listdomains VALUES ('AFR', 'mr', 'Mauritania');
INSERT INTO st_listdomains VALUES ('AME', 'ms', 'Montserrat');
INSERT INTO st_listdomains VALUES ('EUR', 'mt', 'Malta');
INSERT INTO st_listdomains VALUES ('AFR', 'mu', 'Mauritius');
INSERT INTO st_listdomains VALUES ('AFR', 'mv', 'Maldives');
INSERT INTO st_listdomains VALUES ('AFR', 'mw', 'Malawi');
INSERT INTO st_listdomains VALUES ('AME', 'mx', 'Mexico');
INSERT INTO st_listdomains VALUES ('ASI', 'my', 'Malaysia');
INSERT INTO st_listdomains VALUES ('AFR', 'mz', 'Mozambique');
INSERT INTO st_listdomains VALUES ('AFR', 'na', 'Namibia');
INSERT INTO st_listdomains VALUES ('OZE', 'nc', 'New Caledonia');
INSERT INTO st_listdomains VALUES ('AFR', 'ne', 'Niger');
INSERT INTO st_listdomains VALUES ('unbekannt', 'nf', 'Norfolk Island');
INSERT INTO st_listdomains VALUES ('AFR', 'ng', 'Nigeria');
INSERT INTO st_listdomains VALUES ('AME', 'ni', 'Nicaragua');
INSERT INTO st_listdomains VALUES ('EUR', 'nl', 'Netherlands');
INSERT INTO st_listdomains VALUES ('EUR', 'no', 'Norway');
INSERT INTO st_listdomains VALUES ('ASI', 'np', 'Nepal');
INSERT INTO st_listdomains VALUES ('OZE', 'nr', 'Nauru');
INSERT INTO st_listdomains VALUES ('unbekannt', 'nt', 'Neutral Zone');
INSERT INTO st_listdomains VALUES ('OZE', 'nu', 'Niue');
INSERT INTO st_listdomains VALUES ('OZE', 'nz', 'New Zealand');
INSERT INTO st_listdomains VALUES ('ASI', 'om', 'Oman');
INSERT INTO st_listdomains VALUES ('AME', 'pa', 'Panama');
INSERT INTO st_listdomains VALUES ('AME', 'pe', 'Peru');
INSERT INTO st_listdomains VALUES ('OZE', 'pf', 'French Polynesia');
INSERT INTO st_listdomains VALUES ('OZE', 'pg', 'Papua New Guinea');
INSERT INTO st_listdomains VALUES ('ASI', 'ph', 'Philippines');
INSERT INTO st_listdomains VALUES ('ASI', 'pk', 'Pakistan');
INSERT INTO st_listdomains VALUES ('EUR', 'pl', 'Poland');
INSERT INTO st_listdomains VALUES ('AME', 'pm', 'St. Pierre and\r\nMiquelon');
INSERT INTO st_listdomains VALUES ('OZE', 'pn', 'Pitcairn Island');
INSERT INTO st_listdomains VALUES ('AME', 'pr', 'Puerto Rico');
INSERT INTO st_listdomains VALUES ('EUR', 'pt', 'Portugal');
INSERT INTO st_listdomains VALUES ('OZE', 'pw', 'Palau');
INSERT INTO st_listdomains VALUES ('AME', 'py', 'Paraguay');
INSERT INTO st_listdomains VALUES ('ASI', 'qa', 'Qatar');
INSERT INTO st_listdomains VALUES ('AFR', 're', 'Reunion Island');
INSERT INTO st_listdomains VALUES ('EUR', 'ro', 'Romania');
INSERT INTO st_listdomains VALUES ('GUS', 'ru', 'Russian\r\nFederation');
INSERT INTO st_listdomains VALUES ('AFR', 'rw', 'Rwanda');
INSERT INTO st_listdomains VALUES ('ASI', 'sa', 'Saudi Arabia');
INSERT INTO st_listdomains VALUES ('OZE', 'sb', 'Solomon Islands');
INSERT INTO st_listdomains VALUES ('AFR', 'sc', 'Seychelles');
INSERT INTO st_listdomains VALUES ('AFR', 'sd', 'Sudan');
INSERT INTO st_listdomains VALUES ('EUR', 'se', 'Sweden');
INSERT INTO st_listdomains VALUES ('ASI', 'sg', 'Singapore');
INSERT INTO st_listdomains VALUES ('AFR', 'sh', 'St. Helena');
INSERT INTO st_listdomains VALUES ('EUR', 'si', 'Slovenia');
INSERT INTO st_listdomains VALUES ('unbekannt', 'sj', 'Svalbard and Jan\r\nMayen Islands');
INSERT INTO st_listdomains VALUES ('EUR', 'sk', 'Slovak Republic');
INSERT INTO st_listdomains VALUES ('AFR', 'sl', 'Sierra Leone');
INSERT INTO st_listdomains VALUES ('EUR', 'sm', 'San Marino');
INSERT INTO st_listdomains VALUES ('AFR', 'sn', 'Senegal');
INSERT INTO st_listdomains VALUES ('AFR', 'so', 'Somalia');
INSERT INTO st_listdomains VALUES ('AME', 'sr', 'Suriname');
INSERT INTO st_listdomains VALUES ('AFR', 'st', 'Sao Tome and\r\nPrincipe');
INSERT INTO st_listdomains VALUES ('GUS', 'su', 'Sovjet Union,\r\nFormew');
INSERT INTO st_listdomains VALUES ('AME', 'sv', 'El Salvador');
INSERT INTO st_listdomains VALUES ('ASI', 'sy', 'Syrian Arab\r\nRepublic');
INSERT INTO st_listdomains VALUES ('AFR', 'sz', 'Swaziland');
INSERT INTO st_listdomains VALUES ('AME', 'tc', 'Turks and Ciacos\r\nIslands');
INSERT INTO st_listdomains VALUES ('AFR', 'td', 'Chad');
INSERT INTO st_listdomains VALUES ('ASI', 'tf', 'French Southern\r\nTerritories');
INSERT INTO st_listdomains VALUES ('AFR', 'tg', 'Togo');
INSERT INTO st_listdomains VALUES ('ASI', 'th', 'Thailand');
INSERT INTO st_listdomains VALUES ('GUS', 'tj', 'Tajikistan');
INSERT INTO st_listdomains VALUES ('OZE', 'tk', 'Tokelau');
INSERT INTO st_listdomains VALUES ('GUS', 'tm', 'Turkmenistan');
INSERT INTO st_listdomains VALUES ('AFR', 'tn', 'Tunisia');
INSERT INTO st_listdomains VALUES ('OZE', 'to', 'Tonga');
INSERT INTO st_listdomains VALUES ('ASI', 'tp', 'East Timor');
INSERT INTO st_listdomains VALUES ('ASI', 'tr', 'Turkey');
INSERT INTO st_listdomains VALUES ('AME', 'tt', 'Trinidad and\r\nTobago');
INSERT INTO st_listdomains VALUES ('OZE', 'tv', 'Tuvalu');
INSERT INTO st_listdomains VALUES ('ASI', 'tw', 'Taiwan');
INSERT INTO st_listdomains VALUES ('AFR', 'tz', 'Tanzania');
INSERT INTO st_listdomains VALUES ('GUS', 'ua', 'Ukraine');
INSERT INTO st_listdomains VALUES ('AFR', 'ug', 'Uganda');
INSERT INTO st_listdomains VALUES ('unbekannt', 'um', 'US Minor Outlying\r\nIslands');
INSERT INTO st_listdomains VALUES ('AME', 'us', 'United States of\r\nAmerica');
INSERT INTO st_listdomains VALUES ('AME', 'uy', 'Uruguay');
INSERT INTO st_listdomains VALUES ('GUS', 'uz', 'Uzbekistan');
INSERT INTO st_listdomains VALUES ('EUR', 'va', 'Holy See (City\r\nVatican State)');
INSERT INTO st_listdomains VALUES ('AME', 'vc', 'Saint Vincent and\r\nthe Grenadines');
INSERT INTO st_listdomains VALUES ('AME', 've', 'Venezuela');
INSERT INTO st_listdomains VALUES ('AME', 'vg', 'Virgin Islands\r\n(British)');
INSERT INTO st_listdomains VALUES ('AME', 'vi', 'Virgin Islands\r\n(USA)');
INSERT INTO st_listdomains VALUES ('ASI', 'vn', 'Vietnam');
INSERT INTO st_listdomains VALUES ('OZE', 'vu', 'Vanuatu');
INSERT INTO st_listdomains VALUES ('OZE', 'wf', 'Wallis and Futuna\r\nIslands');
INSERT INTO st_listdomains VALUES ('OZE', 'ws', 'Western Samoa');
INSERT INTO st_listdomains VALUES ('ASI', 'ye', 'Yemen');
INSERT INTO st_listdomains VALUES ('AFR', 'yt', 'Mayotte');
INSERT INTO st_listdomains VALUES ('EUR', 'yu', 'Yugoslavia');
INSERT INTO st_listdomains VALUES ('AFR', 'za', 'South Africa');
INSERT INTO st_listdomains VALUES ('AFR', 'zm', 'Zambia');
INSERT INTO st_listdomains VALUES ('AFR', 'zr', 'Zaire');
INSERT INTO st_listdomains VALUES ('AFR', 'zw', 'Zimbabwe');
INSERT INTO st_listdomains VALUES ('unbekannt', 'com', 'Companies');
INSERT INTO st_listdomains VALUES ('unbekannt', 'net', 'Networks');
INSERT INTO st_listdomains VALUES ('unbekannt', 'org', 'Organizations');
INSERT INTO st_listdomains VALUES ('AME', 'edu', 'US Educational\r\nInstitutions');
INSERT INTO st_listdomains VALUES ('unbekannt', 'int', 'International\r\nOrganizations');
INSERT INTO st_listdomains VALUES ('unbekannt', 'arpa', 'Advanced\r\nResearch Project Agency');
INSERT INTO st_listdomains VALUES ('AME', 'gov', 'US Governmental\r\nEntities');
INSERT INTO st_listdomains VALUES ('unbekannt', 'mil', 'US Armed\r\nForces');
INSERT INTO st_listdomains VALUES ('unbekannt', 'biz', 'Businesses');
INSERT INTO st_listdomains VALUES ('unbekannt', 'info', 'INFO');
INSERT INTO st_listdomains VALUES ('unbekannt', 'name', 'NAME');
INSERT INTO st_listdomains VALUES ('unbekannt', 'pro', 'PRO');
INSERT INTO st_listdomains VALUES ('unbekannt', 'coop', 'COOP');
INSERT INTO st_listdomains VALUES ('unbekannt', 'aero', 'AERO');
INSERT INTO st_listdomains VALUES ('unbekannt', 'museum', 'MUSEUM');
INSERT INTO st_listdomains VALUES ('EUR', 'eu', 'EU');
INSERT INTO st_listdomains VALUES ('unbekannt', 'firm', 'FIRM');
INSERT INTO st_listdomains VALUES ('unbekannt', 'web', 'WEB');
INSERT INTO st_listdomains VALUES ('unbekannt', 'shop', 'SHOP');
INSERT INTO st_listdomains VALUES ('unbekannt', 'rec', 'recreation/entertainment activities');
INSERT INTO st_listdomains VALUES ('EUR', 'uk', 'United Kingdom');

