<?php
/*          ********************************************************
            *      SMTPMAIL v1.1 - Send E-mail with file attached  *
            *                      using SMTP server               *
            *                                                      *
            *   2004 By Vanderson Pimenta <vandersonpc@globo.com>  *
            *                                                      *
            *       This Script is free to non-comercial use.      *
            *      For commercial use, please send-me a e-mail     *                                                      *
            *                                                      *
            ********************************************************

*/

Class SMPT{
    //Declare Globals Variables
    var $_errno      = 0;
    var $_errmsg     = '';
    var $_errors     = array(
                       1 => 'Invalid Data Input - ',
                       2 => 'Unable to Establish Connection',
                       3 => 'Connection Timed Out',
                       4 => 'SMTP error returned',
                       5 => 'Error Send Attached File(s)',
                       6 => 'Error Sending Message!!',);

    var $_smtpserver = "";
    var $_conn       = false;
    var $_to         = array();
    var $_cc         = array();
    var $_from       = "";
    var $_msgtype    = "";
    var $_subject    = "";
    var $_message    = "";
    var $_attach     = array();


   /* Open connection to smtpd on port 25 (fsockopen) */

   function SMTP($host,$timeout=10)
          {
            if (strlen($host)<=0)
	           return $this->error(1, 'server');
	        else $this->_smtpserver=$host;

            if (!$this->_conn = fsockopen($host, 25, &$errno, &$errstr, $timeout))
		       return $this->error(2);

	        if (!socket_set_blocking($this->_conn, true))
		       return $this->error(4, 'set blocking');

            if (!$this->GetFeedback())
		       return $this->error(2, 'during onset');
            return true;
	      }
	      
   function GetFeedback()
	      {
	        if (!$response=fgets($this->_conn, 1024))
		       return false;
	        if ($this->IsOK($response))
		       return true;
	        else return false;
	}

Function IsOK ($input)
	{
 	if (!ereg("((^[0-9])([0-9]*))", $input, $regs))
		return $this->error(1, 'input');
	$code=$regs[1];
	switch ($code)
		{
		case '220':
		case '221':
		case '250':
		case '251':
		case '354':
			return true;
			break;
		default:
			return $this->error(4, $input);
			break;
		}
	}


   function Error($errno,$msg="")
          {
            $this->_errno   = $errno;
            $this->_errmsg .= $msg;
            return false;
          }
          
   function ErrMsg($error=false)
          {
	        if (false===$error)
		       {
		        $errno=$this->_errno;
		        return $this->_errors[$errno].' '.$this->_errmsg;
		       }
	        else return $this->_errors[$error];
          }

   function ErrNo()
          {
	        return $this->_errno;
	      }
	      
   function ResetData()
          {
            $_from       = "";
            $_msgtype    = "";
            $_subject    = "";
            $_message    = "";
            $_attach     = array();
            $_type       = "";
        	return true;
	      }


   function AddDest($dest)
          {
            if (strlen($dest) <=0)
               return $this->Error(1, 'To not defined!');
            if (strlen($dest) >= 129)
               return $this->Error(1, '"To" length too long');
            $this->_to[] = $dest;
            return true;
          }
   function AddSender($sender)
          {
            if (strlen($sender) <=0)
               return $this->Error(1, 'Sender not defined!');
            if (strlen($sender) >= 129)
               return $this->Error(1, 'Sender length too long');
		    $this->_from = $sender;
		    return true;
          }
          
   function AddCc($cc)
          {
            if (!$this->AddDest($cc))
               return false;
		    $this->_cc = $cc;
            return true;
          }

   function AddSubject($subject)
          {
            if (strlen($subject) <=0)
                return false;
            $this->_subject = $subject;
            return true;
          }

   function AddMessage($mailtext)
          {
            if (strlen($mailtext) <=0)
                return $this->Error(1, 'Message Empty');
            $this->_message = $mailtext;
            return true;
          }
          
   function AddAttached($attached)
          {
		    $this->_attach[] = $attached;
            return true;
          }
          
   //Send Message
   function Send($mtype="html"){

        $this->_msgtype = $mtype;

        $subject = stripslashes($this->_subject);

        $strHELO = "HELO ".$this->_smtpserver."\r\n";
		fputs($this->_conn,$strHELO);
        if (!$this->GetFeedback())
           return $this->error($this->errno(), "($strHELO)");

		$strMAIL = "MAIL FROM: <".$this->_from.">\r\n";
		fputs($this->_conn,$strMAIL);
        if (!$this->GetFeedback())
           return $this->error($this->errno(), "($strMAIL)");

        while (list($key,$t) =each ($this->_to))
              {
               $strRCPT .= "RCPT TO: <".$t.">\r\n";
              }
		$strRCPT .= "\r\n";
        fputs($this->_conn,$strRCPT);
        if (!$this->GetFeedback())
            return $this->error($this->errno(), "($t)");

		$strDATA1 = "DATA\r\n";
		fputs($this->_conn,$strDATA1);
        if (!$this->GetFeedback())
           return $this->error($this->errno(), "($strDATA1)");

		if($this->_subject != "")
          {
      	   $strS = "Subject: ".$this->_subject."\r\n";
		   fputs($this->_conn,$strS);
		  }

        $OB="----=_OuterBoundary_000";
        $IB="----=_InnerBoundery_001";
        $Html=$Html?$Html:preg_replace("/\n/","{br}",$this->_message) or die("neither text nor html part present.");
        $Text=$Text?$Text:"Sorry, but you need an html mailer to read this mail.";
        $this->_from or die("sender address missing");
        $this->_to or die("recipient address missing");
        $headers ="MIME-Version: 1.0\r\n";
        $headers.="From: ".$this->_from." <".$this->_from.">\r\n";

        if (sizeof($this->_to) >=1)
           foreach( $this->_to as $to)  $headers.= "To: ".$to."\r\n";
            
        if (sizeof($this->_cc) >=1)
           foreach( $this->_cc as $cc)  $headers.= "Cc: ".$cc."\r\n";

        $headers.="Reply-To: ".$this->_from." <".$this->_from.">\n";
        $headers.="X-Priority: 1\n";
        $headers.="X-MSMail-Priority: High\n";
        $headers.="X-Mailer: PHP SMTPMail\n";
        $headers.="Content-Type: multipart/mixed;\n\tboundary=\"".$OB."\"\n";

         //Messages start with text/html alternatives in OB
        $Msg ="This is a multi-part message in MIME format.\n";
        $Msg.="\n--".$OB."\n";
        $Msg.="Content-Type: multipart/alternative;\n\tboundary=\"".$IB."\"\n\n";
        
        if (strtoupper($this->_msgtype) != "HTML")
           {
             //plaintext section
             $Msg.="\n--".$IB."\n";
             $Msg.="Content-Type: text/plain;\n\tcharset=\"iso-8859-1\"\n";
             $Msg.="Content-Transfer-Encoding: quoted-printable\n\n";
             // plaintext goes here
             $Msg.=$this->_message."\n\n";
           } else
             {
              // html section
              $Msg.="\n--".$IB."\n";
              $Msg.="Content-Type: text/html;\n\tcharset=\"iso-8859-1\"\n";
              $Msg.="Content-Transfer-Encoding: base64\n\n";
              // html goes here
              $Msg.=chunk_split(base64_encode($this->_message))."\n\n";
             }
        // end of IB
        $Msg.="\n--".$IB."--\n";
        
        // attachments
        if (sizeof($this->_attach) > 0)
           foreach($this->_attach as $FileN)
                  {
                   $FileContent = "";
                   $patharray   = "";
                   $FileName    = "";
                   $patharray = explode ("/",$FileN);
                   $FileName=$patharray[count($patharray)-1];
                   $Msg.= "\n--".$OB."\n";
                   $Msg.="Content-Type: application/octetstream;\n\tname=\"".$FileName."\"\n";
                   $Msg.="Content-Transfer-Encoding: base64\n";
                   $Msg.="Content-Disposition: attachment;\n\tfilename=\"".$FileName."\"\n\n";
                   //file goes here
                   if (($fd = @fopen($FileN, "rb", $use_include_path))==False)
                      {
                       return $this->Error(5);
                      } else
                         {
                          if ($fd)
                             {
                              while (!feof($fd)) $FileContent .= fread($fd, 1024);
                              fclose($fd);
                             }
                          }
                   $FileContent=chunk_split(base64_encode($FileContent));
                   $Msg.=$FileContent;
                   $Msg.="\n\n";
                  }
        //message ends
        $Msg.="\n--".$OB."--\n";


        fputs($this->_conn,$headers."\r\n");
        $strDATA2 = $Msg."\r\n\r\n.\r\n";

        sleep(1);
        fputs($this->_conn,$strDATA2,strlen($strDATA2));
        if (!$this->_conn)
		   return $this->error(3, 'function end');

        fputs($this->_conn,"QUIT\r\n");
        
        if ($this->GetFeedback())
		   {
		    fclose($this->_conn);
		    $this->ResetData();
		    return true;
	  	   } else
             {
              return $this->error(6); ;
		     }
     }
}

	

?>
