<?php
//-----------------------------------------------------------------------------
//
//	script.inc
//
//	Creates the actual firewall script
//
//	 Eclipsys Inc 1998 - 2000 under GPL licence
//	Web Site : http://www.eclipsys.qc.ca
//	Email    : asagala@eclipsys.qc.ca
//	
//  Top protion of code was taken from phpfwgen
//  Thanks to Del <del@babel.com.au>
//
//	MODIFICATIONS
//	Date		Programmer		Action
//	2000-06-06	A.Sagala		Creation 
//-----------------------------------------------------------------------------


require ('../config.inc');
require ('../functions.inc');

function gen_script() 
{
  global $CONF;
  global $IPCHAINS_PATH;
  global $APP_VERSION;

  $protocols = read_protocols();
  $services = read_services();
  $netobjects = read_objects();

  $ichn = 1;
  $fchn = 1;
  $ochn = 1;
  $outrules = 0;

  #
  # Generate the file.
  #
  $firewall = fopen("$CONF/rc.firewall", "w+");
  chmod( "$CONF/rc.firewall", 0755 );

  fwrite ($firewall, "#!/bin/sh\n");
  fwrite ($firewall, "#\n");
  fwrite ($firewall, "# Firewall script generated by $APP_VERSION.\n");
  fwrite ($firewall, "#\n");
  fwrite ($firewall, "# eFire by Alexandre Sagala (asagala@eclipsys.qc.ca) \n");
  fwrite ($firewall, "#\n");
  fwrite ($firewall, "# Thanks to Del (del@babel.com.au) who made PHP Firewall Generator which  \n");
  fwrite ($firewall, "# helped me alot for this script model and the general program idea\n");
  fwrite ($firewall, "#\n");
  fwrite ($firewall, "# Thanks to: Trinity OS file\n");
  fwrite ($firewall, "# http://www.ecst.csuchico.edu/~dranch/LINUX/TrinityOS/cHTML/TrinityOS-042500c-10.html\n");
  fwrite ($firewall, "#\n");
  fwrite ($firewall, "# eFire (C) Eclipsys Inc under the GPL.\n");
  fwrite ($firewall, "# Website : http://www.eclipsys.qc.ca.\n");
  fwrite ($firewall, "#\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "IPCHAINS=$IPCHAINS_PATH\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "# Network object definitions.\n");
  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "PRIVPORTS=\"0:1023\"\n");
  fwrite ($firewall, "HIPORTS=\"1024:65535\"\n");
  fwrite ($firewall, "ALL=\"0.0.0.0/0\"\n");

  if (is_array($netobjects)) {
    reset($netobjects);
    while ( list( $key, $val ) = each( $netobjects ) ) 
	{
      $exploded = explode (" ", $val);
      fwrite ($firewall, "$key=\"$exploded[0]/$exploded[1]\"\n");
    }
  }
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#-------------------------------\n");
  fwrite ($firewall, "# Turn on forwarding and others.\n");
  fwrite ($firewall, "#-------------------------------\n");
  fwrite ($firewall, "echo 1 > /proc/sys/net/ipv4/ip_forward\n");
  fwrite ($firewall, "echo 1 > /proc/sys/net/ipv4/ip_always_defrag\n");
  fwrite ($firewall, "echo 1 > /proc/sys/net/ipv4/ip_dynaddr\n");
  fwrite ($firewall, "echo 1 > /proc/sys/net/ipv4/tcp_syncookies\n");
  fwrite ($firewall, "echo 1 > /proc/sys/net/ipv4/icmp_ignore_bogus_error_responses\n");
  fwrite ($firewall, "echo 1 > /proc/sys/net/ipv4/icmp_echo_ignore_broadcasts\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "# Turn off ICMP redirects.\n");
  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "for file in /proc/sys/net/ipv4/conf/*/accept_redirects; do\n");
  fwrite ($firewall, "  echo \"0\" > \$file\n");
  fwrite ($firewall, "done\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#---------------------------------\n");
  fwrite ($firewall, "# Turn off source routed packets.\n");
  fwrite ($firewall, "#---------------------------------\n");
  fwrite ($firewall, "for file in /proc/sys/net/ipv4/conf/*/accept_source_route; do\n");
  fwrite ($firewall, "  echo \"0\" > \$file\n");
  fwrite ($firewall, "done\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "# Turn on anti-spoofing.\n");
  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "for file in /proc/sys/net/ipv4/conf/*/rp_filter; do\n");
  fwrite ($firewall, "  echo \"2\" > \$file\n");
  fwrite ($firewall, "done\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "# Masquerading timeouts\n");
  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "\$IPCHAINS -M -S 7200 10 60\n");
  fwrite ($firewall, "\n");


  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "# Default Rules\n");
  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#---------------------------\n");
  fwrite ($firewall, "# Default permissions\n");
  fwrite ($firewall, "#---------------------------\n");
  fwrite ($firewall, "\$IPCHAINS -P input REJECT\n");
  fwrite ($firewall, "\$IPCHAINS -P output REJECT\n");
  fwrite ($firewall, "\$IPCHAINS -P forward REJECT\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "# Flush all old rulesets.\n");
  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "\$IPCHAINS -F input\n");
  fwrite ($firewall, "\$IPCHAINS -F output\n");
  fwrite ($firewall, "\$IPCHAINS -F forward\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "# Allow loopback interface\n");
  fwrite ($firewall, "#----------------------------\n");
  fwrite ($firewall, "# (#" . $ichn++ . ")\n");
  fwrite ($firewall, "\$IPCHAINS -A input -i lo -j ACCEPT\n");
  fwrite ($firewall, "# (#" . $ochn++ . ")\n");
  fwrite ($firewall, "\$IPCHAINS -A output -i lo -j ACCEPT\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "# Forwarding / Masquerading\n");
  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "\n");

  fwrite ($firewall, "#-------------------------------\n");
  fwrite ($firewall, "# Masquerade specified networks.\n");
  fwrite ($firewall, "#-------------------------------\n");
  fwrite ($firewall, "\n");

  if (is_array($netobjects)) 
  {
    reset($netobjects);
    while ( list($key,$val) = each($netobjects) ) 
	{
      $exploded = explode (" ", $val);
      if ($exploded[2] == "YES") 
	  {
        fwrite ($firewall, "# (#" . $fchn++ . ")\n");
        fwrite ($firewall, "\$IPCHAINS -A forward -s \$$key -d \$ALL -j MASQ\n");
      }
    }
  }
  fwrite ($firewall, "\n");


  ########################
  # Read Forwarding rules
  #
  $rules = read_rulesets('forward');

  if (is_array($rules)) 
  {
    reset($rules);
    while ( list($key,$rule) = each($rules) ) 
	{
      $rule = chop($rule);
      list ($type,$source, $dest, $proto, $port, $action, $log) = preg_split ("/[\s]+/", $rule);

      fwrite ($firewall, "\n");
      fwrite ($firewall, "# Rule number $key [ $rule ]\n#\n");
	  fwrite ($firewall, "# (#" . $fchn++ . ")\n");
      fwrite ($firewall, "\$IPCHAINS -A forward");

	  if ($proto != "ALL") 
		fwrite ($firewall, " -p $proto");
      
	  if ($proto == "icmp") 
	  {
		fwrite ($firewall, " -s \$$source");
		if ($port != "ALL") 
			fwrite ($firewall, " $port");
		fwrite ($firewall, " -d \$$dest");
      }
	  else 
	  {
		fwrite ($firewall, " -s \$$source -d \$$dest");
		if ($port != "ALL") 
			fwrite ($firewall, " $port");
      }
          
	  fwrite ($firewall, " -j $action");
      
	  if ($log == "YES") fwrite ($firewall, " -l");
		fwrite ($firewall, "\n");

    }
  }

  fwrite ($firewall, "\n#-------------------------------\n");
  fwrite ($firewall, "# Catch All forward Rule.\n");
  fwrite ($firewall, "#-------------------------------\n");
  fwrite ($firewall, "\n");
  fwrite ($firewall, "\$IPCHAINS -A forward -j REJECT -s \$ALL -d \$ALL -l");

  fwrite ($firewall, "\n");
  fwrite ($firewall, "\n");
  
  
  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "# Output Rules\n");
  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "\n");

  ########################
  # Read Output rules
  #
  $rules = read_rulesets('output');

  if (is_array($rules)) 
  {
    reset($rules);
    while ( list($key,$rule) = each($rules) ) 
	{
      $rule = chop($rule);
      list ($type,$source, $dest, $proto, $port, $action, $log) = preg_split ("/[\s]+/", $rule);

	  fwrite ($firewall, "\n");
      fwrite ($firewall, "# Rule number $key [ $rule ]\n#\n");
	  fwrite ($firewall, "# (#" . $ochn++ . ")\n");
      fwrite ($firewall, "\$IPCHAINS -A output");

	  if ($proto != "ALL") 
		fwrite ($firewall, " -p $proto");
      
	  if ($proto == "icmp") 
	  {
		fwrite ($firewall, " -s \$$source");
		if ($port != "ALL") 
			fwrite ($firewall, " $port");
		fwrite ($firewall, " -d \$$dest");
      }
	  else 
	  {
		fwrite ($firewall, " -s \$$source -d \$$dest");
		if ($port != "ALL") 
			fwrite ($firewall, " $port");
      }
          
	  fwrite ($firewall, " -j $action");
      
	  if ($log == "YES") fwrite ($firewall, " -l");
		fwrite ($firewall, "\n");

    }
  }

  fwrite ($firewall, "\n#-------------------------------\n");
  fwrite ($firewall, "# Catch All output Rule.\n");
  fwrite ($firewall, "#-------------------------------\n");
  fwrite ($firewall, "\n");
  fwrite ($firewall, "\$IPCHAINS -A output -j REJECT -s \$ALL -d \$ALL -l");

  fwrite ($firewall, "\n");
  fwrite ($firewall, "\n");



  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "# Input Rules\n");
  fwrite ($firewall, "#############################################################################\n");
  fwrite ($firewall, "\n");

  ########################
  # Read Input rules
  #
  $rules = read_rulesets('input');

  if (is_array($rules)) 
  {
    reset($rules);
    while ( list($key,$rule) = each($rules) ) 
	{
      $rule = chop($rule);
      list ($type,$source, $dest, $proto, $port, $action, $log) = preg_split ("/[\s]+/", $rule);

	  fwrite ($firewall, "\n");
      fwrite ($firewall, "# Rule number $key [ $rule ]\n#\n");
	  fwrite ($firewall, "# (#" . $ochn++ . ")\n");
      fwrite ($firewall, "\$IPCHAINS -A input");

	  if ($proto != "ALL") 
		fwrite ($firewall, " -p $proto");
      
	  if ($proto == "icmp") 
	  {
		fwrite ($firewall, " -s \$$source");
		if ($port != "ALL") 
			fwrite ($firewall, " $port");
		fwrite ($firewall, " -d \$$dest");
      }
	  else 
	  {
		fwrite ($firewall, " -s \$$source -d \$$dest");
		if ($port != "ALL") 
			fwrite ($firewall, " $port");
      }
          
	  fwrite ($firewall, " -j $action");
      
	  if ($log == "YES") fwrite ($firewall, " -l");
		fwrite ($firewall, "\n");

    }
  }
 
  fwrite ($firewall, "\n#-------------------------------\n");
  fwrite ($firewall, "# Catch All input Rule.\n");
  fwrite ($firewall, "#-------------------------------\n");
  fwrite ($firewall, "\n");
  fwrite ($firewall, "\$IPCHAINS -A input -j REJECT -s \$ALL -d \$ALL -l");


  fclose($firewall);

  
}

?>
