<?
//-----------------------------------------------------------------------------
//
//	objects.php3
//
//	Add & Delete Network Objects
//
//	 Eclipsys Inc 1998 - 2000 under GPL licence
//	Web Site : http://www.eclipsys.qc.ca
//	Email    : asagala@eclipsys.qc.ca
//	
//  Pieces of code taken from phpfwgen
//  Thanks to Del <del@babel.com.au> for the code
//
//	MODIFICATIONS
//	Date		Programmer		Action
//	2000-06-06	A.Sagala		Creation 
//-----------------------------------------------------------------------------
?>

<HTML>
<HEAD>
<TITLE>Network Objects</TITLE>


</HEAD>
<BODY>

<?php

require ('../config.inc');
require('../functions.inc');

$netobjects = read_objects();

if (isset($action))
{
	switch($action) 
	{
		case "Create":
			if (!empty($newobjectname) || !empty($newnetaddr) || !empty($newnetmask)) 
			{
				$netobjects[$newobjectname] = "$newnetaddr $newnetmask $newmasq";
				write_objects($netobjects);
			}
			break;
		
		case "Delete":
			unset($netobjects[$objectname]);
			write_objects($netobjects);
			break;
	}
}

?>

<TABLE WIDTH=100% border=0>
<TR <? echo $HEADERROW_PARAMS;?>><TD ALIGN=left VALIGN=top><FONT FACE=ARIAL SIZE=2><B> Network Objects</B></FONT></TD></TR><TR>
<TD>
<BR>
 You can add all you network interfaces ( eth0,eth1,lo) here . 
 You can also create network objects for other things such as the internet or special hosts.<BR>
 <BR>
 Example: <BR>
 <BR>
  &nbsp&nbsp ALL ip: 0.0.0.0 netmask: 0 masq: NO  is equivalent to 0.0.0.0/0 <BR>
  &nbsp&nbsp LAN ip: 192.168.0.0 netmask: 24 masq : YES is equivalent to 192.168.0.0/24 <BR>
 <BR>
 <BR>
<FONT COLOR=red>No need to specify loopback. It is allowed by default</FONT>
</TD>
</TR>
</TABLE>
<BR>

<TABLE BORDER=1 <? echo $TABLE_PARAMS;?> width=100%>
  <TR ALIGN=LEFT VALIGN=TOP <?echo $HEADERROW_PARAMS;?>>
    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Object Name</B></CENTER></FONT></TD>
    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Network Address</B></CENTER></FONT></TD>
    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Network Mask</B></CENTER></FONT></TD>
    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Masquerade</B></CENTER></FONT></TD>
    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Action</B></CENTER></FONT></TD>
  </TR>

  <FORM NAME="addobject" METHOD="POST" ACTION="objects.php3?action=Create">
  <TR ALIGN=LEFT VALIGN=TOP>
    <TD><CENTER><INPUT TYPE="TEXT" NAME="newobjectname" VALUE=""></CENTER></TD>
    <TD><CENTER><INPUT TYPE="TEXT" NAME="newnetaddr" VALUE=""></CENTER></TD>
    <TD><CENTER><INPUT TYPE="TEXT" NAME="newnetmask" VALUE=""></CENTER></TD>
    <TD><CENTER><SELECT NAME="newmasq">
        <OPTION SELECTED>YES
        <OPTION>NO
        </SELECT>
        </CENTER>
	</TD>
    <TD><CENTER><INPUT TYPE="IMAGE" SRC="../images/Screen.gif" BORDER=0 NAME="networkobject" ALT="Create"></CENTER></TD>
  </TR>
  </FORM>

</TABLE>

<?php

################################
# Print all the network objects
#

function print_netobject ($netobject, $value) 
{ 
  list ($address, $mask, $masq) = preg_split ("/[\s]+/", $value);
  
  print "  <TR ALIGN=MIDDLE VALIGN=MIDDLE>\n";
  print "    <TD WIDTH=165><CENTER>$netobject</CENTER></TD>\n";
  print "    <TD WIDTH=165><CENTER>$address</CENTER></TD>\n";
  print "	 <TD WIDTH=165><CENTER>$mask</CENTER></TD>\n";
  print "	 <TD><CENTER>$masq</CENTER></TD>\n";
  print "	 <TD>";
  print "	  <FORM NAME=\"rmobject\" METHOD=\"POST\" ACTION=\"objects.php3?action=Delete&objectname=$netobject\">";
  print "       <INPUT TYPE=\"IMAGE\" SRC=\"../images/Trash.gif\" ALT=\"Delete\" BORDER=0 NAME=\"networkobject\" VALUE=\"Delete\">";
  print "     </FORM>";
  print "    </TD>\n";
  print "  </TR>\n";
}


########################################
# Table header for read network objects
#

print "\n<BR>\n\n";
print "<TABLE BORDER=1 $TABLE_PARAMS width=100%>\n";
print "  <TR ALIGN=LEFT VALIGN=TOP $HEADERROW_PARAMS>\n";
print "    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Object Name</B></CENTER></FONT></TD>\n";
print "    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Network Address</B></CENTER></FONT></TD>\n";
print "    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Network Mask</B></CENTER></FONT></TD>\n";
print "    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Masquerade</B></CENTER></FONT></TD>\n";
print "    <TD><FONT FACE=ARIAL SIZE=2><CENTER><B>Submit</B></CENTER></FONT></TD>\n";
print "  </TR>\n";


if (isset($netobjects))
{
	reset($netobjects);

	while ( list($key,$val) = each($netobjects) ) 
	{
		print_netobject ($key, $val);
	}
}

?>
</TABLE>
</BODY>
</HTML>
