<?

//-----------------------------------------------------------------------------
//
//	functions.inc
//
//
//	 Eclipsys Inc 1998 - 2000 under GPL licence
//	Web Site : http://www.eclipsys.qc.ca
//	Email    : asagala@eclipsys.qc.ca
//	
//  Code taken from phpfwgen
//  Thanks to Del <del@babel.com.au> for the code
//
//	MODIFICATIONS
//	Date		Programmer		Action
//	2000-06-06	A.Sagala		Creation 
//-----------------------------------------------------------------------------

function read_objects() 
{
  global $CONF;
  $netobjectr = file("$CONF/netobjects");
  while ( list( $key, $val ) = each( $netobjectr ) ) 
  {
    #
    # Skip blank lines and comments
    #
    if ( strlen($val) < 5 ) continue;
    if ( substr($val, 0, 1) == "#" ) continue;
    $exploded = explode (" ", $val);
    $netobjects[$exploded[0]] = "$exploded[1] $exploded[2] " . chop($exploded[3]);
  }
  return $netobjects;
}



function write_objects($netobjects) 
{
  global $CONF;
  $objfile = fopen ("$CONF/netobjects","w+");
  reset($netobjects);
  while ( list($key,$val) = each($netobjects) ) 
  {
    fwrite ($objfile, "$key $val\n");
  }
  fclose($objfile);
}

$netobjects = read_objects();

function read_rulesets($type) 
{
  global $CONF;
  $ruler = file("$CONF/$type.rules");
  $rulekey = 1;
  while ( list( $key, $val ) = each($ruler) ) 
  {
    #
    # Skip blank lines and comments
    #
    if ( strlen($val) < 5 ) continue;
    if ( substr($val, 0, 1) == "#" ) continue;
    $rules[$rulekey] = chop($val);
    $rulekey += 1;
  }
  return $rules;
}

function write_rulesets($rules,$type) 
{
  global $CONF;
  $rulefile = fopen ("$CONF/$type.rules","w+");
  reset($rules);
  while ( list($key,$val) = each($rules) ) 
  {
    fwrite ($rulefile, "$val\n");
  }
  fclose ($rulefile);
}


function read_protocols() 
{
  $protocolr = file("/etc/protocols");
  while ( list( $key, $val ) = each($protocolr) ) 
  {
    if ( strlen($val) < 5 ) continue;
    if ( substr($val, 0, 1) == "#" ) continue;
    $exploded = preg_split ("/[\s\/]+/", $val);
    $protocols[$exploded[0]] = intval($exploded[1]);
    $port = intval($exploded[1]);
  }
  asort($protocols);
  return $protocols;
}

function read_services() {
  $servicer = file("/etc/services");

  $services["HIPORTS/udp"] = "1024:65535";
  $services["HIPORTS/tcp"] = "1024:65535";
  while ( list($key,$val ) = each($servicer) ) 
  {
    if ( strlen($val) < 5 ) continue;
    if ( substr($val, 0, 1) == "#" ) continue;
    $exploded = preg_split ("/[\s\/]+/", $val);
    $service = $exploded[0];
    $port = intval($exploded[1]);
    $proto = $exploded[2];
    $services["$service/$proto"] = $port;
  }

  ksort($services);	// alphabetical
  return $services;
}

?>
