<?php
/*
 * sendcard
 * Copyright Peter Bowyer <peter@sendcard.org> 2000, 2001, 2002
 * This script is released under the Artistic License
 * Please look in the docs/ directory for install instructions.
 *  
 * $Id: sendcard.php,v 1.14 2004/11/08 20:59:17 reywob Exp $
 */

################################################################################
# NO NEED TO EDIT ANYTHING BELOW THIS LINE TO GET SENDCARD WORKING WITH
# PHP-NUKE OR PHPWEBSITE.  LOOK IN THE ADMIN AREA INSTEAD
################################################################################

define('SENDCARD_FILE_PATH', dirname(__FILE__) . '/');

// Try and manipulate some PHP settings to make sendcard work properly
@ini_set('magic_quotes_gpc', '0');
@ini_set('magic_quotes_runtime', '0');


#error_reporting(E_ALL); // used for debugging
error_reporting(E_ALL & ~E_NOTICE);
set_magic_quotes_runtime(0);
extract((array)$HTTP_POST_VARS);
extract((array)$HTTP_GET_VARS);

// Include setup file
$dbfile = "";
require_once(SENDCARD_FILE_PATH . "sendcard_setup.php");
define('SENDCARD_MODE', $sendcard_mode);

/*
 * Declare variables used from files below to remove security risk
 */



switch(SENDCARD_MODE){
	case "PHPWEBSITE":
		if(!isset($mainfile)) {
			include("./mainfile.php"); 
		}
		include("./open_session.php");
		include("./header.php");
		include("./config.php");

		global $plug_id;
		break;
	case 'PHP-NUKE':
		if (!stristr($HTTP_SERVER_VARS['PHP_SELF'], 'modules.php')) {
	  			#die ("You can't access this file directly...");
		}
		$sc_language = $currentlang;
		$module_name = 'sendcard';
		define('FORM_ACTION', 'modules.php?name=sendcard');
		require_once("mainfile.php");
		require('header.php');
		break;
	default:
		define('FORM_ACTION', 'sendcard.php');
		break;
}

/*
 * Include all the necessary files
 */

// Set the default language file to be included
if (!isset($sc_language)) {
    $sc_language = $sc_default_language;
}

setcookie('sc_language', $sc_language);

require_once(SENDCARD_FILE_PATH . "include/".$dbfile);
require_once(SENDCARD_FILE_PATH . "include/template.inc");
require_once(SENDCARD_FILE_PATH . "include/lang/" . $sc_language . "/sendcard.lang.php");
require_once(SENDCARD_FILE_PATH . "functions.php");
require_once(SENDCARD_FILE_PATH . "sendcard_user_functions.php");

setlocale(LC_ALL, $sc_lang['locale']);
$date = strftime($sc_lang['date_format']);

/* If the variables are unset, initialise them with empty values as it prevents
 * any errors when error_reporting is set to E_ALL
 */
$from = isset($from) ? prevent_xss($from) : '';
$to = isset($to) ? prevent_xss($to) : '';
$image = isset($image) ? prevent_xss($image) : '';
$caption = isset($caption) ? prevent_xss($caption) : '';
$bgcolor = isset($bgcolor) ? prevent_xss($bgcolor) : '';
$to_email = isset($to_email) ? prevent_xss($to_email) : '';
$from_email = isset($from_email) ? prevent_xss($from_email) : '';
$fontface = isset($fontface) ? prevent_xss($fontface) : '';
$fontcolor = isset($fontcolor) ? prevent_xss($fontcolor) : '';
$message = isset($message) ? prevent_xss($message) : '';
$music = isset($music) ? prevent_xss($music) : '';
if (!isset($notify)) { $notify = 0; }
if (!isset($id)) { $id = ""; }
$applet_name = isset($applet_name) ? prevent_xss($applet_name) : '';
// You may want to remove the prevent_xss() call from the following if your
// $user1, $user2 and $user3 contain javascript
$user1 = isset($user1) ? prevent_xss($user1) : '';
$user2 = isset($user2) ? prevent_xss($user2) : '';
$user3 = isset($user3) ? prevent_xss($user3) : '';

$send_time = isset($send_time) ? $send_time : '';

define('SENDCARD_SITE_URL', 'http://www.sendcard.org');

// Get the template details
if(!isset($form) || $form == ''){
	$form = "form";
}
if(!isset($des) || $des == ''){
	$des = "card";
}
if (!isset($template) || $template == '') {
    $template = 'message';
}
// If we have the printer friendly version requested:
if(isset($print)) {
	$des = "print";
	$sc_lang['view_message'] = $sc_lang['print_view_message'];
}

/*** plugin top_file ***/


$db = new DB_Sendcard;
/*** plugin after_db_init ***/
if ($separate_language_templates) {
    $tpl = new Sendcard_Template($tpl_path . '/' . $sc_language);
} else {
    $tpl = new Sendcard_Template($tpl_path);
}
// Set the global files - we override this when viewing the card
$tpl->set_file(array("form" => "$form.tpl", "message" => "$template.tpl", "card" => "$des.tpl", "img_tags" => "image.tpl"));
$tpl->set_var('SENDCARD_SITE_URL', SENDCARD_SITE_URL);

/*** plugin after_db_tpl_init ***/

foreach($sc_lang as $key => $val) {
    $tpl->set_var("LANG:$key", $val);
}
$tpl->set_var('FORM_ACTION', FORM_ACTION);

// If it's preview time, validate the email addresses
 // Check that both email addresses validate   
 if ( isset($preview) ) {   
    if (!is_valid_email($to_email)) {   
    	unset($preview);   
        $invalid_to_email = 1;   
    }   
    if (!is_valid_email($from_email)){   
        unset($preview);   
        $invalid_from_email = 1;   
	}   
} 


/*****************************************************************************/
if ( isset($preview) ) {
/*****************************************************************************/

// Preview the card

$message = stripslashes($message);

/*** plugin preview_top ***/

if (isset($notify) && '' == $notify) {
	$notify = 0;
}

if( !isset($month) ) {
	$month = "";
}
if( !isset($day) ) {
	$day = "";
}
if( !isset($year) ) {
	$year = "";
}

$send_time = advancetime($month, $day, $year);


$send_button = "\n        <form method=\"post\" action=\"" . FORM_ACTION . "\">";
$send_button .= buildHiddenInputs(array('image' => $image,
                                        'caption' => $caption,
                                        'bgcolor' => $bgcolor,
                                        'to' => $to,
                                        'to_email' => $to_email,
                                        'send' => 1,
                                        'from' => $from,
                                        'from_email' => $from_email,
                                        'fontface' => $fontface,
                                        'fontcolor' => $fontcolor,
                                        'message' => $message,
                                        'music' => $music,
                                        'notify' => $notify,
                                        'send_time' => $send_time,
                                        'template' => $template,
                                        'des' => $des,
                                        'img_width' => $img_width,
                                        'img_height' => $img_height,
                                        'applet_name' => $applet_name,
                                        'previewed' => 1,
                                        'user1' => $user1,
                                        'user2' => $user2,
                                        'user3' => $user3,
                                        'sc_language' => $sc_language
                                        ), '        ');

$send_button .= "        <input type=\"submit\" name=\"send\" value=\"" . $sc_lang['send_button_label'] . "\">\n";

/*** plugin preview_send_button ***/

$send_button .= "        </form>\n";

$message = makesafe($message);
$message = makeurl($message);
$caption = stripslashes($caption);

set_img_block($image);

$tpl->set_var("IMG_PATH", $img_path);
$tpl->set_var("IMAGE", $image);
$tpl->set_var("CAPTION", $caption);
$tpl->set_var("BGCOLOR", $bgcolor);
$tpl->set_var("TO", $to[0]);
$tpl->set_var("TO_EMAIL", $to_email[0]);
$tpl->set_var("FROM", $from);
$tpl->set_var("FROM_EMAIL", $from_email);
$tpl->set_var("FONTFACE", $fontface);
$tpl->set_var("FONTCOLOR", $fontcolor);
$tpl->set_var("IMG_WIDTH", $img_width);
$tpl->set_var("IMG_HEIGHT", $img_height);
$tpl->set_var("MESSAGE", nl2br($message));
$tpl->set_var("MUSIC", $music_path . $music);
$tpl->set_var("APPLET_NAME", $applet_name);
$tpl->set_var("USER1", $user1);
$tpl->set_var("USER2", $user2);

/*** plugin preview_bottom ***/

if ($music == "") {
	$tpl->del_block("message", "music_block");
}
$tpl->set_var("FOOTER", $send_button);

$tpl->parse("CONTENT", array("message", "card"));
$tpl->p("CONTENT", "card");

/*****************************************************************************/
}elseif ( isset($send) ) {
/*****************************************************************************/

/**
 *
 * Send the card
 *
 */

if (!isset($previewed)) {
	// This has been added so that if you don't go through the preview screen
	// then it still works.
	if (isset($notify) && '' == $notify) {
		$notify = 0;
	}
	
	if( !isset($month) ) {
		$month = "";
	}
	if( !isset($day) ) {
		$day = "";
	}
	if( !isset($year) ) {
		$year = "";
	}
    $send_time = advancetime($month, $day, $year);
}

$ip_address = isset($HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR']) ? $HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'] : $HTTP_SERVER_VARS['REMOTE_ADDR'];

/*** plugin send_top ***/
$ip_address_time_limit = time() - $block_sending_time;
$db->query("SELECT count(*) as c FROM $tbl_name WHERE ip_address='$ip_address' AND time_created > $ip_address_time_limit");
while($db->next_record()){
	$num_ip_address = $db->f('c');
} // while
if ($num_ip_address > $block_sending_number) {
    sendcard_show_message(stripslashes($sc_lang['sent_too_many_cards']));
    exit();
}

$emailsent = ($send_time > time()) ? 0 : 1;

if(!get_magic_quotes_gpc()){
	$loop_num = count($to);
    for($i=0;$i< $loop_num; $i++){
         $to[$i] = addslashes($to[$i]);
    }
    $from = addslashes($from);
}

$message = prevent_xss($message);

if(!get_magic_quotes_gpc()){
     $message = addslashes($message);
     $caption = addslashes($caption);
     $user1 = addslashes($user1);
     $user2 = addslashes($user2);
}

// Seed the random number generator for use in function make_card_id.  This seed
// is from the PHP manual page for mt_srand
mt_srand (hexdec(substr(md5(microtime()), -8)) & 0x7fffffff);


$loop_num =  count($to_email);
if ($loop_num > $max_cards) {
    die($sc_lang['too_many_recipients']);
}

for ($i = 0; $i < $loop_num; $i++){
    $id = make_card_id();
    $sql = "INSERT INTO $tbl_name (image, caption, bgcolor, towho, to_email, fromwho, from_email, fontcolor, fontface, message, music, id, notify, emailsent, template, des, img_width, img_height, applet_name, user1, user2, user3, send_time, time_created, ip_address, sc_language";
	/*** plugin send_loop_sql_1 ***/
	$sql .= ") VALUES ('$image', '$caption', '$bgcolor', '$to[$i]', '$to_email[$i]', '$from', '$from_email', '$fontcolor', '$fontface', '$message', '$music', '$id', '$notify', '$emailsent', '$template', '$des', '$img_width', '$img_height', '$applet_name', '$user1', '$user2', '$user3', '$send_time', '" . time() . "', '$ip_address', '$sc_language'";
    /*** plugin send_loop_sql_2 ***/
	$sql .= ")";
    $db->query($sql);
    /*** plugin send_loop ***/

	if ($emailsent == 1) {
        send_card_email(stripslashes($to[$i]), $to_email[$i], stripslashes($from), $from_email, $id);
        /*** plugin before_send_card_email ***/
    }// End if

}//End for


/*** plugin send_bottom ***/
$tpl->set_var("CONTENT", $sc_lang['thankyou']);
$tpl->pparse("GLOBAL", "card");

/*****************************************************************************/
}elseif ( isset($view) && $view != 0 ){
/*****************************************************************************/

/*** plugin view_top ***/

$query = "SELECT * FROM $tbl_name where id='$id'";
$db->query($query);

while($db->next_record()) {
    $image = $db->f("image");
    $caption = stripslashes($db->f("caption"));
    $bgcolor = $db->f("bgcolor");
    $to = stripslashes( $db->f("towho") ) ;
    $to_email = $db->f("to_email");
    $from = stripslashes($db->f("fromwho"));
    $from_email = $db->f("from_email");
    $message = makesafe(stripslashes($db->f("message")));
    $fontface = $db->f("fontface");
    $fontcolor = $db->f("fontcolor");
    $template = $db->f("template");
    $music = $db->f("music");
    $notify = $db->f("notify");
    if ($des != 'print') {
        $des = $db->f("des");
    }
    $img_width = $db->f("img_width");
    $img_height = $db->f("img_height");
    $applet_name = $db->f("applet_name");
    $user1 = stripslashes($db->f("user1"));
    $user2 = stripslashes($db->f("user2"));
    $user3 = stripslashes($db->f("user3"));
    $id = $db->f("id");
    $sc_language = $db->f("sc_language");
}

// Language handling code
if ($separate_language_templates) {
    $tpl->set_root($tpl_path . '/' . $sc_language);
}
require_once(SENDCARD_FILE_PATH . "include/lang/" . $sc_language . "/sendcard.lang.php");
if(isset($print)) {
	$des = "print";
	$sc_lang['view_message'] = $sc_lang['print_view_message'];
}

$tpl->set_file(array("message" => "$template.tpl", "card" => "$des.tpl"));
/*** plugin view_after_set_file ***/

// Check to see if there was a matching row in the database
if($to != "") {
$message = makeurl($message);
set_img_block($image);

/*** plugin view_middle ***/

$tpl->set_var("IMG_PATH", $img_path);
$tpl->set_var("IMAGE", $image);
$tpl->set_var("CAPTION", $caption);
$tpl->set_var("BGCOLOR", $bgcolor);
$tpl->set_var("TO", $to);
$tpl->set_var("TO_EMAIL", $to_email);
$tpl->set_var("FROM", $from);
$tpl->set_var("FROM_EMAIL", $from_email);
$tpl->set_var("FONTFACE", $fontface);
$tpl->set_var("FONTCOLOR", $fontcolor);
$tpl->set_var("MESSAGE", nl2br($message));
$tpl->set_var("MUSIC", $music_path . $music);
$tpl->set_var("IMG_WIDTH", $img_width);
$tpl->set_var("IMG_HEIGHT", $img_height);
$tpl->set_var("APPLET_NAME", $applet_name);
$tpl->set_var("USER1", $user1);
$tpl->set_var("USER2", $user2);
$tpl->set_var("USER3", $user3);
$tpl->set_var("FOOTER", subst_placeholders(stripslashes($sc_lang['view_message'])));
if ($music == "") {
	$tpl->del_block("message", "music_block");
}
$tpl->parse("CONTENT", "message");
$tpl->pparse("CONTENT", "card");


// Check to see that the sender has asked to be notified, and that it isn't the sender viewing the card.
if ($notify == 1 && $sender_view != "1"){
	send_thankyou_email($from, $from_email, $to, $to_email);

    $query = "UPDATE $tbl_name SET notify='0' where id='$id'";
    $db->query($query);
}

$oldtime = time() - $kept;

$clearout = "DELETE FROM $tbl_name where send_time < $oldtime";
$db->query($clearout);
/*** plugin view_bottom ***/


} else {
	// If no data was found, we print an apologetic message.
	sendcard_show_message(stripslashes($sc_lang['no_card_msg']));
} // End else

/*****************************************************************************/
}else{
/*****************************************************************************/

if (0 == count($HTTP_POST_VARS) && 0 == count($HTTP_GET_VARS)) {
	// The form hasn't been submitted - someone's requested sendcard.php directly.
	sendcard_show_message(stripslashes($sc_lang['no_card_msg']));
	exit();
}
/*
 * This is where we generate the form to fill in the card.
 */
if( !isset($num_recipients) ){
    $num_recipients = 1;
}

// Now we test to see if the image width and height have been specified. If not,
// we get them from the image.  We can only get them from GIF, JPG, PNG or SWF files
if(!isset($img_width) && !isset($img_height) ) {
	$img_width = img_width($image);
	$img_height = img_height($image);
}

/*** plugin form_top ***/

#$tpl->set_file(array("form" => "$form.tpl", "card" => "$des.tpl", "img_tags" => "image.tpl"));
$tpl->set_block("form", "recipient_block", "recipient");

set_img_block($image);

$tpl->set_var("APPLET_NAME", $applet_name);
$tpl->set_var("IMG_PATH", $img_path);
$tpl->set_var("IMAGE", $image);
$tpl->set_var("CAPTION", $caption);
$tpl->set_var("DES", $des);
$tpl->set_var('FORM', $form);
$tpl->set_var("TEMPLATE", $template);
$tpl->set_var("IMG_WIDTH", $img_width);
$tpl->set_var("IMG_HEIGHT", $img_height);

for($i=0; $i < $num_recipients;$i++){
    $tpl->set_var("TO", $to[$i]);
    $tpl->set_var("TO_EMAIL", $to_email[$i]);
    $tpl->set_var("I", $i);
    $tpl->parse("recipient", "recipient_block", true);
}

$tpl->set_var("FROM", $from);
$tpl->set_var("FROM_EMAIL", $from_email);

$use_adv_date = isset($use_adv_date) ? $use_adv_date : 1;
if($use_adv_date) {
	$tpl->set_var("DATE", DateSelector("Now"));
} else {
	$tpl->set_var("DATE", "");
}
$tpl->set_var("APPLET_NAME", $applet_name);
$tpl->set_var("USER1", $user1);
$tpl->set_var("USER2", $user2);
$tpl->set_var("MESSAGE", $message);
$tpl->set_var("NUM_RECIPIENTS", $num_recipients);

if ( isset($invalid_to_email) ) {
	$tpl->set_var("INVALIDTO_EMAIL", $sc_lang['email_error']);
}else{
	$tpl->set_var("INVALIDTO_EMAIL", "");
}
if ( isset($invalid_from_email) ) {
	$tpl->set_var("INVALIDFROM_EMAIL", $sc_lang['email_error']);
}else{
	$tpl->set_var("INVALIDFROM_EMAIL", "");
}

$preview_button .= buildHiddenInputs(array('image' => $image,
                                        'caption' => $caption,
                                        'num_recipients' => $num_recipients,
                                        'template' => $template == 'message' ? '' : $template,
                                        'des' => $des == 'card' ? '' : $des,
                                        'img_width' => $img_width,
                                        'img_height' => $img_height,
                                        'applet_name' => $applet_name,
                                        'user1' => $user1,
                                        'user2' => $user2,
                                        'user3' => $user3,
                                        'sc_language' => $sc_language
                                        ), '        ');

/*** plugin form_bottom ***/

$tpl->set_var("FOOTER", $preview_button);



$tpl->parse("CONTENT", "form");
$tpl->pparse("CONTENT", "card");

}//End else
/*** plugin end_file ***/
switch(SENDCARD_MODE){
	case "PHPWEBSITE":
		include("./footer.php");
		break;
	case 'PHP-NUKE':
		include('footer.php');
		break;
	default:
		break;
}
?>