
CREATE TABLE `comentarios` (
  `id` bigint(20) NOT NULL auto_increment,
  `ref_id` bigint(20) NOT NULL default '0',
  `ref_tipo` char(3) NOT NULL default 'pag',
  `userid` bigint(20) NOT NULL default '0',
  `data` datetime NOT NULL default '0000-00-00 00:00:00',
  `comentario` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `paginaid` (`ref_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 

--

CREATE TABLE `down_cat` (
  `id` bigint(20) NOT NULL auto_increment,
  `nome` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 

-- 

INSERT INTO `down_cat` VALUES (1, 'Geral')

--

CREATE TABLE `downloads` (
  `id` bigint(20) NOT NULL auto_increment,
  `arquivo` varchar(255) NOT NULL default '',
  `titulo` varchar(255) NOT NULL default '',
  `descricao` text NOT NULL,
  `categoria` bigint(20) NOT NULL default '0',
  `pagid` bigint(20) default NULL,
  `link` varchar(255) default NULL,
  `data` datetime NOT NULL default '0000-00-00 00:00:00',
  `permissao` enum('Todos','Membros') NOT NULL default 'Todos',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 

--

CREATE TABLE `enquete` (
  `id` bigint(20) NOT NULL auto_increment,
  `pergunta` varchar(255) NOT NULL,
  `inicio` date NOT NULL,
  `fim` date NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 

-- 

CREATE TABLE `enquete_respostas` (
  `id` bigint(20) NOT NULL auto_increment,
  `enquete_id` bigint(20) NOT NULL,
  `resposta` varchar(255) NOT NULL,
  `votos` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `enquete_id` (`enquete_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 

--  

CREATE TABLE `forum_cat` (
  `id` bigint(20) NOT NULL auto_increment,
  `titulo` varchar(255) NOT NULL default '',
  `descricao` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 

-- 

INSERT INTO `forum_cat` VALUES (1, 'Geral', 'Forum de debate geral')

-- 

CREATE TABLE `forum_respostas` (
  `id` bigint(20) NOT NULL auto_increment,
  `topico_id` bigint(20) NOT NULL default '0',
  `user_id` bigint(20) NOT NULL default '0',
  `data` datetime NOT NULL default '0000-00-00 00:00:00',
  `mensagem` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 

--

CREATE TABLE `forum_topicos` (
  `id` bigint(20) NOT NULL auto_increment,
  `cat_id` bigint(20) NOT NULL default '0',
  `data` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_id` bigint(20) NOT NULL default '0',
  `titulo` varchar(255) NOT NULL default '',
  `mensagem` text NOT NULL,
  `ultima_resp` datetime NOT NULL default '0000-00-00 00:00:00',
  `respostas` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 

--

CREATE TABLE `lista_ips` (
  `ip` varchar(15) NOT NULL default '000.000.000.000',
  `str_tag` varchar(255) default NULL,
  `int_tag` bigint(20) default NULL,
  `data_tag` datetime NOT NULL,
  KEY `ip` (`ip`),
  KEY `expirar` (`data_tag`)
) ENGINE=MyISAM

--

CREATE TABLE `noticias` (
  `id` bigint(20) NOT NULL auto_increment,
  `titulo` varchar(255) default NULL,
  `texto` text,
  `data` datetime NOT NULL default '0000-00-00 00:00:00',
  `pagid` bigint(20) default '0',
  `link` varchar(255) default NULL,
  `icone` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 

--  

CREATE TABLE `paginas` (
  `id` bigint(20) NOT NULL auto_increment,
  `permissao` enum('Todos','Membros','Administrador') NOT NULL default 'Todos',
  `moddata` datetime default NULL,
  `titulo` varchar(255) default NULL,
  `conteudo` text,
  `phpinclude` varchar(255) default NULL,
  `comentarios` enum('Sim','Nao') NOT NULL default 'Sim',
  `includepos` enum('Acima','Abaixo') NOT NULL default 'Acima',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 

-- 

INSERT INTO `paginas` VALUES (1, 'Todos', '0000-00-00 00:00:00', 'Pagina Principal', '<p style="font-family: arial,helvetica,sans-serif"><font size="2">O PortalFacil  um Sistema de Gerenciamento de  Contedo feito em PHP voltado para sites de pequeno porte.</font></p>  <font size="2" style="font-family: arial,helvetica,sans-serif"><b>  Apelido do administrador e senha de acesso:<br />  E-mail: admin@localhost.abc<br />  Senha: 123mudar<br /><br /></b>O sistema  desenvolvido em PHP usando banco de dados MySQL, o layout pode ser modificado facilmente em editores html, tem suporte a temas, a traduo para outros idiomas  bem simples, tem suporte a XML/RSS Feed para as noticias, Forum, area de Downloads, Smiles, Enquetes, sistema de Busca e editor visual de HTML.<br /><br />Divirta-se )<br /></font>', 'noticias.php', 'Sim', 'Abaixo')

--

CREATE TABLE `paineis` (
  `id` bigint(20) NOT NULL auto_increment,
  `titulo` varchar(255) default NULL,
  `permissao` enum('Todos','Membros','Administrador','Visitantes') NOT NULL default 'Administrador',
  `lado` enum('Esquerdo','Direito','Inferior','Superior','Oculto') NOT NULL default 'Esquerdo',
  `conteudo` text,
  `include` varchar(255) default NULL,
  `includepos` enum('Acima','Abaixo') NOT NULL default 'Acima',
  `moldura` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 

--

INSERT INTO `paineis` VALUES (1, 'Estatisticas', 'Todos', 'Inferior', '', 'usuariosonline.php', 'Acima', 1)
--
INSERT INTO `paineis` VALUES (2, 'Administrador', 'Administrador', 'Esquerdo', '<a href="index.php?acao=admin">Administrao</a>', '', 'Acima', 1)
--
INSERT INTO `paineis` VALUES (3, 'Menu', 'Todos', 'Esquerdo', '', 'menu.php', 'Acima', 1)
--
INSERT INTO `paineis` VALUES (4, 'Indice', 'Todos', 'Esquerdo', '<p><a href="index.php">Home Page</a></p>     \r\n\r\n<p><a href="index.php?acao=noticias">Noticias</a></p>     \r\n\r\n<p><a href="index.php?acao=downloads">Downloads</a></p>\r\n\r\n<p><a href="index.php?acao=forum">Forum</a></p>\r\n\r\n<p><a href="index.php?acao=busca">Busca</a></p>\r\n\r\n<p><a href="index.php?acao=enquete">Enquete</a></p>', '', 'Acima', 1)
--
INSERT INTO `paineis` VALUES (5, 'Enquete', 'Todos', 'Esquerdo', '', 'enquete.php', 'Abaixo', 1)
--
INSERT INTO `paineis` VALUES (6, 'Ultimas Noticias', 'Todos', 'Esquerdo', '', 'ultimasnoticias.php', 'Acima', 1)
--
INSERT INTO `paineis` VALUES (8, 'Forum', 'Todos', 'Esquerdo', '', 'ultimasdoforum.php', 'Acima', 1)

-- 

CREATE TABLE `permissoes` (
  `usuario_id` bigint(20) NOT NULL default '0',
  `paginas` tinyint(1) NOT NULL default '0',
  `paineis` tinyint(1) NOT NULL default '0',
  `membros` tinyint(1) NOT NULL default '0',
  `noticias` tinyint(1) NOT NULL default '0',
  `forum` tinyint(1) NOT NULL default '0',
  `downloads` tinyint(1) NOT NULL default '0',
  `imagens` tinyint(1) NOT NULL default '0',
  `enquetes` tinyint(1) NOT NULL default '0',
  `plugins` tinyint(1) NOT NULL default '0',
  `email` tinyint(1) NOT NULL default '0',
  `opcoes` tinyint(1) NOT NULL default '0',
  `moderar_forum` tinyint(1) NOT NULL default '0',
  `permissoes` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`usuario_id`)
) ENGINE=MyISAM

--

INSERT INTO `permissoes` VALUES (2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)

--

CREATE TABLE `smiles` (
  `id` bigint(20) NOT NULL auto_increment,
  `code` varchar(255) NOT NULL,
  `src` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 

--

INSERT INTO `smiles` VALUES (7, ':)', 'smile.gif')
--
INSERT INTO `smiles` VALUES (6, ':(', 'sad.gif')
--
INSERT INTO `smiles` VALUES (5, ':/', 'dry.gif')
--
INSERT INTO `smiles` VALUES (4, ':P', 'tongue.gif')
--
INSERT INTO `smiles` VALUES (3, ';)', 'wink.gif')
--
INSERT INTO `smiles` VALUES (2, ':(', 'cry.gif')
--
INSERT INTO `smiles` VALUES (1, '>:(', 'mad.gif')

--

CREATE TABLE `usuarios` (
  `id` bigint(20) NOT NULL auto_increment,
  `tipo` enum('Membro','Administrador','Visitante') NOT NULL default 'Membro',
  `email` varchar(255) NOT NULL default '',
  `senha` varchar(20) NOT NULL default '',
  `nome` varchar(255) NOT NULL default '',
  `nick` varchar(255) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `data` datetime NOT NULL default '0000-00-00 00:00:00',
  `newsletter` char(1) NOT NULL default 'N',
  `avatar` varchar(255) default NULL,
  `bloqueado` enum('Sim','No') NOT NULL default 'No',
  `pais` varchar(255) default NULL,
  `cidade` varchar(255) default NULL,
  `uf` varchar(2) default NULL,
  `foto` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email_2` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 

--

INSERT INTO `usuarios` VALUES (1, 'Visitante', 'visitante', 'visitante', 'Visitante', 'Visitante', '', '0000-00-00 00:00:00', 'N', NULL, 'No', '', '', '', NULL)
--
INSERT INTO `usuarios` VALUES (2, 'Administrador', 'admin@localhost.abc', '123mudar', 'Administrador', 'Admin', '', '0000-00-00 00:00:00', 'S', '', 'No', 'Brasil', 'So Paulo', 'SP', '')

-- 

CREATE TABLE `usuariosonline` (
  `ip` varchar(15) NOT NULL default '',
  `id` bigint(20) default NULL,
  `nome` varchar(255) default NULL,
  `data` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ip`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM