# templates.inc

use strict;

# Templates screen
sub templates
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Get a list of available templates
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/TEMPLATES.cgi");
	$file_db->close_file();
	my %template_info = $file_db->get_records(-sort_by => "template_date");

	# Page breakdown
	my $current_page = int($FORM->param('page'));
	my $total_records = 0;
	$total_records = scalar(@{$template_info{'template_id'}}) if %template_info;
	my ($start_pos, $end_pos, $prev_link, $next_link) = &page_breaker($current_page, $main::TEMPLATES_PER_PAGE, $total_records, "templates");

	# Start new GUI screen
	my $screen = lib::GUI->new( title    => "Member Area: Templates",
	                            user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->tab( -label  => "Existing Templates",
		              -active => 1
		            );

		$screen->tab( -label  => "Create New Template",
		              -link   => "$main::SCRIPT_URL/members.cgi?redirect=new_template",
		            );

		# List of templates
		if ($total_records > 0) {
			my $delete_link = "";
			my $date = new lib::Date;
			for(my $k = $start_pos; $k <= $end_pos; $k++) {
				if (scalar(@{$template_info{'template_id'}}) > 1) {
					$delete_link = qq([<a href="$main::SCRIPT_URL/members.cgi?redirect=confirm_template_deletion&template_id=$template_info{'template_id'}[$k]">delete</a>]</font>);
				}
				$template_info{'template_date'}[$k] = $date->to_string( -date      => $template_info{'template_date'}[$k],
				                                                        -show_time => '1');
				$screen->main_block(-code => qq(<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$template_info{'template_name'}[$k]</font><br> 
						                                <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">Last Modified: $template_info{'template_date'}[$k]<br> 
						                                [<a href="$main::SCRIPT_URL/members.cgi?redirect=edit_template&template_id=$template_info{'template_id'}[$k]">edit</a>] 
						                                $delete_link)
						                   );
			}
		} else {
				$screen->main_block( -code => qq(<br><br><div align="center"><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">There are no templates available.</font></div><br><br>));
		}

		$screen->main_footer(-label => "$prev_link :: $next_link") if $main::TEMPLATES_PER_PAGE > 0;

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Create new template
sub new_template
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Default template code
	my $submission_code = qq(<table width="300" border="0" cellspacing="5" cellpadding="0">
                                 <tr> 
                                 <td>{POLL_QUESTION}</td>
                                 </tr>
                                 <tr> 
                                 <td>{POLL_OPTIONS}</td>
                                 </tr>
                                 <tr> 
                                 <td>{SUBMIT_BUTTON} {VIEW_BUTTON}</td>
                                 </tr>
                                 <tr> 
                                 <td><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">Start date: </font>{START_DATE}</td>
                                 </tr>
                                 <tr> 
                                 <td><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">End date: </font>{END_DATE}</td>
                                 </tr>
                                 </table>);

	my $display_code = qq(<table width="300" border="0" cellspacing="5" cellpadding="0">
                              <tr> 
                              <td>{POLL_QUESTION}</td>
                              </tr>
                              <tr> 
                              <td>{POLL_RESULTS}</td>
                              </tr>
                              <tr> 
                              <td><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">Total votes: </font>{TOTAL_VOTES}</td>
                              </tr>
                              <tr> 
                              <td><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">Start date: </font>{START_DATE}</td>
                              </tr>
                              <tr> 
                              <td><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">End date: </font>{END_DATE}</td>
                              </tr>
                              </table>);

	&filter_html($submission_code, $display_code);

	# Start new GUI screen
	my $screen = lib::GUI->new( title    => "Member Area: Templates",
	                            user_msg => $memb_info{'user_info'}
	                          );

		# Focus on first field (template name)
		$screen->javascript(-location => "body",
		                    -code     => qq(onload="document.adform1.template_name.focus(); document.adform1.template_name.select()")
		                   );

		# Main window
		$screen->tab( -label  => "Existing Templates",
		              -link   => "$main::SCRIPT_URL/members.cgi?redirect=templates"
		            );

		$screen->tab( -label  => "Create New Template",
		              -active => 1
		            );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_template">)
		                   );

		$screen->main_field( -label => "Template name:",
		                     -code  => qq(<input name="template_name" type="text" class="guitextbox" size="40" maxlength="150" value="My Template">)
		                   );

		$screen->main_field( -label => "Font face:",
		                     -code  => qq(<input name="template_font_face" type="text" class="guitextbox" size="40" maxlength="150" value="$main::FONT_FACE">)
		                   );

		$screen->main_field( -label => "Font size:",
		                     -code  => qq(<input name="template_font_size" type="text" class="guitextbox" size="40" maxlength="3" value="1">)
		                   );

		$screen->main_field( -label => "Poll alignment:",
		                     -code  => qq(<input type="radio" name="poll_alignment" value="horizontal" checked>
                                                  <img src="$main::NONCGI_URL/icons/horizontal_poll.gif" border="0" width="20" height="20" alt="Horizontal">
                                                  <input type="radio" name="poll_alignment" value="vertical">
                                                  <img src="$main::NONCGI_URL/icons/vertical_poll.gif" border="0" width="20" height="20" alt="Vertical"></font>)
		                   );

		$screen->main_field( -label       => "Poll option separator:",
		                     -description => "*defines radio button alignment",
		                     -code        => qq(<input name="option_separator" type="text" class="guitextbox" size="40" maxlength="300" value="&lt;br&gt;">)
		                   );

		$screen->main_field( -label => "Show the number of votes:",
		                     -code  => qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		                                  <input type="radio" name="show_votes" value="1" checked>
                                                  Yes 
                                                  <input type="radio" name="show_votes" value="0">
                                                  No</font>)
		                   );

		$screen->main_field( -label => "Show vote distribution (%):",
		                     -code  => qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		                                  <input type="radio" name="show_percent" value="1" checked>
                                                  Yes 
                                                  <input type="radio" name="show_percent" value="0">
                                                  No</font>)
		                   );

		$screen->main_field( -label => "Show graphic bars:",
		                     -code  => qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		                                  <input type="radio" name="show_bars" value="1" checked>
                                                  Yes 
                                                  <input type="radio" name="show_bars" value="0">
                                                  No</font>)
		                   );

		$screen->main_field( -label       => "Graphic bar length (maximum):",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="bar_length" type="text" class="guitextbox" size="40" maxlength="3" value="150">)
		                   );

		$screen->main_field( -label       => "Graphic bar width:",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="bar_width" type="text" class="guitextbox" size="40" maxlength="3" value="10">)
		                   );

		$screen->main_field( -label       => "Poll results horizontal spacing:",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="options_horizontal_spacing" type="text" class="guitextbox" size="40" maxlength="3" value="5">)
		                   );

		$screen->main_field( -label       => "Poll results vertical spacing:",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="options_vertical_spacing" type="text" class="guitextbox" size="40" maxlength="3" value="5">)
		                   );

		$screen->main_field( -label       => "Poll submission screen code:",
		                     -description => "*variables:<br>
		                                      {POLL_QUESTION}<br>
		                                      {POLL_OPTIONS}<br>
		                                      {SUBMIT_BUTTON}<br>
		                                      {VIEW_BUTTON}<br>
		                                      {START_DATE}<br>
		                                      {END_DATE}",
		                     -code => qq(<textarea name="submission_code" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$submission_code</textarea>)
		                   );

		$screen->main_field( -label       => "Poll display screen code:",
		                     -description => "*variables:<br>
		                                      {POLL_QUESTION}<br>
		                                      {POLL_RESULTS}<br>
		                                      {TOTAL_VOTES}<br>
		                                      {START_DATE}<br>
		                                      {END_DATE}",
		                     -code => qq(<textarea name="display_code" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$display_code</textarea>)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi?redirect=templates'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer(-label => 'All fields are required.');

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Save template information
sub save_template
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Error checking
	my $error_string = "";

	if ($FORM->param('template_name')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter template name.";
	}

	if ($FORM->param('template_font_face')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter font face.";
	}

	if ($FORM->param('template_font_size')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter font size.";
	}

	if ($FORM->param('bar_length') !~ /^\d+$/) {
		$error_string .= "<br>- Graphic bar length must be an integer between 1 and 999.";
	}

	if ($FORM->param('bar_width') !~ /^\d+$/) {
		$error_string .= "<br>- Graphic bar width must be an integer between 1 and 999.";
	}

	if ($FORM->param('options_horizontal_spacing') !~ /^\d+$/) {
		$error_string .= "<br>- Poll results horizontal spacing must be an integer between 1 and 999.";
	}

	if ($FORM->param('options_vertical_spacing') !~ /^\d+$/) {
		$error_string .= "<br>- Poll results vertical spacing must be an integer between 1 and 999.";
	}

	if ($FORM->param('submission_code')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter poll submission screen code.";
	}

	if ($FORM->param('display_code')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter poll display screen code.";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                );
	}

	# Format fields
	my $template_name = $FORM->param('template_name');
	my $template_font_face = $FORM->param('template_font_face');
	my $template_font_size = $FORM->param('template_font_size');
	my $poll_alignment = $FORM->param('poll_alignment');
	my $option_separator = $FORM->param('option_separator');
	my $show_votes = $FORM->param('show_votes');
	my $show_percent = $FORM->param('show_percent');
	my $show_bars = $FORM->param('show_bars');
	my $bar_length = $FORM->param('bar_length');
	my $bar_width = $FORM->param('bar_width');
	my $options_horizontal_spacing = $FORM->param('options_horizontal_spacing');
	my $options_vertical_spacing = $FORM->param('options_vertical_spacing');
	my $submission_code = $FORM->param('submission_code');
	my $display_code = $FORM->param('display_code');

	$poll_alignment   = "horizontal" unless $poll_alignment eq "vertical";

	foreach my $field($show_votes, $show_percent, $show_bars) {
		$field = '1' unless $field eq '0';
	}

	&filter_html($template_name);
	&remove_tabs_hard_returns($template_name, $template_font_face, $template_font_size, $option_separator, $submission_code, $display_code);
	&encode_text_fields($template_font_face, $template_font_size, $option_separator, $submission_code, $display_code);

	my $date = new lib::Date;
	my $current_date = $date->current_date();

	my $file_db = new lib::FileDB;

	# Get next available template id
	$file_db->open_file( -file_name => "$main::DATA_PATH/AUTO_INCREMENT.cgi", 
	                     -open_to   => "update" );
	my %template_id_info = $file_db->get_record(-condition => "field_name=TEMPLATE_ID");
	my $template_id = $template_id_info{'auto_value'};
	$file_db->update_records( -condition => "field_name=TEMPLATE_ID",
	                          -fields    => ['auto_value'], 
	                          -values    => [++$template_id]
	                         );
	$file_db->commit_changes();
	$file_db->close_file();

	# Add template to TEMPLATES table
	$file_db->open_file( -file_name => "$main::DATA_PATH/TEMPLATES.cgi", 
	                     -open_to   => "append" );
	$file_db->insert_record( -values    => [ $template_id,   $memb_info{'memb_id'}, 
	                                         $template_name, $current_date ]
	                         );
	$file_db->commit_changes();
	$file_db->close_file();

	# Create template file
	$file_db->open_file( -file_name => "$main::TMPL_PATH/$template_id.inc", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => [qq(# Poll Template (Warning! Do not edit manually.) #

\$template_font_face = qq~$template_font_face~;
\$template_font_size = qq~$template_font_size~;
\$poll_alignment = '$poll_alignment';
\$option_separator = qq~$option_separator~;
\$show_votes = '$show_votes';
\$show_percent = '$show_percent';
\$show_bars = '$show_bars';
\$bar_length = '$bar_length';
\$bar_width = '$bar_width';
\$options_horizontal_spacing = '$options_horizontal_spacing';
\$options_vertical_spacing = '$options_vertical_spacing';
\$submission_code = qq~$submission_code~;
\$display_code = qq~$display_code~;

1;)]
	                     );
	$file_db->commit_changes();
	$file_db->close_file();

	# Display success message
	lib::MsgBox->new( type           => "success",
	                  text           => "New template has been saved.",
	                  button2_action => "LINK",
	                  close_link     => "$main::SCRIPT_URL/members.cgi?redirect=templates",
	                 );
}

# Confirm template deletion
sub confirm_template_deletion
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Display a warning
	lib::MsgBox->new( type          => "question",
	                  hidden_fields => ['redirect', 'template_id'],
	                  hidden_values => ['delete_template', $FORM->param('template_id')],
	                  text          => "Are you sure you want to delete this template?",
	                  button1       => "Yes",
	                  button2       => "No"
	                );
}

# Delete template
sub delete_template
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Check if template is being used by any of the polls
	my $template_id = $FORM->param('template_id');
	my ($current_polls, $archived_polls);

	# Read polls
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/POLLS.cgi");
	$file_db->close_file();
	my %poll_info = $file_db->get_records(-condition => "template=$template_id");

	if (%poll_info) {

		my $date = new lib::Date;
		my $current_date = $date->current_date();
	
		for (my $i = 0; $i < scalar(@{$poll_info{'poll_id'}}); $i++) {
			if ($poll_info{'end_date'}[$i] > $current_date) {
				$current_polls .= "<br>- $poll_info{'poll_question'}[$i] (current)";
			} else {
				$archived_polls .= "<br>- $poll_info{'poll_question'}[$i] (archived)";
			}
		}
	
		lib::MsgBox->new( type           => "error",
		                  text           => "Cannot delete template because it is being used by the following poll(s): $current_polls $archived_polls",
		                  button2_action => "LINK",
		                  close_link     => "$main::SCRIPT_URL/members.cgi?redirect=templates"
		                );
	}

	# Remove template from TEMPLATES table
	$file_db->open_file( -file_name => "$main::DATA_PATH/TEMPLATES.cgi",
	                     -open_to   => "update" 
	                   );
	my %template_info = $file_db->get_records();
	if (%template_info && scalar(@{$template_info{'template_id'}}) < 2) {
		$file_db->commit_changes();
		$file_db->close_file();
		lib::MsgBox->new( type           => "error",
		                  text           => "Cannot delete template: you must have at least one template available at all times.",
		                  button2_action => "LINK",
		                  close_link     => "$main::SCRIPT_URL/members.cgi?redirect=templates"
		                );
	} else {
		$file_db->delete_records(-condition => "template_id=$template_id");
	}
	$file_db->commit_changes();
	$file_db->close_file();

	# Remove template file
	$file_db->delete_file(-file_name => "$main::TMPL_PATH/$template_id.inc");

	# Success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Selected template has been deleted.",
	                  button2_action => "LINK",
		          close_link     => "$main::SCRIPT_URL/members.cgi?redirect=templates"
	                );
}

# Edit template screen
sub edit_template
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my $template_id = $FORM->param('template_id');

	# Get template information
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/TEMPLATES.cgi");
	$file_db->close_file();
	my %template_info = $file_db->get_record(-condition => "template_id=$template_id");

	# Record not found
	if (!%template_info) {
		lib::MsgBox->new( type => "error",
		                  text => "Could not locate template (ID=$template_id)."
		                );
	}

	# Load template file
	require "$main::TMPL_PATH/$template_id.inc";

	# Start new GUI screen
	my $screen = lib::GUI->new( title    => "Member Area: Templates",
	                            user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->tab( -label  => "Existing Templates",
		              -active => 1
		            );

		$screen->tab( -label => "Create New Template",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=new_template",
		            );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_edited_template">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="template_id" type="hidden" value="$template_id">)
		                   );

		$screen->main_field( -label => "Template name:",
		                     -code  => qq(<input name="template_name" type="text" class="guitextbox" size="40" maxlength="150" value="$template_info{'template_name'}">)
		                   );

		$screen->main_field( -label => "Font face:",
		                     -code  => qq(<input name="template_font_face" type="text" class="guitextbox" size="40" maxlength="150" value="$main::template_font_face">)
		                   );

		$screen->main_field( -label => "Font size:",
		                     -code  => qq(<input name="template_font_size" type="text" class="guitextbox" size="40" maxlength="3" value="$main::template_font_size">)
		                   );

		# Check selected value
		my $tmp_code = qq(<input type="radio" name="poll_alignment" value="horizontal">
                                  <img src="$main::NONCGI_URL/icons/horizontal_poll.gif" border="0" width="20" height="20" alt="Horizontal">
                                  <input type="radio" name="poll_alignment" value="vertical">
                                  <img src="$main::NONCGI_URL/icons/vertical_poll.gif" border="0" width="20" height="20" alt="Vertical"></font>);
		$tmp_code =~ s/value=\"$main::poll_alignment\"/value=\"$main::poll_alignment\" checked/;

		$screen->main_field( -label => "Poll alignment:",
		                     -code  => $tmp_code
		                   );

		$screen->main_field( -label       => "Poll option separator:",
		                     -description => "*defines radio button alignment",
		                     -code        => qq(<input name="option_separator" type="text" class="guitextbox" size="40" maxlength="300" value="$main::option_separator">)
		                   );

		# Check selected value
		$tmp_code = qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		               <input type="radio" name="show_votes" value="1">
                               Yes 
                               <input type="radio" name="show_votes" value="0">
                               No</font>);
		$tmp_code =~ s/value=\"$main::show_votes\"/value=\"$main::show_votes\" checked/;
		$screen->main_field( -label => "Show the number of votes:",
		                     -code  => $tmp_code
		                   );

		# Check selected value
		$tmp_code = qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		               <input type="radio" name="show_percent" value="1">
                               Yes 
                               <input type="radio" name="show_percent" value="0">
                               No</font>);
		$tmp_code =~ s/value=\"$main::show_percent\"/value=\"$main::show_percent\" checked/;

		$screen->main_field( -label => "Show vote distribution (%):",
		                     -code  => $tmp_code
		                   );

		# Check selected value
		$tmp_code = qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		               <input type="radio" name="show_bars" value="1">
                               Yes 
                               <input type="radio" name="show_bars" value="0">
                               No</font>);
		$tmp_code =~ s/value=\"$main::show_bars\"/value=\"$main::show_bars\" checked/;

		$screen->main_field( -label => "Show graphic bars:",
		                     -code  => $tmp_code
		                   );

		$screen->main_field( -label       => "Graphic bar length (maximum):",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="bar_length" type="text" class="guitextbox" size="40" maxlength="3" value="$main::bar_length">)
		                   );

		$screen->main_field( -label       => "Graphic bar width:",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="bar_width" type="text" class="guitextbox" size="40" maxlength="3" value="$main::bar_width">)
		                   );

		$screen->main_field( -label       => "Poll results horizontal spacing:",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="options_horizontal_spacing" type="text" class="guitextbox" size="40" maxlength="3" value="$main::options_horizontal_spacing">)
		                   );

		$screen->main_field( -label       => "Poll results vertical spacing:",
		                     -description => "*1 - 999 pixels",
		                     -code        => qq(<input name="options_vertical_spacing" type="text" class="guitextbox" size="40" maxlength="3" value="$main::options_vertical_spacing">)
		                   );

		&filter_html($main::submission_code, $main::display_code);

		$screen->main_field( -label       => "Poll submission screen code:",
		                     -description => "*variables:<br>
		                                      {POLL_QUESTION}<br>
		                                      {POLL_OPTIONS}<br>
		                                      {SUBMIT_BUTTON}<br>
		                                      {VIEW_BUTTON}<br>
		                                      {START_DATE}<br>
		                                      {END_DATE}",
		                     -code        => qq(<textarea name="submission_code" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$main::submission_code</textarea>)
		                   );

		$screen->main_field( -label       => "Poll display screen code:",
		                     -description => "*variables:<br>
		                                      {POLL_QUESTION}<br>
		                                      {POLL_RESULTS}<br>
		                                      {TOTAL_VOTES}<br>
		                                      {START_DATE}<br>
		                                      {END_DATE}",
		                     -code        => qq(<textarea name="display_code" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$main::display_code</textarea>)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi?redirect=templates'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer(-label => 'All fields are required.');

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Save edited template
sub save_edited_template
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my $template_id = $FORM->param('template_id');

	# Error checking
	my $error_string = "";

	if ($FORM->param('template_name')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter template name.";
	}

	if ($FORM->param('template_font_face')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter font face.";
	}

	if ($FORM->param('template_font_size')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter font size.";
	}

	if ($FORM->param('bar_length') !~ /^\d+$/) {
		$error_string .= "<br>- Graphic bar length must be an integer between 1 and 999.";
	}

	if ($FORM->param('bar_width') !~ /^\d+$/) {
		$error_string .= "<br>- Graphic bar width must be an integer between 1 and 999.";
	}

	if ($FORM->param('options_horizontal_spacing') !~ /^\d+$/) {
		$error_string .= "<br>- Poll results horizontal spacing must be an integer between 1 and 999.";
	}

	if ($FORM->param('options_vertical_spacing') !~ /^\d+$/) {
		$error_string .= "<br>- Poll results vertical spacing must be an integer between 1 and 999.";
	}

	if ($FORM->param('submission_code')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter poll submission screen code.";
	}

	if ($FORM->param('display_code')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter poll display screen code.";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                );
	}

	# Format fields
	my $template_name = $FORM->param('template_name');
	my $template_font_face = $FORM->param('template_font_face');
	my $template_font_size = $FORM->param('template_font_size');
	my $poll_alignment = $FORM->param('poll_alignment');
	my $option_separator = $FORM->param('option_separator');
	my $show_votes = $FORM->param('show_votes');
	my $show_percent = $FORM->param('show_percent');
	my $show_bars = $FORM->param('show_bars');
	my $bar_length = $FORM->param('bar_length');
	my $bar_width = $FORM->param('bar_width');
	my $options_horizontal_spacing = $FORM->param('options_horizontal_spacing');
	my $options_vertical_spacing = $FORM->param('options_vertical_spacing');
	my $submission_code = $FORM->param('submission_code');
	my $display_code = $FORM->param('display_code');

	$poll_alignment   = "horizontal" unless $poll_alignment eq "vertical";

	foreach my $field($show_votes, $show_percent, $show_bars) {
		$field = '1' unless $field eq '0';
	}

	&filter_html($template_name);
	&remove_tabs_hard_returns($template_name, $template_font_face, $template_font_size, $option_separator, $submission_code, $display_code);
	&encode_text_fields($template_font_face, $template_font_size, $option_separator, $submission_code, $display_code);

	my $date = new lib::Date;
	my $current_date = $date->current_date();

	# Update TEMPLATES table
	my $file_db = new lib::FileDB;
	$file_db->open_file( -file_name => "$main::DATA_PATH/TEMPLATES.cgi",
	                     -open_to   => "update"
	                   );
	$file_db->update_records( -condition => "template_id=$template_id",
	                          -fields    => [ 'template_name', 'template_date' ],
	                          -values    => [ $template_name,  $current_date   ]
	                        );
	$file_db->commit_changes();
	$file_db->close_file();

	# Update template file
	$file_db->open_file( -file_name => "$main::TMPL_PATH/$template_id.inc", 
	                     -open_to   => "overwrite" );
	$file_db->insert_record(-values => [qq(# Poll Template (Warning! Do not edit manually.) #

\$template_font_face = qq~$template_font_face~;
\$template_font_size = qq~$template_font_size~;
\$poll_alignment = '$poll_alignment';
\$option_separator = qq~$option_separator~;
\$show_votes = '$show_votes';
\$show_percent = '$show_percent';
\$show_bars = '$show_bars';
\$bar_length = '$bar_length';
\$bar_width = '$bar_width';
\$options_horizontal_spacing = '$options_horizontal_spacing';
\$options_vertical_spacing = '$options_vertical_spacing';
\$submission_code = qq~$submission_code~;
\$display_code = qq~$display_code~;

1;)]
	                       );
	$file_db->commit_changes();
	$file_db->close_file();

	# Display success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Template has been saved.",
	                  button2_action => "LINK",
	                  close_link     => "$main::SCRIPT_URL/members.cgi?redirect=edit_template&template_id=$template_id",
	                 );
}

1;