# setup.inc

use strict;

# Script variables configuration (default screen = Paths and URLs)
sub setup
{
	my %memb_info = @_;

	my $FORM = new CGI;


	# Current polls screen
	my $screen = lib::GUI->new(title    => "Member Area: Setup",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->tab( -label  => "Paths and URLs",
		              -active => 1
		            );

		$screen->tab( -label => "Security",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_security_options"
		            );

		$screen->tab( -label => "Date and Time",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_date_and_time"
		            );

		$screen->tab( -label => "Display Options",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_display_options"
		            );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_setup_options">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="save_what" type="hidden" value="paths_and_urls">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="return_to" type="hidden" value="setup">)
		                   );

		$screen->main_field( -label => "System path to Poll Master cgi directory:",
		                     -code  => qq(<input name="SCRIPT_PATH" type="text" class="guitextbox" size="40" maxlength="500" value="$main::SCRIPT_PATH">)
		                   );

		$screen->main_field( -label => "System path to data directory:",
		                     -code  => qq(<input name="DATA_PATH" type="text" class="guitextbox" size="40" maxlength="500" value="$main::DATA_PATH">)
		                   );

		$screen->main_field( -label => "System path to templates directory:",
		                     -code  => qq(<input name="TMPL_PATH" type="text" class="guitextbox" size="40" maxlength="500" value="$main::TMPL_PATH">)
		                   );

		$screen->main_field( -label => "URL for Poll Master cgi directory:",
		                     -code  => qq(<input name="SCRIPT_URL" type="text" class="guitextbox" size="40" maxlength="500" value="$main::SCRIPT_URL">)
		                   );

		$screen->main_field( -label => "URL for NonCGI directory:",
		                     -code  => qq(<input name="NONCGI_URL" type="text" class="guitextbox" size="40" maxlength="500" value="$main::NONCGI_URL">)
		                   );

		$screen->main_field( -label => "Home page URL:",
		                     -code  => qq(<input name="HOME_PAGE_URL" type="text" class="guitextbox" size="40" maxlength="500" value="$main::HOME_PAGE_URL">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer();

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Security options
sub setup_security_options
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Current polls screen
	my $screen = lib::GUI->new(title    => "Member Area: Setup",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->tab( -label => "Paths and URLs",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup"
		            );

		$screen->tab( -label  => "Security",
		              -active => 1
		            );

		$screen->tab( -label => "Date and Time",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_date_and_time"
		            );

		$screen->tab( -label => "Display Options",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_display_options"
		            );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_setup_options">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="save_what" type="hidden" value="security_options">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="return_to" type="hidden" value="setup_security_options">)
		                   );

		# IP Log cleaning time generator
		my $ip_time_val;
		my $ip_time_list = qq(<select name="ip_cleaning_time_mult" size="1" class="guiformfield">
	                              <option value="1">seconds</option>
	                              <option value="60">minutes</option>
	                              <option value="3600">hours</option>
	                              <option value="86400">days</option>
	                              </select>
	                             );
		if ($main::DEFAULT_IP_CLEANING_TIME == 0) {
			$ip_time_val = 0;
			$ip_time_list =~ s/value=\"1\"/value=\"1\" selected/;
		} else {
			foreach my $multiplier(86400, 3600, 60, 1) {
				if (($main::DEFAULT_IP_CLEANING_TIME % $multiplier) == 0) {
					$ip_time_val  = int($main::DEFAULT_IP_CLEANING_TIME / $multiplier);
					$ip_time_list =~ s/value=\"$multiplier\"/value=\"$multiplier\" selected/;
					last;	# break out of the loop to prevent multiple select
				}
			}
		}
		$screen->main_field( -label       => "Default IP cleaning time:",
		                     -description => "*enter 0 to disallow multiple votes",
		                     -code        => qq(<input name="DEFAULT_IP_CLEANING_TIME" type="text" value="$ip_time_val" class="guiformfield" size="16" maxlength="15">
		                                        $ip_time_list)
		                   );

		# Highlight selection
		my $tmp_code = qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		                     <input type="radio" name="USE_COOKIE_TRACKING" value="1">
                                     ON 
                                     <input type="radio" name="USE_COOKIE_TRACKING" value="0">
                                     OFF</font>);
		$tmp_code =~ s/value=\"$main::USE_COOKIE_TRACKING\">/value=\"$main::USE_COOKIE_TRACKING\" checked>/;
		$screen->main_field( -label       => "Cookie-based vote tracking:",
		                     -description => "*adds extra security to simple IP tracking",
		                     -code        => $tmp_code
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer();

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Date and time options
sub setup_date_and_time
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Current polls screen
	my $screen = lib::GUI->new(title    => "Member Area: Setup",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->tab( -label => "Paths and URLs",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup"
		            );

		$screen->tab( -label => "Security",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_security_options"
		            );

		$screen->tab( -label  => "Date and Time",
		              -active => 1
		            );

		$screen->tab( -label => "Display Options",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_display_options"
		            );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_setup_options">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="save_what" type="hidden" value="date_and_time">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="return_to" type="hidden" value="setup_date_and_time">)
		                   );

		my $tmp_code = qq(<select name="GM_TIME_OFFSET" size="1" class="guitextbox">
		                  <option value="-12">GMT - 12 Hours</option>
		                  <option value="-11">GMT - 11 Hours</option>
		                  <option value="-10">GMT - 10 Hours</option>
		                  <option value="-9">GMT - 9 Hours</option>
		                  <option value="-8">GMT - 8 Hours</option>
		                  <option value="-7">GMT - 7 Hours</option>
		                  <option value="-6">GMT - 6 Hours</option>
		                  <option value="-5">GMT - 5 Hours</option>
		                  <option value="-4">GMT - 4 Hours</option>
		                  <option value="-3.5">GMT - 3.5 Hours</option>
		                  <option value="-3">GMT - 3 Hours</option>
		                  <option value="-2">GMT - 2 Hours</option>
		                  <option value="-1">GMT - 1 Hours</option>
		                  <option value="0">GMT</option>
		                  <option value="1">GMT + 1 Hour</option>
		                  <option value="2">GMT + 2 Hours</option>
		                  <option value="3">GMT + 3 Hours</option>
		                  <option value="3.5">GMT + 3.5 Hours</option>
		                  <option value="4">GMT + 4 Hours</option>
		                  <option value="4.5">GMT + 4.5 Hours</option>
		                  <option value="5">GMT + 5 Hours</option>
		                  <option value="5.5">GMT + 5.5 Hours</option>
		                  <option value="6">GMT + 6 Hours</option>
		                  <option value="6.5">GMT + 6.5 Hours</option>
		                  <option value="7">GMT + 7 Hours</option>
		                  <option value="8">GMT + 8 Hours</option>
		                  <option value="9">GMT + 9 Hours</option>
		                  <option value="9.5">GMT + 9.5 Hours</option>
		                  <option value="10">GMT + 10 Hours</option>
		                  <option value="11">GMT + 11 Hours</option>
		                  <option value="12">GMT + 12 Hours</option>
		                  </select>);
		$tmp_code =~ s/value=\"$main::GM_TIME_OFFSET\">/value=\"$main::GM_TIME_OFFSET\" selected>/;
		$screen->main_field( -label       => "Time zone:",
		                     -description => "*relative to Greenwich Mean Time",
		                     -code        => $tmp_code
		                   );

		$screen->main_field( -label       => "Time zone label:",
		                     -description => "*optional",
		                     -code        => qq(<input name="TIME_ZONE" type="text" class="guitextbox" size="40" maxlength="100" value="$main::TIME_ZONE">)
		                   );

		$tmp_code = qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
                               <input type="radio" name="DATE_FORMAT" value="us_standard">
                               US Standard (e.g. 07/16/00)<br>
                               <input type="radio" name="DATE_FORMAT" value="us_extended">
                               US Extended (e.g. July 16, 2000)<br>
                               <input type="radio" name="DATE_FORMAT" value="euro_standard">
                               European Standard (e.g. 16/07/00)<br>
                               <input type="radio" name="DATE_FORMAT" value="euro_extended">
                               European Extended (e.g. 16 July 2000)</font>);
		$tmp_code =~ s/value=\"$main::DATE_FORMAT\">/value=\"$main::DATE_FORMAT\" checked>/;
		$screen->main_field( -label => "Date format:",
		                     -code  => $tmp_code
		                   );

		$tmp_code = qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
                               <input type="radio" name="TIME_FORMAT" value="ampm">
                               AM/PM Format (e.g. 10:33 PM)<br>
                               <input type="radio" name="TIME_FORMAT" value="24hour">
                               24-Hour Format (e.g. 22:33)</font>);
		$tmp_code =~ s/value=\"$main::TIME_FORMAT\">/value=\"$main::TIME_FORMAT\" checked>/;
		$screen->main_field( -label => "Time format:",
		                     -code  => $tmp_code
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer();

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Display options
sub setup_display_options
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Current polls screen
	my $screen = lib::GUI->new(title    => "Member Area: Setup",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->tab( -label => "Paths and URLs",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup"
		            );

		$screen->tab( -label => "Security",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_security_options"
		            );

		$screen->tab( -label => "Date and Time",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=setup_date_and_time"
		            );

		$screen->tab( -label  => "Display Options",
		              -active => 1
		            );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_setup_options">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="save_what" type="hidden" value="display_options">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="return_to" type="hidden" value="setup_display_options">)
		                   );

		$screen->main_field( -label => "Interface font name:",
		                     -code  => qq(<input name="FONT_FACE" type="text" class="guitextbox" size="40" maxlength="200" value="$main::FONT_FACE">)
		                   );

		$screen->main_field( -label => "Primary font size:",
		                     -code  => qq(<input name="PRIMARY_FONT_SIZE" type="text" class="guitextbox" size="40" maxlength="15" value="$main::PRIMARY_FONT_SIZE">)
		                   );

		$screen->main_field( -label => "Secondary font size:",
		                     -code  => qq(<input name="SECONDARY_FONT_SIZE" type="text" class="guitextbox" size="40" maxlength="15" value="$main::SECONDARY_FONT_SIZE">)
		                   );

		$screen->main_field( -label       => "Number of polls to show per page:",
		                     -description => "*enter 0 to show all polls",
		                     -code        => qq(<input name="POLLS_PER_PAGE" type="text" class="guitextbox" size="40" maxlength="3" value="$main::POLLS_PER_PAGE">)
		                   );

		$screen->main_field( -label       => "Number of templates to show per page:",
		                     -description => "*enter 0 to show all templates",
		                     -code        => qq(<input name="TEMPLATES_PER_PAGE" type="text" class="guitextbox" size="40" maxlength="3" value="$main::TEMPLATES_PER_PAGE">)
		                   );

		my $tmp_GUI_HEADING = $main::GUI_HEADING;
		my $tmp_GUI_FOOTER  = $main::GUI_FOOTER;
		&filter_html($tmp_GUI_HEADING, $tmp_GUI_FOOTER);
		$screen->main_field( -label       => "Interface heading html code:",
		                     -description => "*this code will appear between the opening &lt;BODY&gt; tag and the graphical user interface screen",
		                     -code        => qq(<textarea name="GUI_HEADING" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$tmp_GUI_HEADING</textarea>)
		                   );

		$screen->main_field( -label       => "Interface footer html code:",
		                     -description => "*this code will appear between the graphical user interface screen and the closing &lt;/BODY&gt; tag",
		                     -code        => qq(<textarea name="GUI_FOOTER" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$tmp_GUI_FOOTER</textarea>)
		                   );

		my $tmp_POLLS_HEADING = $main::POLLS_HEADING;
		my $tmp_POLLS_FOOTER  = $main::POLLS_FOOTER;
		&filter_html($tmp_POLLS_HEADING, $tmp_POLLS_FOOTER);
		$screen->main_field( -label       => "Polls list heading html code:",
		                     -description => qq(*used to generate the list of archived and currently running polls<br>
		                                        <a href="$main::SCRIPT_URL/polls_list.cgi" target="_blank">see the list of all polls</a><br>
		                                        <a href="$main::SCRIPT_URL/polls_list.cgi?show=current" target="_blank">see the list of current polls</a><br>
		                                        <a href="$main::SCRIPT_URL/polls_list.cgi?show=archived" target="_blank">see the list of archived polls</a><br>),
		                     -code        => qq(<textarea name="POLLS_HEADING" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$tmp_POLLS_HEADING</textarea>)
		                   );

		$screen->main_field( -label       => "Polls list footer html code:",
		                     -description => "*used to generate the list of archived and currently running polls",
		                     -code        => qq(<textarea name="POLLS_FOOTER" cols="30" rows="7" wrap="VIRTUAL" class="guitextbox">$tmp_POLLS_FOOTER</textarea>)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer();

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Save setup options
sub save_setup_options
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my $return_to = $FORM->param('return_to');

	# Error checking
	my $error_string = "";

	if ($FORM->param('save_what') eq "paths_and_urls") {

		my $tmp_SCRIPT_PATH = $FORM->param('SCRIPT_PATH');
		my $tmp_DATA_PATH   = $FORM->param('DATA_PATH');
		my $tmp_TMPL_PATH   = $FORM->param('TMPL_PATH');

		if (!-d $tmp_SCRIPT_PATH) {
				$error_string .= "<br>- System path to Poll Master cgi directory is incorrect. 
				                        $tmp_SCRIPT_PATH: No such file or directory.";
		}

		if (!-d $tmp_DATA_PATH) {
				$error_string .= "<br>- System path to data directory is incorrect. 
				                        $tmp_DATA_PATH: No such file or directory.";
		}

		if (!-d $tmp_TMPL_PATH) {
				$error_string .= "<br>- System path to templates directory is incorrect. 
				                        $tmp_TMPL_PATH: No such file or directory.";
		}

		if ($FORM->param('SCRIPT_URL')  !~ /^http:\/\/\S+$/) {
				$error_string .= "<br>- You did not enter a valid URL for Poll Master cgi directory.";
		}

		if ($FORM->param('NONCGI_URL')  !~ /^http:\/\/\S+$/) {
				$error_string .= "<br>- You did not enter a valid URL for NonCGI directory.";
		}

		if ($FORM->param('HOME_PAGE_URL')  !~ /^http:\/\/\S+$/) {
				$error_string .= "<br>- You did not enter a valid home page URL.";
		}
	}
	elsif ($FORM->param('save_what') eq "security_options") {
		if ($FORM->param('DEFAULT_IP_CLEANING_TIME') !~ /^\d+$/ || $FORM->param('DEFAULT_IP_CLEANING_TIME') < 0) {
				$error_string .= "<br>- Default IP cleaning time must either be a zero or positive integer.";
		}
	}
	elsif ($FORM->param('save_what') eq "display_options") {

		if ($FORM->param('FONT_FACE')  !~ /\S+/) {
				$error_string .= "<br>- You did not enter GUI font name.";
		}

		if ($FORM->param('PRIMARY_FONT_SIZE')  !~ /\S+/) {
				$error_string .= "<br>- You did not enter primary font size.";
		}

		if ($FORM->param('SECONDARY_FONT_SIZE')  !~ /\S+/) {
				$error_string .= "<br>- You did not enter secondary font size.";
		}

		if ($FORM->param('POLLS_PER_PAGE') !~ /^\d+$/ || $FORM->param('POLLS_PER_PAGE') < 0) {
				$error_string .= "<br>- Number of polls to show per page must either be a zero or positive integer.";
		}

		if ($FORM->param('TEMPLATES_PER_PAGE') !~ /^\d+$/ || $FORM->param('TEMPLATES_PER_PAGE') < 0) {
				$error_string .= "<br>- Number of templates to show per page must either be a zero or positive integer.";
		}
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                 );
	}

	# Assign new values to variables
	if ($FORM->param('save_what') eq "paths_and_urls") {
		$main::SCRIPT_PATH   = $FORM->param('SCRIPT_PATH');
		$main::DATA_PATH     = $FORM->param('DATA_PATH');
		$main::TMPL_PATH     = $FORM->param('TMPL_PATH');
		$main::SCRIPT_URL    = $FORM->param('SCRIPT_URL');
		$main::NONCGI_URL    = $FORM->param('NONCGI_URL');
		$main::HOME_PAGE_URL = $FORM->param('HOME_PAGE_URL');

		&remove_tabs_hard_returns($main::SCRIPT_PATH, $main::DATA_PATH, $main::TMPL_PATH, $main::SCRIPT_URL, $main::NONCGI_URL, $main::HOME_PAGE_URL);
		&encode_text_fields($main::SCRIPT_PATH, $main::DATA_PATH, $main::TMPL_PATH, $main::SCRIPT_URL, $main::NONCGI_URL, $main::HOME_PAGE_URL);
	}
	elsif ($FORM->param('save_what') eq "security_options") {
		$main::DEFAULT_IP_CLEANING_TIME = $FORM->param('DEFAULT_IP_CLEANING_TIME');
		$main::USE_COOKIE_TRACKING      = $FORM->param('USE_COOKIE_TRACKING');
	}
	elsif ($FORM->param('save_what') eq "date_and_time") {
		$main::GM_TIME_OFFSET = $FORM->param('GM_TIME_OFFSET');
		$main::TIME_ZONE      = $FORM->param('TIME_ZONE');
		$main::DATE_FORMAT    = $FORM->param('DATE_FORMAT');
		$main::TIME_FORMAT    = $FORM->param('TIME_FORMAT');

		&remove_tabs_hard_returns($main::GM_TIME_OFFSET);
		&encode_text_fields($main::GM_TIME_OFFSET);
	}
	elsif ($FORM->param('save_what') eq "display_options") {
		$main::FONT_FACE           = $FORM->param('FONT_FACE');
		$main::PRIMARY_FONT_SIZE   = $FORM->param('PRIMARY_FONT_SIZE');
		$main::SECONDARY_FONT_SIZE = $FORM->param('SECONDARY_FONT_SIZE');
		$main::POLLS_PER_PAGE      = $FORM->param('POLLS_PER_PAGE');
		$main::TEMPLATES_PER_PAGE  = $FORM->param('TEMPLATES_PER_PAGE');
		$main::GUI_HEADING         = $FORM->param('GUI_HEADING');
		$main::GUI_FOOTER          = $FORM->param('GUI_FOOTER');
		$main::POLLS_HEADING       = $FORM->param('POLLS_HEADING');
		$main::POLLS_FOOTER        = $FORM->param('POLLS_FOOTER');

		&remove_tabs_hard_returns($main::FONT_FACE, $main::PRIMARY_FONT_SIZE, $main::SECONDARY_FONT_SIZE, $main::POLLS_PER_PAGE, 
		                          $main::TEMPLATES_PER_PAGE, $main::GUI_HEADING, $main::GUI_FOOTER, $main::POLLS_HEADING, $main::POLLS_FOOTER);

		&encode_text_fields($main::FONT_FACE, $main::PRIMARY_FONT_SIZE, $main::SECONDARY_FONT_SIZE, $main::POLLS_PER_PAGE, 
		                    $main::TEMPLATES_PER_PAGE, $main::GUI_HEADING, $main::GUI_FOOTER, $main::POLLS_HEADING, $main::POLLS_FOOTER);
	}

	# Save settings
	my $file_db = new lib::FileDB;
	$file_db->open_file( -file_name => "$main::SCRIPT_PATH/settings.inc", 
	                     -open_to   => "update"
	                   );
	$file_db->delete_records();
	$file_db->insert_record(-values => [qq()]);	# insert empty record to prevent text overlap
	$file_db->insert_record(-values => [qq(# System Paths
\$SCRIPT_PATH = qq~$main::SCRIPT_PATH~;
\$DATA_PATH = qq~$main::DATA_PATH~;
\$TMPL_PATH = qq~$main::TMPL_PATH~;

# URLs
\$SCRIPT_URL = qq~$main::SCRIPT_URL~;
\$NONCGI_URL = qq~$main::NONCGI_URL~;
\$HOME_PAGE_URL = qq~$main::HOME_PAGE_URL~;

# Security Options
\$DEFAULT_IP_CLEANING_TIME = '$main::DEFAULT_IP_CLEANING_TIME';
\$USE_COOKIE_TRACKING = '$main::USE_COOKIE_TRACKING';

# Date and Time
\$GM_TIME_OFFSET = '$main::GM_TIME_OFFSET';
\$TIME_ZONE = qq~$main::TIME_ZONE~;
\$DATE_FORMAT = '$main::DATE_FORMAT';
\$TIME_FORMAT = '$main::TIME_FORMAT';

# Display Options
\$FONT_FACE = qq~$main::FONT_FACE~;
\$PRIMARY_FONT_SIZE = qq~$main::PRIMARY_FONT_SIZE~;
\$SECONDARY_FONT_SIZE = qq~$main::SECONDARY_FONT_SIZE~;
\$POLLS_PER_PAGE = '$main::POLLS_PER_PAGE';
\$TEMPLATES_PER_PAGE = '$main::TEMPLATES_PER_PAGE';
\$GUI_HEADING = qq~$main::GUI_HEADING~;
\$GUI_FOOTER = qq~$main::GUI_FOOTER~;
\$POLLS_HEADING = qq~$main::POLLS_HEADING~;
\$POLLS_FOOTER = qq~$main::POLLS_FOOTER~;

1; # Do not remove this line)]
	                     );
	$file_db->commit_changes();
	$file_db->close_file();

	# Display success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Setup options have been saved.",
	                  button2_action => "LINK",
	                  close_link     => "$main::SCRIPT_URL/members.cgi?redirect=$return_to",
	                 );
}

1;