#!/usr/bin/perl -w

# polls_list.cgi

###############################################################
#                                                             #
# Any use of this program is entirely at the risk of the      #
# user. No liability will be accepted by the author.          #
#                                                             #
# This code must not be distributed or sold, even in modified #
# form, without the written permission of the author.         #
#                                                             #
###############################################################

use strict;

# Load variables and class libraries, trap all errors
eval {
	# Get script location (UNIX & Windows)
	($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");

	# Get script location (Windows)
	($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

	# Load global variables and subroutines
	require "common.inc";
	require "settings.inc";

	# Load class libraries
	use CGI::Carp qw(fatalsToBrowser);
	use CGI qw(:standard);
	use lib::Date;
	use lib::FileDB;
	use strict;
};
if ($@) {
	print "Content-type: text/plain\n\n",
	      "Failed to load global variables and class libraries:\n$@\n",
	      "Please make sure that all program files were uploaded in ASCII mode,\n",
	      "permissions have been set correctly and all files are in correct location.\n",
	      "Refer to program manual for more detail.";
	exit;
}

# Execute script
eval { &main; };
if ($@) {
	print "Content-type: text/plain\n\n",
	      "An unexpected error has occurred:\n$@\n";
	exit;
}

######################## MAIN PROGRAM BLOCK ########################
sub main
{
	# Denial of service attack prevention
	$CGI::POST_MAX = 1024000;	# max form post size
	$CGI::DISABLE_UPLOADS = 1;	# no file uploads

	my $FORM = new CGI;

	# Get current date
	my $date = new lib::Date;
	my $current_date = $date->current_date();

	# Read polls
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/POLLS.cgi");
	$file_db->close_file();
	my %current_poll_info = $file_db->get_records( -condition => "end_date>$current_date",
                                                       -sort_by   => "start_date"
                                                     );
	my %archived_poll_info = $file_db->get_records( -condition => "end_date<=$current_date",
                                                        -sort_by   => "end_date",
                                                      );

	# Build a list of current polls
	my $current_polls_list = "";
	if (%current_poll_info) {

		for (my $i = 0; $i < scalar(@{$current_poll_info{'poll_id'}}); $i++) {
			
			# Show poll only if it is active 
			if ($current_poll_info{'active'}[$i]) {

				$current_poll_info{'start_date'}[$i] = $date->to_string(-date => $current_poll_info{'start_date'}[$i]);
				$current_poll_info{'end_date'}[$i]   = $date->to_string(-date => $current_poll_info{'end_date'}[$i]);

				$current_polls_list .= qq(<p><a href="$main::SCRIPT_URL/poll.cgi?poll_id=$current_poll_info{'poll_id'}[$i]">$current_poll_info{'poll_question'}[$i]</a><br>
				                          Start Date: $current_poll_info{'start_date'}[$i] - End date: $current_poll_info{'end_date'}[$i]</p>);
			}
		}
	}
	if ($current_polls_list) {
		$current_polls_list = qq(<p><b>Current Polls</b></p>
		                         $current_polls_list);
	} else {
		$current_polls_list = qq(<p><b>Current Polls</b></p>
		                         <p>There are no currently running polls...</p>);
	}

	# Build a list of archived polls
	my $archived_polls_list = "";
	if (%archived_poll_info) {

		for (my $i = 0; $i < scalar(@{$archived_poll_info{'poll_id'}}); $i++) {

			# Show poll only if it is active 
			if ($archived_poll_info{'active'}[$i]) {

				$archived_poll_info{'start_date'}[$i] = $date->to_string(-date => $archived_poll_info{'start_date'}[$i]);
				$archived_poll_info{'end_date'}[$i]   = $date->to_string(-date => $archived_poll_info{'end_date'}[$i]);

				$archived_polls_list .= qq(<p><a href="$main::SCRIPT_URL/poll.cgi?poll_id=$archived_poll_info{'poll_id'}[$i]">$archived_poll_info{'poll_question'}[$i]</a><br>
				                           Start Date: $archived_poll_info{'start_date'}[$i] - End date: $archived_poll_info{'end_date'}[$i]</p>);
			}
		}
	}
	if ($archived_polls_list) {
		$archived_polls_list = qq(<p><b>Archived Polls</b></p>
		                          $archived_polls_list);
	} else {
		$archived_polls_list = qq(<p><b>Archived Polls</b></p>
		                          <p>There are no archived polls...</p>);
	}
	

	# Display polls list
	print "Content-type: text/html\n\n";
	print $main::POLLS_HEADING;
	print $current_polls_list unless $FORM->param('show') eq "archived";
	print $archived_polls_list unless $FORM->param('show') eq "current";
	print $main::POLLS_FOOTER;
	exit;
}
