#!/usr/bin/perl -w

# poll.cgi

###############################################################
#                                                             #
# Any use of this program is entirely at the risk of the      #
# user. No liability will be accepted by the author.          #
#                                                             #
# This code must not be distributed or sold, even in modified #
# form, without the written permission of the author.         #
#                                                             #
###############################################################

use strict;

# Load variables and class libraries, trap all errors
eval {
	# Get script location (UNIX & Windows)
	($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");

	# Get script location (Windows)
	($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

	# Load global variables and subroutines
	require "common.inc";
	require "settings.inc";

	# Load class libraries
	use CGI::Carp qw(fatalsToBrowser);
	use CGI qw(:standard);
	use lib::Date;
	use lib::FileDB;
	use strict;
};
if ($@) {
	print "Content-type: text/plain\n\n",
	      "Failed to load global variables and class libraries:\n$@\n",
	      "Please make sure that all program files were uploaded in ASCII mode,\n",
	      "permissions have been set correctly and all files are in correct location.\n",
	      "Refer to program manual for more detail.";
	exit;
}

# Execute script
eval { &main; };
if ($@) {
	print "Content-type: text/plain\n\n",
	      "An unexpected error has occurred:\n$@\n";
	exit;
}

######################## MAIN PROGRAM BLOCK ########################
sub main
{
	# Denial of service attack prevention
	$CGI::POST_MAX = 1024000;	# max form post size
	$CGI::DISABLE_UPLOADS = 1;	# no file uploads

	my $FORM = new CGI;

	my $poll_id;
	if ($FORM->param('poll_id')) {
		$poll_id = $FORM->param('poll_id');
	} else {
		croak "Poll ID $ENV{'POLL_ID'} was not supplied.";
	}

	# Demo mode
	my $demo_check = $FORM->param('demo');

	# Return URL
	my $return_url = $FORM->param('return_url');

	# Read polls
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/POLLS.cgi");
	$file_db->close_file();
	my %poll_info = $file_db->get_record(-condition => "poll_id=$poll_id");

	# Record not found
	croak "Could not locate poll (ID=$poll_id)." if !%poll_info;

	# Read poll options
	$file_db->open_file(-file_name => "$main::DATA_PATH/$poll_id.cgi");
	$file_db->close_file();
	my %poll_options_info = $file_db->get_records();
	my $number_of_options = 0;
	$number_of_options = scalar(@{$poll_options_info{'option_num'}}) if %poll_options_info;

	# Load poll template
	require "$main::TMPL_PATH/$poll_info{'template'}.inc";

	# Get current date
	my $date = new lib::Date;
	my $current_date = $date->current_date();

	# Check if it's time to clean IP log
	if ($poll_info{'end_date'} > $current_date && $poll_info{'ip_cleaning_time'} && ($current_date - $poll_info{'ip_cleaning_date'}) >= $poll_info{'ip_cleaning_time'}) {
		my $tmp = $current_date - $poll_info{'ip_cleaning_date'};
		&reset_ip_log($poll_id, $current_date);
	}

	# HTML output
	my $html_out = qq(<form style="margin: 0px;" name="adform$poll_id" method="post" action="$main::SCRIPT_URL/poll.cgi">
                          <input name="poll_id" type="hidden" value="$poll_id">
                          <input name="demo" type="hidden" value="$demo_check">
                          <input name="return_url" type="hidden" value="$return_url">
                         );

	# Options HTML
	my $options_html = "";

	# Display error if vote is not active
	if (!$poll_info{'active'}) {
		$html_out = qq(<font size="$main::template_font_size" face="$main::template_font_face">Poll has been deactivated.</font>);

	} else {

		my $already_voted;
		if ($poll_info{'end_date'} <= $current_date) {
			$already_voted = 1;
		} else {
			$already_voted = &see_if_voted($poll_id, $current_date, $poll_info{'ip_cleaning_time'});
		}

		my ($start_date, $end_date) = ($date->to_string(-date => $poll_info{'start_date'}), $date->to_string(-date => $poll_info{'end_date'}));

		# Process vote if submitted and valid
		if ($FORM->param('submit_vote')) {
			if ($FORM->param('option') && !$already_voted && $poll_info{'end_date'} > $current_date) {
				&record_vote($poll_id, $current_date);
			}
			if ($return_url) {
				print "Location:$return_url\n\n";
			} else {
				$demo_check = "&demo=$demo_check" if $demo_check;
				print "Location:$main::SCRIPT_URL/poll.cgi?poll_id=$poll_id$demo_check\n\n";
			}
			exit;
		}

		# Skip voting and show results
		if ($FORM->param('view_results') && $main::submission_code =~ /\{VIEW_BUTTON\}/) {
			if ($return_url) {
				print "Location:$return_url?view_results\n\n";
			} else {
				$demo_check = "&demo=$demo_check" if $demo_check;
				print "Location:$main::SCRIPT_URL/poll.cgi?poll_id=$poll_id$demo_check&view_results\n\n";
			}
			exit;
		}

		# Display poll results
		elsif ($already_voted || (($ENV{'REQUEST_URI'} =~ /view_results/ || $ENV{'QUERY_STRING_UNESCAPED'} =~ /view_results/ || $ENV{'QUERY_STRING'} =~ /view_results/) && 
		       $main::submission_code =~ /\{VIEW_BUTTON\}/)) {

			# Get total number of votes
			my $total_votes = 0;
			foreach my $tmp_votes(@{$poll_options_info{'option_votes'}}) {
				$total_votes += $tmp_votes;
			}
	
			# Row separator
			my $row_separator = "<tr>\n";
			for (my $n = 1; $n < ($number_of_options * 2); $n++) {
				$row_separator .= qq(<td nowrap><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="$main::options_horizontal_spacing"></td>\n);
			}
			$row_separator .= "</tr>\n";
	
			# Column separator
			my $column_separator = qq(<td nowrap><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="$main::options_vertical_spacing" height="1"></td>\n);
	
			# Poll option rows
			my $rows_str = "";
	
			# Build horizontally aligned poll
			if ($main::poll_alignment eq 'horizontal') {
				$rows_str = &build_horizontal_poll($number_of_options, $total_votes, $main::show_votes, $main::show_percent, $main::show_bars, $main::bar_width, $main::bar_length, $row_separator, $column_separator, %poll_options_info);
	
			# Build vertically aligned poll
			} else {
				$rows_str = &build_vertical_poll($number_of_options, $total_votes, $main::show_votes, $main::show_percent, $main::show_bars, $main::bar_width, $main::bar_length, $row_separator, $column_separator, %poll_options_info);
			}

			$options_html = qq(<table border="0" cellspacing="0" cellpadding="0">\n$rows_str</table>\n);
			$html_out .= $main::display_code;
			$html_out =~ s/\{POLL_RESULTS\}/$options_html/g;
			$html_out =~ s/\{TOTAL_VOTES\}/<font size=\"$main::template_font_size\" face=\"$main::template_font_face\">$total_votes<\/font>/g;
		}
		
		# Display option selection
		else {
			for (my $m = 1; $m <= $number_of_options; $m++) {
				$options_html .= qq(<input type="radio" name="option" value="$m">
                                                    $poll_options_info{'option_text'}[$m - 1]$main::option_separator\n);
			}
			$html_out .= $main::submission_code;
			$html_out =~ s/\{POLL_OPTIONS\}/<font size=\"$main::template_font_size\" face=\"$main::template_font_face\">$options_html<\/font>/g;
			$html_out =~ s/\{SUBMIT_BUTTON\}/<input name=\"submit_vote\" type=\"submit\" value=\"Submit Vote\">/g;
			$html_out =~ s/\{VIEW_BUTTON\}/<input name=\"view_results\" type=\"submit\" value=\"View Results\">/g;
		}

		# Common variables for horizontal/vertical polls
		$html_out =~ s/\{POLL_QUESTION\}/<font size=\"$main::template_font_size\" face=\"$main::template_font_face\">$poll_info{'poll_question'}<\/font>/g;
		$html_out =~ s/\{START_DATE\}/<font size=\"$main::template_font_size\" face=\"$main::template_font_face\">$start_date<\/font>/g;
		$html_out =~ s/\{END_DATE\}/<font size=\"$main::template_font_size\" face=\"$main::template_font_face\">$end_date<\/font>/g;
	}

	# Attach "Close Window" button if viewing in demo mode
	if ($demo_check) {
		$html_out .= qq(<hr align="center" width="100%" size="$main::SECONDARY_FONT_SIZE">
                                <table width="100%" border="0" bgcolor="#FFFFFF">
                                <tr> 
                                <td><font color="green" size="2" face="Arial, Helvetica, sans-serif"><b>LINK 
                                TO POLL CGI:</b><br>
                                <br>
                                <font color="blue"><b>$main::SCRIPT_URL/poll.cgi?poll_id=$poll_id</b></font><br>
                                <br>
                                <br>
                                <b><font color="green">SSI CODE:<br>
                                (replace highlighted <font color="red">VARIABLES</font> with corresponding 
                                values)</font></b><br>
                                <br>
                                <font color="blue"><b>&lt;!--#include virtual=&quot;<font color="red">VIRTUAL-PATH-TO</font>/poll.cgi?poll_id=$poll_id&amp;return_url=<font color="red">URL-WITH-SSI-CALL</font>&quot;--&gt;</b></font></font></td>
                                </tr>
                                </table>
                                <hr align="center" width="100%" size="$main::SECONDARY_FONT_SIZE">
                                <div align="center">
                                <input name="CLOSE_WINDOW" type="button" value="Close Window" onClick="self.close()">
                                </div>
                               );
	}

	# Complete poll
	$html_out .= "</form>";
	

	# Display poll
	print "Content-type: text/html\n\n";
	print $html_out;
	exit;
}

########################### SUB ROUTINES ###########################

# Check visitor's IP address and cookies:
# return 1 if already voted, 0 otherwise
sub see_if_voted
{
	my ($poll_id, $current_date, $ip_cleaning_time) = @_;

	my $FORM = new CGI;

	# Check cookies
	my $cookie_name = "pm_" . $poll_id . "_voted";
	if ($main::USE_COOKIE_TRACKING && $FORM->cookie($cookie_name) > 0 && ($current_date - $FORM->cookie($cookie_name)) < $ip_cleaning_time) {
		return 1;

	# Check IP db
	} else {
		my $file_db = new lib::FileDB;
		$file_db->open_file(-file_name => "$main::DATA_PATH/$poll_id.log");
		$file_db->close_file();
		my %ip_info = $file_db->get_record(-condition => "ip_address=$ENV{'REMOTE_ADDR'}");
		if (%ip_info) {
			return 1;
		} else {
			return 0;
		}
	}
}

# Record vote
sub record_vote
{
	my ($poll_id, $current_date) = @_;

	my $FORM = new CGI;

	my $option_num = $FORM->param('option');

	# Set cookie
	if ($main::USE_COOKIE_TRACKING) {
		my $cookie_name = "pm_" . $poll_id . "_voted";
		print "Set-Cookie: $cookie_name=$current_date; expires=Sat, 10-Jan-2099 10:10:10 GMT; path=/\n";
	}

	my $file_db = new lib::FileDB;

	# Update poll file
	$file_db->open_file( -file_name => "$main::DATA_PATH/$poll_id.cgi",
	                     -open_to   => "update"
	                   );
	my %poll_options_info = $file_db->get_record(-condition => "option_num=$option_num");
	$file_db->update_records( -condition => "option_num=$option_num",
	                          -fields    => ['option_votes'],
	                          -values    => [++$poll_options_info{'option_votes'}]
	                        );
	$file_db->commit_changes();
	$file_db->close_file();

	# Record IP address
	$file_db->open_file( -file_name => "$main::DATA_PATH/$poll_id.log",
	                     -open_to   => "append"
	                   );
	$file_db->insert_record(-values => [$ENV{'REMOTE_ADDR'}]);
	$file_db->commit_changes();
	$file_db->close_file();
}

# Build horizontal poll
sub build_horizontal_poll
{
	my ($number_of_options, $total_votes, $show_votes, $show_percent, $show_bars, $bar_width, $bar_length, $row_separator, $column_separator, %poll_options_info) = @_;

	# Initialize rows and temporary variables
	my (@rows, $rows_str, $percent_votes, $percent_bar);

	for (my $m = 0; $m < $number_of_options; $m++) {

		# Option text column
		$rows[$m] = "<tr>\n";
		$rows[$m] .= qq(<td nowrap><font size="$main::template_font_size" face="$main::template_font_face">$poll_options_info{'option_text'}[$m]</font></td>\n);
		if ($show_votes) {
			$rows[$m] .= qq($column_separator<td nowrap><font size="$main::template_font_size" face="$main::template_font_face">$poll_options_info{'option_votes'}[$m]</font></td>\n);
		}

		# Vote percentage column
		if ($show_percent) {
			if ($total_votes == 0) {
				$percent_votes = 0;
			} else {
				$percent_votes = int(($poll_options_info{'option_votes'}[$m] / $total_votes) * 100);
				if (((($poll_options_info{'option_votes'}[$m] / $total_votes) * 100) - $percent_votes) >= 0.5) {
					$percent_votes++;	# round off
				}
			}
			$rows[$m] .= qq($column_separator<td nowrap><font size="$main::template_font_size" face="$main::template_font_face">$percent_votes%</font></td>\n);
		}

		# Graphical bars column
		if ($show_bars) {
			if ($total_votes < 1) {
				$percent_bar = 1;
			} else {
				$percent_bar = int(($poll_options_info{'option_votes'}[$m] / $total_votes) * $bar_length);
				$percent_bar = 1 if $percent_bar < 1;
			}
			$rows[$m] .= qq($column_separator<td nowrap><table width="$percent_bar" height="$bar_width" border="0" cellpadding="0" cellspacing="0" bgcolor="$poll_options_info{'option_color'}[$m]">
                                        <tr> 
                                        <td><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="$percent_bar" height="$bar_width"></td>
                                        </tr>
                                        </table></td>
                                       );
		}

		# Complete row
		$rows[$m] .= "</tr>\n";
	}

	# Combine all rows
	$rows_str = join $row_separator, @rows;

	return $rows_str;
}

# Build vertical poll
sub build_vertical_poll
{
	my ($number_of_options, $total_votes, $show_votes, $show_percent, $show_bars, $bar_width, $bar_length, $row_separator, $column_separator, %poll_options_info) = @_;

	# Initialize rows, columns and temporary variables
	my (@rows, @columns, $rows_str, $columns_str, $percent_votes, $percent_bar);

	# Graphical bars row
	if ($show_bars) {
		@columns = ();
		for (my $p = 0; $p < $number_of_options; $p++) {
			if ($total_votes == 0) {
				$percent_bar = 1;
			} else {
				$percent_bar = int(($poll_options_info{'option_votes'}[$p] / $total_votes) * $bar_length);
				$percent_bar = 1 if $percent_bar < 1;
			}
			$columns[$p] = qq(<td nowrap><div align="center"> 
                                          <table width="$bar_width" height="$percent_bar" border="0" cellpadding="0" cellspacing="0" bgcolor="$poll_options_info{'option_color'}[$p]">
                                          <tr> 
                                          <td><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="$bar_width" height="$percent_bar"></td>
                                          </tr>
                                          </table>
                                          </div></td>);
		}
		$columns_str = join $column_separator, @columns;
		push(@rows, qq(<tr valign="bottom"> $columns_str\n</tr>\n));
	}

	# Vote percentage row
	if ($show_percent) {
		@columns = ();
		for (my $q = 0; $q < $number_of_options; $q++) {
			if ($total_votes == 0) {
				$percent_votes = 0;
			} else {
				$percent_votes = int(($poll_options_info{'option_votes'}[$q] / $total_votes) * 100);
				if (((($poll_options_info{'option_votes'}[$q] / $total_votes) * 100) - $percent_votes) >= 0.5) {
					$percent_votes++;	# round off
				}
			}
			$columns[$q] = qq(<td nowrap><div align="center"><font size="$main::template_font_size" face="$main::template_font_face">$percent_votes%</font></div></td>);
		}
		$columns_str = join $column_separator, @columns;
		push(@rows, qq(<tr valign="top"> \n$columns_str</tr>\n));
	}

	# Votes row
	if ($show_votes) {
		@columns = ();
		for (my $r = 0; $r < $number_of_options; $r++) {
			$columns[$r] = qq(<td nowrap><div align="center"><font size="$main::template_font_size" face="$main::template_font_face">$poll_options_info{'option_votes'}[$r]</font></div></td>);
		}
		$columns_str = join $column_separator, @columns;
		push(@rows, qq(<tr valign="top"> \n$columns_str</tr>\n));
	}

	# Option text row
	@columns = ();
	for (my $t = 0; $t < $number_of_options; $t++) {
		$columns[$t] = qq(<td><div align="center"><font size="$main::template_font_size" face="$main::template_font_face">$poll_options_info{'option_text'}[$t]</font></div></td>);
	}
	$columns_str = join $column_separator, @columns;
	push(@rows, qq(<tr valign="top"> \n$columns_str</tr>\n));

	# Combine all rows
	$rows_str = join $row_separator, @rows;

	return $rows_str;
}

# Reset IP Log
sub reset_ip_log
{
	my ($poll_id, $current_date) = @_;

	my $file_db = new lib::FileDB;

	# Reset IP log
	$file_db->open_file(-file_name => "$main::DATA_PATH/$poll_id.log",
	                    -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => ["IP_ADDRESS"]);
	$file_db->commit_changes();
	$file_db->close_file();

	# Update POLLS table
	$file_db->open_file( -file_name => "$main::DATA_PATH/POLLS.cgi",
	                     -open_to   => "update"
	                   );
	$file_db->update_records( -condition => "poll_id=$poll_id",
	                          -fields    => ['ip_cleaning_date'],
	                          -values    => [$current_date]
	                        );
	$file_db->commit_changes();
	$file_db->close_file();
}