# new_poll.inc

use strict;

# New poll screen
sub new_poll
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Get a list of available templates
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/TEMPLATES.cgi");
	$file_db->close_file();
	my %template_info = $file_db->get_records();

	# Must have at least one template
	if (!%template_info) {
		lib::MsgBox->new( type => "error",
		                  text => "There are no poll templates available. You must have at least one template available to use this function."
		                );
	}

	# Templates list (field)
	my $templates_list = qq(<select name="template" size="1" class="guitextbox">\n);
	for (my $k = 0; $k < scalar(@{$template_info{'template_id'}}); $k++) {
		$templates_list .= qq(<option value="$template_info{'template_id'}[$k]">$template_info{'template_name'}[$k]</option>);
	}
	$templates_list .= qq(</select>);

	# Generate date fields
	my $date = new lib::Date;
	my $WEEK_IN_SECS = 604800;
	my $current_date = $date->current_date();
	my ($year, $month, $day, $hour, $min, $sec) = ($date->get_year(  -date => $current_date),
	                                               $date->get_month( -date => $current_date),
	                                               $date->get_day(   -date => $current_date),
	                                               $date->get_hour(  -date => $current_date),
	                                               $date->get_minute(-date => $current_date),
	                                               $date->get_second(-date => $current_date)
	                                              );
	my ($fut_year, $fut_month, $fut_day, $fut_hour, $fut_min, $fut_sec) = ($date->get_year(  -date => $current_date + $WEEK_IN_SECS),
	                                                                       $date->get_month( -date => $current_date + $WEEK_IN_SECS),
	                                                                       $date->get_day(   -date => $current_date + $WEEK_IN_SECS),
	                                                                       $date->get_hour(  -date => $current_date + $WEEK_IN_SECS),
	                                                                       $date->get_minute(-date => $current_date + $WEEK_IN_SECS),
	                                                                       $date->get_second(-date => $current_date + $WEEK_IN_SECS)
	                                                                      );

	# Current date selection
	my $cur_year_selection = $date->year_selection_box( -name     => "start_year",
	                                                    -start    => $year,
	                                                    -end      => $year + 5,
	                                                    -selected => $year
	                                                  );

	my $cur_month_selection = $date->month_selection_box( -name     => "start_month",
	                                                      -selected => $month
	                                                    );

	my $cur_day_selection = $date->day_selection_box( -name     => "start_day",
	                                                  -selected => $day
	                                                );

	# Future date selection
	my $fut_year_selection = $date->year_selection_box( -name     => "end_year",
	                                                    -start    => $fut_year,
	                                                    -end      => $year + 5,
	                                                    -selected => $fut_year
	                                                  );

	my $fut_month_selection = $date->month_selection_box( -name     => "end_month",
	                                                      -selected => $fut_month
	                                                    );

	my $fut_day_selection = $date->day_selection_box( -name     => "end_day",
	                                                  -selected => $fut_day
	                                                );

	# IP Log cleaning time generator
	my $ip_time_val;
	my $ip_time_list = qq(<select name="ip_cleaning_time_mult" size="1" class="guiformfield">
                              <option value="1">seconds</option>
                              <option value="60">minutes</option>
                              <option value="3600">hours</option>
                              <option value="86400">days</option>
                              </select>
                             );
	if ($main::DEFAULT_IP_CLEANING_TIME == 0) {
		$ip_time_val = 0;
		$ip_time_list =~ s/value=\"1\"/value=\"1\" selected/;
	} else {
		foreach my $multiplier(86400, 3600, 60, 1) {
			if (($main::DEFAULT_IP_CLEANING_TIME % $multiplier) == 0) {
				$ip_time_val  = int($main::DEFAULT_IP_CLEANING_TIME / $multiplier);
				$ip_time_list =~ s/value=\"$multiplier\"/value=\"$multiplier\" selected/;
				last;	# break out of the loop to prevent multiple select
			}
		}
	}


	# Start new GUI screen
	my $screen = lib::GUI->new( title    => "Member Area: New Poll",
	                            user_msg => $memb_info{'user_info'}
	                          );

		# Focus on first field (poll question)
		$screen->javascript( -location => "body",
		                     -code     => qq(onload="document.adform1.poll_question.focus(); document.adform1.poll_question.select()")
		                   );

		# Main window
		$screen->tab( -label  => "General Settings",
		              -active => 1
		            );

		$screen->tab(-label  => "Options and Colors");

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="new_poll_options">)
		                   );

		$screen->main_field( -label => "Poll question/description:",
		                     -code  => qq(<textarea name="poll_question" cols="30" rows="5" wrap="VIRTUAL" class="guitextbox">Enter poll question here...</textarea>)
		                   );

		$screen->main_field( -label       => "Number of answer options:",
		                     -description => "*enter a value between 2 and 999",
		                     -code        => qq(<input name="number_of_options" type="text" class="guitextbox" size="40" maxlength="3">)
		                   );

		$screen->main_field( -label => "Poll template:",
		                     -code  => $templates_list
		                   );

		$screen->main_field( -label       => "Start date:",
		                     -description => "*must be a current or future date",
		                     -code        => qq($cur_month_selection $cur_day_selection $cur_year_selection)
		                   );

		$screen->main_field( -label       => "End date:",
		                     -description => "*must be a future date",
		                     -code        => qq($fut_month_selection $fut_day_selection $fut_year_selection)
		                   );

		$screen->main_field( -label       => "Clean IP log every:",
		                     -description => "*enter 0 to disallow multiple votes",
		                     -code        => qq(<input name="ip_cleaning_time" type="text" value="$ip_time_val" class="guiformfield" size="16" maxlength="15">
		                                        $ip_time_list)
		                   );

		$screen->main_field( -label       => "Active:",
		                     -description => "*allows to temporarily disable the poll",
		                     -code        => qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		                                        <input type="radio" name="active" value="1" checked>
                                                        Yes 
                                                        <input type="radio" name="active" value="0">
                                                        No</font>)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="next_step" type="submit" class="guibutton" value="Next Step...">)
		                   );

		$screen->main_footer(-label => 'All fields are required.');

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# New poll options screen
sub new_poll_options
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Get current date
	my $date = new lib::Date;
	my $current_date = $date->current_date();
	my ($cur_year, $cur_month, $cur_day, $cur_hour, $cur_min, $cur_sec) = ($date->get_year(  -date => $current_date),
	                                                                       $date->get_month( -date => $current_date),
	                                                                       $date->get_day(   -date => $current_date),
	                                                                       $date->get_hour(  -date => $current_date),
	                                                                       $date->get_minute(-date => $current_date),
	                                                                       $date->get_second(-date => $current_date)
	                                                                      );
	$current_date = $date->to_numeric( -year  => $cur_year,
	                                   -month => $cur_month,
	                                   -day   => $cur_day);

	# Error checking
	my $error_string = "";

	if ($FORM->param('poll_question')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter poll question/description.";
	}

	if ($FORM->param('number_of_options') !~ /^\d+$/ || $FORM->param('number_of_options') < 2 || 
	    $FORM->param('number_of_options') > 999) {
		$error_string .= "<br>- The number of answer options must be an integer between 2 and 999.";
	}

	# Check if the dates are valid
	my $days_in_start_month = $date->days_in_month( -month => $FORM->param('start_month'), 
	                                                -year  => $FORM->param('start_year')
	                                              );

	if ($FORM->param('start_day') > $days_in_start_month) {
		$error_string .= "<br>- Start date is invalid: there are only $days_in_start_month days in selected month.";
	}

	my $days_in_end_month = $date->days_in_month( -month => $FORM->param('end_month'), 
	                                              -year  => $FORM->param('end_year')
	                                            );

	if ($FORM->param('end_day') > $days_in_end_month) {
		$error_string .= "<br>- End date is invalid: there are only $days_in_end_month days in selected month.";
	}

	my $start_date = $date->to_numeric( -year  => $FORM->param('start_year'), 
	                                    -month => $FORM->param('start_month'), 
	                                    -day   => $FORM->param('start_day')
	                                  );

	my $end_date = $date->to_numeric( -year   => $FORM->param('end_year'), 
	                                  -month => $FORM->param('end_month'), 
	                                  -day   => $FORM->param('end_day')
	                                 );

	# Start date must be a current or future date
	if ($FORM->param('start_year') !~ /^\d+$/ || $FORM->param('start_day') !~ /^\d+$/ || $FORM->param('start_month') !~ /^\d+$/ || 
	    $FORM->param('start_year') !~ /^\d+$/ || $start_date < $current_date) {
	   	$error_string .= "<br>- Start date must be a current or future date.";
	}

	# End date must be a future date
	if ($FORM->param('end_year') !~ /^\d+$/ || $FORM->param('end_day') !~ /^\d+$/ || $FORM->param('end_month') !~ /^\d+$/ || 
	    $FORM->param('end_year') !~ /^\d+$/ || $end_date <= $current_date) {
	   	$error_string .= "<br>- End date must be a future date.";
	}

	# End date must be a later date than the start date
	if ($start_date >= $end_date) {
	   	$error_string .= "<br>- End date must be a later date than the start date.";
	}

	if ($FORM->param('ip_cleaning_time') !~ /^\d+$/) {
		$error_string .= "<br>- IP log cleaning time must either be a 0 or positive integer.";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                 );
	}

	# Format fields
	my ($poll_question, $template) = ($FORM->param('poll_question'), $FORM->param('template'));
	$poll_question =~ s/\n/ /g;
	$poll_question =~ s/\r//g;
	$poll_question =~ s/\t//g;
	&filter_html($poll_question);
	my $number_of_options = $FORM->param('number_of_options');
	my $ip_cleaning_time = int($FORM->param('ip_cleaning_time') * $FORM->param('ip_cleaning_time_mult'));
	my $active = $FORM->param('active');
	$active = '0' unless $active eq '1';

	# Poll options and colors screen
	my $screen = lib::GUI->new(title    => "Member Area: New Poll",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# JavaScript functions
		my $js_code = "var tot_options = $number_of_options;\nvar colorArray = [";
		my @colors = &colors_list();
		for (my $i = 0; $i < $#colors; $i++) {
			$js_code .= "$i, ";
			$js_code .= "\n" if !(($i + 1) % 20);	# 20 numbers per line
		}
		$js_code .= scalar(@colors) - 1;
		$js_code .= "];\n\n";
		$js_code .= qq(function randomColors()
		               {
		               		var tmpArray  = new Array();
		               		tmpArray = tmpArray.concat(colorArray);
		               		var random_num;
		               		for (var i = 1; i <= tot_options; i++) {
		               			random_num = Math.floor(Math.random() * (tmpArray.length + 1));
		               			var tmpList = document.adform1.elements["option_" + i + "_color"];
		               			tmpList.options[tmpArray[random_num + 1]].selected = true;
		               			tmpArray.splice(random_num, 1);
		               			if (tmpArray.length == 0) {
		               				tmpArray = tmpArray.concat(colorArray);
		               			}
		               		}
		               }
		               );
		$screen->javascript(-code => $js_code);

		# Focus on first field (answer option 1)
		$screen->javascript( -location => "body",
		                     -code     => qq(onload="document.adform1.option_1.focus()")
		                    );

		# Main window
		$screen->tab( -link   => "javascript:history.back();",
		              -label  => "General Settings"
		             );

		$screen->tab( -label  => "Options and Colors",
		              -active => 1
		             );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_new_poll">)
		                    );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="poll_question" type="hidden" value="$poll_question">)
		                    );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="number_of_options" type="hidden" value="$number_of_options">)
		                    );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="template" type="hidden" value="$template">)
		                    );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="start_date" type="hidden" value="$start_date">)
		                    );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="end_date" type="hidden" value="$end_date">)
		                    );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="ip_cleaning_time" type="hidden" value="$ip_cleaning_time">)
		                    );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="active" type="hidden" value="$active">)
		                    );

		$screen->main_field( -label => "Randomize color selection:",
		                     -code => qq(<input name="randomize" type="button" class="guibutton" value="Randomize!" onClick="randomColors()">)
		                    );

		for (my $j = 1; $j <= $number_of_options; $j++) {

			$screen->main_field( -label => "Answer option $j:",
			                     -code => qq(<input name="option_$j" type="text" class="guitextbox" size="40" maxlength="500">)
			                    );

			my $colors_list = &colors_list("option_${j}_color");
			$screen->main_field( -label => "Answer option $j color:",
			                     -description => "*select from the list or enter a hexadecimal color value",
			                     -code => qq($colors_list <input name="option_${j}_hex_color" type="text" value="#" class="guiformfield" size="10" maxlength="7">)
			                    );
		}

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="GO_BACK" type="button" class="guibutton" value="Go Back" onClick="history.back()">)
		                    );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                    );

		$screen->main_footer(-label => '* Indicates a required field.');

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Save new poll
sub save_new_poll
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my (%option_values, $option_text);
	my $option_num = 0;

	my $date = new lib::Date;
	my $current_date = $date->current_date();

	# Error checking and formatting
	my $error_string;

	for (my $i = 1; $i <= $FORM->param('number_of_options'); $i++) {
		if ($FORM->param("option_$i") =~ /\S+/ && $FORM->param("option_${i}_color") !~ /\S+/ && $FORM->param("option_${i}_hex_color") !~ /^#\S\S\S\S\S\S$/) {
			$error_string .= "<br>- Please select or enter a valid color value for answer option $i. Leave it blank if you do not want to use it.";
		}
		elsif ($FORM->param("option_$i") =~ /\S+/) {
			$option_num++;
			$option_text = $FORM->param("option_$i");
			$option_text =~ s/\n/ /g;
			$option_text =~ s/\r//g;
			$option_text =~ s/\t//g;
			$option_values{'option_num'}[$option_num - 1] = $option_num;
			$option_values{'option_text'}[$option_num - 1] = $option_text;
			if ($FORM->param("option_${i}_color") =~ /\S+/) {
				$option_values{'option_color'}[$option_num - 1] = $FORM->param("option_${i}_color");
			} else {
				$option_values{'option_color'}[$option_num - 1] = $FORM->param("option_${i}_hex_color");
			}
			$option_values{'option_votes'}[$option_num - 1] = '0';
		}
	}

	if ($option_num < 2) {
		$error_string .= "<br>- You must enter at least 2 answer options for this poll.";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                 );
	}

	my $file_db = new lib::FileDB;

	# Get next available poll id
	$file_db->open_file( -file_name => "$main::DATA_PATH/AUTO_INCREMENT.cgi", 
	                     -open_to   => "update" );
	my %poll_id_info = $file_db->get_record(-condition => "field_name=POLL_ID");
	my $poll_id = $poll_id_info{'auto_value'};
	$file_db->update_records( -condition => "field_name=POLL_ID",
	                          -fields    => ['auto_value'], 
	                          -values    => [++$poll_id]
	                         );
	$file_db->commit_changes();
	$file_db->close_file();

	# Save poll info
	$file_db->open_file( -file_name => "$main::DATA_PATH/POLLS.cgi", 
	                     -open_to   => "update" );
	$file_db->insert_record( -values => [ $poll_id,                         $memb_info{'memb_id'}, 
	                                      $FORM->param('poll_question'),    $FORM->param('template'), 
	                                      $FORM->param('start_date'),       $FORM->param('end_date'), 
	                                      $FORM->param('ip_cleaning_time'), $current_date, 
	                                      $FORM->param('active')]
	                       );
	$file_db->commit_changes();
	$file_db->close_file();

	# Save poll options
	$file_db->open_file( -file_name => "$main::DATA_PATH/$poll_id.cgi", 
	                     -open_to   => "overwrite" );
	$file_db->insert_record(-values => ["OPTION_NUM", "OPTION_TEXT", "OPTION_COLOR", "OPTION_VOTES"]);
	for (my $j = 0; $j < $option_num; $j++) {
		$file_db->insert_record(-values => [$option_values{'option_num'}[$j], $option_values{'option_text'}[$j], $option_values{'option_color'}[$j], $option_values{'option_votes'}[$j]]);
	}
	$file_db->commit_changes();
	$file_db->close_file();

	# Create poll IP db
	$file_db->open_file(-file_name => "$main::DATA_PATH/$poll_id.log",
	                    -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => ["IP_ADDRESS"]);
	$file_db->commit_changes();
	$file_db->close_file();

	# Display success message
	lib::MsgBox->new( type           => "success",
	                  text           => "New poll has been saved.",
	                  button2_action => "LINK",
	                  close_link     => "$main::SCRIPT_URL/members.cgi?redirect=current_polls",
	                 );
}

# Generate color selection box
sub colors_list
{
	my ($field_name) = @_;

	my @colors = ('aliceblue', 'antiquewhite', 'aquamarine', 'azure', 'beige',
	              'bisque', 'black', 'blanchedalmond', 'blue', 'blueviolet',
	              'brown', 'burlywood', 'cadetblue', 'chartreuse', 'chocolate',
	              'coral', 'cornflowerblue', 'cornsilk', 'cyan', 'darkblue',
	              'darkcyan', 'darkgoldenrod', 'darkgray', 'darkgreen', 'darkkhaki',
	              'darkmagenta', 'darkolivegreen', 'darkorange', 'darkorchid', 'darkred',
	              'darksalmon', 'darkseagreen', 'darkslateblue', 'darkslategray', 'darkturquoise',
	              'darkviolet', 'deeppink', 'deepskyblue', 'dimgray', 'dodgerblue',
	              'firebrick', 'floralwhite', 'forestgreen', 'gainsboro', 'ghostwhite',
	              'gold', 'goldenrod', 'gray', 'green', 'greenyellow',
	              'honeydew', 'hotpink', 'indianred', 'ivory', 'khaki',
	              'lavender', 'lavenderblush', 'lawngreen', 'lemonchiffon', 'lightblue',
	              'lightcoral', 'lightcyan', 'lightgoldenrod', 'lightgoldenrodyellow', 'lightgray',
	              'lightgreen', 'lightpink', 'lightsalmon', 'lightseagreen', 'lightskyblue',
	              'lightslateblue', 'lightslategray', 'lightsteelblue', 'lightyellow', 'limegreen',
	              'linen', 'magenta', 'maroon', 'mediumaquamarine', 'mediumblue',
	              'mediumorchid', 'mediumpurple', 'mediumseagreen', 'mediumslateblue', 'mediumspringgreen',
	              'mediumturquoise', 'mediumvioletred', 'midnightblue', 'mintcream', 'mistyrose',
	              'moccasin', 'navajowhite', 'navy', 'navyblue', 'oldlace',
	              'olivedrab', 'orange', 'orangered', 'orchid', 'palegoldenrod',
	              'palegreen', 'paleturquoise', 'palevioletred', 'papayawhip', 'peachpuff',
	              'peru', 'pink', 'plum', 'powderblue', 'purple',
	              'red', 'rosybrown', 'royalblue', 'saddlebrown', 'salmon',
	              'sandybrown', 'seagreen', 'seashell', 'sienna', 'skyblue',
	              'slateblue', 'slategray', 'snow', 'springgreen', 'steelblue',
	              'tan', 'thistle', 'tomato', 'turquoise', 'violet',
	              'violetred', 'wheat', 'white', 'whitesmoke', 'yellow',
	              'yellowgreen');

	if ($field_name) {
		my $colors_list = qq(<select name="$field_name" size="1" class="guiformfield">
		                     <option value="" selected>Custom color:</option>\n);
		for (my $i = 0; $i < scalar(@colors); $i++) {
			$colors_list .= qq(<option style="background-color: $colors[$i]" value="$colors[$i]">$colors[$i]</option>\n);
		}
		$colors_list .= qq(</select>\n);
		return $colors_list;
	} else {
		return @colors;
	}
}

1;