#!/usr/bin/perl -w

# members.cgi

###############################################################
#                                                             #
# Any use of this program is entirely at the risk of the      #
# user. No liability will be accepted by the author.          #
#                                                             #
# This code must not be distributed or sold, even in modified #
# form, without the written permission of the author.         #
#                                                             #
###############################################################

use strict;

# Load variables and class libraries, trap all errors
eval {
	# Get script location (UNIX & Windows)
	($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");

	# Get script location (Windows)
	($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

	# Load global variables and subroutines
	require "archives.inc";
	require "common.inc";
	require "current_polls.inc";
	require "memb_profile.inc";
	require "new_poll.inc";
	require "settings.inc";
	require "setup.inc";
	require "templates.inc";

	# Load class libraries
	use CGI::Carp qw(fatalsToBrowser);
	use CGI qw(:standard);
	use lib::Date;
	use lib::FileDB;
	use lib::GUI;
	use lib::Login;
	use lib::MsgBox;
	use strict;
};
if ($@) {
	print "Content-type: text/plain\n\n",
	      "Failed to load global variables and class libraries:\n$@\n",
	      "Please make sure that all program files were uploaded in ASCII mode,\n",
	      "permissions have been set correctly and all files are in correct location.\n",
	      "Refer to program manual for more detail.";
	exit;
}

# Execute script
eval { &main; };
if ($@) { lib::MsgBox->new(text => $@); }

######################## MAIN PROGRAM BLOCK ########################
sub main
{
	# Denial of service attack prevention
	$CGI::POST_MAX = 1024000;	# max form post size
	$CGI::DISABLE_UPLOADS = 1;	# no file uploads

	my $FORM = new CGI;
	my %memb_info;

	# Get member information from cookies
	my ($pmUser, $pmPassword) = ($FORM->cookie('pmUser'), $FORM->cookie('pmPassword'));

	# Redirect to selected screen
	if ($FORM->param('redirect')) {
		if ($pmUser && $pmPassword) {
			%memb_info = &validate_login($pmUser, $pmPassword, 1);
		} else {
			%memb_info = &validate_login($FORM->param('user_name'), $FORM->param('password'), 0);
		}
		eval "&" . $FORM->param("redirect") . '(%memb_info)';
		lib::MsgBox->new(text => $@) if $@;

	# Skip login screen if e-mail/password are saved
	} elsif ($pmUser && $pmPassword) {
		%memb_info = &validate_login($pmUser, $pmPassword, 1);
		&memb_main(%memb_info);

	# Login screen
	} else {
		my $screen = lib::Login->new(redirect => "memb_main");
	}

	exit;
}

########################### SUB ROUTINES ###########################

# Main administrative screen
sub memb_main {

	my %memb_info = @_;

	my $FORM = new CGI;

	# Start new GUI screen
	my $screen = lib::GUI->new(title    => "Member Area: Main Menu",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->main_heading(-label => "Main Menu");

			$screen->main_block(-code => qq(<b><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a href="$main::SCRIPT_URL/members.cgi?redirect=memb_profile">Profile</a></font></b><br>
                                                        <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">View 
                                                        or edit your personal preferences.</font>));

			$screen->main_block(-code => qq(<b><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a href="$main::SCRIPT_URL/members.cgi?redirect=new_poll">New 
                                                        Poll</a></font></b><br> <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">Use 
                                                        a simple step-by-step wizard to add new 
                                                        poll to your website.</font>));

			$screen->main_block(-code => qq(<b><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a href="$main::SCRIPT_URL/members.cgi?redirect=current_polls">Current 
                                                        Polls</a></font></b><br> <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">View, 
                                                        edit, delete or expire any of your existing 
                                                        polls.</font>));

			$screen->main_block(-code => qq(<b><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a href="$main::SCRIPT_URL/members.cgi?redirect=archives">Archives</a></font></b><br> 
                                                        <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">View, 
                                                        edit or delete any of your archived polls.</font>));

			$screen->main_block(-code => qq(<b><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a href="$main::SCRIPT_URL/members.cgi?redirect=templates">Templates</a></font></b><br> 
                                                        <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">Create, 
                                                        edit, preview or delete poll templates.</font>));

			$screen->main_block(-code => qq(<b><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a href="$main::SCRIPT_URL/members.cgi?redirect=setup">Setup</a></font></b><br> 
                                                        <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">Configure program variables and 
                                                        options.</font>));

		$screen->main_footer(-label => '<a href="http://www.estudio.ca" target="_blank">Poll Master Documentation</a>');

		$screen->side_bar_from_template(-template => "memb_main");

	# Display GUI screen
	$screen->display();
}

# Validate login information
sub validate_login
{
	my ($user_name, $password, $cookie_check) = @_;

	my $error_string = "";

	if ($user_name !~ /^[\w ]+$/ || length($user_name) < 3 || length($user_name) > 30) {
		$error_string .= "<br>- You did not enter a valid user name.";
	}

	if ($password eq "" || $password =~ /\s/ || length($password) < 4 || length($password) > 12) {
		$error_string .= "<br>- You did not enter a valid password.";
	}

	if ($error_string) {
		if ($cookie_check) {
			# Login screen
			print "Set-Cookie: pmUser=\n";
			print "Set-Cookie: pmPassword=\n";
			my $screen = lib::Login->new(redirect => "memb_main");
		} else {
			# Display error message
			lib::MsgBox->new( type => "error",
			                  text => "Your submission was not accepted: $error_string"
			                );
		}
	}

	# Validate login information
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/USERS.cgi");
	my %memb_record = $file_db->get_record(-condition => "name=$user_name");
	$file_db->close_file();

	if (%memb_record) {
		unless ($memb_record{'password'} eq $password) {
			$error_string .= "<br>- The password that you entered is incorrect.";
		}
	} else {
		$error_string .= "<br>- Entered user name was not found in the database.";
	}

	if ($error_string) {
		if ($cookie_check) {
			# Login screen
			print "Set-Cookie: pmUser=\n";
			print "Set-Cookie: pmPassword=\n";
			my $screen = lib::Login->new(redirect => "memb_main");
		} else {
			# Display error message
			lib::MsgBox->new( type => "error",
			                  text => "Your submission was not accepted: $error_string"
			                );
		}
	}

	# Save login information for next session
	if (!$cookie_check) {
		print "Set-Cookie: pmUser=$user_name\n";
		print "Set-Cookie: pmPassword=$password\n";
	}

	# Return member information
	$memb_record{'user_info'} = "User: " . $memb_record{'name'} . " (" . $memb_record{'memb_type'} . ")";
	return %memb_record;
}

# Log out
sub memb_log_out
{
	my %memb_info = @_;
	print "Set-Cookie: pmUser=\n";
	print "Set-Cookie: pmPassword=\n";
	print "Location: $main::HOME_PAGE_URL\n\n";
}
