# memb_profile.inc

use strict;

# User profile screen
sub memb_profile
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my $date = new lib::Date;
	my $memb_date = $date->to_string(-date => $memb_info{'memb_date'});

	# Start new GUI screen
	my $screen = lib::GUI->new(title => "Member Area: Profile",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->main_heading(-label => "Profile");

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="memb_profile_save">)
		                   );

		$screen->main_field( -label => "Member since:",
		                     -code => qq(<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$memb_date</font>)
		                   );

		$screen->main_field( -label => "Membership type:",
		                     -code => qq(<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$memb_info{'memb_type'}</font>)
		                   );

		$screen->main_field( -label       => "User name:",
		                     -description => "*3 - 30 characters, no symbols or special characters",
		                     -code        => qq(<input name="user_name" type="text" class="guitextbox" size="40" maxlength="30" value="$memb_info{'name'}">)
		                   );

		$screen->main_field( -label => "E-mail:",
		                     -code => qq(<input name="email" type="text" class="guitextbox" size="40" maxlength="150" value="$memb_info{'email'}">)
		                   );

		$screen->main_field( -label => "Password:",
		                     -description => "*4 - 12 characters, no spaces",
		                     -code => qq(<input name="password" type="password" class="guitextbox" size="40" maxlength="12" value="$memb_info{'password'}">)
		                   );

		$screen->main_field( -label => "Confirm password:",
		                     -description => "*required if you are changing the password",
		                     -code => qq(<input name="password_confirm" type="password" class="guitextbox" size="40" maxlength="12">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer();

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Save changes to member profile
sub memb_profile_save
{
	my %memb_info = @_;
	my $FORM = new CGI;

	# Error checking
	my $error_string = "";

	if ($FORM->param('user_name')  !~ /^[\w ]+$/) {
		$error_string .= "<br>- You did not enter a valid user name.";
	} elsif (length($FORM->param('user_name')) < 3 || length($FORM->param('user_name')) > 30) {
		$error_string .= "<br>- The user name must be between 3 and 30 characters long.";
	}

	if ($FORM->param('email') !~ /[\w\-]+\@[\w\-]+\.[\w\-]+/) {
		$error_string .= "<br>- You did not enter a valid e-mail address.";
	}

	if ($FORM->param('password') eq "" || $FORM->param('password') =~ /\s/) {
		$error_string .= "<br>- You did not enter a valid password.";
	} elsif (length($FORM->param('password')) < 4 || length($FORM->param('password')) > 12) {
			$error_string .= "<br>- The password must be between 4 and 12 characters long.";
	}
	elsif (($FORM->param('password') ne $memb_info{'password'}) && ($FORM->param('password') ne $FORM->param('password_confirm'))) {
		$error_string .= "<br>- The two passwords that you entered do not match.";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                 );
	}

	# Save profile
	my $file_db = new lib::FileDB;
	$file_db->open_file( -file_name => "$main::DATA_PATH/USERS.cgi", 
	                     -open_to   => "update" 
	                   );
	$file_db->update_records( -condition => "memb_id=$memb_info{'memb_id'}", 
	                          -fields    => ['name',                    'email',                'password'              ],
	                          -values    => [$FORM->param('user_name'), $FORM->param('email'),  $FORM->param('password')]
	                        );
	$file_db->commit_changes();
	$file_db->close_file();

	my ($pmUser, $pmPassword) = ($FORM->param('user_name'), $FORM->param('password'));

	print "Set-Cookie: pmUser=$pmUser\n";
	print "Set-Cookie: pmPassword=$pmPassword\n";

	# Display success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Profile settings have been saved.",
	                  button2_action => "LINK",
	                  close_link     => "$main::SCRIPT_URL/members.cgi?redirect=memb_profile",
	                 );
}

1;