package lib::MsgBox;
$VERSION = 1.00;
use CGI::Carp qw(fatalsToBrowser);
use strict;

{
# Encapsulated class data

	# Default constructor values
	my %_attr_data = #        DEFAULT
	   ( _type           => [ "fatal_error"                       ],
	     _action         => [ ""                                  ],
	     _hidden_fields  => [ ""                                  ],
	     _hidden_values  => [ ""                                  ],
	     _text           => [ "An unexpected error has occurred." ],
	     _checkbox       => [ 0                                   ],
	     _smalltext      => [ ""                                  ],
	     _button1        => [ ""                                  ],
	     _button2        => [ "OK"                                ],
	     _button2_action => [ "GO_BACK"                           ],
	     _msg_icon       => [ 1                                   ],
	     _close_link     => [ "javascript:history.back();"        ],
	     _close_icon     => [ 1                                   ]
	   );
	   
	# Message box titles
	my %_title = 
	   ( error       => "Error!",
	     fatal_error => "Fatal error!",
	     info        => "Information",
	     question    => "Question",
	     success     => "Success!",
	     wait        => "Please wait...",
	     warning     => "Warning!",
	   );

# Class methods, to operate on encapsulated class data

	# Classwide default value for all specified object attributes
	sub _default_for
	{
		my ($self, $attr) = @_;
		$_attr_data{$attr}[0];
	}

	# List of names of all specified object attributes
	sub _standard_keys
	{
		keys %_attr_data;
	}

	# Display message box
	sub _display
	{
		my $self = shift;

		# Error detection
		if (!$self->{_text}) {
			croak "Incorrect use of lib::MsgBox::new() method: missing or invalid text parameter.";
		}

		# Hidden fields
		my $hidden_fields = "";
		if ($self->{_hidden_fields}) {
			for (my $i = 0; $i < scalar(@{$self->{_hidden_fields}}); $i++) {
				$hidden_fields .= qq(  <input name="$self->{_hidden_fields}[$i]" type="hidden" value="$self->{_hidden_values}[$i]">\n);
			}
		}

		# Message box title
		my $msg_title = $_title{$self->{_type}};

		# Default HTML values
		my $_checkbox_html = qq(\n                      <input name="dontshow" type="checkbox" id="dontshow" value="1">\n);
		my $_button1_html  = qq(                <input name="$self->{_button1}" type="submit" class="msgboxbutton" id="$self->{_button1}" value="$self->{_button1}">);
		my $_button2_html  = "";
		my $_tmp_closelink = $self->{_close_link};

		# Three button types: "go back", "link" or "submit form"
		if ($self->{_button2_action} eq "GO_BACK") {
			$_button2_html = qq(                <input name="$self->{_button2}" type="button" class="msgboxbutton" value="$self->{_button2}" onClick="history.back()">);
		} elsif ($self->{_button2_action} eq "LINK") {
			$_button2_html = qq(                <input name="$self->{_button2}" type="button" class="msgboxbutton" value="$self->{_button2}" onClick="parent.location='$self->{_close_link}'">);
		} elsif ($self->{_button2_action} eq "CLOSE_WINDOW") {
			$_button2_html = qq(                <input name="$self->{_button2}" type="button" class="msgboxbutton" value="$self->{_button2}" onClick="self.close()">);
			$_tmp_closelink   = qq(javascript:self.close(););
		} else {
			$_button2_html = qq(                <input name="$self->{_button2}" type="submit" class="msgboxbutton" value="$self->{_button2}">);
		}

		# Close icon/link
		my $close_icon = "";
		$close_icon = qq(<a href="$_tmp_closelink"><img src="$main::NONCGI_URL/icons/title_bar_close.gif" alt="$self->{_button2}" hspace="1" vspace="1" border="0"></a>) if $self->{_close_icon};

		# Message icon
		my $msg_icon = "";
		$msg_icon = qq(<img src="$main::NONCGI_URL/icons/$self->{_type}.gif" alt="$msg_title" vspace="3">) if $self->{_msg_icon};

		# Assign default HTML values
		my ($_tmp_checkbox, $_tmp_extra_row, $_tmp_button1, $_tmp_button2) = ("", "", "", "");

		# Assign values
		$_tmp_checkbox = $_checkbox_html if $self->{_checkbox};		# check box

		if ($self->{_smalltext}) {					# small text
			$_tmp_extra_row = qq(                <tr>
                  <td><div align="center"><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">$_tmp_checkbox
                      $self->{_smalltext}</font></div></td>
                </tr>);
        	}

		$_tmp_button1 = $_button1_html if $self->{_button1};		# button 1
		$_tmp_button2 = $_button2_html if $self->{_button2};		# button 2

		# Print Message Box
		print "Content-type:text/html\n\n";
		print qq(<html>
<head>
<title>$msg_title</title>
<link href="$main::NONCGI_URL/styles/pm.css" rel="stylesheet" type="text/css">
</head>
<body>
<form style="margin: 0px;" name="adform1" method="post" action="$self->{_action}">
$hidden_fields
  <table width="400" border="0" align="center" cellpadding="1" cellspacing="0" bgcolor="#AFB4D1" class="guitable">
    <tr bgcolor="#AEADC4"> 
      <td width="100%"><font color="#4B5383" size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><b>&nbsp;$msg_title</b></font></td>
      <td><div align="right">$close_icon</div></td>
    </tr>
    <tr> 
      <td colspan="2"><table width="100%" border="0" cellpadding="3" cellspacing="0" bgcolor="#C2C5DC">
          <tr> 
            <td width="15%" rowspan="2" valign="top"><div align="center">$msg_icon</div></td>
            <td width="70%" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr> 
                  <td><div align="center"><font color="#000000" size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$self->{_text}</font></div></td>
                </tr>
$_tmp_extra_row
              </table></td>
            <td width="15%">&nbsp;</td>
          </tr>
          <tr> 
            <td valign="top"><div align="center"> 
$_tmp_button1
$_tmp_button2
              </div></td>
            <td valign="top">&nbsp;</td>
          </tr>
        </table></td>
    </tr>
  </table>
  </form>
</body>
</html>
);
		exit;
	}
}

# Constructor
sub new
{
	my ($class, %arg) = @_;
	my $self = bless {}, $class;
	foreach my $attrname ( $self->_standard_keys() )
	{
		my ($argname) = ($attrname =~ /^_(.*)/);
		if (exists $arg{$argname})
		   { $self->{$attrname} = $arg{$argname} }
		else
		   { $self->{$attrname} = $self->_default_for($attrname) }
	}
	$self->{_action} = "$main::SCRIPT_URL/members.cgi" if !$self->{_action};	# Action needs to be set separately due to use of global variable
	$self->_display();
	return $self;
}

1;