package lib::GUI;
$VERSION = 1.00;
use CGI::Carp qw(fatalsToBrowser);
use strict;

{
# Encapsulated class data

	# Default constructor values
	my %_attr_data = #         DEFAULT
	   ( _action          => [ ""                        ],
	     _encoding        => [ ""                        ],
	     _title           => [ "Poll Master v1.0"        ],
	     _help_icon       => [ 1                         ],
	     _help_icon_link  => [ ""                        ],
	     _close_icon      => [ 1                         ],
	     _user_menu       => [ 1                         ],
	     _user_msg        => [ ""                        ],
	     _powered_msg     => [ "Powered by Poll Master"  ],
	   );

	# Code containers
	my %_code_container = 
	   ( _javascript_head    => "",
	     _javascript_body    => "",
	     _html_hidden_fields => "",
	     _html_main_heading  => "",
	     _html_main_footer   => "",
	     _html_main_buttons  => "",
	     _html_main          => "",
	     _html_side_bar      => "",
	   );

	# Tab containers
	my (@_tab_link, @_tab_label, @_tab_active);

# Class methods, to operate on encapsulated class data

	# Classwide default value for all specified object attributes
	sub _default_for
	{
		my ($self, $attr) = @_;
		$_attr_data{$attr}[0];
	}

	# List of names of all specified object attributes
	sub _standard_keys
	{
		keys %_attr_data;
	}

	# Add to code container
	sub _add_to_code
	{
		my ($self, $location, $code) = @_;

		if ($location eq "_tab_label") {
			push(@_tab_label,  $code);
		} elsif ($location eq "_tab_active") {
			push(@_tab_active,  $code);
		} else {
			$_code_container{$location} .= $code;
		}
	}

	# Generate user menu
	sub _user_menu
	{
		return qq(<tr valign="top"> 
                          <td nowrap><font color="#000000" size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a class="guimenu" href="$main::SCRIPT_URL/members.cgi?redirect=memb_profile">Profile</a> 
                          <a class="guimenu" href="$main::SCRIPT_URL/members.cgi?redirect=new_poll">New Poll</a> <a class="guimenu" href="$main::SCRIPT_URL/members.cgi?redirect=current_polls">Current 
                          Polls</a> <a class="guimenu" href="$main::SCRIPT_URL/members.cgi?redirect=archives">Archives</a> <a class="guimenu" href="$main::SCRIPT_URL/members.cgi?redirect=templates">Templates</a> 
                          </font></td>
                          <td nowrap><div align="right"><font color="#000000" size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><a class="guimenu" href="$main::SCRIPT_URL/members.cgi?redirect=setup">Setup</a> 
                          <a class="guimenu" href="$main::SCRIPT_URL/members.cgi?redirect=memb_log_out">Log Out</a></font></div></td>
                          </tr>\n);
	}

	# Return code in the container
	sub _get_code
	{
		my ($self, $location) = @_;

		if ($location eq "_tab_label") {
			return @_tab_label;
		} elsif ($location eq "_tab_active") {
			return @_tab_active;
		} else {
			return $_code_container{$location};
		}
	}
	
	# Build tabs
	sub _get_tabs
	{
		my $self = shift;

		my ($tmp_color, $tmp_font_color, $tab_top_row, $tab_bottom_row, $tabs);

		my @tab_label  = $self->_get_code("_tab_label");
		my @tab_active = $self->_get_code("_tab_active");

		# Build tab rows
		for (my $i = 0; $i < scalar(@tab_label); $i++) {

			$tab_top_row .= qq(<td><table width="100%");
			$tab_bottom_row .= qq(<td);

			if (!$tab_active[$i]) {
				$tab_top_row .= qq( bgcolor="#E8F0FF");
				$tab_bottom_row .= qq( bgcolor="#C2C5DC");
			}

			# Complete top row
			$tab_top_row .= qq( border="0" cellspacing="0" cellpadding="3">
                                            <tr> 
                                            <td nowrap><font color="#AFB4D1" size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><b>$tab_label[$i]</b></font></td>
                                            </tr>
                                            </table></td>
                                            <td width="1" bgcolor="#C2C5DC"><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="1"></td>\n);

			# Complete bottom row
			$tab_bottom_row .= qq(><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="1"></td>
                                              <td bgcolor="#C2C5DC"><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="1"></td>\n);
		}

		# Complete tabs
		if ($tab_top_row && $tab_bottom_row) {
			$tabs = qq(<tr> 
                                   <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                   <tr> 
                                   $tab_top_row
                                   <td width="100%"><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="1"></td>
                                   </tr>
                                   <tr> 
                                   $tab_bottom_row
                                   <td width="100%" bgcolor="#C2C5DC"><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="1"></td>
                                   </tr>
                                   </table></td>
                                   </tr>);
		}

		return $tabs;
	}

	# Build side bar
	sub _get_side_bar
	{
		my $self = shift;

		my $side_bar_code = $self->_get_code("_html_side_bar");

		my $side_bar = qq(<td width="1" bgcolor="#C2C5DC"><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="1"></td>
                                  <td valign="top"><table width="140" border="0" cellpadding="5" cellspacing="0" id="SIDE BAR">
                                  $side_bar_code
                                  </table></td>) if $side_bar_code;

		return $side_bar;
	}
}

# Constructor
sub new
{
	my ($class, %arg) = @_;
	my $self = bless {}, $class;
	foreach my $attrname ( $self->_standard_keys() )
	{
		my ($argname) = ($attrname =~ /^_(.*)/);
		if (exists $arg{$argname})
		   { $self->{$attrname} = $arg{$argname} }
		else
		   { $self->{$attrname} = $self->_default_for($attrname) }
	}
	$self->{_action} = "$main::SCRIPT_URL/members.cgi" if !$self->{_action};	# Action needs to be set separately due to use of global variable
	return $self;
}

# Add JavaScript code between <HEAD></HEAD> tags or within <BODY...> tag
sub javascript
{
	my ($self, %arg) = @_;

	# Error detection
	if (!$arg{'-code'}) {
		croak "Incorrect use of lib::GUI::javascript() method: missing or invalid -code parameter.";
	}

	# Defaults
	$arg{'-location'} = "head" unless $arg{'-location'} eq "body";

	my $location = "_javascript_" . $arg{'-location'};
	$self->_add_to_code($location, $arg{'-code'});
}

# Add a tab link/label
sub tab
{
	my ($self, %arg) = @_;

	# Error detection
	if (!$arg{'-label'}) {
		croak "Incorrect use of lib::GUI::tab() method: missing or invalid -label parameter.";
	}

	# Defaults
	$arg{'-active'} = "0" unless $arg{'-active'} eq "1";

	# Save tab
	$arg{'-label'} = "<a href=\"$arg{'-link'}\" class=\"guitablabel\">" . $arg{'-label'} . "</a>" if $arg{'-link'};
	$self->_add_to_code("_tab_label", $arg{'-label'});
	$self->_add_to_code("_tab_active", $arg{'-active'});
}

# Add a heading to main window
sub main_heading
{
	my ($self, %arg) = @_;

	# Error detection
	if (!$arg{'-label'}) {
		croak "Incorrect use of lib::GUI::main_heading() method: missing or invalid -label parameter.";
	}

	# Defaults
	$arg{'-icon'} = "sub_menu_item" if $arg{'-icon'} eq "";
	$arg{'-line'} = "1" unless $arg{'-line'} eq "0";

	# Icon wrap
	$arg{'-icon'} = qq(<img src="$main::NONCGI_URL/icons/$arg{'-icon'}.gif" align="absmiddle">)  if $arg{'-icon'};

	# Complete heading
	$self->_add_to_code("_html_main_heading", qq(<tr> 
                                                     <td><table width="100%" border="0" cellpadding="5" cellspacing="0" id="HEADING">
                                                     <tr> 
                                                     <td>$arg{'-icon'}
                                                     <font color="#AFB4D1" size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><b>$arg{'-label'}</b></font></td>
                                                     </tr>
                                                     </table></td>
                                                     </tr>\n));

	# Optional line
	$self->_add_to_code("_html_main_heading", qq(<tr> 
                                                     <td><table width="100%" border="0" cellspacing="0" cellpadding="0" id="HEADING LINE">
                                                     <tr> 
                                                     <td bgcolor="#C2C5DC"><img src="$main::NONCGI_URL/icons/transparent_pixel.gif" width="1" height="1"></td>
                                                     </tr>
                                                     </table></td>
                                                     </tr>\n)) if $arg{'-line'};
}

# Add a footer to main window
sub main_footer
{
	my ($self, %arg) = @_;

	my $footer_buttons = $self->_get_code("_html_main_buttons");

	# Defaults
	$arg{'-line'} = "1" unless $arg{'-line'} eq "0";

	# Optional line
	$self->_add_to_code("_html_main_footer", qq(<tr> 
                                                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0" id="FOOTER LINE">
                                                    <tr> 
                                                    <td bgcolor="#C2C5DC"><img src="icons/transparent_pixel.gif" width="1" height="1"></td>
                                                    </tr>
                                                    </table></td>
                                                    </tr>\n)) if $arg{'-line'};

	# Footer with text and button(s)
	if ($footer_buttons) {
		$self->_add_to_code("_html_main_footer", qq(<tr>
                                                            <td><table width="100%" border="0" cellpadding="5" cellspacing="0" id="FOOTER">
                                                            <tr> 
                                                            <td><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">$arg{'-label'}</font></td>
                                                            <td><div align="right"> 
                                                            $footer_buttons
                                                            </div></td>
                                                            </tr>
                                                            </table></td>
                                                            </tr>\n));

	# Footer with text only
	} else {
		$self->_add_to_code("_html_main_footer", qq(<tr> 
                                                            <td><table width="100%" border="0" cellpadding="5" cellspacing="0" id="FOOTER">
                                                            <tr> 
                                                            <td><div align="center"><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">$arg{'-label'}</font></div></td>
                                                            </tr>
                                                            </table></td>
                                                            </tr>\n));
	}
}

# Add a code block to main window
sub main_block
{
	my ($self, %arg) = @_;

	# Error detection
	if (!$arg{'-code'}) {
		croak "Incorrect use of lib::GUI::main_custom_block() method: missing or invalid -code parameter.";
	}

	# Complete code block
	$self->_add_to_code("_html_main", qq(<tr> 
                                             <td colspan="2">$arg{'-code'}</td>
                                             </tr>\n));
}

# Main window form field
sub main_field
{
	my ($self, %arg) = @_;

	my $description;

	# Error detection
	if (!$arg{'-code'}) {
		croak "Incorrect use of lib::GUI::main_field() method: missing or invalid -code parameter.";
	}

	$description = qq(<br><font size="$main::SECONDARY_FONT_SIZE">$arg{'-description'}</font>) if $arg{'-description'};

	# Complete form field
	if ($arg{'-type'} eq "hidden") {
		$self->_add_to_code("_html_hidden_fields", "$arg{'-code'}\n");
	} elsif ($arg{'-type'} eq "button") {
		$self->_add_to_code("_html_main_buttons", $arg{'-code'});
	} else {
		$self->_add_to_code("_html_main", qq(<tr valign="top"> 
                                                     <td><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$arg{'-label'}$description</font></td>
                                                     <td>$arg{'-code'}</td>
                                                     </tr>));
	}
}

# Add a message to side bar
sub side_message
{
	my ($self, %arg) = @_;

	# Error detection
	if (!$arg{'-title'}) {
		croak "Incorrect use of lib::GUI::side_message() method: missing or invalid -title parameter.";
	} elsif (!$arg{'-text'}) {
		croak "Incorrect use of lib::GUI::side_message() method: missing or invalid -text parameter.";
	}

	# Icon wrap
	$arg{'-icon'} = qq(<img src="$main::NONCGI_URL/icons/$arg{'-icon'}.gif" align="absmiddle">)  if $arg{'-icon'};
	
	# Complete side bar message
	$self->_add_to_code("_html_side_bar", qq(<tr> 
                                                 <td>$arg{'-icon'} 
                                                 <b><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$arg{'-title'}</font></b><br> 
                                                 <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">$arg{'-text'}</font></td>
                                                 </tr>));
}

# Add a code block to side bar
sub side_block
{
	my ($self, %arg) = @_;

	# Error detection
	if (!$arg{'-code'}) {
		croak "Incorrect use of lib::GUI::main_field() method: missing or invalid -code parameter.";
	}

	# Complete side bar message
	$self->_add_to_code("_html_side_bar", qq(<tr> 
                                                 <td>
                                                 $arg{'-code'}
                                                 </td>
                                                 </tr>));
}

# Build side bar from template
sub side_bar_from_template
{
	my ($self, %arg) = @_;

	# Error detection
	if (!$arg{'-template'}) {
		croak "Incorrect use of lib::GUI::side_bar_from_template() method: missing or invalid -template parameter.";
	}

	# Load side bar template
	require "$main::TMPL_PATH/$arg{'-template'}_sb.inc";

	# Default side bar messages
	if (%lib::GUI::default_sb_msg) {
		for (my $i = 0; $i < scalar(@{$lib::GUI::default_sb_msg{'title'}}); $i++) {
			$self->side_message( -icon  => $lib::GUI::default_sb_msg{'icon'}[$i],
			                     -title => $lib::GUI::default_sb_msg{'title'}[$i],
			                     -text  => $lib::GUI::default_sb_msg{'text'}[$i]
			                   );
		}
	}

	# Custom side bar blocks
	if (@lib::GUI::custom_sb_msg) {
		foreach my $msg(@lib::GUI::custom_sb_msg) {
			$self->side_block(-code => $msg);
		}
	}
}

# Display GUI
sub display
{
	my $self = shift;
	my ($encoding, $help_icon, $close_icon, $user_menu);

	# Generate GUI code
	my $javascript_head = $self->_get_code("_javascript_head");
	my $javascript_body = $self->_get_code("_javascript_body");
	my $hidden_fields   = $self->_get_code("_html_hidden_fields");
	my $main_heading    = $self->_get_code("_html_main_heading");
	my $main_footer     = $self->_get_code("_html_main_footer");
	my $main_content    = $self->_get_code("_html_main");
	my $tabs            = $self->_get_tabs();
	my $side_bar        = $self->_get_side_bar();
	$encoding           = qq(enctype="multipart/form-data") if $self->{_encoding};
	$help_icon          = qq(<a href="$self->{_help_icon_link}"><img src="$main::NONCGI_URL/icons/title_bar_question.gif" alt="Help" hspace="1" vspace="1" border="0"></a>) if $self->{_help_icon};
	$close_icon         = qq(<a href="$main::HOME_PAGE_URL"><img src="$main::NONCGI_URL/icons/title_bar_close.gif" alt="Close" hspace="1" vspace="1" border="0"></a>) if $self->{_close_icon};
	$user_menu          = $self->_user_menu() if $self->{_user_menu};

	print "Content-type: text/html\n\n";
	print qq(<html>
		 <head>
		 <title>$self->{_title}</title>
		 <link href="$main::NONCGI_URL/styles/pm.css" rel="stylesheet" type="text/css">
		 <script language="JavaScript" type="text/JavaScript">
		 <!--
		 $javascript_head
		 //-->
		 </script>
		 </head>
		 <body bgcolor="#FFFFFF" text="#000000" link="#000000" vlink="#000000" alink="#000000" $javascript_body>
		 $main::GUI_HEADING
	 	 <form style="margin: 0px;" action="$self->{_action}" method="post" name="adform1" $encoding>
		 $hidden_fields
		 <table width="600" border="0" align="center" cellpadding="1" cellspacing="0" bgcolor="#AFB4D1" class="guitable">
		 <tr bgcolor="#AEADC4"> 
		 <td width="100%"><font color="#4B5383" size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><b>&nbsp;$self->{_title}</b></font></td>
		 <td nowrap><div align="right">$help_icon$close_icon</div></td>
		 </tr>
		 <tr> 
		 <td colspan="2"><table width="100%" border="0" cellpadding="2" cellspacing="0" bgcolor="#C2C5DC">
		 $user_menu
		 <tr> 
		 <td colspan="2" valign="top"><table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#FFFFFF" id="WHITE BG TABLE,  row1 = tabs, row2 = main,sep,side">
		 $tabs
		 <tr> 
		 <td><table width="100%" border="0" cellpadding="0" cellspacing="0" id="col1=main, col2=sep, col3=side">
		 <tr> 
		 <td width="100%" valign="top"><table width="100%" border="0" cellpadding="0" cellspacing="0" id="MAIN WINDOW">
		 $main_heading
		 <tr> 
		 <td><table width="100%" border="0" cellpadding="5" cellspacing="0" id="MAIN_CONTENT">
		 $main_content
		 </table></td>
		 </tr>
		 $main_footer
		 </table></td>
		 $side_bar
		 </tr>
		 </table></td>
		 </tr>
		 </table></td>
		 </tr>
		 <tr> 
		 <td colspan="2"><table width="100%" border="0" cellspacing="0" cellpadding="0">
		 <tr> 
		 <td nowrap><font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">$self->{_user_msg}</font></td>
		 <td nowrap><div align="right"><font color="#000000" size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">$self->{_powered_msg}</font></div></td>
		 </tr>
		 </table></td>
		 </tr>
		 </table></td>
		 </tr>
		 </table>
		 </form>
		 $main::GUI_FOOTER
		 </body>
		 </html>
		);
	exit;
}

1;