package lib::EMail;
$VERSION = 1.00;
use CGI::Carp qw(fatalsToBrowser);
use strict;

{
# Encapsulated class data

	# Default constructor values
	my %_attr_data =       # DEFAULT
	   ( _mail_to       => [ "" ],
	     _mail_from     => [ "" ],
	     _cc_list       => [ "" ],
	     _bcc_list      => [ "" ],
	     _subject       => [ "" ],
	     _text_message  => [ "" ],
	     _html_message  => [ "" ]
	   );

# Class methods, to operate on encapsulated class data

	# Classwide default value for all specified object attributes
	sub _default_for
	{
		my ($self, $attr) = @_;
		$_attr_data{$attr}[0];
	}

	# List of names of all specified object attributes
	sub _standard_keys
	{
		keys %_attr_data;
	}
}

# Constructor
sub new
{
	my ($class, %arg) = @_;

	my $self = bless {}, $class;

	foreach my $attrname ( $self->_standard_keys() )
	{
		my ($argname) = ($attrname =~ /^_(.*)/);
		if (exists $arg{$argname})
		   { $self->{$attrname} = $arg{$argname} }
		else
		   { $self->{$attrname} = $self->_default_for($attrname) }
	}

	# Load libraries
	use lib "$main::SCRIPT_PATH/lib/";
	use lib::MIME::Lite;

	my $message = MIME::Lite->new( To      => $self->{_mail_to},
	                               From    => $self->{_mail_from},
	                               cc      => $self->{_cc_list},
	                               Bcc     => $self->{_bcc_list},
	                               Subject => $self->{_subject},
	                               Type    => 'multipart/mixed',
		                      );

	# Attach text message
	if ($self->{_text_message} ne '') {
		my $text_message = $message->attach(Type => 'text/plain',
				         Data => [$self->{_text_message}]);
	}

	# Attach html message
	if ($self->{_html_message} ne '' ) {
		my $html_message = $message->attach(Type => 'text/html',
		                         Data => [$self->{_html_message}]);
	}

	# Send mail
	if ($main::MAIL_DELIVERY_METHOD eq 'smtp') {
		MIME::Lite->send('smtp', "$main::SMTP_SERVER");
	} else {
		MIME::Lite->send('sendmail', "$main::SENDMAIL_PATH -t -oi");
	}
	$message->send;

	return $self;
}

1;