#!/usr/bin/perl -w

# install.cgi

###############################################################
#                                                             #
# Any use of this program is entirely at the risk of the      #
# user. No liability will be accepted by the author.          #
#                                                             #
# This code must not be distributed or sold, even in modified #
# form, without the written permission of the author.         #
#                                                             #
###############################################################

use strict;

# Load variables and class libraries, trap all errors
eval {
	# Get script location (UNIX & Windows)
	($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");

	# Get script location (Windows)
	($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

	# Load global variables
	require "common.inc";
	require "settings.inc";

	# Load class libraries
	use CGI::Carp qw(fatalsToBrowser);
	use CGI qw(:standard);
	use lib::Date;
	use lib::FileDB;
	use lib::GUI;
	use lib::MsgBox;
	use strict;
};
if ($@) {
	print "Content-type: text/plain\n\n",
	      "Failed to load global variables and class libraries:\n$@\n",
	      "Please make sure that all program files were uploaded in ASCII mode,\n",
	      "permissions have been set correctly and all files are in correct location.\n",
	      "Refer to program manual for more detail.";
	exit;
}

# Execute script
eval { &main; };
if ($@)
{
	lib::MsgBox->new( text       => $@,
	                  msg_icon   => 0,
	                  close_icon => 0
                        );
}

######################## MAIN PROGRAM BLOCK ########################
sub main
{
	# Denial of service attack prevention
	$CGI::POST_MAX = 1024000;	# max form post size
	$CGI::DISABLE_UPLOADS = 1;	# no file uploads

	my $FORM = new CGI;

	# Redirect to selected screen
	if ($FORM->param('redirect')) {
		eval "&" . $FORM->param("redirect");
		if ($@)
		{
			lib::MsgBox->new( text       => $@,
			                  msg_icon   => 0,
			                  close_icon => 0,
		                        );
		}
	}

	# Start new GUI screen
	my $screen = lib::GUI->new( title      => "Poll Master Installation Wizard",
	                            action     => "install.cgi",
	                            help_icon  => 0,
	                            close_icon => 0,
	                            user_menu  => 0
	                          );

		# Main window
		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="setup_paths_and_urls">)
		                   );

		$screen->main_block(-code => qq{<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><b>Thank you for trying Poll Master software!</b><br><br>
                                                This installation wizard will guide you through the quick setup process.<br>
                                                Click the &quot;Install Now&quot; button below to begin Poll Master setup.</font>
                                               });

		$screen->main_block(-code => qq{<div align="right"> 
		                                <input name="install" type="submit" class="guibutton" value="Install Now">
		                                </div>});

	# Display GUI screen
	$screen->display();
}

########################### SUB ROUTINES ###########################

# Set up system paths and URLs
sub setup_paths_and_urls
{
	# Attempt to determine paths and URLs from environment
	my ($path_info, $url_info);
	if ($ENV{'SCRIPT_FILENAME'} =~ /install\.cgi/) {
		$path_info = $ENV{'SCRIPT_FILENAME'};
	}
	elsif ($ENV{'PATH_TRANSLATED'} =~ /install\.cgi/) {
		$path_info = $ENV{'PATH_TRANSLATED'};
	}
	if ($ENV{'SCRIPT_URI'} =~ /install\.cgi/) {
		$url_info = $ENV{'SCRIPT_URI'};
	}
	elsif ($ENV{'HTTP_REFERER'} =~ /install\.cgi/) {
		$url_info = $ENV{'HTTP_REFERER'};
	}
	elsif ($ENV{'SCRIPT_URL'} =~ /install\.cgi/) {
		$url_info = $ENV{'SCRIPT_URL'};
	}
	else
	{
		$url_info = "http://";
	}
	$path_info =~ s/\\/\//g;
	$path_info =~ s/\/install\.cgi//;
	$url_info  =~ s/\/install\.cgi//;

	# Start new GUI screen
	my $screen = lib::GUI->new( title      => "Poll Master Installation Wizard",
	                            action     => "install.cgi",
	                            help_icon  => 0,
	                            close_icon => 0,
	                            user_menu  => 0
	                          );

		# Main window
		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="test_system_paths_and_urls">)
		                   );

		$screen->main_block(-code => qq{<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE"><b>Configure system paths and URLs.</b><br><br>
                                                System paths refer to physical locations of directories on the server. They are complete locations, 
                                                not the locations from the web root, but from the server root. System paths on Windows servers are 
                                                displayed differently than on UNIX systems. Here are the sample system paths for two operating systems:<br><br>
                                                For UNIX servers: <font color="blue">/usr/home/yourdomain/www/cgi-bin</font><br> 
                                                For Win32/NT servers: <font color="blue">C:/home/yourdomain/cgi-bin</font><br><br> 
                                                Note: the paths listed above are examples, not your actual paths.<br>
                                                If you are installing the script on Windows server, be sure to use the format above for your system paths 
                                                (note the forward slashes, rather than backward slashes).<br>
                                                For URLs, please provide the full hyperlinks, such as <font color="blue">http://www.yourdomain.com/cgi-bin</font>, 
                                                rather than relative links such as <font color="blue">/cgi-bin</font>.<br> 
                                                Poll Master installation wizard will attempt to provide complete or partial system paths and URLs for you.
                                                These paths and URLs may not be accurate or complete, but they will give you a headstart. 
                                                All system paths and URLs must be entered in order for Poll Master to function properly.</font>
                                               });

		$screen->main_field( -label       => "System path to Poll Master cgi directory:",
		                     -description => qq(*do not include the trailing slash - <font color="blue">/</font>),
		                     -code        => qq(<input name="SCRIPT_PATH" type="text" class="guitextbox" size="40" maxlength="500" value="$path_info">)
		                   );

		$screen->main_field( -label       => "System path to data directory:",
		                     -description => qq(*do not include the trailing slash - <font color="blue">/</font>),
		                     -code        => qq(<input name="DATA_PATH" type="text" class="guitextbox" size="40" maxlength="500" value="$path_info/data">)
		                   );

		$screen->main_field( -label       => "System path to templates directory:",
		                     -description => qq(*do not include the trailing slash - <font color="blue">/</font>),
		                     -code        => qq(<input name="TMPL_PATH" type="text" class="guitextbox" size="40" maxlength="500" value="$path_info/templates">)
		                   );

		$screen->main_field( -label       => "URL for Poll Master cgi directory:",
		                     -description => qq(*do not include the trailing slash - <font color="blue">/</font>),
		                     -code        => qq(<input name="SCRIPT_URL" type="text" class="guitextbox" size="40" maxlength="500" value="$url_info">)
		                   );

		$screen->main_field( -label       => "URL for NonCGI directory:",
		                     -description => qq(*do not include the trailing slash - <font color="blue">/</font>),
		                     -code        => qq(<input name="NONCGI_URL" type="text" class="guitextbox" size="40" maxlength="500" value="http://">)
		                   );

		$screen->main_field( -label       => "Home page URL:",
		                     -description => qq(*do not include the trailing slash - <font color="blue">/</font>),
		                     -code        => qq(<input name="HOME_PAGE_URL" type="text" class="guitextbox" size="40" maxlength="500" value="http://">)
		                   );

		$screen->main_block(-code => qq{<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">Click the &quot;Submit&quot; button below to test 
		                                entered values.</font>
                                               });

		$screen->main_block(-code => qq{<div align="right"> 
		                                <input name="install" type="submit" class="guibutton" value="Submit">
		                                </div>});

	# Display GUI screen
	$screen->display();
}

# Test system paths and URLs
sub test_system_paths_and_urls
{
	my $FORM = new CGI;

	# Error checking
	my $error_string = "";

	my $tmp_SCRIPT_PATH = $FORM->param('SCRIPT_PATH');
	my $tmp_DATA_PATH = $FORM->param('DATA_PATH');
	my $tmp_TMPL_PATH = $FORM->param('TMPL_PATH');

	if (!-d $tmp_SCRIPT_PATH) {
			$error_string .= "<br>- System path to Poll Master cgi directory is incorrect. 
			                        $tmp_SCRIPT_PATH: No such file or directory.";
	}

	if (!-d $tmp_DATA_PATH) {
			$error_string .= "<br>- System path to data directory is incorrect. 
			                        $tmp_DATA_PATH: No such file or directory.";
	}

	if (!-d $tmp_TMPL_PATH) {
			$error_string .= "<br>- System path to templates directory is incorrect. 
			                        $tmp_TMPL_PATH: No such file or directory.";
	}

	if ($FORM->param('SCRIPT_URL')  !~ /^http:\/\/\S+$/) {
			$error_string .= "<br>- You did not enter a valid URL for Poll Master cgi directory. All URLs must start with http://";
	}

	if ($FORM->param('NONCGI_URL')  !~ /^http:\/\/\S+$/) {
			$error_string .= "<br>- You did not enter a valid URL for NonCGI directory. All URLs must start with http://";
	}

	if ($FORM->param('HOME_PAGE_URL')  !~ /^http:\/\/\S+$/) {
			$error_string .= "<br>- You did not enter a valid home page URL. All URLs must start with http://";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type       => "error",
		                  text       => "System paths and URLs test failed: $error_string",
		                  msg_icon   => 0,
		                  close_icon => 0,
		                 );
	}

	# Test NonCGI directory
	$main::NONCGI_URL = $FORM->param('NONCGI_URL');
	lib::MsgBox->new( type          => "question",
	                  action        => "install.cgi",
	                  hidden_fields => ['redirect', 'SCRIPT_PATH', 'DATA_PATH', 'TMPL_PATH', 'SCRIPT_URL', 'NONCGI_URL', 'HOME_PAGE_URL'],
	                  hidden_values => ['create_db_structures', $FORM->param('SCRIPT_PATH'), $FORM->param('DATA_PATH'), $FORM->param('TMPL_PATH'), $FORM->param('SCRIPT_URL'), $FORM->param('NONCGI_URL'), $FORM->param('HOME_PAGE_URL')],
		          text          => "System paths test passed!<br><br>
		                            Testing the URL of NonCGI directory:<br><br>
		                            - Can you see an image icon with a question mark (?) to 
		                            the left of this text?<br><br>
		                            Select &quot;Yes&quot; to proceed to 
		                            next step of setup process, or select &quot;No&quot; to re-enter 
		                            the NonCGI URL.<br><br>
		                            There are two reasons why the image may not show up: either NonCGI URL 
		                            was entered incorrectly or it is located inside the cgi-bin. 
		                            If latter is the case, try moving it outside the cgi-bin and change the NonCGI URL value 
		                            accordingly.",
		          button1       => "Yes",
	                  button2       => "No",
	                  close_icon    => 0,
		        );
}

# Create DB structures and complete setup
sub create_db_structures
{
	my $FORM = new CGI;

	# Assign new values to variables
	$main::SCRIPT_PATH = $FORM->param('SCRIPT_PATH');
	$main::DATA_PATH = $FORM->param('DATA_PATH');
	$main::TMPL_PATH = $FORM->param('TMPL_PATH');
	$main::SCRIPT_URL = $FORM->param('SCRIPT_URL');
	$main::NONCGI_URL = $FORM->param('NONCGI_URL');
	$main::HOME_PAGE_URL = $FORM->param('HOME_PAGE_URL');

	# Format variables
	&remove_tabs_hard_returns($main::SCRIPT_PATH, $main::DATA_PATH, $main::TMPL_PATH, $main::SCRIPT_URL, $main::NONCGI_URL, $main::HOME_PAGE_URL);
	&encode_text_fields($main::SCRIPT_PATH, $main::DATA_PATH, $main::TMPL_PATH, $main::SCRIPT_URL, $main::NONCGI_URL, $main::HOME_PAGE_URL);

	my $date = new lib::Date;
	my $current_date = $date->current_date();

	my $file_db = new lib::FileDB;

	# Save settings
	$file_db->open_file( -file_name => "$main::SCRIPT_PATH/settings.inc", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => [qq(
# System Paths
\$SCRIPT_PATH = qq~$main::SCRIPT_PATH~;
\$DATA_PATH = qq~$main::DATA_PATH~;
\$TMPL_PATH = qq~$main::TMPL_PATH~;

# URLs
\$SCRIPT_URL = qq~$main::SCRIPT_URL~;
\$NONCGI_URL = qq~$main::NONCGI_URL~;
\$HOME_PAGE_URL = qq~$main::HOME_PAGE_URL~;

# Security Options
\$DEFAULT_IP_CLEANING_TIME = '0';
\$USE_COOKIE_TRACKING = '1';

# Date and Time
\$GM_TIME_OFFSET = '0';
\$TIME_ZONE = qq~~;
\$DATE_FORMAT = 'us_extended';
\$TIME_FORMAT = 'ampm';

# Display Options
\$FONT_FACE = qq~Arial, Helvetica, sans-serif~;
\$PRIMARY_FONT_SIZE = qq~2~;
\$SECONDARY_FONT_SIZE = qq~1~;
\$POLLS_PER_PAGE = '10';
\$TEMPLATES_PER_PAGE = '10';
\$GUI_HEADING = qq~~;
\$GUI_FOOTER = qq~~;
\$POLLS_HEADING = qq~<font face="Arial, Helvetica, sans-serif" size="2">~;
\$POLLS_FOOTER = qq~</font>~;

1; # Do not remove this line)]
	                       );
	$file_db->commit_changes();
	$file_db->close_file();

	# Create AUTO_INCREMENT table
	$file_db->open_file( -file_name => "$main::DATA_PATH/AUTO_INCREMENT.cgi", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => [ 'FIELD_NAME',  'AUTO_VALUE' ]);
	$file_db->insert_record(-values => [ 'MEMB_ID',     '1'          ]);
	$file_db->insert_record(-values => [ 'POLL_ID',     '0'          ]);
	$file_db->insert_record(-values => [ 'TEMPLATE_ID', '2'          ]);
	$file_db->commit_changes();
	$file_db->close_file();

	# Create USERS table
	$file_db->open_file( -file_name => "$main::DATA_PATH/USERS.cgi", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => [ 'MEMB_ID', 'NAME',  'EMAIL',           'PASSWORD', 'MEMB_TYPE',     'MEMB_DATE',   'LOGIN_DATE'  ]);
	$file_db->insert_record(-values => [ '1',       'Admin', 'admin@email.xxx', 'pass',     'Administrator', $current_date, $current_date ]);
	$file_db->commit_changes();
	$file_db->close_file();

	# Create POLLS table
	$file_db->open_file( -file_name => "$main::DATA_PATH/POLLS.cgi", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => ['POLL_ID', 'MEMB_ID', 'POLL_QUESTION', 'TEMPLATE', 'START_DATE', 'END_DATE', 'IP_CLEANING_TIME', 'IP_CLEANING_DATE', 'ACTIVE']);
	$file_db->commit_changes();
	$file_db->close_file();

	# Create TEMPLATES table
	$file_db->open_file( -file_name => "$main::DATA_PATH/TEMPLATES.cgi", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => [ 'TEMPLATE_ID', 'MEMB_ID', 'TEMPLATE_NAME',                      'TEMPLATE_DATE' ]);
	$file_db->insert_record(-values => [ '1',           '1',       'Default template (horizontal bars)', $current_date   ]);
	$file_db->insert_record(-values => [ '2',           '1',       'Default template (vertical bars)',   $current_date   ]);
	$file_db->commit_changes();
	$file_db->close_file();

	# Default template code
	my $submission_code = qq(<table width="300" border="0" cellspacing="5" cellpadding="0">
                                 <tr> 
                                 <td>{POLL_QUESTION}</td>
                                 </tr>
                                 <tr> 
                                 <td>{POLL_OPTIONS}</td>
                                 </tr>
                                 <tr> 
                                 <td>{SUBMIT_BUTTON} {VIEW_BUTTON}</td>
                                 </tr>
                                 <tr> 
                                 <td><font size="1" face="Arial, Helvetica, sans-serif">Start date: </font>{START_DATE}</td>
                                 </tr>
                                 <tr> 
                                 <td><font size="1" face="Arial, Helvetica, sans-serif">End date: </font>{END_DATE}</td>
                                 </tr>
                                 </table>);

	my $display_code = qq(<table width="300" border="0" cellspacing="5" cellpadding="0">
                              <tr> 
                              <td>{POLL_QUESTION}</td>
                              </tr>
                              <tr> 
                              <td>{POLL_RESULTS}</td>
                              </tr>
                              <tr> 
                              <td><font size="1" face="Arial, Helvetica, sans-serif">Total votes: </font>{TOTAL_VOTES}</td>
                              </tr>
                              <tr> 
                              <td><font size="1" face="Arial, Helvetica, sans-serif">Start date: </font>{START_DATE}</td>
                              </tr>
                              <tr> 
                              <td><font size="1" face="Arial, Helvetica, sans-serif">End date: </font>{END_DATE}</td>
                              </tr>
                              </table>);

	# Create default horizontally aligned template
	$file_db->open_file( -file_name => "$main::TMPL_PATH/1.inc", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => [qq(# Poll Template (Warning! Do not edit manually.) #

\$template_font_face = qq~Arial, Helvetica, sans-serif~;
\$template_font_size = qq~1~;
\$poll_alignment = 'horizontal';
\$option_separator = qq~<br>~;
\$show_votes = '1';
\$show_percent = '1';
\$show_bars = '1';
\$bar_length = '150';
\$bar_width = '10';
\$options_horizontal_spacing = '5';
\$options_vertical_spacing = '5';
\$submission_code = qq~$submission_code~;
\$display_code = qq~$display_code~;

1;)]
	                       );
	$file_db->commit_changes();
	$file_db->close_file();

	# Create default vertically aligned template
	$file_db->open_file( -file_name => "$main::TMPL_PATH/2.inc", 
	                     -open_to   => "overwrite"
	                   );
	$file_db->insert_record(-values => [qq(# Poll Template (Warning! Do not edit manually.) #

\$template_font_face = qq~Arial, Helvetica, sans-serif~;
\$template_font_size = qq~1~;
\$poll_alignment = 'vertical';
\$option_separator = qq~<br>~;
\$show_votes = '1';
\$show_percent = '1';
\$show_bars = '1';
\$bar_length = '150';
\$bar_width = '20';
\$options_horizontal_spacing = '5';
\$options_vertical_spacing = '5';
\$submission_code = qq~$submission_code~;
\$display_code = qq~$display_code~;

1;)]
	                       );
	$file_db->commit_changes();
	$file_db->close_file();

	# Display success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Poll Master was set up successfully!<br>
	                                     Press the button below to proceed to login screen.
	                                     Use the following information to log in to Member Area:<br><br>
	                                     User name: <b>Admin</b><br><br>
	                                     Password: <b>pass</b><br><br>
	                                     Note: user name <u>is not</u> CaSe SeNsItIvE while password <u>is</u> CaSe SeNsItIvE.<br><br>
	                                     To prevent accidental data loss, please delete <b>install.cgi</b> file 
	                                     from Poll Master cgi directory.<br><br>
	                                     If something doesn't work properly, be sure to check your permissions 
	                                     and ensure that all program files were uploaded in ASCII mode.",
	                  button2_action => "LINK",
	                  close_link     => "$main::SCRIPT_URL/members.cgi",
	                 );
}