# current_polls.inc

use strict;

# Display currently running polls
sub current_polls
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Get current date
	my $date = new lib::Date;
	my $current_date = $date->current_date();

	# Retreive currently running polls
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/POLLS.cgi");
	$file_db->close_file();
	my %poll_info = $file_db->get_records( -condition => "end_date>$current_date",
	                                       -sort_by   => "start_date"
	                                     );

	my $return_to = $FORM->param('redirect');

	# Page breakdown
	my $total_records = 0;
	my $current_page = int($FORM->param('page'));
	$total_records = scalar(@{$poll_info{'poll_id'}}) if %poll_info;
	my ($start_pos, $end_pos, $prev_link, $next_link) = &page_breaker($current_page, $main::POLLS_PER_PAGE, $total_records, $return_to);

	# Current polls screen
	my $screen = lib::GUI->new(title    => "Member Area: Current Polls",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# JavaScript functions
		$screen->javascript(-code => &popup_window_javascript(640, 480));

		# Main window
		$screen->main_heading(-label => "Current Polls");

			if ($total_records > 0) {

				# Read USERS table
				$file_db->open_file(-file_name => "$main::DATA_PATH/USERS.cgi");
				$file_db->close_file();

				my %poll_user_info;

				for (my $i = $start_pos; $i <= $end_pos; $i++) {
					%poll_user_info = $file_db->get_record(-condition => "memb_id=$poll_info{'memb_id'}[$i]");
					if (%poll_user_info) {
						$poll_info{'user'}[$i] = $poll_user_info{'name'};
					} else {
						$poll_info{'user'}[$i] = "Unknown User";
					}
					if ($poll_info{'active'}[$i] eq "0") {
						$poll_info{'status'}[$i] = "Deactivated";
						$poll_info{'STATUS'}[$i] = "Deactivated";
					} elsif ($poll_info{'start_date'}[$i] > $current_date) {
						$poll_info{'status'}[$i] = "Not yet started";
						$poll_info{'STATUS'}[$i] = "Not yet started";
					} else {
						$poll_info{'status'}[$i] = "Active";
						$poll_info{'STATUS'}[$i] = "Active";
					}
					$poll_info{'start_date'}[$i] = $date->to_string(-date => $poll_info{'start_date'}[$i]);
					$poll_info{'end_date'}[$i]   = $date->to_string(-date => $poll_info{'end_date'}[$i]);
					$screen->main_block(-code => qq(<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$poll_info{'poll_question'}[$i]</font><br> 
					                                <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">User: $poll_info{'user'}[$i] - 
                                                                        Status: $poll_info{'status'}[$i] - 
                                                                        Start Date: $poll_info{'start_date'}[$i] - 
                                                                        End Date: $poll_info{'end_date'}[$i]<br> 
					                                [<a href="javascript:openWindow('$main::SCRIPT_URL/poll.cgi?poll_id=$poll_info{'poll_id'}[$i]&demo=1')">view</a>] 
					                                [<a href="$main::SCRIPT_URL/members.cgi?redirect=edit_poll&poll_id=$poll_info{'poll_id'}[$i]&return_to=$return_to">edit</a>] 
					                                [<a href="$main::SCRIPT_URL/members.cgi?redirect=confirm_poll_archive&poll_id=$poll_info{'poll_id'}[$i]">archive</a>] 
                                                                        [<a href="$main::SCRIPT_URL/members.cgi?redirect=confirm_poll_deletion&poll_id=$poll_info{'poll_id'}[$i]&return_to=$return_to">delete</a>]</font>)
					                   );
				}
			} else {
				$screen->main_block( -code => qq(<br><br><div align="center"><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">There are no currently running polls.</font></div><br><br>));
			}

		$screen->main_footer(-label => "$prev_link :: $next_link") if $main::POLLS_PER_PAGE > 0;

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Confirm poll deletion
sub confirm_poll_deletion
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Display a warning
	lib::MsgBox->new( type          => "question",
	                  hidden_fields => ['redirect', 'poll_id', 'return_to'],
	                  hidden_values => ['delete_poll', $FORM->param('poll_id'), $FORM->param('return_to')],
	                  text          => "Are you sure you want to delete this poll?",
	                  button1       => "Yes",
	                  button2       => "No"
	                );
}

# Delete a poll
sub delete_poll
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my ($poll_id, $return_to) = ($FORM->param('poll_id'), $FORM->param('return_to'));

	# Remove poll from POLLS table
	my $file_db = new lib::FileDB;
	$file_db->open_file( -file_name => "$main::DATA_PATH/POLLS.cgi", 
	                     -open_to   => "update" 
	                   );
	$file_db->delete_records(-condition => "poll_id=$poll_id");
	$file_db->commit_changes();
	$file_db->close_file();

	# Remove poll file
	$file_db->delete_file(-file_name => "$main::DATA_PATH/$poll_id.cgi");

	# Remove poll IP db
	$file_db->delete_file(-file_name => "$main::DATA_PATH/$poll_id.log");

	# Success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Selected poll has been deleted.",
	                  button2_action => "LINK",
		          close_link     => "$main::SCRIPT_URL/members.cgi?redirect=$return_to"
	                );
}

# Edit poll
sub edit_poll
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my ($poll_id, $return_to) = ($FORM->param('poll_id'), $FORM->param('return_to'));

	# Retrieve poll record
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/POLLS.cgi");
	$file_db->close_file();
	my %poll_info = $file_db->get_record(-condition => "poll_id=$poll_id");

	# Record not found
	if (!%poll_info) {
		lib::MsgBox->new( type => "error",
		                  text => "Could not locate poll (ID=$poll_id)."
		                );
	}

	# Get a list of available templates
	$file_db->open_file(-file_name => "$main::DATA_PATH/TEMPLATES.cgi");
	$file_db->close_file();
	my %template_info = $file_db->get_records();

	# Must have at least one template
	if (!%template_info) {
		lib::MsgBox->new( type => "error",
		                  text => "There are no poll templates available. You must have at least one template to use this function."
		                );
	}

	my $templates_list = qq(<select name="template" size="1" class="guitextbox">\n);
	for (my $i = 0; $i < scalar(@{$template_info{'template_id'}}); $i++) {
		if ($template_info{'template_id'}[$i] eq $poll_info{'template'}) {
			$templates_list .= qq(<option value="$template_info{'template_id'}[$i]" selected>$template_info{'template_name'}[$i]</option>);
		} else {
			$templates_list .= qq(<option value="$template_info{'template_id'}[$i]">$template_info{'template_name'}[$i]</option>);
		}
	}
	$templates_list .= qq(</select>);

	# Start date selection
	my $date = new lib::Date;
	my ($year, $month, $day) = ($date->get_year(  -date => $poll_info{'start_date'}),
	                            $date->get_month( -date => $poll_info{'start_date'}),
	                            $date->get_day(   -date => $poll_info{'start_date'})
	                           );

	my $cur_year_selection = $date->year_selection_box( -name     => "start_year",
	                                                    -start    => $year,
	                                                    -end      => $year + 5,
	                                                    -selected => $year
	                                                  );

	my $cur_month_selection = $date->month_selection_box( -name     => "start_month",
	                                                      -selected => $month
	                                                    );

	my $cur_day_selection = $date->day_selection_box( -name     => "start_day",
	                                                  -selected => $day
	                                                );

	# Future date selection
	my ($fut_year, $fut_month, $fut_day) = ($date->get_year(  -date => $poll_info{'end_date'}),
	                                        $date->get_month( -date => $poll_info{'end_date'}),
	                                        $date->get_day(   -date => $poll_info{'end_date'})
	                                       );

	my $fut_year_selection = $date->year_selection_box( -name     => "end_year",
	                                                    -start    => $fut_year,
	                                                    -end      => $year + 5,
	                                                    -selected => $fut_year
	                                                  );

	my $fut_month_selection = $date->month_selection_box( -name     => "end_month",
	                                                      -selected => $fut_month
	                                                    );

	my $fut_day_selection = $date->day_selection_box( -name     => "end_day",
	                                                  -selected => $fut_day
	                                                );

	# IP Log cleaning time generator
	my $ip_time_val;
	my $ip_time_list = qq(<select name="ip_cleaning_time_mult" size="1" class="guiformfield">
                              <option value="1">seconds</option>
                              <option value="60">minutes</option>
                              <option value="3600">hours</option>
                              <option value="86400">days</option>
                              </select>
                             );
	if ($poll_info{'ip_cleaning_time'} == 0) {
		$ip_time_val = 0;
		$ip_time_list =~ s/value=\"1\"/value=\"1\" selected/;
	} else {
		foreach my $multiplier(86400, 3600, 60, 1) {
			if (($poll_info{'ip_cleaning_time'} % $multiplier) == 0) {
				$ip_time_val  = int($poll_info{'ip_cleaning_time'} / $multiplier);
				$ip_time_list =~ s/value=\"$multiplier\"/value=\"$multiplier\" selected/;
				last;	# break out of the loop to prevent multiple select
			}
		}
	}

	# Start new GUI screen
	my $screen = lib::GUI->new( title    => "Member Area: Edit Poll",
	                            user_msg => $memb_info{'user_info'}
	                          );

		# Main window
		$screen->tab( -label  => "General Settings",
		              -active => 1
		            );

		$screen->tab( -label => "Options and Colors",
		              -link  => "$main::SCRIPT_URL/members.cgi?redirect=edit_poll_options&poll_id=$poll_id&return_to=$return_to"
		            );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_poll">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="poll_id" type="hidden" value="$poll_id">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="return_to" type="hidden" value="$return_to">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="ip_cleaning_date" type="hidden" value="$poll_info{'ip_cleaning_date'}">)
		                   );

		&filter_html($poll_info{'poll_question'});
		$screen->main_field( -label => "Poll question/description:",
		                     -code => qq(<textarea name="poll_question" cols="30" rows="5" wrap="VIRTUAL" class="guitextbox">$poll_info{'poll_question'}</textarea>)
		                   );

		$screen->main_field( -label => "Poll template:",
		                     -code  => $templates_list
		                   );

		$screen->main_field( -label => "Start date:",
		                     -description => "*must be a current or future date",
		                     -code => qq($cur_month_selection $cur_day_selection $cur_year_selection)
		                   );

		$screen->main_field( -label => "End date:",
		                     -description => "*must be a future date",
		                     -code => qq($fut_month_selection $fut_day_selection $fut_year_selection)
		                   );

		$screen->main_field( -label       => "Clean IP log every:",
		                     -description => "*enter 0 to disallow multiple votes",
		                     -code        => qq(<input name="ip_cleaning_time" type="text" value="$ip_time_val" class="guiformfield" size="16" maxlength="15">
		                                        $ip_time_list)
		                   );

		# Check selected value
		my $tmp_code = qq(<font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE"> 
		                                 <input type="radio" name="active" value="1">
                                                 Yes 
                                                 <input type="radio" name="active" value="0">
                                                 No</font>);
		$tmp_code =~ s/value=\"$poll_info{'active'}\"/value=\"$poll_info{'active'}\" checked/;
		$screen->main_field( -label => "Active:",
		                     -description => "*allows to temporarily disable the poll",
		                     -code => $tmp_code
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi?redirect=$return_to'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer(-label => 'All fields are required.');

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Save poll settings
sub save_poll
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my ($poll_id, $return_to) = ($FORM->param('poll_id'), $FORM->param('return_to'));

	# Get current date
	my $date = new lib::Date;
	my $current_date = $date->current_date();
	my ($cur_year, $cur_month, $cur_day, $cur_hour, $cur_min, $cur_sec) = ($date->get_year(  -date => $current_date),
	                                                                       $date->get_month( -date => $current_date),
	                                                                       $date->get_day(   -date => $current_date),
	                                                                       $date->get_hour(  -date => $current_date),
	                                                                       $date->get_minute(-date => $current_date),
	                                                                       $date->get_second(-date => $current_date)
	                                                                      );
	$current_date = $date->to_numeric( -year  => $cur_year,
	                                   -month => $cur_month,
	                                   -day   => $cur_day);

	# Error checking
	my $error_string = "";

	if ($FORM->param('poll_question')  !~ /\S+/) {
		$error_string .= "<br>- You did not enter poll question/description.";
	}

	# Check if the dates are valid
	my $days_in_start_month = $date->days_in_month( -month => $FORM->param('start_month'), 
	                                                -year  => $FORM->param('start_year')
	                                              );

	if ($FORM->param('start_day') > $days_in_start_month) {
		$error_string .= "<br>- Start date is invalid: there are only $days_in_start_month days in selected month.";
	}

	my $days_in_end_month = $date->days_in_month( -month => $FORM->param('end_month'), 
	                                              -year  => $FORM->param('end_year')
	                                            );

	if ($FORM->param('end_day') > $days_in_end_month) {
		$error_string .= "<br>- End date is invalid: there are only $days_in_end_month days in selected month.";
	}

	my $start_date = $date->to_numeric( -year  => $FORM->param('start_year'), 
	                                    -month => $FORM->param('start_month'), 
	                                    -day   => $FORM->param('start_day')
	                                  );

	my $end_date = $date->to_numeric( -year   => $FORM->param('end_year'), 
	                                  -month  => $FORM->param('end_month'), 
	                                  -day    => $FORM->param('end_day')
	                                 );

	# Check start date
	if ($FORM->param('start_year') !~ /^\d+$/ || $FORM->param('start_day') !~ /^\d+$/ || $FORM->param('start_month') !~ /^\d+$/ || 
	    $FORM->param('start_year') !~ /^\d+$/) {
	   	$error_string .= "<br>- Start date is invalid.";
	}

	# End date must be a future date
	if ($FORM->param('end_year') !~ /^\d+$/ || $FORM->param('end_day') !~ /^\d+$/ || $FORM->param('end_month') !~ /^\d+$/ || 
	    $FORM->param('end_year') !~ /^\d+$/) {
	   	$error_string .= "<br>- End date is invalid.";
	}

	# End date must be a later date than the start date
	if ($start_date >= $end_date) {
	   	$error_string .= "<br>- End date must be a later date than the start date.";
	}

	if ($FORM->param('ip_cleaning_time') !~ /^\d+$/) {
		$error_string .= "<br>- IP log cleaning time must either be a 0 or positive integer.";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                 );
	}

	# Format fields
	my ($poll_question, $template) = ($FORM->param('poll_question'), $FORM->param('template'));
	$poll_question =~ s/\n/ /g;
	$poll_question =~ s/\r//g;
	$poll_question =~ s/\t//g;
	&filter_html($poll_question);
	my $ip_cleaning_time = int($FORM->param('ip_cleaning_time') * $FORM->param('ip_cleaning_time_mult'));
	my $ip_cleaning_date = int($FORM->param('ip_cleaning_date'));
	my $active = $FORM->param('active');
	$active = '0' unless $active eq '1';

	# Save poll info
	my $file_db = new lib::FileDB;
	$file_db->open_file( -file_name => "$main::DATA_PATH/POLLS.cgi", 
	                     -open_to   => "update" 
	                   );
	$file_db->update_records( -condition => "poll_id=$poll_id", 
	                          -fields    => ['poll_question',               'template',                'start_date', 'end_date', 'ip_cleaning_time', 'ip_cleaning_date', 'active'               ],
	                          -values    => [$FORM->param('poll_question'), $FORM->param('template'),  $start_date,  $end_date,  $ip_cleaning_time,  $ip_cleaning_date,  $FORM->param('active') ]
	                        );
	$file_db->commit_changes();
	$file_db->close_file();

	# Success message
	lib::MsgBox->new( type           => "success",
	                  text           => "General poll settings have been saved.",
	                  button2_action => "LINK",
		          close_link     => "$main::SCRIPT_URL/members.cgi?redirect=edit_poll&poll_id=$poll_id&return_to=$return_to"
	                );
}

# Edit poll options
sub edit_poll_options
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my ($poll_id, $return_to) = ($FORM->param('poll_id'), $FORM->param('return_to'));

	# Read poll options
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/$poll_id.cgi");
	$file_db->close_file();
	my %poll_options_info = $file_db->get_records();
	my $number_of_options = 0;
	$number_of_options = scalar(@{$poll_options_info{'option_num'}}) if %poll_options_info;

	my $add_options = int($FORM->param('add_options'));
	$add_options = 0 if $add_options < 0;
	$number_of_options += $add_options;

	# Poll options and colors screen
	my $screen = lib::GUI->new(title    => "Member Area: Edit Poll",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# JavaScript functions
		my $js_code = "var tot_options = $number_of_options;\nvar colorArray = [";
		my @colors = &colors_list();
		for (my $i = 0; $i < $#colors; $i++) {
			$js_code .= "$i, ";
			$js_code .= "\n" if !(($i + 1) % 20);	# 20 numbers per line
		}
		$js_code .= scalar(@colors) - 1;
		$js_code .= "];\n\n";
		$js_code .= qq(function randomColors()
		               {
		               		var tmpArray  = new Array();
		               		tmpArray = tmpArray.concat(colorArray);
		               		var random_num;
		               		for (var i = 1; i <= tot_options; i++) {
		               			random_num = Math.floor(Math.random() * (tmpArray.length + 1));
		               			var tmpList = document.adform1.elements["option_" + i + "_color"];
		               			tmpList.options[tmpArray[random_num + 1]].selected = true;
		               			tmpArray.splice(random_num, 1);
		               			if (tmpArray.length == 0) {
		               				tmpArray = tmpArray.concat(colorArray);
		               			}
		               		}
		               }\n
		               );
		$js_code .= qq(function resetVotes()
		               {
		               		for (var i = 1; i <= tot_options; i++) {
		               			var tmpList = document.adform1.elements["option_" + i + "_votes"];
		               			tmpList.value = 0;
		               		}
		               }\n
		               );
		$js_code .= qq(function moreOptions()
		               {
		               		var addOptions = $add_options;
		               		var evenMore   = parseInt(document.adform1.more_poll_options.value, 10);
		               		if (evenMore > 0) {
		               			addOptions    += evenMore;
		               			var newURL = '$main::SCRIPT_URL/members.cgi?redirect=edit_poll_options&poll_id=$poll_id&add_options=' + 
		               			              addOptions +
		               			             '&return_to=current_polls';
		               			parent.location=newURL;
		               		}
		               }
		               );
		$screen->javascript(-code => $js_code);

		# Main window
		$screen->tab(-link   => "$main::SCRIPT_URL/members.cgi?redirect=edit_poll&poll_id=$poll_id&return_to=$return_to",
		             -label  => "General Settings");

		$screen->tab(-label  => "Options and Colors",
		             -active => 1);

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="redirect" type="hidden" value="save_poll_options">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="poll_id" type="hidden" value="$poll_id">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="return_to" type="hidden" value="$return_to">)
		                   );

		$screen->main_field( -type => "hidden",
		                     -code => qq(<input name="number_of_options" type="hidden" value="$number_of_options">)
		                   );

		$screen->main_field( -label => "Add more options:",
		                     -description => "*enter a number between 1 and 999",
		                     -code => qq(<input name="more_poll_options" type="text" class="guiformfield" size="10" maxlength="3">
		                                 <input name="add_poll_options" type="button" class="guibutton" value="Add" onClick="moreOptions()">)
		                   );

		$screen->main_field( -label => "Reset all votes to zero:",
		                     -code => qq(<input name="reset_votes" type="button" class="guibutton" value="Reset Votes" onClick="resetVotes()">)
		                   );

		$screen->main_field( -label => "Randomize color selection:",
		                     -code => qq(<input name="randomize" type="button" class="guibutton" value="Randomize!" onClick="randomColors()">)
		                   );

		my ($colors_list, $hex_color_field);
		for (my $j = 1; $j <= $number_of_options; $j++) {
			$colors_list = &colors_list("option_${j}_color");
			if ($poll_options_info{'option_color'}[$j-1] =~ /^#\S\S\S\S\S\S$/) {
				$hex_color_field = $poll_options_info{'option_color'}[$j-1];
			} else {
				$hex_color_field = "#";
				$colors_list =~ s/ selected//;
				$colors_list =~ s/value=\"$poll_options_info{'option_color'}[$j-1]\"/value=\"$poll_options_info{'option_color'}[$j-1]\" selected/;
			}
			$poll_options_info{'option_votes'}[$j-1] = int($poll_options_info{'option_votes'}[$j-1]);
			$screen->main_field( -label => "Answer option $j:",
			                     -code  => qq(<input name="option_$j" type="text" value="$poll_options_info{'option_text'}[$j-1]" class="guitextbox" size="40" maxlength="500">)
			                   );
			$screen->main_field( -label => "Answer option $j color:",
			                     -code  => qq($colors_list <input name="option_${j}_hex_color" type="text" value="#" class="guiformfield" size="10" maxlength="7">)
			                   );
			$screen->main_field( -label => "Answer option $j votes:",
		                     -code => qq(<input name="option_${j}_votes" type="text" value="$poll_options_info{'option_votes'}[$j-1]" class="guitextbox" size="40" maxlength="500">)
		                   );
		}

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="cancel" type="button" class="guibutton" value="Cancel" onClick="parent.location='$main::SCRIPT_URL/members.cgi?redirect=$return_to'">)
		                   );

		$screen->main_field( -type => "button",
		                     -code => qq(<input name="save" type="submit" class="guibutton" value="Save">)
		                   );

		$screen->main_footer(-label => '* Indicates a required field.');

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Save poll options
sub save_poll_options
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my ($poll_id, $return_to) = ($FORM->param('poll_id'), $FORM->param('return_to'));

	my (%option_values, $option_text);
	my $option_num = 0;

	# Error checking and formatting
	my $error_string;

	for (my $i = 1; $i <= $FORM->param('number_of_options'); $i++) {
		if ($FORM->param("option_$i") =~ /\S+/ && $FORM->param("option_${i}_color") !~ /\S+/ && $FORM->param("option_${i}_hex_color") !~ /^#\S\S\S\S\S\S$/) {
			$error_string .= "<br>- Please select or enter a valid color value for answer option $i. Leave it blank if you do not want to use it.";
		}
		elsif (int($FORM->param("option_${i}_votes")) < 0) {
			$error_string .= "<br>- The number of votes for answer option $i must either be 0 or a positive integer.";
		}
		elsif ($FORM->param("option_$i") =~ /\S+/) {
			$option_num++;
			$option_text = $FORM->param("option_$i");
			$option_text =~ s/\n/ /g;
			$option_text =~ s/\r//g;
			$option_text =~ s/\t//g;
			$option_values{'option_num'}[$option_num - 1] = $option_num;
			$option_values{'option_text'}[$option_num - 1] = $option_text;
			if ($FORM->param("option_${i}_color") =~ /\S+/) {
				$option_values{'option_color'}[$option_num - 1] = $FORM->param("option_${i}_color");
			} else {
				$option_values{'option_color'}[$option_num - 1] = $FORM->param("option_${i}_hex_color");
			}
			$option_values{'option_votes'}[$option_num - 1] = int($FORM->param("option_${i}_votes"));
		}
	}

	if ($option_num < 2) {
		$error_string .= "<br>- You must enter at least 2 answer options for this poll.";
	}

	# Display error message
	if ($error_string) {
		lib::MsgBox->new( type => "error",
		                  text => "Your submission was not accepted: $error_string"
		                 );
	}

	# Update poll options file
	my $file_db = new lib::FileDB;
	$file_db->open_file( -file_name => "$main::DATA_PATH/$poll_id.cgi", 
	                     -open_to   => "update" 
	                   );
	$file_db->delete_records();	# reset options
	for (my $j = 0; $j < $option_num; $j++) {
		$file_db->insert_record(-values => [$option_values{'option_num'}[$j], $option_values{'option_text'}[$j], $option_values{'option_color'}[$j], $option_values{'option_votes'}[$j]]);
	}
	$file_db->commit_changes();
	$file_db->close_file();

	# Success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Poll options have been saved.",
	                  button2_action => "LINK",
		          close_link     => "$main::SCRIPT_URL/members.cgi?redirect=edit_poll_options&poll_id=$poll_id&return_to=$return_to"
	                );
}

1;