# common.inc

use strict;

# Random password generator
# (thanks to Jacqueline D. Hamilton)
sub random_password
{
	my ($length) = @_;

	if ($length eq "" or $length < 3) {
		$length = 6;		# make it at least 6 chars long.
	}

	my $vowels = "aeiouyAEUY";
	my $consonants = "bdghjmnpqrstvwxzBDGHJLMNPQRSTVWXZ12345678";
	srand(time() ^ ($$ + ($$ << 15)) );
	my $alt = int(rand(2)) - 1;
	my $s = "";
	my $newchar = "";

	foreach my $i (0..$length-1) {
		if ($alt == 1) {
			$newchar = substr($vowels, rand(length($vowels)), 1);
		} else {
			$newchar = substr($consonants, rand(length($consonants)), 1);
		}
		$s .= $newchar;
		$alt = !$alt;
	}

	return $s;
}

# Given the current page, number of records per page, total records and redirect link,
# return the starting array position, ending array position and prev/next links
sub page_breaker
{
	my ($current_page, $recs_per_page, $total_records, $return_to) = @_;

	my ($start_pos, $end_pos, $total_pages, $prev_link, $next_link);

	if ($recs_per_page > 0) {
		$total_pages = int($total_records / $recs_per_page);
		$total_pages++ if ($total_records % $recs_per_page) > 0;
		$current_page = 1 if ($current_page < 1 || $current_page > $total_pages);
		$start_pos = ($recs_per_page * ($current_page - 1));
		$end_pos = (($recs_per_page * $current_page) - 1);
		$end_pos = $total_records - 1 if $end_pos > ($total_records - 1);
		if ($current_page > 1) {
			$prev_link = sprintf("<a href=\"$main::SCRIPT_URL/$return_to&page=%d\">&lt;&lt;Prev $recs_per_page</a>", $current_page - 1);
		} else {
			$prev_link = "&lt;&lt;Prev $recs_per_page";
		}
		if ($current_page < $total_pages) {
			$next_link = sprintf("<a href=\"$main::SCRIPT_URL/$return_to&page=%d\">Next $recs_per_page&gt;&gt;</a>", $current_page + 1);
		} else {
			$next_link = "Next $recs_per_page&gt;&gt;";
		}
	} else {
		$start_pos = 0;
		$end_pos = $total_records - 1;
	}

	return ($start_pos, $end_pos, $prev_link, $next_link);
}

# JavaScript code for popup window
sub popup_window_javascript
{
	my ($width, $height) = @_;

	return qq(function openWindow(windowURL)
		  {
		  var newWindow = window.open(windowURL,'name','width=$width,height=$height,menubar=0,resizable=1,scrollbars=1,status=0,titlebar=0,toolbar=0');
		  if (window.focus) {
		  newWindow.focus();
		  }
		  }
		  );
}

# Filter HTML code
sub filter_html
{
	foreach my $field(@_) {
		$field =~ s{&}{&amp;}gso;
		$field =~ s{<}{&lt;}gso;
		$field =~ s{>}{&gt;}gso;
		$field =~ s{"}{&quot;}gso;
	}
}

# Remove line feeds and tabs
sub remove_line_feeds_tabs
{
	foreach my $field(@_) {
		&remove_leading_trailing_space($field);
		$field =~ s/\t//g;	# remove tabs
		$field =~ s/\n\r\n/ <P>/ig;
		$field =~ s/\n/ <BR>/ig;
		$field =~ s/\r//g;
		$field =~ s/(<P>){2,}/<P>/ig;
		$field =~ s/(<BR><BR>){2,}/<BR>/ig;
		$field =~ s/<!/< !/ig;
		$field =~ s/(<UL.*?>)(<BR>)/$1/ig;
	}
	return (@_);
}

# Remove leading and trailing space
sub remove_leading_trailing_space
{
	foreach my $field(@_) {
		$field =~ s/^\s+//;	# remove leading white space
		$field =~ s/\s+$//;	# remove trailing white space
	}
}

# Encode special characters in text fields
sub encode_text_fields
{
	foreach my $field(@_) {
		$field =~ s/\\/\\\\/g;
		$field =~ s/\~/\\\~/g;
		$field =~ s/\@/\\\@/g;
		$field =~ s/\%/\\\%/g;
		$field =~ s/\$/\\\$/g;
	}
	return (@_);
}

# Remove tabs and hard returns
sub remove_tabs_hard_returns
{
	foreach my $field(@_) {
		$field =~ s/\t//g;
		$field =~ s/\r//g;
	}
	return (@_);
}

1;
