# archives.inc

use strict;

# Display currently running polls
sub archives
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Get current date
	my $date = new lib::Date;
	my $current_date = $date->current_date();

	# Retreive archived polls
	my $file_db = new lib::FileDB;
	$file_db->open_file(-file_name => "$main::DATA_PATH/POLLS.cgi");
	$file_db->close_file();
	my %poll_info = $file_db->get_records( -condition => "end_date<=$current_date",
	                                       -sort_by   => "end_date",
	                                     );

	my $return_to = $FORM->param('redirect');

	# Page breakdown
	my $total_records = 0;
	my $current_page = int($FORM->param('page'));
	$total_records = scalar(@{$poll_info{'poll_id'}}) if %poll_info;
	my ($start_pos, $end_pos, $prev_link, $next_link) = &page_breaker($current_page, $main::POLLS_PER_PAGE, $total_records, $return_to);

	# Current polls screen
	my $screen = lib::GUI->new(title    => "Member Area: Archives",
	                           user_msg => $memb_info{'user_info'}
	                          );

		# JavaScript functions
		$screen->javascript(-code => &popup_window_javascript(640, 480));

		# Main window
		$screen->main_heading(-label => "Archives");

			if ($total_records > 0) {

				# Read USERS table
				$file_db->open_file(-file_name => "$main::DATA_PATH/USERS.cgi");
				$file_db->close_file();

				my %poll_user_info;
				for (my $i = $start_pos; $i <= $end_pos; $i++) {
					%poll_user_info = $file_db->get_record(-condition => "memb_id=$poll_info{'memb_id'}[$i]");
					if (%poll_user_info) {
						$poll_info{'user'}[$i] = $poll_user_info{'name'};
					} else {
						$poll_info{'user'}[$i] = "Unknown User";
					}
					$poll_info{'start_date'}[$i] = $date->to_string(-date => $poll_info{'start_date'}[$i]);
					$poll_info{'end_date'}[$i]   = $date->to_string(-date => $poll_info{'end_date'}[$i]);
					if ($poll_info{'active'}[$i] eq "0") {
						$poll_info{'status'}[$i] = "Deactivated";
					} else {
						$poll_info{'status'}[$i] = "Active";
					}
					$screen->main_block(-code => qq(<font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">$poll_info{'poll_question'}[$i]</font><br> 
					                                <font size="$main::SECONDARY_FONT_SIZE" face="$main::FONT_FACE">User: $poll_info{'user'}[$i] - 
					                                Status: $poll_info{'status'}[$i] - 
                                                                        Start Date: $poll_info{'start_date'}[$i] - 
                                                                        End Date: $poll_info{'end_date'}[$i]<br> 
					                                [<a href="javascript:openWindow('$main::SCRIPT_URL/poll.cgi?poll_id=$poll_info{'poll_id'}[$i]&demo=1')">view</a>] 
					                                [<a href="$main::SCRIPT_URL/members.cgi?redirect=edit_poll&poll_id=$poll_info{'poll_id'}[$i]&return_to=$return_to">edit</a>] 
                                                                        [<a href="$main::SCRIPT_URL/members.cgi?redirect=confirm_poll_deletion&poll_id=$poll_info{'poll_id'}[$i]&return_to=$return_to">delete</a>]</font>)
					                   );
				}
			} else {
				$screen->main_block( -code => qq(<br><br><div align="center"><font size="$main::PRIMARY_FONT_SIZE" face="$main::FONT_FACE">There are no archived polls.</font></div><br><br>));
			}

		$screen->main_footer(-label => "$prev_link :: $next_link") if $main::POLLS_PER_PAGE > 0;

		$screen->side_bar_from_template(-template => $FORM->param('redirect'));

	# Display GUI screen
	$screen->display();
}

# Confirm move to archive
sub confirm_poll_archive
{
	my %memb_info = @_;

	my $FORM = new CGI;

	# Display a warning
	lib::MsgBox->new( type          => "warning",
	                  hidden_fields => ['redirect', 'poll_id'],
	                  hidden_values => ['archive_poll', $FORM->param('poll_id')],
	                  text          => "You are about to archive the currently running poll. 
	                                    The end date for this poll will be set to current date.",
	                  button1       => "Continue",
	                  button2       => "Cancel"
	                );
}

# Archive poll
sub archive_poll
{
	my %memb_info = @_;

	my $FORM = new CGI;

	my ($poll_id, $return_to) = ($FORM->param('poll_id'), $FORM->param('return_to'));

	my $date = new lib::Date;
	my $current_date = $date->current_date();

	# Update POLLS table
	my $file_db = new lib::FileDB;
	$file_db->open_file( -file_name => "$main::DATA_PATH/POLLS.cgi", 
	                     -open_to   => "update" 
	                   );
	$file_db->update_records( -condition => "poll_id=$poll_id", 
	                          -fields    => ['end_date'],
	                          -values    => [$current_date] 
	                        );
	$file_db->commit_changes();
	$file_db->close_file();

	# Success message
	lib::MsgBox->new( type           => "success",
	                  text           => "Selected poll was moved to archives.",
	                  button2_action => "LINK",
		          close_link     => "$main::SCRIPT_URL/members.cgi?redirect=current_polls"
	                );
}

1;