<?php

/**
 * Modules Security Layer
 *
 * @version $Id: modsecurity.php,v 1.8 2002/03/04 05:58:13 ryan Exp $
 * @package phpWebSite
 * @module modsecurity
 * @modulegroup core
 * @author Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 */

global $inc_prefix;

if(!$inc_prefix) {
 global $PHP_SELF;

 if(substr_count($PHP_SELF,"/mod/")) $inc_prefix="../../";
 else if(substr_count($PHP_SELF,"mod.php") || substr_count($PHP_SELF,"admin.php")) $inc_prefix="./";
 else $inc_prefix="../";
 }

/*
 * This function checks that current file had been included/required by
 * setup/upgrade.php or setup/install.php
 */
function check_internal_call()
{
global $PHP_SELF, $HTTP_REFERER, $HTTP_HOST, $inc_prefix, $admintest;

include($inc_prefix."config.php");

if(strlen($admintest) && ($admintest == $security_hash))
	return 2;

$tmp = strtolower($PHP_SELF);
list($base,$ext) = explode('.',$tmp);
$tmp = strrev($base);
list($last,$dir) = explode('/',$tmp);
$dir = strrev($dir);

if (($dir=="setup") ||
    (substr_count($HTTP_REFERER,$HTTP_HOST) && substr_count($HTTP_REFERER,"admin.php")))
	return 1;

return 0;
}

// ------------------

include_once($inc_prefix."htmlheader.php");

?>
