<?php

/**
 * Class definition for the weblink module
 *
 * Provides all functionality needed to add or modify a link
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @module weblink
 * @modulegroup core
 * @package phpWebSite
 */


class weblink {

	var $lid;
	var $title;
	var $url;
	var $description;
	var $date;
	var $name;
	var $email;
	var $category;
	var $hits;
	var $date;


	/**
	 * Constructor for the weblink class
	 *
	 * Sets all variables to thier appropriate default value.
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param none
	 * @return none
	 */

	function weblink() {
		$this->title = "New";
		$this->url = "http://";
		$this->description = $null_var;
		$this->name = $null_var;
		$this->email = $null_var;
	}
  
	function get_title() {return $this->title;}
	function get_url() {return $this->url;}
	function get_description() {return $this->description;}
	function get_name() {return $this->name;}
	function get_email() {return $this->email;}


	/**
	 * Builds form for users to submit weblink
	 *
	 * The function get_form builds most of the form see its comments
	 * for more details. This function is called again on an error.
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param string the category previously chosen
	 * @return none
	 */

	function submit_weblink() {
    
		$title = "TRANSLATE[[Submit a Link]]"; 
    
		$content = $this->get_form("submit_link");

		$content .= "
			Seu Nome: <input type=\"text\" name=\"name\" value=\"$this->name\" size=\"30\" maxlength=\"60\" /><br />
			TRANSLATE[[Your Email]]: <input type=\"text\" name=\"email\" value=\"$this->email\" size=\"30\" maxlength=\"60\" /><br /><br />
			<input type=\"submit\" value=\"Submeter\" />
		</form>";

		thememainbox($title, $content);
	}


	/**
	 * Provides form for admins to accept weblinks
	 *
	 * The function get_form builds most of the form see its comments
	 * for more details. This function is called again on an error.
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param int the link id of the link to be accepted
	 * @param string the category previously chosen
	 * @return none
	 */

	function accept_weblink() {
 
		$content .= $this->get_form("activate_link");

		$content .= "<br />
			Seu Nome: <input type=\"text\" name=\"name\" value=\"$this->name\" size=\"30\" maxlength=\"60\" /><br />
			TRANSLATE[[Your Email]]: <input type=\"text\" name=\"email\" value=\"$this->email\" size=\"30\" maxlength=\"60\" /><br />
			<input type=\"hidden\" name=\"lid\" value=\"$this->lid\" /><br />
			<span class=\"onebiggerred\">TRANSLATE[[Submission Decision]]</span><br />
			<input type=\"submit\" name=\"accept\" value=\"TRANSLATE[[Accept]]\" />
			<input type=\"submit\" name=\"decline\" value=\"TRANSLATE[[Decline]]\" />&nbsp;&nbsp;<a href=\"$this->url\" target=\"_blank\">Visitar</a>
		</form><hr />";

		return $content;
	}


	/**
	 * Provides form for admins to add a link
	 *
	 * The function get_form builds most of the form see its comments
	 * for more details. This function is called again on an error.
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param string the category previously chosen
	 * @return none
	 */

	function add_link() {
    
		$title = "Adicionar Link";
    
		$content = $this->get_form("link_db_update");

		$content .= "
			<input type=\"submit\" name=\"insert\" value=\"Adicionar URL:\" />
		</form>";
    
		thememainbox($title, $content);
	}
  

	/**
	 * Provides form for admins to modify a current link
	 *
	 * The function get_form builds most of the form see its comments
	 * for more details. This function is called again on an error.
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param string the category so it can be auto selected
	 * @param int the link id of the link to be modified
	 * @return none
	 */

	function modify_link() {
		global $table_prefix;

		$title = "TRANSLATE[[Modify Link]]";
    
		$content = $this->get_form("link_db_update");

		$content .= "
			<input type=\"hidden\" name=\"name\" value=\"$this->name\" />
			<input type=\"hidden\" name=\"email\" value=\"$this->email\" />
			<span class=\"onebiggerred\">TRANSLATE[[Submission Decision]]</span><br />
			<input type=\"hidden\" name=\"lid\" value=\"$this->lid\" />
			<input type=\"submit\" name=\"update\" value=\"TRANSLATE[[Update URL]]:\" />
			<input type=\"submit\" name=\"delete\" value=\"TRANSLATE[[Delete URL]]:\" />&nbsp;&nbsp;
			<b><a href=\"$this->url\" target=\"_blank\">Visitar</a></b>
		</form>";

		thememainbox($title, $content);

		$title = "TRANSLATE[[Associate Web Links With Userpages]].";

		$content = "
		TRANSLATE[[Pick the userpages you want to be associated with this link and add them to the list]].
		<form method=\"post\" action=\"mod.php\">
		<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
		<input type=\"hidden\" name=\"op\" value=\"related\" />
		<input type=\"hidden\" name=\"lid\" value=\"$this->lid\" />
		<input type=\"hidden\" name=\"category\" value=\"$this->category\" />

		<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
		<tr>
		<td align=\"center\"><b>TRANSLATE[[Userpages]]</b></td><td>&nbsp;</td><td align=\"center\"><b>TRANSLATE[[Associated Userpages]]</b></td>
		</tr>

		<tr>
		<td align=\"center\"><select name=\"pages[]\" size=\"5\" multiple=\"multiple\">\n";

		$result = mysql_query("SELECT id, title FROM " . $table_prefix . "mod_userpage_data");
		if(!mysql_num_rows($result))	$content .= "<option value=\"\">TRANSLATE[[No userpages in database...]]</option>";
		while(list($id, $pagetitle) = mysql_fetch_row($result)) $content .= "<option value=\"$id\">$pagetitle</option>";

		$content .= "
		</select></td>

		<td align=\"center\"><input type=\"submit\" name=\"remove\" value=\"<-Remover\" /><br /><br />
		<input type=\"submit\" name=\"add\" value=\"Adicionar->\" /></td>
		
		<td align=\"center\"><select name=\"related_pages[]\" size=\"5\" multiple=\"multiple\">";

		$result = mysql_query("SELECT related FROM " . $table_prefix . "mod_weblink_data WHERE lid='$this->lid'");
		list($related) = mysql_fetch_row($result);
		$related = unserialize($related);

		if(!is_array($related))	$related = array();

		$sql_query = "SELECT id, title FROM " . $table_prefix . "mod_userpage_data WHERE id='0'";
		while(list($key, $value) = each($related))	$sql_query .= " OR id='$value'";

		$result = mysql_query($sql_query);
		if(!mysql_num_rows($result))	$content .= "<option value=\"\">TRANSLATE[[No userpages selected...]]</option>";
		while(list($id, $pagetitle) = mysql_fetch_row($result)) $content .= "<option value=\"$id\">$pagetitle</option>";

		$content .= "
		</select></td></tr></table>
		</form><br /><br />";
    
		thememainbox($title, $content);

		echo "
		<form method=\"post\" action=\"mod.php\">
			<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
			<input type=\"hidden\" name=\"op\" value=\"admin_buttons\" />
			<input type=\"submit\" name=\"current\" value=\"Voltar\" />
		</form>";
	}


	/**
	 * Builds the main part of the form for all previous form functions
	 *
	 * Puts together the form with all the information that is consistent among 
	 * all the forms.
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param string the op to be performed
	 * @param string the category previously chosen so it can be auto selected
	 * @return string the content that is built
	 */

	function get_form($type) {
		global $table_prefix;

		$content = "
		<form method=\"post\" action=\"mod.php\">
		<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
		<input type=\"hidden\" name=\"op\" value=\"$type\" />
		TRANSLATE[[Page Title]]:<input type=\"text\" name=\"title\" value=\"$this->title\" size=\"50\" maxlength=\"100\" /><br />
		TRANSLATE[[Page URL]]:<input type=\"text\" name=\"url\" value=\"$this->url\" size=\"50\" maxlength=\"100\" /><br />
		TRANSLATE[[Category]]:
		<select name=\"category\">\n";

		$cid_result = mysql_query("SELECT cid, cat FROM " . $table_prefix . "mod_weblink_cat WHERE cid=pid ORDER BY cat ASC");
		while(list($cid, $cat) = mysql_fetch_row($cid_result)) {
			$content .= "<option value=\"$cat\"";
			if($this->category == $cat) $content .= "selected=\"selected\"";
			$content .= ">$cat</option>\n";
			$main_cat = $cat;

			$result = mysql_query("SELECT cid, pid, cat FROM " . $table_prefix . "mod_weblink_cat WHERE pid='$cid' AND pid!=cid ORDER BY cat ASC");
			while(list($this_cid, $pid, $cat) = mysql_fetch_row($result)) {
				$content .= "<option value=\"$cat\"";
				if($this->category == $cat) $content .= "selected=\"selected\"";
				$content .= ">$main_cat / $cat</option>\n";
			}
		}

		$content .= "
			</select><br />
			Descrio: <br />
			<textarea name=\"description\" cols=\"60\" rows=\"10\" wrap=\"virtual\">$this->description</textarea><br /><br />";

		return $content;
	}
  

	/**
	 * Sets the class variables
	 *
	 * Does error checking and strips all html and php tags
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param string the title given to the link
	 * @param string the url of the link
	 * @param string the description for the link
	 * @param string the name of the person the link was submitted by
	 * @param string their email
	 * @return int 1 is returned when all data meets the criteria otherwise a 0 is returned for error
	 */

	function set_link_data($title, $url, $description, $name, $email, $category) {

		$this->title = check_words($title);
		$this->url = check_words($url);
		$this->description = check_words($description);

		$this->title = stripslashes(strip_tags($this->title));
		$this->url = stripslashes(strip_tags($this->url));
		$this->description = stripslashes(strip_tags($this->description));
		$this->name = stripslashes(strip_tags($name));
		$this->email = stripslashes(strip_tags($email));
		$this->category = $category;

		if(!$title) {
			$this->show_error("title");
			return 0;
		} else if(!$url || $url=="http://" || $url=="https://") {
			$this->show_error("url");
			return 0;
		} else if (($url) && ($url!="http://") && ($url!="https://") && ((!ereg("[http://]",$url)) && ((!ereg("[https://]",$url)) || (!ereg("[.]",$url)) || (strlen($url) < 12) || (ereg("[^a-zA-Z0-9~.:/]",$url))))) {
			$this->show_error("url");
			return 0;
		} else if($this->check_broken_url($url)>0) {
			$this->show_error("url");
			return 0;
		} else if(!$description) {
			$this->show_error("description");
			return 0;
		} else if(!$name) {
			$this->show_error("name");
			return 0; 
		} else if(!$email) {
			$this->show_error("email");
			return 0;
		} else return 1;
	}


	/**
	 * Prints appropriate error messages for set_link_data
	 *
	 * @author Steven Levin <steven@tux.appstate.edu>
	 * @param string the type of error that occurred
	 * @return none
	 */

	function show_error($type) {
		$title = "<font color=\"red\"><b>TRANSLATE[[ERROR]]!!</b></font>";
    
		switch($type) {
		case "title":
			$content = "TRANSLATE[[The Page Title for the weblink is missing or invalid]].";
			break;
		case "url":
			$content = "TRANSLATE[[The Page URL for the weblink is missing or invalid]].";
			break;
    		case "description": 
			$content = "TRANSLATE[[The Description for the weblink is missing or invalid]].";
			break;
		case "name":
			$content = "TRANSLATE[[Your Name was not entered for the weblink]].";
			break;
		case "email":
			$content = "TRANSLATE[[Your Email was not entered for the weblink]].";
			break;
		case "category":
			$content = "TRANSLATE[[The Category for the weblink is missing or invalid]].";
			break;
		}
    
		thememainbox($title, $content);
	}


	/*
	 * Return 0 if URL is NOT broken, 1 if broken, and -1 if it cannot be checked
	 * --
	 * Actually https hosts are skipped 'cos PHP fopen() always fails on them
	 */

	function check_broken_url($url) {
		// Skip HTTPS hosts   
		if(substr($url,0,8)=='https://')
			return -1;
                
		// Check if URL is not broken
		$checkurl = ($url[strlen($url)-1]=='/') ? $url : "$url/";
		$check = @fopen($checkurl, "r");
		if($check)
		{
			@socket_set_timeout($check, 10);
			fclose($check);
			return 0;
		}
		else
			return 1;
	}

	function set_all_data($lid, $title, $url, $description, $name, $email, $date, $category, $hits, $new){

		$this->lid = $lid;
		$this->title = check_words($title);
		$this->url = check_words($url);
		$this->description = check_words($description);

		$this->title = stripslashes(strip_tags($this->title));
		$this->url = stripslashes(strip_tags($this->url));
		$this->description = stripslashes(strip_tags($this->description));
		$this->name = stripslashes(strip_tags($name));
		$this->email = stripslashes(strip_tags($email));

		$this->date = $date;
		$this->category = $category;
		$this->hits = $hits;
		$this->new = $new;
	}
}

?>
