<?php

/*
 * This userpage class has all the functions necessary to
 * create and edit a userpage instance.
 *
 * @module userpage
 * @package phpWebSite
 * @author Adam Morton, adam@tux.appstate.edu
*/
include("./mod/userpage/userpage_functions.php");

/* This class contains all the variables and functions needed to
   create and edit a userpage. */
class userpage
{
	var $new_page;
	var $editing_page;
	var $text_mode;
	var $page_active;
	var $sub_active;
	var $text_active;
	var $image_active;
	var $main_title;
	var $subtitle;
	var $text;
	var $imagename;
	var $alt;
	var $layout;
	var $sections;
	var $viewblocks;

/* Creates a new userpage and makes it active. */
function userpage ()
{
	include("./mod/userpage/userpage_config.php");

	$this->new_page = 1;
	$this->editing_page = 0;
	$this->text_mode = 0;
	$this->page_active = 1;
	$this->viewblocks = 0;
	$this->layout = $default_layout;
	$this->sections = $default_num_sections;
	$this->main_title = "TRANSLATE[[New Web Page]]";
}

/* Sets the active flags for sub-titles, text, and images */
function set_active ($sub, $text, $image)
{
	for($i=0; $i<$this->sections; $i++) $this->sub_active[$i] = $sub[$i];
	for($i=0; $i<$this->sections; $i++) $this->text_active[$i] = $text[$i];
	for($i=0; $i<$this->sections; $i++) $this->image_active[$i] = $image[$i];
}

/* Sets viewblocks */
function set_viewblocks ($switch)
{
	$this->viewblocks = $switch;
}

function check_viewblocks()
{
	return $this->viewblocks;
}

/* Sets the title of this userpage */
function set_title ($newtitle)
{
	global $error_type;

	if(!$newtitle) $error_type = "main_title";
	$this->main_title = check_html($newtitle,"nohtml");
}

/* Sets all subtitles for this userpage */
function set_subtitle ($newsubtitle)
{
	for($i=0; $i<$this->sections; $i++)
	$this->subtitle[$i] = check_html($newsubtitle[$i],"nohtml");;
}

/* Sets all the text for this userpage */
function set_text ($newtext)
{
	global $error_type;

	if(!$newtext[0]) $error_type = "text";

	for($i=0; $i<$this->sections; $i++)
	$this->text[$i] = check_html($newtext[$i]);
}

/* Sets all image attributes for this userpage */
function set_image ($newimage, $newimage_name, $newimage_type, $newimage_size, $alttag, $index, $old_image, $existing_image)
{
	global $error_type, $error_section;

	include("./mod/userpage/userpage_config.php");
	include("config.php");

	$temp_type = explode(";", $newimage_type);
        $this->alt[$index] = check_html($alttag,"nohtml");

	if($old_image && !$alttag)
	{
		$error_type = "alt_tag";
		$error_section = $index + 1;
		return;
	}

	if($newimage != "none" && $newimage != "")
	{
		$img_input = 1;

                $res = mysql_query("select allowed_imgs,max_image_size,files_umask from ".$table_prefix."flags");
                list($allowed_types,$max_image_size,$files_umask) = mysql_fetch_row($res);

		if($newimage_size > $max_image_size)
		{
			$error_type = "image_size";
			$error_section = $index + 1;
		}
		else if(!substr_count($allowed_types,$newimage_type))
		{
			$error_type = "image_type";
			$error_section = $index + 1;
		}
		else if(!$alttag)
		{
			$error_type = "alt_tag";
			$error_section = $index + 1;
		}

		if($error_type != 'image_size' && $error_type != 'image_type')
		{
        	if(!(file_exists($image_directory.$newimage_name) && filesize($image_directory.$newimage_name)==$newimage_size))
            {
            	@umask((int)$files_umask);
            	if(!@move_uploaded_file($newimage, $image_directory.$newimage_name))
                {
                    $error_type = "permission";
					$error_section = $index + 1;
				}
                else
				{
					$this->imagename[$index] = $newimage_name;
					system("chmod 644 " . $image_directory . $newimage_name);
				}
            }
            else
			{
				$this->imagename[$index] = $newimage_name;
				system("chmod 644 " . $image_directory . $newimage_name);
			}
		}
	}

        // use a pre-existent image
        if(!$img_input && ($existing_image && $existing_image != "none"))
        {
                $img_input=2;
                $this->imagename[$index] = $existing_image;

        	// check for alt errors
        	if(!$alttag)
		{
		$error_type = "alt_tag";
		$error_section = $index + 1;
		}
	}
}

/* Sets the layout number for this userpage */
function set_layout ($newlayout)
{
	$this->layout = $newlayout;
}

/* Sets the text mode for this userpage. 0 for plain text
   and 1 for HTML formatted. */
function set_textmode ($text_mode)
{
	$this->text_mode = $text_mode;
}

/* Prints a preview warning box and asks the user for input. */
function previewing ()
{
	$title = "<b>TRANSLATE[[Preview Web Page]]</b>";

	$content = "<div align=\"center\"><b>TRANSLATE[[Below is a preview of your page]].<br />
	TRANSLATE[[Press the back button to edit it some more]].<br />
	TRANSLATE[[Press the next button to save it in the database]].</b>
	<form action=\"mod.php\" method=\"post\">
	<table border=\"0\" width=\"50%\">
	<tr><td align=\"center\">
	<input type=\"hidden\" name=\"mod\" value=\"userpage\" />
	<input type=\"hidden\" name=\"op\" value=\"finish\" />
	<input type=\"submit\" name=\"back\" value=\"Voltar\" />
	</td><td align=\"center\">
	<input type=\"submit\" name=\"finish\" value=\"TRANSLATE[[Next]]\" />
	</td></tr></table>
	</form></div>\n";

	thememainbox($title, $content);

}

/* Simply prints out a button so an admin can directly edit
   this userpage. */
function admin_edit ()
{
	global $current_id;

	echo "<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"userpage\" />
	<input type=\"hidden\" name=\"op\" value=\"edit_userpage\" />
	<input type=\"hidden\" name=\"page_id\" value=\"$current_id\" />
	<input type=\"submit\" value=\"Editar Pgina\" />
	</form>\n";

	//Add a "delete" button next to the "edit" button.
	echo "<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"userpage\" />
	<input type=\"hidden\" name=\"op\" value=\"confirm_delete\" />
	<input type=\"hidden\" name=\"page_id\" value=\"$current_id\" />
	<input type=\"submit\" value=\"TRANSLATE[[Delete Page]]\" />
	</form>\n
	";
}

/* Calls the appropriate template function depending on this
   userpage's current layout */
function view_page ()
{
	global $current_data;
	$current_data = $this;

	if($this->is_active())
	{
		$temp = 'template' . $this->layout;
		$temp($this);
	}
}

/* Shows the data contained in this userpage and allows the user to edit it */
function edit_page ()
{
	global $current_data;
	$current_data = $this;

	include("config.php");
	include("./mod/userpage/userpage_config.php");

	back_to_admin();

	if($this->new_page) $title = "<b>TRANSLATE[[New Web Page]]</b>";
	else $title = "<b>TRANSLATE[[Edit Web Page]]</b>";

	$page_title = stripslashes($this->main_title);

	$content = "<table align=\"center\" cellspacing=\"10\"><tr>
	<td class=\"type5\" colspan=\"2\">
	<form action=\"mod.php\" method=\"post\" enctype=\"multipart/form-data\">\n";

	$content .= "<b>TRANSLATE[[Mode]] : </b>\n";
        $content .= form_options(0,"option","text_mode",array("0","TRANSLATE[[Plain Text]]","1","TRANSLATE[[HTML]]"), $this->text_mode);

	$content .="<br />\n
	<b>TRANSLATE[[Number of sections]] :</b>
	<input type=\"text\" name=\"num_sections\" value=\"$this->sections\" size=\"2\" maxlenght=\"2\" />
	<input type=\"hidden\" name=\"old_num_sections\" value=\"$this->sections\" />
	<br />
	
	<b>TRANSLATE[[Display right column when viewing the page?]] :</b>";
	
        $content .= form_options(0,"option","viewblocks",array("0","No","1","Sim"), $this->viewblocks);

	$content .= "
	<input type=\"hidden\" name=\"old_viewblocks\" value=\"$this->viewblocks\" />
	<br />
	<input type=\"submit\" value=\"Mudar\" />
	<br />
	<br />

	<b>Ttulo:</b><br />
        <input type=\"text\" name=\"title\" value=\"$page_title\" maxlength=\"200\" size=\"40\" />
	<br /><hr /><br />";

	// exiting images -- array prepared for form_options()
        $imagesarray = list_existing_images($image_directory);

	for($i=0; $i < $this->sections; $i++)
	{
		$j = $i+1;

		$sub = stripslashes($this->subtitle[$i]);
		
		if(!$this->text_mode)
			$this->text[$i] = str_replace("<br />", "\n", $this->text[$i]);

		$text = stripslashes(htmlspecialchars($this->text[$i]));
		$alttag = stripslashes($this->alt[$i]);
		$img = $this->imagename[$i];

		if($this->sub_active[$i]) $sub_select = "checked=\"checked\"";
		else $sub_select = "";

		if($this->text_active[$i]) $text_select = "checked=\"checked\"";
		else $text_select = "";

		if($this->image_active[$i]) $image_select = "checked=\"checked\"";
		else $image_select = "";

		$content .= "
	<input type=\"checkbox\" name=\"sub_active[$i]\" value=\"$j\" $sub_select />
	<b>Subttulo $j:</b><br />
	<input type=\"text\" name=\"subtitle[$i]\" value=\"$sub\" maxlength=\"200\" size=\"40\" />
	<br />
	<input type=\"checkbox\" name=\"text_active[$i]\" value=\"$j\" $text_select />
	<b>Texto $j:</b><br />
	<textarea name=\"text[$i]\" cols=\"80\" rows=\"15\" wrap=\"virtual\">$text</textarea>
	<br />
	";

        $content .= display_importexport_controls("imported[$i]","imported_mode[$i]","imported_stricttypes[$i]", "next_import", "./mod.php?mod=userpage", 0, "section_id=$i");

	$content .= "
	<input type=\"checkbox\" name=\"image_active[$i]\" value=\"$j\" $image_select />
	<b>Imagem $j:</b><br />
		";

	if($img)
	{
		$content .= "<input type=\"hidden\" name=\"old_image[$i]\" value=\"1\" />
		<input type=\"hidden\" name=\"img_id\" value=\"$i\" />
		<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" /><br />
		<input type=\"submit\" name=\"remove_image\" value=\"Remove Imagem\" /><br /><br />\n";
	}
	else
		$content .= "<input type=\"hidden\" name=\"old_image[$i]\" value=\"0\" />\n";

	$content .= "<b>TRANSLATE[[Upload a new image]] $j: </b><input type=\"file\" name=\"image[$i]\" maxlength=\"80\" size=\"40\" /><br />\n";

	if (count($imagesarray)){
	  $content .= "<b> ou TRANSLATE[[Use existing image]] $j: </b>";
	  $content .= "
<select name=\"existing_image[$i]\">
<option value=\"none\">TRANSLATE[[None]]</option>";
	  foreach ($imagesarray as $theimage){
	    if ($theimage == $img)
	      $content .= "<option selected=\"selected\">$theimage</option>";
	    else
	      $content .= "<option>$theimage</option>";
	  }
	  $content .= "
</select><br />";
	}
	
	$content .= "<b>TRANSLATE[[Short Image Description]] $j: </b><input type=\"text\" name=\"alt[$i]\" value=\"$alttag\" maxlength=\"80\" size=\"40\" />
	<br /><br />\n<hr />\n<br />\n";
	}

	$content .= "<div align=\"center\">
	<a href=\"./mod.php?mod=userpage&amp;op=show_layouts\" target=\"_blank\">Layout</a>
	<br /><table border=\"0\" width=\"30%\">\n<tr>\n";

	for($i=0; $i < $num_layouts; $i++)
	{
		$j = $i+1;

		if($this->layout == $j) $sel = "checked=\"checked\"";
		else $sel = "";

		$content .= "<td align=\"center\">
		<input type=\"radio\" name=\"layout\" value=\"$j\" $sel />
		<br />$j
		</td>\n";
	}

	$content .= "</tr></table></td></tr><tr>
	<td align=\"center\">
	<input type=\"hidden\" name=\"mod\" value=\"userpage\" />
	<input type=\"hidden\" name=\"op\" value=\"save_data\" />\n";

        $result = mysql_query("select * from " . $table_prefix."mod_userpage_data");
        if($result && mysql_num_rows($result))
         $content .= "<input type=\"submit\" name=\"back\" value=\"Voltar\" />\n</td>\n<td align=\"center\">\n";

	$content .= "<input type=\"submit\" name=\"next\" value=\"TRANSLATE[[Next]]\" /></div></td>
	</tr>
	</form>
	</td>
</tr>
</table>
	";

	thememainbox($title, $content);
}

/* Allows the user to select a layout for this userpage */
function show_layouts ()
{
	include("./mod/userpage/userpage_config.php");

	echo "<b>TRANSLATE[[Current Layouts]]</b>";
	echo "<table border=\"0\" width=\"100%\">
	<tr><td align=\"center\" colspan=\"2\">\n";

	for($i=1; $i <= $num_layouts; $i++)
	{
		$temp = 'layout_message' . $i;
		$description = $$temp;

		echo "<tr><td><img src=\"./mod/userpage/images/layouts/layout$i.gif\" alt=\"Layout $i\" />
		<br /></td><td><b>Layout $i</b><br /><p>$description</p></td></tr>\n";
	}

	echo "</table>\n";
}

function remove_image ($img_id)
{
	$this->image_active[$img_id] = 0;
	$this->imagename[$img_id] = "";
	$this->alt[$img_id] = "";
}

/* Saves the current data of this userpage in the database */
function save_page ()
{
	global $current_data, $current_id;
	include('config.php');								// table prefix
	$this->new_page = 0;
	$page_title = $this->main_title;
	$data = addslashes(serialize($this));

	mysql_query("LOCK TABLES " . $table_prefix."mod_userpage_data WRITE");
	$result = mysql_query("INSERT INTO " . $table_prefix."mod_userpage_data (id,title,data) VALUES ('', '$page_title', '$data')");

	if($result)
	{
		$result = mysql_query("SELECT max(id) FROM " . $table_prefix."mod_userpage_data");
		list($current_id) = mysql_fetch_row($result);
        mysql_query("LOCK TABLES " . $table_prefix."mod_userpage_related WRITE");
        mysql_query("INSERT INTO " . $table_prefix."mod_userpage_related (page_id) VALUES ('$current_id')");
        mysql_query("UNLOCK TABLES");

		global $sv_user_id;
		$i_sql = 
		 "insert into " . $table_prefix."mod_userpage_owner
		  (owner_id,page_id) 
			values ($sv_user_id,$current_id)";
		$result = mysql_query($i_sql);

		back_to_admin();
		$title = "TRANSLATE[[New Web Page Saved]]!";
		$content = "<b>TRANSLATE[[Your new page has successfully been saved to the database]]!</b>";
		thememainbox($title, $content);
	}
	else
	{
        mysql_query("UNLOCK TABLES");
		$this->new_page = 1;
		$title = "<font color=\"red\"><b>TRANSLATE[[ERROR]]!!</b></font>";
		$content = "<b>TRANSLATE[[There was a database error when attempting to save your page]]!</b><br /><br />
		TRANSLATE[[Please try to save it again in a moment]].<br />
		TRANSLATE[[If the problem persists, contact your system administrator]].";
		thememainbox($title, $content);
		$this->view_page();
		include("footer.php");
		exit();
	}
}

/* Updates the current data of this userpage in the database */
function update_page ()
{
	global $current_data, $current_id, $admintest, $security_hash;
	include('config.php');			// table prefix
	$page_title = $this->main_title;
	$this->editing_page = 0;
	$data = addslashes(serialize($this));

	$result = mysql_query("UPDATE " . $table_prefix."mod_userpage_data SET title='$page_title', data='$data' WHERE id='$current_id'");

	if($result)
	{
		back_to_admin();
		$title = "TRANSLATE[[Web Page Updated]]!";

		//prevent a non-admin user from accessing the menu
		if ($admintest == $security_hash) {
			$content = "<b>TRANSLATE[[Your page has successfully been updated in the database]]!</b><br /><br />
			TRANSLATE[[You can choose to add this page to the menu again or keep the current placement by clicking the finish button]].
			<br /><form method=\"post\" action=\"admin.php\">
			<input type=\"submit\" value=\"Finalizar\" /></form>";
			}

		thememainbox($title, $content);
	}
	else
	{
		$title = "<font color=\"red\"><b>ERROR!!</b></font>";
		$content = "<b>TRANSLATE[[There was a database error when attempting to update your page]]!</b><br /><br />
		TRANSLATE[[Please try to save it again in a moment]].<br />TRANSLATE[[If the problem persists, contact your system administrator]].";
		thememainbox($title, $content);
		$this->view_page();
	}
}


/* This function strips any php tags from the text areas in
   this userpage and adds slashes to any quotes etc. */
function format_data ()
{
	$this->main_title = check_html($this->main_title,"nohtml");

	for($i=0; $i < $this->sections; $i++)
	{
		$this->subtitle[$i] = check_html($this->subtitle[$i],"nohtml");

		if(!$this->text_mode)
			$this->text[$i] = str_replace("\n", "<br />", $this->text[$i]);
		
		$this->text[$i] = check_html($this->text[$i]);

		$this->imagename[$i] = check_html($this->imagename[$i]);
		$this->alt[$i] = check_html($this->alt[$i],"nohtml");
	}
}

/* Prints an error box if this userpage has an error, then allows the
   user to re-edit their userpage to correct the error */
function page_error ($type, $page_id="")
{
	global $error_section;

	include("./mod/userpage/userpage_config.php");
	include("config.php");

        $res = mysql_query("select allowed_imgs,max_image_size from ".$table_prefix."flags");
        list($allowed_types,$max_image_size) = mysql_fetch_row($res);

	$title = "<font color=\"red\"><b>TRANSLATE[[ERROR]]!!</b></font>";
	$content = "<b>TRANSLATE[[The following error has occurred]]:</b><br /><br />\n";

        check_import_errors($content, $type, $page_id);

	switch($type)
	{
		case "page_id":
		$content .= "TRANSLATE[[You must specify a page id when attempting to access a page]]!";
		break;

		case "active":
		$content .= "TRANSLATE[[Page not active]]!";
		break;

		case "not_found":
		$content .= "TRANSLATE[[Page not found]]!<br />ID da pgina: $page_id";
		break;

		case "refresh":
		back_to_admin();
		$content .= "TRANSLATE[[Data lost! This error can occur by hitting your browser's refresh or back button]].<br />
		TRANSLATE[[Please try to navigate the site with the provided]] <b>TRANSLATE[[Next]]</b> e <b>Voltar</b> TRANSLATE[[buttons]].\n";
		break;

		case "main_title":
		$content .= "TRANSLATE[[You have not submitted a main title for your page]]! TRANSLATE[[Please enter a main title now]].";
		break;

		case "text":
		$content .= "TRANSLATE[[The first text area does not appear to contain text]], TRANSLATE[[please enter some now]].\n";
		break;

		case "image_size":
		$content .= "TRANSLATE[[The file you selected for image]] <b>$error_section</b> TRANSLATE[[is too large]]!<br />
		TRANSLATE[[The largest file size allowed on this server is]] $max_image_size TRANSLATE[[bytes]].<br />TRANSLATE[[Please select a smaller image for uploading now]].";
		break;

		case "image_type":
		$content .= "TRANSLATE[[The file you selected for image]] <b>$error_section</b> TRANSLATE[[is not a valid image type]]!<br />
            	TRANSLATE[[The valid types are]]:<br /><br />$allowed_types<br /><br />TRANSLATE[[Please select a new file for uploading now]].";
		break;

		case "alt_tag":
		$content .= "TRANSLATE[[You have not supplied a short description for image]] <b>$error_section</b>!<br />
           	TRANSLATE[[Please enter a short description for image]] <b>$error_section</b>.";
		break;

		case "permissions":
		$content .= "TRANSLATE[[There was a file system error when attempting to upload image]] <b>$error_section</b>!<br />
		TRANSLATE[[Consult your network administrator]]";
		break;
	}

	$content .= "<br /><br />";
	thememainbox($title, $content);
}

/* Returns the active status of this userpage */
function is_active ()
{
	return $this->page_active;
}

/* End of Class: userpage */
}
?>
