<?php

/*
 * This is the hub of the userpage module. All operational
 * decisions are made here.
 *
 * @module userpage
 * @package phpWebSite
 * @author Adam Morton, adam@tux.appstate.edu
*/

/* Include class file. Module specific functions are included in it. */
include("./mod/userpage/userpage.php");

/* Include needed core/config files. */
include("config.php");
if(!isset($mainfile)) include("mainfile.php");
include("open_session.php");
include("core_functions.php");
include("importexport.php");

if ($op=="view_pages")
 {
  include('./mod/userpage/userpage_view_pages.php');
  return 1;
 }

session_register("current_data");
session_register("current_id");
session_register("error_type");
session_register("error_section");

global $sv_user_id, $error_type, $error_section;

if ($op == "Print")
{
	printable($current_data, $current_id);
	return 1;
}

if (!$sv_user_id) {
  //   if this is the first call to userpage, set the session
  //   variable
   cookiedecode($user);
   session_register('sv_user_id','sv_user_name');
   $s_sql="select uid 
     from " . $table_prefix."users 
     where uname = '$cookie[1]'";
   $result=mysql_query ($s_sql);
   //print $s_sql.'<br>'.mysql_error();
   list($sv_user_id) = mysql_fetch_row($result);
   $sv_user_name = $cookie[1];
}

/* Added for related items functionality - Adam */
global $current_page_id;
$current_page_id = $page_id;

if($op != "on_off" && $op != "show_layouts" && $op != "delete_userpage" && $op != "export")
     include("header.php");

/* BEGIN ADMIN SWITCH */
if (($admintest == $security_hash)
		or (user_owns_page($page_id,$sv_user_id)))
switch($op)
{
	case "create_userpage":
	$current_data = new userpage;
	$current_data->edit_page();
	break;

	case "save_data":
	if(($num_sections != old_num_sections) || ($viewblocks != old_viewblocks))
	 $_changepars=1;

	if($remove_image)
	{
		$current_data->remove_image($img_id);
		$current_data->edit_page();
	}
	else if($next || $next_import || $_changepars)
	{
		$error_type = "none";
		$current_data->set_active($sub_active, $text_active, $image_active);
		$current_data->set_title($title);
		$current_data->set_subtitle($subtitle);
		$current_data->set_text($text);
		$current_data->set_viewblocks($viewblocks);

                // moved up there 'cos set_import() could override $text_mode
                $current_data->set_textmode($text_mode);

		for($i=0; $i<$current_data->sections; $i++) {
		if($sv_user_id)
			$newimage_name = $sv_user_id.'-'.$image_name[$i];
		else 
			$newimage_name = $image_name[$i];

                 $current_data->set_image($image[$i], $newimage_name, $image_type[$i], $image_size[$i], $alt[$i], $i, $old_image[$i], $existing_image[$i]);
                 if ($imported[$i] && $imported[$i] != 'none')
                  {
	          import($current_data->text[$i], $imported[$i], $imported_stricttypes[$i], $imported_type[$i], $imported_size[$i], $imported_mode[$i], $i, $current_data->text_active[$i], $current_data->text_mode);

                  $imp_flag++;
                  }
                 }

		$current_data->set_layout($layout);
		$current_data->format_data();

                /* Check for errors */
                if($error_type!='none')
                {
                   if ( !($imp_flag && $error_type == 'text') ) {
                        $current_data->page_error($error_type);
                        $current_data->edit_page();
                        break;
                   }
                }

		if ($next)
		{
                	if ($imp_flag)
                	{
                        	$current_data->edit_page();
                        	break;
                	}

                	$current_data->previewing();
                	$current_data->view_page();
		}
		else if ($next_import)
		{
        		$current_data->edit_page();
			break;
		}
		else if( $_changepars )
		{
			if ( $error_type != 'none')
				$error_type = "none";

			if($num_sections != old_num_sections)
                        {
                                if(eregi("^([0-9]+)$",$num_sections))
                                        {
                                        if($num_sections)
                                                $current_data->sections=$num_sections;
                                        }
                        }

		   	$current_data->edit_page();
                  	 break;
		}
	}
	else
	list_userpages();
	break;

	case "show_layouts":
	$current_data->show_layouts();
	break;

	case "save_layout":
	$current_data->set_layout($layout);
	$current_data->edit_page();
	break;

	case "finish":

	//bobt mod
	if (($admintest != $security_hash)
			and (user_owns_page($page_id,$sv_user_id)))
	{
		   if ($back)
		   	$current_data->edit_page();
		   else if($current_data->new_page)
			 {
			 $current_data->save_page();
			 echo "TRANSLATE[[Save successful]]";
			 }
		   else if($current_data->editing_page)
			 {
			 $current_data->update_page();
     			 echo "TRANSLATE[[Save successful]]";
   			 }
		
		   break;
	}
	//bobt end

	if($back) $current_data->edit_page();
	else if($current_data->new_page)
	{
		$current_data->save_page();
		choose_menu($current_id);
	}
	else if($current_data->editing_page)
	{
		$current_data->update_page();
		choose_menu($current_id);
	}
	else $current_data->page_error("refresh");
	break;

	case "list_userpages":
	list_userpages();
	break;

	case "on_off":
	$result = mysql_query("SELECT data FROM " . $table_prefix."mod_userpage_data WHERE id='$page_id'");
	list($data) = mysql_fetch_row($result);
	$current_data = new userpage;
	$current_data = unserialize($data);
	$current_data->page_active = $switch;
	$data = addslashes(serialize($current_data));
	mysql_query("UPDATE " . $table_prefix."mod_userpage_data SET data='$data' WHERE id='$page_id'");
	mysql_query("UPDATE " . $table_prefix."menu SET menu_active='$switch' WHERE page_id='$page_id'");
	include("header.php");
	list_userpages();
	break;

	case "confirm_delete":
	confirm_delete($page_id);
	break;

	case "delete_userpage":
	mysql_query("LOCK TABLES " 
		. $table_prefix."mod_userpage_data WRITE" 
		. "," . $table_prefix."mod_userpage_owner WRITE"
        . "," . $table_prefix."mod_userpage_related WRITE"
		. "," . $table_prefix."menu WRITE");
	mysql_query("DELETE FROM " . $table_prefix."mod_userpage_data WHERE id='$page_id'");
    mysql_query("DELETE FROM " . $table_prefix."mod_userpage_related WHERE page_id='$page_id'");
	mysql_query("DELETE FROM " . $table_prefix."mod_userpage_owner WHERE page_id='$page_id'");
  //print mysql_error();

	mysql_query("DELETE FROM " . $table_prefix."menu WHERE page_id='$page_id'");
	mysql_query("UNLOCK TABLES");

	include("header.php");
	if ($admintest == $security_hash)
	{ list_userpages();
	} else {
		print "TRANSLATE[[Delete was successful]]";
	}

	break;

	case "edit_userpage":
	if($page_id)
	{
		$current_id = $page_id;
		$result = mysql_query("SELECT data FROM " . $table_prefix."mod_userpage_data WHERE id='$current_id'");
		list($data) = mysql_fetch_row($result);

		if(!$data)
		{
			$current_data = new userpage;
			$current_data->page_error("not_found", $page_id);
			break;
		}

		$current_data = new userpage;
		$current_data = unserialize($data);
		$current_data->editing_page = 1;
		$current_data->edit_page();
	}
	else
	{
		$current_data = new userpage;
		$current_data->page_error("page_id");
	}
	break;

        case "export":
        export($current_data->text[$section_id], $export_mode, $conv, $current_data->text_mode);
        break;
} //bobt mod - added else message
  else if ($op=='create_userpage')
  { print "<br>TRANSLATE[[Sorry, you need special privileges to create web pages. You either don't have the privilege, or you have exceeded your page limit.  If you believe you should have this privilege, or a higher page limit, please contact the site operator.]]";
}
//bobt mod end - added else message

/* END ADMIN SWITCH */

/* BEGIN USER SWITCH */
if(!$op)
switch($op)
{
	default:
	if(!$op)
	if($page_id)
	{
		$current_id = $page_id;
		$result = mysql_query("SELECT data FROM " . $table_prefix."mod_userpage_data WHERE id='$current_id'");
		list($data) = mysql_fetch_row($result);

		if(!$data)
		{
			$current_data = new userpage;
			$current_data->page_error("not_found", $page_id);
			break;
		}

		$current_data = new userpage;
		$current_data = unserialize($data);

		if($current_data->is_active())
		{
			if (($admintest == $security_hash)
				or (user_owns_page($page_id,$sv_user_id))) 
			 { $current_data->admin_edit();
			 }
		
			$current_data->view_page();
			if($current_data->check_viewblocks())
			$index = 2;
		}
		else
		echo $current_data->page_error("active");
	}
	else
	{
		$current_data = new userpage;
		$current_data->page_error("page_id");
	}
	break;
}

if($op != "show_layouts" && $op != "export")
include("footer.php");

?>
