<?php

#########################################################
#							 #
# @module comments					 #
# @package phpWebSite					 #
# @author Ryan Cowan, ryan@tux.appstate.edu              #
#							 # 
##########################################################

include("config.php");
include_once("mainfile.php");
include_once("./mod/comments/comments.php");
include_once("./mod/comments/comments_interface.php");
include("./mod/comments/comments_config.php");
include("open_session.php");

################################################################################
#  Params:  $cmt_cid - The cid of the current comment.			       #
#									       #	
#  Description: Returns an object containing the current comment data.         #
################################################################################
function get_current_comment($cmt_cid)
{
	global $table_prefix, $cmt_mid;

	$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND cid='$cmt_cid'");	
	$cmt_current_comment = mysql_fetch_object($cmt_result);
	
	return $cmt_current_comment;
}

################################################################################
#  Params:  $cmt_field - The field to be searched.			       #
# 	    $cmt_uinfo - The info to be searched for.			       #
#									       #	
#  Description: Searches the table for the number of trolls. It returns the    #
#               number of comments with a score below zero are returned.       #
################################################################################	
function count_trolls($cmt_field, $cmt_uinfo)
{
	global $cmt_mid, $table_prefix;
	
	mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data READ");
	$cmt_result = mysql_query("SELECT COUNT(cid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND $cmt_field='$cmt_uinfo' AND score<-1");
	mysql_query("UNLOCK TABLES");
	if(mysql_num_rows($cmt_result)==0)
		return 0;
	else
	{
		list($cmt_troll) = mysql_fetch_row($cmt_result);
		return $cmt_troll;
	}
}

################################################################################
#  Params:  $cmt_array - The field to be searched.				       #
# 	    $cmt_uinfo - The userinfo to be searched for.			       #
#									       #	
#  Description: Returns the number of comments made by the user.               #
################################################################################
function count_comments($cmt_field, $cmt_uinfo)
{	
	global $cmt_mid, $table_prefix;
	
	mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data READ");
	$cmt_result = mysql_query("SELECT COUNT(cid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND $cmt_field='$cmt_uinfo'");
	mysql_query("UNLOCK TABLES");
	if(mysql_num_rows($cmt_result)==0)
		return 0;
	else
	{
		list($cmt_count) = mysql_fetch_row($cmt_result);
		return $cmt_count;
	}
}

################################################################################
#  Param:  $cmt_cid - The array location of the current comment.		       #
#									       #	
#  Description: Displays a confirmation question.			       #
################################################################################ 
function delete_question($cmt_cid)
{
	global $table_prefix, $cmt_mid;

	$cmt_title = "TRANSLATE[[Remove Comment]]?";
	$cmt_content = "<div align=\"center\"><table border=\"0\" summary=\"Comment\">
	<tr><td align=\"left\">";
	
	$cmt_current_comment = get_current_comment($cmt_cid);
	$cmt_content .= comment($cmt_current_comment, 0, 1);

	$cmt_content .= "</td></tr></table>
	<form action=\"mod.php\" method=\"post\">
	<p>TRANSLATE[[You are about to delete this comment]].<br />
	TRANSLATE[[Are you sure]]?</p>";
	
	//Finds out if the comment has any child comments.
	$cmt_result = mysql_query("SELECT parent FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND parent='$cmt_cid'");
	
	if(mysql_num_rows($cmt_result)!=0)
	{
		if($cmt_current_comment->parent==0)
			$cmt_content .= "TRANSLATE[[Delete the ENTIRE thread]]: ";
		else	
			$cmt_content .= "TRANSLATE[[Delete rest of the thread]]: "; 

		$cmt_content .= "<input type=\"checkbox\" name=\"cmt_remove_childern\" /><br /><br />";
	}
	else
		$cmt_content .= "<input type=\"hidden\" name=\"cmt_remove_childern\" value=\"0\" /><br /><br />";

	$cmt_content .= "<input type=\"hidden\" name=\"mod\" value=\"comments\" />
	<input type=\"hidden\" name=\"cmt_cid\" value=\"$cmt_cid\" />
	<input type=\"submit\" name=\"op\" value=\"SIM\" />
	<input type=\"submit\" name=\"op\" value=\"NO\" /> 
	</form></div>";
	themesidebox($cmt_title, $cmt_content);
}

################################################################################
#  Description: Displays a parent comment and calls display_childern for each  #
#               parent comment.						       #
################################################################################ 
function display_comment() 
{
	global $table_prefix, $cmt_thold, $cmt_current_parent, $cmt_order, $cmt_mid,
	$cmt_start_key, $cmt_comment_content;
		
	$cmt_comment_content .=  "</div>";

	if(!$cmt_start_key)
		$cmt_start_key = 1;

	$cmt_comment_content .=  "<br />";
	
	if($cmt_start_key!=1)
	{
		//Oldest First
		if($cmt_order==4) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND cid=$cmt_start_key ORDER BY cid ASC");

		//Newest First
		if($cmt_order==1) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='0' ORDER BY cid DESC");
	
		//Highest First
		if($cmt_order==2) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='0' ORDER BY score DESC");

		//Lowest First
		if($cmt_order==3) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='0' ORDER BY score ASC");
	}
	else
	{ 	
		//Oldest First
		if($cmt_order==4) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='0' ORDER BY cid ASC");

		//Newest First
		if($cmt_order==1) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='0' ORDER BY cid DESC");
	
		//Highest First
		if($cmt_order==2) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='0' ORDER BY score DESC");

		//Lowest First
		if($cmt_order==3) 
			$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='0' ORDER BY score ASC");
	}	

	while($cmt_current_parent = mysql_fetch_object($cmt_result))
	{	
		$cmt_comment_content .= comment($cmt_current_parent,0,0);
		display_childern($cmt_current_parent->cid);
	}
}


################################################################################
#  Description: Displays a parent comments childern.			       #
################################################################################ 
function display_childern($cmt_cid) 
{
	global $table_prefix, $cmt_mode, $cmt_order, $cmt_thold, $cmt_anonymous, $cmt_current_parent,
	$cmt_comment_content, $cmt_current_child, $cmt_mid;
	
	//Oldest First
	if($cmt_order==4) 
		$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='$cmt_cid' ORDER BY cid ASC");

	//Newest First
	if($cmt_order==1) 
		$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='$cmt_cid' ORDER BY cid DESC");
	
	//Highest First
	if($cmt_order==2) 
		$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='$cmt_cid' ORDER BY score DESC");

	//Lowest First
	if($cmt_order==3) 
		$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_thold' AND parent='$cmt_cid' ORDER BY score ASC");

	while($cmt_current_child = mysql_fetch_object($cmt_result))
	{
		if($cmt_mode!="threaded")
		{
			if($cmt_mode=="nested")
				$cmt_comment_content .= "<blockquote>";
			$cmt_comment_content .= comment($cmt_current_child,0, 0);
			display_childern($cmt_current_child->cid);
			if($cmt_mode=="nested")
				$cmt_comment_content .=  "</blockquote>";
		}
		else
		{	
			$cmt_comment_content .=  "<blockquote>";
			if($cmt_current_child->anonymous)
				$cmt_name = $cmt_anonymous;
			else
				$cmt_name = $cmt_current_child->name;
			$cmt_datetime = formatTimestamp($cmt_current_child->date);

			$cmt_comment_content .=  "<a href=\"mod.php?mod=comments&amp;op=refresh&amp;cmt_cid=$cmt_current_child->cid\">$cmt_current_child->subject</a> por: $cmt_name ligado: $cmt_datetime<br /><br />";

			display_childern($cmt_current_child->cid);
			$cmt_comment_content .= "</blockquote>";
		}
	}
}

################################################################################
#  Param:  $cmt_current_comment - The current comment.     		       #
#          $cmt_read_more - if the comment is too large, then a read more link is  #
#                       displayed.					       #
#          $cmt_preview - if comment is being previewed before being saved     #
#                     then the reply/delete links will be be displayed	       #
#									       #
#  Description: Displays the comment at the given $cmt_cid location.	       #
################################################################################ 
function comment($cmt_current_comment, $cmt_read_more, $cmt_preview)
{
	global $admintest, $cookie, $cmt_reasons, $cmt_anonymous, $security_hash, 
	$user, $userinfo, $current_admin, $cmt_mode, $cmt_start_key, $table_prefix;
	
	$cmt_current_comment->comment = str_replace("\n", "<br />", $cmt_current_comment->comment);	
	
	$cmt_res=mysql_query("SELECT comment_moderate,max_comment_length,edit_comments FROM ".$table_prefix."flags");
	list($cmt_moderate,$cmt_limit,$cmt_edit) = mysql_fetch_row($cmt_res);

	if($cmt_edit)
		$cmt_edited = $cmt_current_comment->edited;
	else
		$cmt_edited = 0;

	cookiedecode($user);
	
	$cmt_content .= "
	<table border=\"0\" summary=\"Comment\">
		<tr>
			<td class=\"type4\">";

	$cmt_datetime = formatTimestamp($cmt_current_comment->date);
	
	$cmt_content .=  "$cmt_current_comment->subject"; 

	if((($admintest==$security_hash) && ($cmt_moderate == 1)) || (($cmt_moderate == 2) && $user)) 
	{
		$cmt_content .= " | <select name=\"cmt_reason[$cmt_current_comment->cid]\">";
		for($i=0; $i<sizeof($cmt_reasons); $i++) 
			$cmt_content .= "<option value=\"$i\">$cmt_reasons[$i]</option>\n";
		$cmt_content .= "</select>";
	}
	
	if(!$cmt_cookie[7]) #USER 'NO SCORE' PREFERENCE.
	{
		$cmt_reason = $cmt_current_comment->reason;
		$cmt_content .=  " | (Placar: $cmt_current_comment->score";
		if($cmt_reason>0)
			$cmt_content .=  ", $cmt_reasons[$cmt_reason]";
		$cmt_content .=  ")";
	}
	
	if ($cmt_current_comment->anonymous)
		$cmt_name = $cmt_anonymous; 
	else
		$cmt_name = $cmt_current_comment->name;

	if ($cmt_current_comment->anonymous)
		$cmt_content .=  "<br />por: $cmt_name ligado: $cmt_datetime";
	else
		$cmt_content .=  "<br />por: <a href=\"mailto:$cmt_current_comment->email\">$cmt_name</a> 
		ligado: $cmt_datetime"; 
	
	if((!$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."authors WHERE aid='$cmt_name'")) && (!$cmt_current_comment->anonymous)) 
		$cmt_content .=  "<br />(<a href=\"user.php?op=userinfo&amp;cmt_uname=$cmt_name\">Info do Usurio</a>) "; 

	if(!$cmt_current_comment->anonymous)
		if (eregi("http://",$cmt_current_comment->url)) 
			$cmt_content .=  "<a href=\"$cmt_current_comment->url\" target=\"window\">$cmt_current_comment->url</a> "; 
	
	$cmt_content .=  "<br />";
	if ($admintest==$security_hash)
		$cmt_content .=  "(IP: $cmt_current_comment->ip) ";

	if($cmt_edited)
		$cmt_content .= "TRANSLATE[[Edited by]]: $cmt_current_comment->editor";
	
	$cmt_content .=  "
		</td>
	</tr>
	<tr>
		<td>";

	if($cmt_edited)
		if(!empty($cmt_current_comment->edit_reason))
			$cmt_current_comment->comment = "<i>$cmt_current_comment->edit_reason</i><br /><br />$cmt_current_comment->comment";
	
	if($user && (strlen($cmt_current_comment->comment) > $cmt_cookie[10]) && !preview && !read_more) 
		$cmt_content .=  substr("$cmt_current_comment->comment", 0, $cmt_cookie[10])."<br />
		<a href=\"mod.php?mod=comments&amp;op=read_more&amp;cmt_cid=$cmt_current_comment->cid\">
		Lr o resto deste comentrio...</a>";
	elseif(!$cmt_read_more && !$cmt_preview && (strlen($cmt_current_comment->comment) > $cmt_limit))
		$cmt_content .=  substr("$cmt_current_comment->comment", 0, $cmt_limit)."<br />
		<a href=\"mod.php?mod=comments&amp;op=read_more&amp;cmt_cid=$cmt_current_comment->cid\">
		Lr o resto deste comentrio...</a>";
	else 
		$cmt_content .= $cmt_current_comment->comment;

	if(!$cmt_preview)
	{
		$cmt_content .=  "
			</td>
		</tr>
		<tr>
			<td>
			<br />[	
			<a href =\"mod.php?mod=comments&amp;op=reply&amp;cmt_cid=$cmt_current_comment->cid\">
			Responder</a>";

		if($cmt_edit || $current_admin)
		{
			if($current_admin)
				$cmt_content .= " | <a href=\"mod.php?mod=comments&amp;op=edit&amp;cmt_cid=$cmt_current_comment->cid\">Editar</a>";
			elseif($user)
			{
				getusrinfo($user);
				$cmt_uname = $userinfo[uname];
				if($cmt_current_comment->name==$cmt_uname)
					$cmt_content .= " | <a href=\"mod.php?mod=comments&amp;op=edit&amp;cmt_cid=$cmt_current_comment->cid\">Editar</a>";
			}

		}

		if($cmt_mode=="threaded")
		{
			$cmt_new_key = $cmt_current_comment->parent;
			if($cmt_start_key!=1)
				$cmt_content .=  " | <a href=\"mod.php?mod=comments&amp;op=refresh&amp;cmt_cid=$cmt_new_key\">Originada</a> ]";
		}

		$cmt_cid = $cmt_current_comment->cid;
		if($admintest==$security_hash) 
			$cmt_content .=  " | <a href=\"mod.php?mod=comments&amp;op=delete_comment&amp;cmt_cid=$cmt_cid\">
			Apaga</a> ]
			<br /><br />";
		else 	
			$cmt_content .=  " ]<br /><br />";

		if($cmt_read_more)
		{
			$cmt_content .=  "<a href=\"mod.php?mod=comments&amp;op=refresh&amp;cmt_cid=0\">Voltar</a>
				</td>
			</tr>
			</table>";
			$cmt_box_title = "TRANSLATE[[Comment]]";
			themesidebox($cmt_box_title, $cmt_content);
		} 
		else
			$cmt_content .=  "
				</td>
			</tr>	
			</table>";
	}
	else
		$cmt_content .=  "
				</td>
			</tr>	
			</table>";

	return $cmt_content; 
}

###################################################################################
#  Param:  $cmt_cid - The cid of the comment to be edited.	        	  #
#	   $cmt_comment - The edited comment. Only used if a reason wasn't given. #
#	   $cmt_subject - The edited subject. Only used if a reason wasn't given. #
#									          #
#  Description: Displays a edit  box for the comment.  Allows the user/admin      #
#		to edit their/the comments after saving.       		          #
################################################################################### 
function edit_box($cmt_cid)
{
	global $userinfo, $current_admin, $user, $cmt_mid, $table_prefix,  
	$cmt_anonymous, $cmt_edit_flag;
	
  	$cmt_result = mysql_query("SELECT edit_comments FROM ".$table_prefix."flags");
	list($cmt_allow_edit) = mysql_fetch_row($cmt_result);

	if(($cmt_allow_edit && isset($user)) || isset($current_admin))
	{
		if(isset($user))
			getusrinfo($user);
		
		$cmt_current_comment = get_current_comment($cmt_cid);

		if(isset($current_admin) || ($cmt_current_comment->name==$userinfo[uname]))
		{
			$cmt_current_comment->comment  = str_replace("<br />", "\n", $cmt_current_comment->comment);	

			if(!isset($cmt_preview_flag))
				$cmt_preview_flag = 0;	
			
			if(!isset($cmt_edit_flag))
				$cmt_edit_flag = 1;
	
			$cmt_datetime = formatTimestamp($cmt_current_comment->date);
	
			if($cmt_current_comment->anonymous)
				$cmt_name = $cmt_anonymous;
			else
				$cmt_name = $cmt_current_comment->name;

			$cmt_box_title = "TRANSLATE[[Edit Reply]] <b>TRANSLATE[[Posted By:]]</b> $cmt_name ";
  			if ($cmt_current_comment->anonymous)
				if(!mysql_query("SELECT * FROM ".$table_prefix."authors WHERE aid='$cmt_current_comment->name'"))
					$cmt_box_title .=  "<br />(<a href=\"user.php?op=userinfo&amp;uname=$cmt_name\">Info do Usurio</a>) "; 
			$cmt_box_title .= "<br /><b>TRANSLATE[[on]]</b> $cmt_datetime";
	
			$cmt_box_content = "<form action=\"mod.php\" method=\"post\">
			<br /><b>Assunto:</b><br />
			<input type=\"text\" name=\"cmt_subject\" size=\"50\" maxlength=\"60\" value=\"";
			
			if(is_numeric($cmt_cid) && (preg_match ("/TRANSLATE[[RE]]/i", "$cmt_current_comment->subject")))
				$cmt_box_content .= "TRANSLATE[[RE]]:";
	
			$cmt_box_content .= "$cmt_current_comment->subject\" /><br /><br /><b>Comentrio:</b><br />
			<textarea cols=\"50\" rows=\"10\" name=\"cmt_comment\" wrap=\"virtual\">$cmt_current_comment->comment</textarea>
	                <br />HTML Permitidos:<br />";
	
			$cmt_box_content .= allowed_html_list('comments');	
			if(!$current_admin)
			{	
				$cmt_result = mysql_query("SELECT allow_postanon FROM ".$table_prefix."mod_comments_flags where mid='$cmt_mid'");
				list($cmt_allow_postanon) = mysql_fetch_row($cmt_result);
				if($cmt_allow_postanon)
				{
					$cmt_box_content .= "<br /><br /><input type=\"checkbox\" name=\"cmt_postanon\""; 
					if($cmt_current_comment->anonymous)
						$cmt_box_content .= " checked=\"checked\"";
					$cmt_box_content .= " />Postar anonimamente";
				}
				else
					if($cmt_current_comment->anonymous)
						$cmt_box_content .= "<br /><br /><input type=\"checkbox\" name=\"cmt_postanon\" checked=\"checked\" />Postar anonimamente<br />(TRANSLATE[[WARNING: Anonymous comments have been turned off]]. TRANSLATE[[You will not be able to change this back until anonymous comments are allowed again]].) ";
			}
	
			$cmt_box_content .= "<br /><br /><hr width=\"100%\"><br /><b>TRANSLATE[[Edited By]]: </b>";
	
			if($current_admin)
				$cmt_box_content .= "$current_admin";
			elseif($user)
			{
				if(!$cmt_current_comment->anonymous)
					$cmt_box_content .= $cmt_name;
	 			else
					$cmt_box_content .= $cmt_anonymous;
			}
	
			$cmt_box_content .= "<br />(TRANSLATE[[This will be shown to let users know that the comment was edited]].)<br /><br /><b>TRANSLATE[[Reason]]:(TRANSLATE[[Optional]])</b><br />
			<textarea cols=\"50\" rows=\"5\" name=\"cmt_reason\" wrap=\"virtual\">$cmt_current_comment->edit_reason</textarea><br />
			(TRANSLATE[[This message will appear in italics before the body of the comment]].)
			<p>
			<input type=\"hidden\" name=\"mod\" value=\"comments\" />
			<input type=\"hidden\" name=\"cmt_cid\" value=\"$cmt_cid\" />
      <input type=\"hidden\" name=\"comment_action\" value=\"edit\" />
			<input type=\"submit\" name=\"op\" value=\"TRANSLATE[[Cancel]]\" />
			<input type=\"submit\" name=\"op\" value=\"Ok!\" /> 
			</p></form>";
		
			themesidebox($cmt_box_title, $cmt_box_content);
		}
		else
			refresh(1);
	}
	else
		refresh(1);		
}

################################################################################
#  Param:  $cmt_cid - The cid of the current comment.           	       #
#	   $cmt_subject - The subject of a comment if there is one.  	       #	
#          $cmt_comment - The comment of a comment if there is one.            #
#          $cmt_postanon - Used if the user wants to post as anonymous.        #
#									       #
#  Description: Displays a reply box for the comment.  Allows the user to      #
#               to preview their comment before saving.  		       #
################################################################################
function reply_box($cmt_parent, $cmt_subject, $cmt_comment, $cmt_posttype, $cmt_postanon)
{
	global $userinfo, $current_admin, $user, $cmt_mid, $cmt_preview_flag, 
	$cmt_anonymous, $table_prefix, $user_url, $cmt_name, $cmt_email, $cmt_reason, $cmt_score;
	
	$cmt_result = mysql_query("SELECT allow_postanon FROM ".$table_prefix."mod_comments_flags where mid='$cmt_mid'");
	list($cmt_allow_postanon) = mysql_fetch_row($cmt_result);
	if(!$cmt_allow_postanon && !$current_admin && !$user)
	{
		$cmt_box_title = "<div align=\"center\">TRANSLATE[[Login Required]]</div>";
		$cmt_box_content = "<div align=\"center\">
		TRANSLATE[[Sorry, you must be logged in to enjoy this aspect of the website]].
		<br /><br />[ <a href=\"user.php\">Login</a> ] 
		| [ <a href=\"mod.php?mod=comments&amp;op=refresh&amp;cmt_cid=0\">Voltar</a> ] 
		</div>";	
	}
	else
	{
		$cmt_result = mysql_query("SELECT max_comment_trolls, max_comments FROM ".$table_prefix."flags");
		list($cmt_troll_limit, $cmt_max_comments) = mysql_fetch_row($cmt_result);
		
		$cmt_ip = getenv("REMOTE_HOST");
		if(empty($cmt_ip)) 
		    $cmt_ip = getenv("REMOTE_ADDR");	
		 		
		if($user)
		{
			getusrinfo($user);
			$cmt_uname = $userinfo[uname];
			$cmt_count = count_comments('name', $cmt_uname);
		}
		elseif(!$current_admin)
			$cmt_count = count_comments('ip', $cmt_ip);
		
		//Troll control
		if($user)
			$cmt_troll =  count_trolls('name', $cmt_uname);
		else
			$cmt_troll =  count_trolls('ip', $cmt_ip);

		if($cmt_count>$cmt_max_comments)
		{
			$cmt_box_title = "<center>TRANSLATE[[Cannot Post Comment]]</center>";
			$cmt_box_content = "
			<div align=\"center\">
			<p>TRANSLATE[[You have reached the maximum number of posts allowed for this instance of the comment module]].</p>";
			if (!$user) 
				$cmt_box_content .= "<p>TRANSLATE[[If you are at a public computer please login and try again]]. 
				<br /><a href=\"user.php\">Login</a></p>";
		 
			$cmt_box_content .= "<a href=\"mod.php?mod=comments&amp;op=refresh\">TRANSLATE[[Ok]]</a></div>";

		}
		elseif($cmt_troll>=$cmt_troll_limit) 
		{
			$cmt_box_title = "<center>TRANSLATE[[Cannot Post Comment]]</center>";
			$cmt_box_content = "<p><center>
			Esta conta ou IP foi temporriamente desabilitada.</p>
			<a href=\"mod.php?mod=comments&amp;op=refresh\">Voltar</a>";
		}
		else
		{
			if($cmt_preview_flag)
			{
				//Setting the preview information.
				set_user_info($cmt_postanon);
				$cmt_comment = set_comment($cmt_posttype, $cmt_comment);
				$cmt_subject = set_subject($cmt_subject);
				$cmt_comment = addslashes($cmt_comment);
				$cmt_subject = addslashes($cmt_subject);
				mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data WRITE READ, ".$table_prefix."flags READ");
				$cmt_result = mysql_query("SELECT MAX(cid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid'");
				list($cmt_cid) = mysql_fetch_row($cmt_result);
				if(empty($cmt_cid)) 
					$cmt_cid = 1;
				else
					$cmt_cid++; 
			
				if(empty($cmt_parent))
					$cmt_parent=0;

				$cmt_res = mysql_query("INSERT INTO  ".$table_prefix."mod_comments_data VALUES ('$cmt_cid','$cmt_parent','$cmt_subject','$cmt_comment','','$cmt_score','$cmt_reason','0','','','$cmt_anonymous','$cmt_name','$cmt_email','$user_url', now(), '$cmt_mid')");
				
				//Displaying the preview comments
				$cmt_current_comment = get_current_comment($cmt_cid);
				$cmt_title = "Prever Estria";
				$cmt_content = comment($cmt_current_comment, 0, 1);

				//Removing the preview comment.
				mysql_query("DELETE FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND cid='$cmt_cid'");
				mysql_query("UNLOCK TABLES");
				themesidebox($cmt_title, $cmt_content);
				$cmt_comment = stripslashes($cmt_comment);
				$cmt_subject = stripslashes($cmt_subject);
			}
	
			if(is_numeric($cmt_parent))
			{
				$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND cid='$cmt_parent'");	
				$cmt_current_comment = mysql_fetch_object($cmt_result);
				$cmt_content = "";
				$cmt_content = comment($cmt_current_comment, 0, 1);
				$cmt_title = "TRANSLATE[[Parent Comment]]";
				themesidebox($cmt_title, $cmt_content);
				if(empty($cmt_subject))
					$cmt_subject = $cmt_current_comment->subject;
			}
		
			$cmt_box_title = "<span class=\"type4bigger\">Responder</span>";
		
			$cmt_box_content = "<form action=\"mod.php\" method=\"post\"><br /><b>Seu Nome: </b>";
		
			if($current_admin)
				$cmt_box_content .= "$current_admin<br />";
			elseif($user) 
			{
				getusrinfo($user);	
				$cmt_name = $userinfo[uname];
				$cmt_box_content .= "<a href=\"user.php\">$cmt_name</a> 
				[ <a href=\"user.php?op=logout\">Logout</a> ]<br />";
			}
			else
				$cmt_box_content .= $cmt_anonymous." [ <a href=\"user.php\">Login</a> ]<br />"; 
			
			$cmt_box_content .= "
			<b>Assunto: (TRANSLATE[[Required]])</b><br />
			<input type=\"text\" name=\"cmt_subject\" size=\"50\" maxlength=\"60\" value=\"";
	
		
			if(is_numeric($cmt_parent) && (!substr_count($cmt_subject, "TRANSLATE[[RE]]")))
				$cmt_box_content .= "TRANSLATE[[RE]]:";

			$cmt_box_content .= "$cmt_subject\" /><br /><b>Comentrio: (TRANSLATE[[Required]])</b><br />
			<textarea cols=\"50\" rows=\"10\" name=\"cmt_comment\" wrap=\"virtual\">$cmt_comment</textarea>
			<br />HTML Permitidos:<br />";
			$cmt_box_content .= allowed_html_list('comments');
		
			$cmt_box_content .= "<p><select name=\"cmt_posttype\">";

			$selected = "";
			if($cmt_posttype=='exttrans')
				$selected = "selected=\"selected\"";

			$cmt_box_content .= "
			<option value=\"exttrans\" $selected>Extrans (tags html ao texto)</option>";
			$selected = "";
			if($cmt_posttype=='html')
				$selected = "selected";

			$cmt_box_content .= "
			<option value=\"html\" $selected>Formatao HTML</option>";
	
			$selected = "";
			if(($cmt_posttype=='plaintext') || empty($cmt_posttype))
				$selected = "selected";

			$cmt_box_content .= "
			<option value=\"plaintext\" $selected>Texto anterior limpo</option>
			</select></p>";
		
			if($cmt_allow_postanon)
			{
				$cmt_box_content .= "<p><input type=\"checkbox\" name=\"cmt_postanon\""; 
				if($cmt_postanon)
					$cmt_box_content .= " checked=\"checked\"";
				$cmt_box_content .= " />Postar anonimamente</p>";
			}
			else
				$cmt_box_content .= "<input type=\"hidden\" name=\"cmt_postanon\" value=\"0\" />";
	
			$cmt_box_content .= "
			<input type=\"hidden\" name=\"mod\" value=\"comments\" />
			<input type=\"hidden\" name=\"cmt_cid\" value=\"$cmt_parent\" />
			<input type=\"submit\" name=\"op\" value=\"Prever Estria\" />
			<input type=\"submit\" name=\"op\" value=\"Ok!\" /> 
			</form><br />";
		}
	}
	themesidebox($cmt_box_title, $cmt_box_content);
}

################################################################################
#  Description: Displays the menu to select an mid.			       #
################################################################################ 
function select_mid()
{
	global $admintest, $security_hash, $table_prefix, $cmt_mid;
	
	if($admintest==$security_hash)
	{
		$cmt_result = mysql_query("SELECT mid FROM ".$table_prefix."mod_comments_flags");
					
		$cmt_box_title = "TRANSLATE[[Manually Enter Comments]]";
		
		$cmt_box_content = "<div align=\"center\">TRANSLATE[[Manually Enter Comments]] | 
		<a href=\"mod.php?mod=comments&op=adminmenu\">TRANSLATE[[Settings]]</a></div>";
	
		if(mysql_num_rows($cmt_result)!=0)
		{
			$cmt_box_content = "<p><form action=\"mod.php\" method=\"post\">
			TRANSLATE[[It is recommended that you dump your data prior to performing an upgrade for phpWebSite]]. 
			TRANSLATE[[If comments were lost or corrupted you may enter the orignial comment here]].
			TRANSLATE[[Please select the instance of the comment that you wish to update]].</p>
			<p><b>
			TRANSLATE[[Select the primary key of the instance of the comment you wish to update]]:</b><br />";

			$cmt_box_content .= "<SELECT name=\"cmt_mid\">";
			while(list($cmt_mid) = mysql_fetch_row($cmt_result))
				$cmt_box_content .=  "<option value=\"$cmt_mid\" $cmt_selected>$cmt_mid</option>";
		
			$cmt_box_content .= "</select><p>
			<input type=\"hidden\" name=\"mod\" value=\"comments\" />
			<input type=\"submit\" name=\"op\" value=\"TRANSLATE[[Proceed]]\" /> 
			<input type=\"submit\" name=\"op\" value=\"TRANSLATE[[Cancel]]\" /></form></p>";	
		}
		else
			$cmt_box_content .= "<br /><div align=\"center\">
			TRANSLATE[[There are no instances of the comment module saved]]!</div>";

		thememainbox($cmt_box_title, $cmt_box_content);
	}
	else
		refresh(1);

}
################################################################################
#  Param:  $cmt_mid - The instance of the comment to be modified.		       #
#          $cmt_new_cid - The cid of the comment to be added.   		       #
#          $cmt_comment - The comment of the comment to be added.		       #
#	   $cmt_subject - The subject of the comment to be added.		       #
#	   $cmt_name - The name of the user who posted the comment to be added.    #
#	   $cmt_email - The email of the user who posted the comment to be added.  #
#          $user_url - The url of the user who posted the comment to be added. #
#	   $cmt_postanon - The post anon flag of the comment to be added.          #
#          $cmt_ip - The ip of the user who posted the comment to be added.        #
#									       #
# Description: Displays the menu for adding a new comment to the instance of   #
# the comment.								       #
################################################################################
function comment_entry($cmt_mid, $cmt_new_cid, $cmt_comment, $cmt_subject, $cmt_name, $cmt_email, $user_url, $cmt_postanon, $cmt_ip)
{
	global $admintest, $security_hash, $table_prefix, $cmt_mid;
	
	if($admintest==$security_hash)
	{
		$cmt_result = mysql_query("SELECT allow_postanon FROM ".$table_prefix."mod_comments_flags where mid='$cmt_mid'");
		list($cmt_allow_postanon) = mysql_fetch_row($cmt_result);
			
		$cmt_box_title = "TRANSLATE[[Manually Enter Comments]]";
		
		$cmt_box_content = "<div align=\"center\">TRANSLATE[[Manually Enter Comments]] | 
		<a href=\"mod.php?mod=comments&op=adminmenu\">TRANSLATE[[Settings]]</a></div>
		<form action=\"mod.php\" method=\"post\">
		<p>TRANSLATE[[It is recommended that you dump your data prior to performing an upgrade for phpWebSite]]. 
		TRANSLATE[[If comments were lost or corrupted you may enter the orignial comment here]]. 
		<br />(*TRANSLATE[[Required]]).</p>
		<p><b>Nome:</b> <input type=\"text\" name=\"cmt_new_name\" value=\"$cmt_name\" size=\"50\" maxlength=\"50\" /></p>
		<p><b>*TRANSLATE[[IP]]:</b> <input type=\"text\" name=\"cmt_new_ip\" value=\"$cmt_ip\" size=\"50\" maxlength=\"50\" /></p>
		<p><b>TRANSLATE[[E-Mail]]:</b> <input type=\"text\" name=\"cmt_new_email\" value=\"$cmt_email\" size=\"50\" maxlength=\"50\" /></p>
		<p><b>URL:</b> <input type=\"text\" name=\"cmt_new_url\" value=\"$user_url\"size=\"50\" maxlength=\"50\" /></p>
		<p><b>*TRANSLATE[[Subject]]:</b> <input type=\"text\" name=\"cmt_new_subject\" value=\"$cmt_subject\" size=\"50\" maxlength=\"50\" /></p>
		<p><b>*TRANSLATE[[Comment]]:</b> <br /><textarea cols=\"50\" rows=\"10\" name=\"cmt_new_comment\" wrap=\"virtual\">$cmt_comment</textarea></p>";
		
		if($cmt_allow_postanon)
		{
			if($cmt_postanon)
				$cmt_checked = "checked";
			else
				$cmt_checked = "";
			$cmt_box_content .= "<p>TRANSLATE[[Post Anonymous]]: <input type=\"checkbox\" name=\"cmt_postanon\" $cmt_checked/></p>";
		}
		else
			$cmt_box_content .= "<p>TRANSLATE[[Anonymous posts are not allowed for this instance of comments]].</p> 
				<input type=\"hidden\" name=\"cmt_postanon\" value=\"0\" />";
			
		$cmt_box_content .= "<p><b>*TRANSLATE[[Select the comment that the new comment is replying to]]:</b><br />
		<SELECT name=\"cmt_cmt_cid\">";
		mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data READ");
		$cmt_result = mysql_query("SELECT cid,subject,date FROM ".$table_prefix."mod_comments_data where mid='$cmt_mid'");
		while(list($cmt_cid,$cmt_subject,$cmt_date) = mysql_fetch_row($cmt_result))
		{
			$cmt_datetime = formatTimestamp($cmt_date);
			$cmt_box_content .=  "<option value=\"$cmt_cid\"";
			if($cmt_cid==$cmt_new_cid)
				$cmt_box_content .= " selected=\"selected\"";
			$cmt_box_content .= ">$cmt_subject - Postado em: $cmt_datetime</option>";
		}			
		$cmt_box_content .= "<option value=\"Parent\">TRANSLATE[[Make Comment Parent]]</option></select></p>";
		mysql_query("UNLOCK TABLES");
		$cmt_box_content .= "<input type=\"hidden\" name=\"cmt_mod\" value=\"comments\" />
		<input type=\"hidden\" name=\"mid\" value=\"$cmt_mid\" />
		<input type=\"submit\" name=\"op\" value=\"TRANSLATE[[Save Entry]]\" /> 
		<input type=\"submit\" name=\"op\" value=\"TRANSLATE[[Cancel]]\" /></form>";	
		thememainbox($cmt_box_title, $cmt_box_content);
	}
	else
		refresh(1);
}

##################################################################################
#  Param:  $cmt_mid - The instance of the comment to be modified.		 #
#          $cmt_new_cid - The cid of the comment to be added.   		 #
#          $cmt_comment - The comment of the comment to be added.		 #
#	   $cmt_subject - The subject of the comment to be added.		 #
#	   $cmt_name - The name of the user who posted the comment to be added.  #
#	   $cmt_email - The email of the user who posted the comment to be added.#
#          $user_url - The url of the user who posted the comment to be added.   #
#	   $cmt_postanon - The post anon flag of the comment to be added.        #
#          $cmt_ip - The ip of the user who posted the comment to be added.      #
#									         #
# Description: Saves the data.						         #
##################################################################################
function save_entry($cmt_mid, $cmt_cid, $cmt_comment, $cmt_subject, $cmt_name, $cmt_email, $user_url, $cmt_postanon, $cmt_ip)
{
	global $admintest, $security_hash, $table_prefix;

	if($admintest==$security_hash)
	{
		if($cmt_postanon)
			$cmt_score = 0;
		else
			$cmt_score = 1;
		$cmt_reason = 0;
		$cmt_comment = set_comment($cmt_posttype, $cmt_comment);
		$cmt_subject = set_subject($cmt_subject);
		$cmt_edited = 0;
		$cmt_editor = "";
		$cmt_edit_reason = "";
		if($cmt_cid=="Parent'")
			$cmt_parent=0;
		else
			$cmt_parent=$cmt_cid;		
		mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data WRITE READ");
		$cmt_result = mysql_query("SELECT MAX(cid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid'");
		list($cmt_cid) = mysql_fetch_row($cmt_result);
		if(empty($cmt_cid)) 
			$cmt_cid = 1;
		else
			$cmt_cid ++; 
		mysql_query("INSERT INTO  ".$table_prefix."mod_comments_data VALUES ('$cmt_cid','$cmt_parent','$cmt_subject','$cmt_comment','$cmt_ip','$cmt_score','$cmt_reason','$cmt_edited','$cmt_editor','$cmt_edit_reason','$cmt_postanon','$cmt_name','$cmt_email','$user_url', now(),'$cmt_mid')");
		mysql_query("UNLOCK TABLES");
	}
	refresh(1);

}

################################################################################
#  Description: Displays a menu that allows admins to set their preferances    #
#  for comments.		 					       #
################################################################################ 
function comment_admin_menu()
{
	global $admintest, $security_hash, $table_prefix;
	
	if($admintest==$security_hash)
	{
		$cmt_result = mysql_query("SELECT default_mode, default_order, default_thold, comment_moderate, max_comment_trolls, max_comment_length, max_comments, edit_comments FROM ".$table_prefix."flags");
		
	if(list($cmt_mode, $cmt_order, $cmt_thold, $cmt_moderate, $cmt_trolls, $cmt_length, $cmt_max, $cmt_edit) = mysql_fetch_row($cmt_result))
	{
		$cmt_title = "Opes de Comentrios";
		
		$cmt_content = "<div align=\"center\"><p><a href=\"mod.php?mod=comments&op=select_mid\">TRANSLATE[[Manually Enter Comments]]</a> | TRANSLATE[[Settings]] </p></div>
		<span class=\"boldtext\">TRANSLATE[[These settings are the defaults setting for comments]]. TRANSLATE[[These settings will only be overridden by a user's preferences]].</span><br /><br />
		<form action=\"mod.php\" method=\"post\">
		<span class=\"boldtext\">Modo de Visualizao</span>
		<select class=\"textbox\" name=\"cmt_new_mode\">

		<option value=\"nocomments\" ";
		if ($cmt_mode == 'nocomments')
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">TRANSLATE[[NO Comments]]</option>

		<option value=\"nested\" ";
		if ($cmt_mode == 'nested')
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">TRANSLATE[[Nested]]</option>

		<option value=\"threaded\" ";
		if ($cmt_mode == 'threaded') 
			 $cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Colocado</option>

		<option value=\"flat\" ";
		if ($cmt_mode == 'flat')
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Confirmado</option>

		</select><br /><br />
		
		<span class=\"boldtext\">Ordem de classificao</span>
		<select class=\"textbox\" name=\"cmt_new_order\">

		<option value=\"4\"";
		if ($cmt_order==4)
		 	$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Antigos primeiro</option>

		<option value=\"1\"";
		if ($cmt_order==1)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Os mais novos primeiro</option>

		<option value=\"2\"";
		if ($cmt_order==2)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Primeiro os Placares Mais Altos</option>

		<option value=\"3\"";
		if ($cmt_order==3)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">TRANSLATE[[Lowest Scores First]]</option>

		</select><br /><br />
	
		<span class=\"boldtext\">Limiar</span>
		<select class=\"textbox\" name=\"cmt_new_thold\">
		
		<option value=\"-1\"";
		if ($cmt_thold==-1)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">-1: Sem corte e rascunho</option>
		
		<option value=\"0\"";
		if ($cmt_thold==0) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">0: Quase Tudo</option>
		
		<option value=\"1\"";
		if ($cmt_thold==1)
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">1: Filtrar os annimos</option>

		<option value=\"2\"";
		if ($cmt_thold==2) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">2: Placar +2</option>

		<option value=\"3\"";
		if ($cmt_thold==3) 
			$cmt_content .= "selected=\"selected\"";
		$cmt_content .= ">3: Placar +3</option>

		<option value=\"4\"";
		if ($cmt_thold==4) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">4: Placar +4</option>

		<option value=\"5\"";
		if ($cmt_thold==5) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">5: Placar +5</option>

		</select><br />
		TRANSLATE[[Comments scored less than this setting will be ignored]].<br />
		TRANSLATE[[Anonymous posts start at 0, logged in posts start at 1]].
		TRANSLATE[[Moderators add and subtract points]].
		<br /><br />
		<span class=\"boldtext\">Comprimento Mx. do Comentrio</span>
		<br />
		<input type=\"text\" name=\"cmt_new_max\" value=\"$cmt_length\" size=\"11\" maxlength=\"11\" /> b (1024 b = 1K)
		<br />
		(TRANSLATE[[Truncates long comments, and adds a Read More link.]] TRANSLATE[[Set really big to disable]])
		<br /><br />
		<div align=\"center\"><hr size=\"1\" width=\"50%\" /><br /></div>
		<span class=\"boldtext\">TRANSLATE[[These settings are controlled by the admin only]].<br /><br /></span>
		<span class=\"boldtext\">TRANSLATE[[Moderators Control the Score]]</span>
		<select class=\"textbox\" name=\"cmt_new_moderate\">
		<option value=\"0\"";
		if ($cmt_moderate==0)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">0: TRANSLATE[[NO Moderation]]</option>
				
		<option value=\"1\"";
		if ($cmt_moderate==1) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">1: TRANSLATE[[Only Administrators]]</option>
		
		<option value=\"2\"";
		if ($cmt_moderate==2)
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">2: TRANSLATE[[Users and Administrators]]</option>
		</select><br /><br />

		<span class=\"boldtext\">TRANSLATE[[Maximum Number of Post allowed from a specific ip or User]].</span>
		<br />
		<input type=\"text\" name=\"cmt_new_total\" value=\"$cmt_max\" size=\"11\" maxlength=\"11\" />
		<br />
		(TRANSLATE[[A user will not be allowed to post a comment if their total number of posts exceeds this number for each instance of Comments]].)<br />
		<br />
		<span class=\"boldtext\">TRANSLATE[[Number of Trolls Allowed Each Month]]</span>
		<br />
		<input type=\"text\" name=\"cmt_new_trolls\" value=\"$cmt_trolls\" size=\"11\" maxlength=\"11\" />
		<br />
		(TRANSLATE[[A user will not be allowed to post a comment if their troll count exceeds this number for each instance of Comments]].  TRANSLATE[[Trolls are comments with a score of -1]].)<br /><br />
		<span class=\"boldtext\">TRANSLATE[[Allows comments to be edited by the User who posted them]]?</span><br />";
		if($cmt_edit)
			$cmt_check_yes = "checked";
		else
			$cmt_check_no = "checked";
		$cmt_content .= "<div align=\"center\">
		<input type=\"radio\" name=\"cmt_edit\" value=\"1\" $cmt_check_yes>SIM
                <input type=\"radio\" name=\"cmt_edit\" value=\"0\" $cmt_check_no>NO
		<input type=\"hidden\" name=\"mod\" value=\"comments\" />
		<input type=\"hidden\" name=\"op\" value=\"save_admin_pref\" />
		<br /><br /><input type=\"submit\" value=\"Salvar as mudanas\" /></div>	
		</form>
		<br />";	
	} 
	else 
	{
		$cmt_title = "Opes de Comentrios";
		$cmt_content = "TRANSLATE[[A problem occurred: Invalid query to the database.]]";
	}
	
	themesidebox($cmt_title, $cmt_content);
	
	} #Do NOT Delete.
}


################################################################################
#  Param:  $cmt_mode - The new default mode for the comments module.	       #
#	   $cmt_order - The new default order for the comments module. 	       #	
#          $cmt_thold - The new default thold for the comments module. 	       #
#	   $cmt_max - The new default length of the comment to be shown for        #
#		  comment_module.					       #
#	   $cmt_moderate - The new setting for moderation.		     	       #
#	   $cmt_reasons - The new reason settings for the comment module.          #
#          $cmt_trolls - The maximum number of trolls a user is allowed to         #
#		     have each month.				               #
#	   $cmt_total - The maximum number of post a user or specific ip is        #
#                   allowed to have for each comment object.	               #
#          $cmt_edit - Flag for editing setting.				       #
#									       #
#  Description: Saves the admin preferences.				       #
################################################################################
function save_admin_pref($cmt_mode, $cmt_order, $cmt_thold, $cmt_max, $cmt_moderate, $cmt_trolls, $cmt_count, $cmt_edit) 
{
	global $admintest, $security_hash, $table_prefix;

	if($admintest==$security_hash)
	{
		mysql_query("UPDATE ".$table_prefix."flags SET default_mode='$cmt_mode', default_order='$cmt_order', default_thold='$cmt_thold', comment_moderate='$cmt_moderate', max_comment_trolls='$cmt_trolls', max_comment_length='$cmt_max', max_comments='$cmt_count', edit_comments='$cmt_edit'");
	}

}

################################################################################
#  Description: Displays a menu that allows users to set their preferances for #
#		comments.	 					       #
################################################################################ 
function comment_user_menu()
{
	global $user, $userinfo, $table_prefix;

	$cmt_result = mysql_query("SELECT default_mode, default_order, default_thold FROM ".$table_prefix."flags");
        list($cmt_mode, $cmt_order, $cmt_thold) = mysql_fetch_row($cmt_result);
	getusrinfo($user);

	if ($userinfo != 0)
	{
		#Uses the comment default settings if user info is not set.
		#These weren't being set when a new user was being made.
		if($userinfo[umode]=="")
			$userinfo[umode]=$cmt_mode;
	
		if($userinfo[uorder]=="")
			$userinfo[uorder]=$cmt_order;
		
		if($userinfo[thold]=="")
			$userinfo[thold]=$cmt_thold;
			
		$cmt_box_title = "Opes de Comentrios";

		//if($cmt_help_system)
		//	$cmt_box_title .= help("USER", "");

		$cmt_content .= "
		<form action=\"mod.php\" method=\"post\">
		<span class=\"boldtext\">Modo de Visualizao</span>
		<select class=\"textbox\" name=\"cmt_new_mode\">
		<option value=\"nocomments\" ";
	
		if ($userinfo[umode] == 'nocomments')
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">TRANSLATE[[NO Comments]]</option>
		<option value=\"nested\" ";
		if ($userinfo[umode] == 'nested')
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">TRANSLATE[[Nested]]</option>
		<option value=\"threaded\" ";
		if ($userinfo[umode] == 'threaded') 
			 $cmt_content .= "selected=\"selected\" ";

		$cmt_content .= ">Colocado</option>
		<option value=\"flat\" ";
		if ($userinfo[umode] == 'flat')
		 	 $cmt_content .= "selected=\"selected\" ";

		$cmt_content .= ">Confirmado</option>
		</select><br /><br />
		
		<span class=\"boldtext\">Ordem de classificao</span>
		<select class=\"textbox\" name=\"cmt_new_order\">
		
		<option value=\"4\"";
		if ($userinfo[uorder]==4)
		 	$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Antigos primeiro</option>

		<option value=\"1\"";
		if ($userinfo[uorder]==1)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Os mais novos primeiro</option>

		<option value=\"3\"";
		if ($userinfo[uorder]==3)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">TRANSLATE[[Lowest Scores First]]</option>

		<option value=\"2\"";
		if ($userinfo[uorder]==2)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">Primeiro os Placares Mais Altos</option>

		</select><br /><br />
	
		<span class=\"boldtext\">Limiar</span>
		<select class=\"textbox\" name=\"cmt_new_thold\">
		<option value=\"-1\"";
		if ($userinfo[thold]==-1)
			$cmt_content .= "selected=\"selected\" ";
		$cmt_content .= ">-1: Sem corte e rascunho</option>
		<option value=\"0\"";
		if ($userinfo[thold]==0) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">0: Quase Tudo</option>
		<option value=\"1\"";
		if ($userinfo[thold]==1)
			$cmt_content .= "selected=\"selected\""; 

		$cmt_content .= ">1: Filtrar os annimos</option>
		<option value=\"2\"";
		if ($userinfo[thold]==2) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">2: Placar +2</option>
		<option value=\"3\"";
		if ($userinfo[thold]==3) $cmt_content .= "selected=\"selected\"";
		$cmt_content .= ">3: Placar +3</option>
		<option value=\"4\"";
		if ($userinfo[thold]==4) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">4: Placar +4</option>
		<option value=\"5\"";
		if ($userinfo[thold]==5) 
			$cmt_content .= "selected=\"selected\""; 
		$cmt_content .= ">5: Placar +5</option>
		</select><br />
		Comentrios com placar menor que este ser ignorado.<br />
		TRANSLATE[[Anonymous posts start at 0, logged in posts start at 1]].
		<br /><br />
		<input type=\"checkbox\" name=\"cmt_new_show_score\"";
		if ($userinfo[noscore])
			$cmt_content .= "checked=\"checked\"";
		$cmt_content .="/><span class=\"boldtext\">TRANSLATE[[Hide Scores]]</span><br />
		(Placares escondidos: Eles ainda se aplicam, voc apenas no os v.)
		<br /><br />
		
		<span class=\"boldtext\">Comprimento Mx. do Comentrio</span><br />
		<input type=\"text\" name=\"cmt_new_max\" value=\"$userinfo[commentmax]\" size=\"11\" maxlength=\"11\" /> b (1024 b = 1K)
		<br />		(Trunca longos comentrios, e adiciona o link Lr Mais. Marque realemente grande para desabilitar)
		<br /><br />
		<input type=\"hidden\" name=\"mod\" value=\"comments\" />
		<input type=\"hidden\" name=\"op\" value=\"save_user_pref\" />
		<input type=\"submit\" value=\"Salvar as mudanas\" />
		</form>";
	} 
	else 
	{
		$cmt_box_title = "Opes de Comentrios";
		$cmt_content = "TRANSLATE[[A problem occurred: Your account is not registered]]";
	}

	themesidebox($cmt_box_title, $cmt_content);
	include("footer.php");
}

################################################################################
#  Param:  $cmt_new_mode - The new default mode for the user.		       #
#	   $cmt_new_order - The new default order for the user.	  	       #	
#          $cmt_new_thold - The new default thold for the user.     	       #
#          $cmt_noscore - Boolean for wheather or not the scores are shown for     #
#		      the comments.             			       #
#	   $cmt_new_max - The new default length of the comment to be shown for    #
#		      user.						       #
#									       #
#  Description: Saves the user preferences and creates a new user cookie.      #
################################################################################
function save_user_pref($cmt_new_mode, $cmt_new_order, $cmt_new_thold, $cmt_noscore, $cmt_new_max) 
{
	global $user, $userinfo, $table_prefix;

	if($cmt_noscore)
		$cmt_noscore=1;
	else
		$cmt_noscore=0;

	getusrinfo($user);
	if ($user_dblocation)
	{
		@mysql_select_db("$user_dbname") or die ("Impossvel selecionar o Banco de Dados");
		mysql_query("update ".$table_prefix."users set umode='$cmt_new_mode', uorder='$cmt_new_order', thold='$cmt_new_thold', noscore='$cmt_noscore', commentmax='$cmt_new_max' where uid=$userinfo[uid]");
		@mysql_select_db("$cmt_dbname") or die ("Impossvel selecionar o Banco de Dados");
	}
	else
	{
		mysql_query("update ".$table_prefix."users set umode='$cmt_new_mode', uorder='$cmt_new_order', thold='$cmt_new_thold', noscore='$cmt_noscore', commentmax='$cmt_new_max' where uid=$userinfo[uid]");
	}

	#Creates new user cookie. The cookie is used in comment().
	$cmt_info = base64_encode("$userinfo[uid]:$userinfo[uname]:$userinfo[pass]:$userinfo[storynum]:$userinfo[umode]:$userinfo[uorder]:$userinfo[thold]:$userinfo[noscore]:$userinfo[ublockon]:$userinfo[theme]:$userinfo[commentmax]");
	setcookie("user","$cmt_info",time()+$cmt_cookieusrtime);
	
	html_header_location("user.php?"); // question is wierd bugfix
}

################################################################################
#  Param:  $cmt_cid - Array location of the current comment.		       #
#									       #
#  Description: Refreashes the page.					       #
################################################################################ 
function refresh($cmt_cid)
{
	global $cmt_start_key, $cmt_comment_url;
	
	$cmt_start_key = $cmt_cid;
	
	if($cmt_comment_url)
		html_header_location("http://$cmt_comment_url");
	elseif($admintest==$security_hash)
		html_header_location("mod.php?mod=comments&op=adminmenu");
	else
	 	html_header_location("index.php");
}

################################################################################
#  Param: $cmt_reason - An array of the reason settings passed from modtwo();  #
#									       #
#  Description: Sets the score and reason for each comment based on the arrray #
#               $cmt_reason.						       #
################################################################################
function moderate($cmt_reason)
{
	global $table_prefix, $cmt_mid;

	foreach($cmt_reason as $cmt_cid => $cmt_new_reason)
	{
		echo "$cmt_mid, $cmt_cid, $cmt_new_reason <br />";

		$result = mysql_query("SELECT score,reason FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND cid='$cmt_cid'");
		while(list($cmt_score, $cmt_reason) = mysql_fetch_row($result))
		{
			echo "new $cmt_score, $cmt_reason, $cmt_new_reason <br />";
			if($cmt_new_reason!=$cmt_reason)
			{
				if(($cmt_score>-1) && ($cmt_score<5))
				{
					if($cmt_new_reason==9)					# Overrated
						$cmt_score--;
					elseif($cmt_new_reason==10)     			# Underated
						$cmt_score++;
					elseif(($cmt_new_reason>0) && ($cmt_new_reason<5))	# Bad Reasons
						$cmt_score--;	
					elseif(($cmt_new_reason>4) && ($cmt_new_reason<9))	# Good Reasons
						$cmt_score++;				
				}
				mysql_query("UPDATE ".$table_prefix."mod_comments_data SET score='$cmt_score', reason='$cmt_new_reason' WHERE mid='$cmt_mid' AND cid='$cmt_cid'");
			}
		}
	}
}	
			
?>
