<?php

##########################################################
#							 #
# @module comments					 #
# @package phpWebSite					 #
# @author Ryan Cowan, ryan@tux.appstate.edu              #
#							 # 
# This file contains all functions used to save/delete a #
# new/edited comment and it's options.		         #
##########################################################

include("config.php");
include_once("mainfile.php");
include("open_session.php");

################################################################################
#  Params:  $cmt_posttype - How the comment will be posted, plain text,        #
#			Extrans(html tags to text, and html formatted.         #
# 	    $cmt_comment - The body of the new comment.			       #
#  									       #	
#  Description: Sets $cmt_comment prior to saving.			       #
################################################################################
function set_comment($cmt_posttype, $cmt_comment) 
{
	$cmt_comment = check_html($cmt_comment, 'comments');
	
	if($cmt_posttype=="exttrans")
		$cmt_comment = check_words(htmlentities(magic_check($cmt_comment)));
	elseif($cmt_posttype=="plaintext")
	{	
		$cmt_comment = str_replace("<br />", "\n", check_words($cmt_comment));
		$cmt_comment = magic_check(htmlspecialchars($cmt_comment));	
	}
	else
		$cmt_comment = check_words(magic_check($cmt_comment));

	return $cmt_comment;
}

################################################################################
#  Params:  $cmt_subject - The subject of the new comment.		       #
#  									       #	
#  Description: Sets $cmt_subject prior to saving.	 		       #
################################################################################
function set_subject($cmt_subject)
{
	$cmt_subject = check_html($cmt_subject, 'nohtml');
	$cmt_subject = htmlspecialchars(magic_check($cmt_subject));
	$cmt_subject = FixQuotes(filter_text($cmt_subject));

	return $cmt_subject;
}

################################################################################
#  Params:  $cmt_edit_reason - The reason why a comment was edited.	       #
#  									       #	
#  Description: Sets $cmt_edit_reason prior to saving.	 		       #
################################################################################
function set_edit_reason($cmt_edit_reason)
{
	$cmt_edit_reason = check_html($cmt_edit_reason, 'comments');
	$cmt_edit_reason = rtrim($cmt_edit_reason);
	$cmt_edit_reason = FixQuotes(str_replace("\n", "<br />",(filter_text($cmt_edit_reason))));

	return $cmt_edit_reason;
}
				
################################################################################
#  Params:   $cmt_postanon - Post anonomusly flag.			       #
#  									       #	
#  Description: Sets the user/admin id 		  			       #
################################################################################
function set_user_info($cmt_postanon)
{
	global $table_prefix, $user, $userinfo, $current_admin, $table_prefix,
	$cmt_score, $cmt_anon, $cmt_reason, $cmt_name, $cmt_email, $user_url;

	$cmt_anon = $cmt_postanon;
	if($current_admin)
	{
		$cmt_result = mysql_query("SELECT aid,email,url FROM ".$table_prefix."authors WHERE aid='$current_admin'");
		list($cmt_name,$cmt_email,$user_url) = mysql_fetch_row($cmt_result);
	}
	elseif ($user) 
	{
		getusrinfo($user);
		$cmt_name = $userinfo[uname];
		$cmt_email = $userinfo[femail];
		$user_url = $userinfo[url];
	}
	else 
	{
		$cmt_aid = 0;
		$cmt_name = "";
		$cmt_email = "";;
		$cmt_url = "";
		$cmt_anon = 'on';
	}

	if($cmt_anon)
		$cmt_score = 0;	
	else
		$cmt_score = 1;

	$cmt_reason = 0;
}

##################################################################################
#  Params:  $cmt_parent - The cid of the parent comment.			 #
#	    $cmt_posttype - Extrans (html tags to text, HTML Formatted, or Text. #
#           $cmt_comment - The body of the comment to be saved.                  #
#           $cmt_subject - The subject of the comment to be saved.               #
#  									         #
#  Description: Makes sure comments aren't posted that have exceeded the troll   #
#               or max number of post limits. Also looks for duplicates and      #
#               if everything checks out it will add the comment to the          #
#               comment array's.					         #
##################################################################################
function save_comment($cmt_parent, $cmt_posttype, $cmt_comment, $cmt_subject, $cmt_postanon) 
{
	include("config.php");

	global $current_admin, $user, $userinfo, $cmt_mode, $cmt_mid,
	$cmt_score, $cmt_reason, $cmt_name, $cmt_email, $user_url, $cmt_anon; 

	if(empty($cmt_subject) || empty($cmt_comment)) 
	{
		$cmt_title = "TRANSLATE[[Invalid Comment]]";
		$cmt_content = "<div align=\"center\">";
		if(empty($cmt_subject))
			$cmt_content .= "<ul><li>TRANSLATE[[The subject was blank]].</li>";
		if(empty($cmt_comment))
			$cmt_content .= "<li>TRANSLATE[[The comment was blank]].</li>";
		$cmt_content .= "</ul>TRANSLATE[[You must have a subject and a comment]]!<br /><br />
			    <a href=\"mod.php?mod=comments&amp;op=reply&amp;cmt_cid=$cmt_parent_key&amp;cmt_subject=$cmt_subject&amp;cmt_comment=$cmt_comment&amp;cmt_postanon=$cmt_postanon\">Voltar</a></div>";
	
		themesidebox($cmt_title, $cmt_content);
	}
	else
	{
		//Duplicate control
		$cmt_duplicate = 0;
	        $cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND subject='$cmt_subject' AND comment='$cmt_comment'");
		if(mysql_num_rows($cmt_result)!=0)
				$cmt_duplicate = 1;

		if($cmt_duplicate)
		{
				$cmt_box_title = "TRANSLATE[[Duplicate]]";
				$cmt_box_content = "<p>TRANSLATE[[Did you submit twice?]]</p>
				<a href=\"mod.php?mod=comments&amp;op=refresh\">Voltar</a>";
		}
		else
		{
			set_user_info($cmt_postanon);
			$cmt_comment = addslashes(set_comment($cmt_posttype, $cmt_comment));
			$cmt_subject = addslashes(set_subject($cmt_subject));
			if(phpversion() < "4.1.0")
			{
				global $HTTP_SERVER_VARS;
				$cmt_ip = $HTTP_SERVER_VARS['REMOTE_ADDR'];  
			}
		 	else
			{
				global $_SERVER;
				$cmt_ip = $_SERVER['REMOTE_ADDR'];
			}
			$cmt_edited = 0;
			$cmt_editor = "";
			$cmt_edit_reason = "";
			mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data WRITE READ");
			$cmt_result = mysql_query("SELECT MAX(cid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid'");
			list($cmt_cid) = mysql_fetch_row($cmt_result);
			if(empty($cmt_cid)) 
				$cmt_cid = 1;
			else
				$cmt_cid ++; 
			if(empty($cmt_parent))
				$cmt_parent=0;
			mysql_query("INSERT INTO  ".$table_prefix."mod_comments_data VALUES ('$cmt_cid','$cmt_parent','$cmt_subject','$cmt_comment','$cmt_ip','$cmt_score','$cmt_reason','$cmt_edited','$cmt_editor','$cmt_edit_reason','$cmt_anon','$cmt_name','$cmt_email','$user_url', now(),'$cmt_mid')");
			mysql_query("UNLOCK TABLES");
		}
	}
	refresh(0);
}

#################################################################################
#  Params:  $cmt_cid - The cid of the comment to be updated.		        #
#	    $cmt_posttype - Extrans (html tags to text, HTML Formatted, or Text.#
#           $cmt_comment - The body of the comment to be saved.                 #
#           $cmt_subject - The subject of the comment to be saved.              #
#	    $cmt_postnon - The anonymous flag. 				        #
#	    $cmt_edit_reason - The reason for the edit.			        #
#  									        #
#  Description: Updates the comment.					        #
#################################################################################
function save_edited_comment($cmt_cid, $cmt_posttype, $cmt_comment, $cmt_subject, $cmt_postanon, $cmt_edit_reason) 
{
	global $table_prefix, $current_admin, $user, $userinfo, $cmt_mode, $cmt_mid,
	$cmt_name, $cmt_email, $user_url, $cmt_anonymous, $cmt_edit_flag; 

	$cmt_comment = set_comment($cmt_posttype, $cmt_comment);
	$cmt_subject = set_subject($cmt_subject);
	$cmt_edit_reason = set_edit_reason($cmt_edit_reason);
	$cmt_edited = 1;
	getusrinfo($user);
	if($current_admin)
		$cmt_editor = $current_admin;
	elseif(!$cmt_postanon)
		$cmt_editor = $userinfo[uname];
	else 
		$cmt_editor = $cmt_anonymous;

	mysql_query("UPDATE ".$table_prefix."mod_comments_data SET anonymous='$cmt_postanon',subject='$cmt_subject',comment='$cmt_comment',edited='$cmt_edited',edit_reason='$cmt_edit_reason',editor='$cmt_editor' WHERE mid='$cmt_mid' AND cid='$cmt_cid'");
	$cmt_edit_flag=0;
	
	refresh(0);
}


####################################################################################
#  Params:  $cmt_id - The cid of the comment to be removed.                    #
# 	    $cmt_remove_childern - Flag for wheather or not to remove childern #
#                              along with the parent.		 	           #
#  									           #	
#  Description: Deletes the data of the comment.			           #
####################################################################################
function delete_comment($cmt_id, $cmt_remove_childern)
{
	global $table_prefix, $cmt_mid;

	mysql_query("DELETE FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND cid='$cmt_id'");

	if($cmt_remove_childern)
		remove_childern($cmt_id);
	else		
		mysql_query("UPDATE ".$table_prefix."mod_comments_data SET parent='0' WHERE parent='$cmt_id'");	

}

################################################################################
#  Params:  $cmt_id - The cid of the comment to be removed.                    #
# 	    								       #
#  Description: Recursively deletes the childern of the parent comment.	       #
################################################################################
function remove_childern($cmt_id)
{
	global $table_prefix, $cmt_mid;

	if(empty($cmt_id))
		return 0;
	
	mysql_query("DELETE FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND parent='$cmt_id'");
	
	$cmt_result = mysql_query("SELECT cid FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND parent='$cmt_id'");
	
	list($cmt_new_cmt_id) = mysql_fetch_row($cmt_result);
	
	remove_childern($cmt_new_cmt_id);	
}

?>
