<?php

/**
 * This file contains the core function definitions for phpWebSite.
 *
 * The functions defined here are essential for the phpWebSite
 * system. This file gets included almost all the time, you should be
 * able to use the functions defined here everywhere in the code.
 *
 * @module mainfile
 * @modulegroup core
 * @package phpWebSite
 */

$mainfile = 1;

include("dbconnect.php");

/**
 * Checks for modules at given position and displays them.
 *
 * This function is used to check for modules registered an the
 * modules table. If a plugin for the given position is found, the
 * plugin code file gets included and the result is displayed using
 * the themeplugin function.
 *
 * Module Numbers system
 * 0  - Off
 * 1  - Left
 * 2  - Topcenter
 * 3  - Right
 * 4  - Middlecenter
 * 5  - Bottomcenter
 * 6  - Left & Topcenter
 * 7  - Left & Middlecenter
 * 8  - Left & Bottomcenter
 * 9  - Left & Right
 * 10 - Topcenter & Middlecenter
 * 11 - Topcenter & Bottomcenter
 * 12 - Topcenter & Right
 * 13 - Middlecenter & Bottomcenter
 * 14 - Middlecenter & Right
 * 15 - Bottomcenter & Right
 * 16 - Left & Topcenter & Right
 * 17 - Left & Middlecenter & Right
 * 18 - Left & Bottomcenter & Right
 * 19 - Topcenter & Middlecenter & Right
 * 20 - Topcenter & Bottomcenter & Right
 * 21 - Middlecenter & Bottomcenter & Right
 * 22 - Topcenter & Middlecenter & Left
 * 23 - Topcenter & Bottomcenter & Left
 * 24 - Middlecenter & Bottomcenter & Left
 * 25 - Topcenter & Middlecenter & Bottomcenter
 * 26 - Left & Topcenter & Middlecenter & Right
 * 27 - Left & Topcenter & Bottomcenter & Right
 * 28 - Left & Middlecenter & Bottomcenter & Right 
 * 29 - Topcenter & Middlecenter & Bottomcenter & Right
 * 30 - Topcenter & Middlecenter & Bottomcenter & Left
 * 31 - All
 *
 * @param int plugin block position
 * @param colcheck : use columns check (used in theme header and footer)
 * @param colstatus : current column status: 1=initialized 0=to be initialized
 * @param colcode : XHTML code needed to initialize current column
 * @return colstatus if colcheck>0, elseway anything
 */
function plug_check($position,$colcheck,$colstatus,$colcode)
{
	global $admintest;
	include('config.php');					// $table_prefix variable

	switch($position)
	{
		case "left":
		case "1":
		$plug_mysql = mysql_query("select name, plug_dir, block_file, admin_only, user_only from " . $table_prefix."modules "
		." where block_pos IN (1,6,7,8,9,16,17,18,22,23,24,26,27,28,30,31)");
		break;

		case "topcenter":
		$plug_mysql = mysql_query("select name, plug_dir, block_file, admin_only, user_only from " . $table_prefix."modules "
		." where block_pos IN (2,6,10,11,12,16,19,20,22,23,25,26,27,29,30,31)");
		break;

		case "right":
		case "3":
		$plug_mysql = mysql_query("select name, plug_dir, block_file, admin_only, user_only from " . $table_prefix."modules "
		." where block_pos IN (3,9,13,14,15,16,17,18,19,20,21,26,27,28,29,31)");
		break;

		case "middlecenter":
		$plug_mysql = mysql_query("select name, plug_dir, block_file, admin_only, user_only from " . $table_prefix."modules "
		." where block_pos IN (4,7,10,13,14,17,19,21,22,24,25,26,28,29,30,31)");
		break;

		case "bottomcenter":
		$plug_mysql = mysql_query("select name, plug_dir, block_file, admin_only, user_only from " . $table_prefix."modules "
		." where block_pos IN (5,8,11,13,15,18,20,21,23,24,25,27,28,29,30,31)");
		break;

        	case "userpage_only":
        	$userpage_flag = 1;
        	$plug_mysql = mysql_query("select name, plug_dir, block_file, admin_only, user_only from " . $table_prefix."modules "
		." where block_pos = '32'");
        	break;
	}

	if (mysql_num_rows($plug_mysql) > 0)
	{
		if($colcheck && (!$colstatus || $colstatus=="0") && $position != "userpage_only")
	    	{
			echo "$colcode";
			$colstatus="1";
        	}

		while ($row = mysql_fetch_array($plug_mysql))
		{
			$box_title = "";
			$box_content = "";
			extract($row);
			if ((($admintest && !$user_only) || (!$admintest && !$admin_only)) || $user_only)
			{
			  	/**
		   		* The plugin code file. Checks to see if plugin actually exists on server.
		   		*/
				if (file_exists("mod/$plug_dir/$block_file"))
				{
                    			include ("mod/$plug_dir/$block_file");
                    			if(!$box_title)		$box_title = $name;
                    			if($box_content)
                    			{
                        			if($userpage_flag && $position == "userpage_only")
                        			{
							if(!$colstatus) echo "$colcode";

							$userpage_flag == 0;
							$colstatus="1";				
                        			}

                        			themeplugin($box_title, $box_content);
                    			}
				}
            		}
        	}
    	}

	if($colcheck)
		return $colstatus;
}


/**
 * Outputs the given parameters somehow &quot;formatted&quot;
 *
 * The given parameters are checked for containing html breaks,
 * headings or paragraph tags. If no tags are found, newlines are
 * replaced by html break tags, otherwise the input is used as is.
 *
 * The input is then printed seperated by to html break tags if the
 * following variable is not empty.
 *
 * @param string The title of the part.
 * @param string The lead-in text.
 * @param string The optional main text.
 * @param string The optional notes text.
 */
function themepreview($title, $hometext, $bodytext="", $notes="")
{
	$previewtext= "<b>$title</b><br /><br />";

	if (!strstr ($hometext, '<p') && !strstr ($hometext, '<table') && !strstr ($hometext, '<br') && !strstr($hometext, '<h'))
	$previewtext .= str_replace ("\n" , "<br />", $hometext);
	else
	$previewtext .= "$hometext";

	if (strlen($bodytext))
	$previewtext .= "<br /><br />";

	if (!strstr ($bodytext, '<p') && !strstr ($bodytext, '<table') && !strstr ($bodytext, '<br') && !strstr($bodytext, '<h'))
	$previewtext .= str_replace ("\n" , "<br />", $bodytext);
	else
	$previewtext .= "$bodytext";

	if (strlen($notes))
	$previewtext .= "<br /><br />";

	if (!strstr ($notes, '<p') && !strstr ($notes, '<table') && !strstr ($notes, '<br') && !strstr($notes, '<h'))
	$previewtext .= str_replace ("\n" , "<br />", $notes);
	else
	$previewtext .= "$notes";
	return $previewtext;
}


/**
 * Increments the totalhits counter in the vars table by one.
 */
function counter()
{
	include('config.php');
	mysql_query("UPDATE " . $table_prefix."vars SET value=value+1 where name='totalhits'");
}

/**
 * base64_decodes the given string and returns the contents as an array.
 *
 * The given parameter is decoded using base64_decode and then
 * exploded at : (colon). The resulting array is returned.
 *
 * @param string user settings cookie data
 * @return array decoded user settings
 */
function cookiedecode($user)
{
	global $cookie;
	$user = base64_decode($user);
	$cookie = explode(":", $user);

	return $cookie;
}

function getusrinfo($user)
{
	include("config.php");
	global $userinfo;

	$user2 = base64_decode($user);
	$user3 = explode(":", $user2);
	if ($user_dblocation)
	{
		@mysql_select_db("$user_dbname") or die ("Impossvel selecionar o Banco de Dados");
		$result = mysql_query("select uid, name, uname, email, femail, url, pass, storynum, umode, uorder, thold, noscore, bio, ublockon, ublock, theme, commentmax from " . $table_prefix."users where uname='$user3[1]' and pass='$user3[2]'");
		@mysql_select_db("$dbname") or die ("Impossvel selecionar o Banco de Dados");
	}
	else
	{
		$result = mysql_query("select uid, name, uname, email, femail, url, pass, storynum, umode, uorder, thold, noscore, bio, ublockon, ublock, theme, commentmax from " . $table_prefix."users where uname='$user3[1]' and pass='$user3[2]'");
	}

	if(mysql_num_rows($result)==1)
		$userinfo = mysql_fetch_array($result);
	else
		$userinfo = "";
	return $userinfo;
}

function FixQuotes ($what = "")
{
	$what = ereg_replace("'","''",$what);

	while (eregi("\\\\'", $what))
	{
		$what = ereg_replace("\\\\'","'",$what);
	}
	return $what;
}

/**
 * This is an attempt to clean up the referer function.
 *
 * @param string URL to insert into referer table
 * @author: Matt McNaney
 */
function new_url($url)
{
  /**
   * The global configuration file.
   */
  include ("config.php");

  $test_home = str_replace ("http://", "", $phpws_url);
  $test_url = str_replace ("http://", "", $url);
  if (eregi("^$test_home", "$test_url") || eregi("^www.$test_home", "$test_url")){
    return;
  }
  $sql_result = mysql_query ("select ref_id from " . $table_prefix."new_referer where url LIKE '$url'");

  // Found match
  if (mysql_num_rows($sql_result)){
    list($ref_id)=mysql_fetch_row($sql_result);
    mysql_query("update " . $table_prefix."new_referer set hit_total=hit_total+1, time='" . date("Y-m-d G:i:s") . "' where ref_id=$ref_id");
  }

  // Did not find match
  else{
    mysql_query("lock tables " . $table_prefix."new_referer WRITE");
    mysql_query("insert into " . $table_prefix."new_referer (url, hit_total, time) values ('$url', '1','" . date("Y-m-d G:i:s") . "')");
    mysql_query("unlock tables");
  }
}



/**
 * Filters bad words from the given string.
 *
 * The given string is checked for bad words found in the CensorList
 * array defined in the global configuration file. According to the
 * CensorMode setting matches are found at the beginning of words, as
 * a fragment or as exact match.
 *
 * Any bad word that was found is replaced by the CensorReplace
 * variable.
 *
 * @param string the message to be filtered.
 * @return string the censored message.
 * @todo convert to using preg_replace. check whether including config.php is necessary.
 */
function check_words($Message)
{
	global $EditedMessage;
	/**
	* The global configuration file.
	*/
	include("config.php");

	$res = mysql_query("select censor_mode,censor_replace,censor_list from ".$table_prefix."flags");
	list($CensorMode,$CensorReplace,$tmp_censorlist) = mysql_fetch_row($res);

	$CensorList = explode(',',str_replace("word/","",stripslashes($tmp_censorlist)));

	$EditedMessage = $Message;

	if ($CensorMode > 0)
	{
    		if (is_array($CensorList))
		{
			$Replacement = $CensorReplace;

			if ($CensorMode == 1)
			{                                // Exact match
				$RegExPrefix   = '([^[:alpha:]]|^)';
				$RegExSuffix   = '([^[:alpha:]]|$)';
			}
			elseif ($CensorMode == 2)
			{				// Word beginning
				$RegExPrefix   = '([^[:alpha:]]|^)';
				$RegExSuffix   = '[[:alpha:]]*([^[:alpha:]]|$)';
			}
			elseif ($CensorMode == 3)
			{		// Word fragment
				$RegExPrefix   = '([^[:alpha:]]*)[[:alpha:]]*';
				$RegExSuffix   = '[[:alpha:]]*([^[:alpha:]]*)';
			}

			for ($i = 0; $i < count($CensorList); $i++)
			{
				$EditedMessage = eregi_replace("$RegExPrefix$CensorList[$i]$RegExSuffix","\\1$Replacement\\2",$EditedMessage);
			}
    		}
  	}
	return ($EditedMessage);
}


function allowed_html_list($mode='')
{
	include("config.php");

	$result = mysql_query("SELECT allowed_html FROM " . $table_prefix."flags");
        list($tmp) = mysql_fetch_row($result);
	$len=strlen($tmp);
	 
	if(!len)
	   return '';

	$allowed_html = explode(',',stripslashes($tmp));

	while($list = each($allowed_html))
	  {
	  list($tag,$tagmode) = explode('=',$list[1]);

	  if(empty($mode))
		$out .= "&lt;$tag&gt;, ";
	  else if($mode=='nosym')
		$out .= "$tag, ";
	  else if($mode=='comments')
		if($tagmode<90) $out .= "&lt;$tag&gt;, ";
	  }

	return substr($out,0,strlen($out)-2);
}

/*
//
// Disabled: Required by the old version of check_html()
//

function _check_html_find_tag_mode($needle,$haystack)
{
while($tmp = each($haystack))
  {
  list($tag,$mode) = explode('=',$tmp[1]);
  if(!strcasecmp($tag,$needle))
        return $mode; 
  }

return 0;
}

//
// Disabled: new implementation follows below (11/feb/2002 - alextxm)
//
function check_html ($str, $strip="")
{
	include("config.php");

	if ($strip == "nohtml")
	 $len=0;
	else {
	 $result = mysql_query("SELECT allowed_html FROM " . $table_prefix."flags");
         list($tmp) = mysql_fetch_row($result);
	 $len=strlen($tmp);

	 if($len) {
	   if($strip != "comments")
	     $allowed_html = explode(',',stripslashes($tmp));
	   else 
		{
		$tmp_allowed_html = explode(',',stripslashes($tmp));
		$allowed_html=array();
		while($tmp = each($tmp_allowed_html))
			{
			list($tag,$tagmode)=explode('=',$tmp[1]);
			if($tagmode<90) array_push($allowed_html,$tmp[1]);
			}
		}
	   }
	 }

	$str = stripslashes($str);
	$str = eregi_replace("<[[:space:]]*([^>]*)[[:space:]]*>","<\\1>",$str);
	$tmp = "";

	while (eregi("<([^> ]*)([^>]*)>",$str,$reg))
	{
		$i = strpos($str,$reg[0]);
		$l = strlen($reg[0]);

		$limit=-1;
		for($j=0;$j<count($reg);$j++) {
		 if(!strlen($reg[$j])) {
			$limit=$j-1;
			break;
			}
		 }

		if ($reg[1][0] == "/") $tag = strtolower(substr($reg[1],1));
		else $tag = strtolower($reg[1]);

		if ($len && ($a = _check_html_find_tag_mode($tag,$allowed_html)))
		{
			if($reg[1][0] == "/")
			 $endtag = ">";
			else {
			 if($reg[$limit][strlen($reg[$limit])-1]=="/")
			  $endtag = " />";
			 else
			  $endtag = ">";
			 }

			if ($reg[1][0] == "/") $tag = "</$tag" . $endtag;
			elseif ($a == 1) $tag = "<$tag" . $endtag;
			else {
			     $tag = "<$tag";

			     if($limit>-1) {
				if($limit>2)
				 for($i=2;$i<=$limit;$i++) {
				  $k = rtrim($reg[$i]);
				  $tag .= ($k[strlen($k)-1]=="/") ? substr($k,0,strlen($k)-1) : $k;
				  }
				else {
				  $k = rtrim($reg[2]);
				  $tag .= ($k[strlen($k)-1]=="/") ? substr($k,0,strlen($k)-1) : $k;
				  }
				}

			     $tag .= $endtag;
			     }
		}
		else $tag = "";

		$tmp .= substr($str,0,$i) . $tag;
		$str = substr($str,$i+$l);
	}
	$str = $tmp . $str;

	// Squash PHP tags unconditionally
	$str = ereg_replace("<\?","",$str);
	$str = ereg_replace("\?>","",$str);

	// fix C-like double escape chars
	$str = fix_c_escaped($str);

	return $str;
}
*/

//
// 11/feb/2002 : new check_html()
//
function check_html($str, $method='')
{
	global $admintest, $security_hash;
	include("config.php");

	if(!$str || !strlen($str)) return '';

	$result = mysql_query("SELECT allowed_html FROM " . $table_prefix."flags");
	list($tmp) = mysql_fetch_row($result);

	switch($method)
	{
		case "nohtml":
		$allowed='';
		break;

		case "comments":
		$t = explode(',',stripslashes($tmp));
		$tmp_allowed = array();
		while($t1 = each($t)) {
			list($tag,$tagmode) = explode('=',$t1[1]);
			if($tagmode<90) array_push($tmp_allowed,$tag);
			}
		break;

		default:
		$t = explode(',',stripslashes($tmp));
		$tmp_allowed = array();
		while($t1 = each($t)) {
			list($tag,) = explode('=',$t1[1]);
			array_push($tmp_allowed,$tag);
			}
		break;
	}

	// always allow comments
	if($method != "nohtml")
	 array_push($tmp_allowed,"<!--");

	if(count($tmp_allowed))
	 {
	 while($t = each($tmp_allowed))
		{
		// Only allow <script> if admin required it and only in pages
                // (not in comments)
		if(strcasecmp($t[1],"script"))
		 $allowed .= "<$t[1]>";
		else
		   {
		   if(($admintest == $security_hash) && ($method != "comments"))
		    $allowed .= "<$t[1]>";
		   }
		}
	 }

	// "<  tag>" -> "<tag>"
	$str = eregi_replace("<[[:space:]]*([^>]*)[[:space:]]*>","<\\1>",$str);

	// "< / tag> -> "</tag>"
	$str = eregi_replace("</[[:space:]]*([^>]*)>","</\\1>",$str);

	// "<tag  > -> "<tag>
	$str = eregi_replace("[[:space:]]*>",">",$str);

	// "<tag / > -> "<tag />"
	$str = eregi_replace("[[:space:]]*/[[:space:]]*>"," />",$str);

	/* 
	special cases: "</tag />" -> "</tag>" (for tags with name<=4 chars)
                       "</tag />" -> "<tag />" (for tags with name>=5 chars)

	This may cause some tags to be transformed wrongly, btw it should work
	with most frequent cases.
	*/
	$str = eregi_replace("</([^>]{1,4})[[:space:]]{1}/>", "</\\1>", $str);
	$str = eregi_replace("</([^>]{5,})[[:space:]]{1}/>", "<\\1 />", $str);

	$str = strip_tags($str, $allowed);

        // Squash PHP tags unconditionally
        $str = ereg_replace("<\?","",$str);
        $str = ereg_replace("\?>","",$str);

	// Squash also ASP-style PHP tags unconditionally, if enabled
	if(!strcasecmp(get_cfg_var("asp_tags"),"on"))
	{
        $str = ereg_replace("<\%","",$str);
        $str = ereg_replace("\%>","",$str);
	}

	// fix bad CR/LF
	$str = fix_bad_crlf($str);

        // fix C-like double escape chars
        $str = fix_c_escaped($str);

	return $str;
}


function fix_bad_crlf($str)
{
$check = (phpversion() < "4.1.0") ? $HTTP_SERVER_VARS[SERVER_SOFTWARE] : $_SERVER[SERVER_SOFTWARE];

if(substr_count($check,"nix") || substr_count($check,"nux"))
	return implode( '', explode( chr(0x0d), $str ) );
else
	return $str;
}

function fix_c_escaped($str)
{
	$new = str_replace("\\n","\n",$str);
	$new = str_replace("\\t","\t",$new);
	$new = str_replace("\\n","\n",$new);
	$new = str_replace("\\0","\0",$new);

	// ignore these
	$new = str_replace("\\r","",$new);
	$new = str_replace("\\a","",$new);
	$new = str_replace("\\b","",$new);
	$new = str_replace("\\v","",$new);

	return $new;
}

/**
 * Performs censoring and filtering of html on the given message.
 *
 * The given string is checked for bad words using the check_words
 * function. Afterwards it is cleaned from illegal html tags using
 * check_html.
 *
 * @param string The message to be filtered.
 * @param string Whether to strip HTML or not (&quot;&quot; or &quot;nohtml&quot;).
 * @return string The filtered message.
 * @see check_html(), check_words()
 * @todo CLEAN UP!
 */
function filter_text($Message, $strip="")
{
	global $EditedMessage;

	check_words($Message);
	$EditedMessage=check_html($EditedMessage, $strip);
	$EditedMessage=check_words($EditedMessage);
	return ($EditedMessage);
}

///////////////////////////////////////////////////////////////////////
// functions for formatting stories.
///////////////////////////////////////////////////////////////////////

/**
 * Formats a given timestamp according to locale configured in global configuration file.
 *
 * @param string Timestamp YYYY-MM-DD
 * @return string Natural language representation of input.
 * @todo convert to preg_match
 */
function formatTimestamp($time)
{
  /**
   * The global configuration file.
   */
  include ("config.php");
  global $datetime;

  setlocale ("LC_TIME", "$locale");

  ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime);
  $datetime = strftime("%A %d %B @ %H:%M:%S", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
  $datetime = ucfirst($datetime);

  return($datetime);
}

function oldNews($storynum)
{
  /**
   * The global configuration file.
   */
	include ("config.php");
	$boxstuff = "";
	$boxTitle = "TRANSLATE[[Past Announcements]]";

        $result = mysql_query("SELECT oldnum FROM " . $table_prefix."flags");
        list($oldnum) = mysql_fetch_row($result);

	$result = mysql_query("select sid, title, time, comments from " . $table_prefix."stories order by time desc limit $storynum, $oldnum");
	while(list($sid, $title, $time) = mysql_fetch_row($result))
	{
		if ($title != "") {
		$doitman = "yes";
		}

		$count1 = "0";
		setlocale ("LC_TIME", "$locale");
		ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime2);
		$datetime2 = strftime("%B %d", mktime($datetime2[4],$datetime2[5],$datetime2[6],$datetime2[2],$datetime2[3],$datetime2[1]));
		$datetime2 = ucfirst($datetime2);
		if ($datetime2 != $time2){
		  $boxstuff .= "$datetime2<br />";
		}
			$boxstuff .= "<a href=\"article.php?sid=$sid\">$title";
			$boxstuff .= "</a><br /><br />";
			$time2 = $datetime2;

		}
			if ($doitman == "yes") {
				thememainbox($boxTitle, $boxstuff);
					}
}

function adminblock()
{
	include('config.php');
	$result = mysql_query("select title, content from " . $table_prefix."adminblock");

	while(list($title, $content) = mysql_fetch_array($result))
	{
		$content = str_replace("\n", "<br />", $content);
		themesidebox($title, $content);
	}
}

function getTopics($s_sid)
{
	include('config.php');
	global $topicname, $topicimage, $topictext;

    	$sid = $s_sid;
    	$result=mysql_query("SELECT topic FROM " . $table_prefix."stories where sid=$sid");
    	list($topic) = mysql_fetch_row($result);
    	$result=mysql_query("SELECT topicid, topicname, topicimage, topictext FROM " . $table_prefix."topics where topicid=$topic");
    	list($topicid, $topicname, $topicimage, $topictext) = mysql_fetch_row($result);
}

function date_select($month, $day, $year)
{
	include("config.php");
	setlocale ("LC_TIME", "$locale");

	$select_date = "";
	if (!$month){
		$month = date(m);
		$day = date(d);
		$year = date(Y);
		$oneweek = mktime(0,0,0,$month, $day + 7, $year);
	}else
		$oneweek = mktime(0,0,0,$month, $day, $year);

	$select_date .= "
	<select name=\"month\">\n";

	for($i=1; $i<13; $i++)
	{
		$select_date .= "<option value=\"".date(m, mktime(0,0,0,$i,1))."\"";
				if (date(m, mktime (0,0,0, $i,1)) == date(m, $oneweek))
					$select_date .= " selected=\"selected\"";

				$select_date .= ">".date("F", mktime(0,0,0,$i,1))."</option>\n";
	}

	$select_date .= "</select>
	<select name=\"day\">
	";

	for($i=1; $i<32; $i++)
	{
		$select_date .= "<option value=\"".date(d, mktime(0,0,0,1,$i))."\"";
				if (date(j, mktime(0,0,0,1,$i)) == date(j, $oneweek))
					$select_date .= " selected=\"selected\"";

				$select_date .= ">".date("d", mktime(0,0,0,1,$i))."</option>\n";
	}
	$select_date .= "</select>
	<select name=\"year\">
	";

	for($i=$year, $j=$year+5; $i < $j; $i++)
	{
		$select_date .= "<option value=\"".date(Y, mktime(0,0,0,1, 1, $i))."\"";
		if (date(Y, mktime(0,0,0,1,1,$i)) == date(Y, $oneweek))
			$select_date .= " selected=\"selected\"";

		$select_date .= ">".date("Y", mktime(0,0,0,1,1,$i))."</option>\n";
	}

	$select_date .= "</select>\n";

	return $select_date;
}

/**
 * Allows page to ignore cache and reload page after an amount of time
 *
 * Original idea from Michael T. Babcock (mbabcock@fibrespeed.net)
 *
 */
function CacheControl()
{
	include("config.php");

	$result = mysql_query("SELECT limit_cache FROM ". $table_prefix."flags");
	list($limit_cache) = mysql_fetch_row($result);

	if ($limit_cache){

		header ("Pragma: no-cache");
		header ("Cache-Control: no-cache, must-revalidate, max_age=0");
		header ("Expires: 0");
	}
}

/*
function help($name) {
	$name = str_replace(" ", "%20", $name);
	$return_value = "
	<script type=\"text/javascript\">
		function launch()
		{
			open('help.php?op=search&name=$name','help','resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=no,menubar=no,width=500,height=300')
		}
	</script>
	[ <a href=\"javascript:launch()\">TRANSLATE[[Help]]</a> ]";

	return $return_value;
}
*/

include_once("htmlheader.php");

function magic_check($quotable)
{
        if (get_magic_quotes_gpc())
        {
                return stripslashes($quotable);
        }
        else
        {
                return addslashes($quotable);
        }
}


function list_existing_images($path)
{
	include("config.php");
	
	$result = mysql_query("SELECT allowed_imgs FROM " . $table_prefix."flags");

	if(!$result) return $imagesarray;

	list($allowed_imgs) = mysql_fetch_row($result);
	$allowed_array = explode(",", $allowed_imgs);
	foreach ($allowed_array as $key=>$value){
	  $allowed_array[$key] = str_replace("image/", ".", $value);
	}

	if (in_array(".jpeg", $allowed_array))
	  $allowed_array[] = ".jpg";

	if (is_dir($path)){
	  $dir = dir($path);
	  while($file = $dir->read()){
	    if (!is_dir($path.$file) && in_array(stristr($file, '.'), $allowed_array)){
	      $imagesarray[] = $file;
	      $found_one = 1;
	    }
	  }
	  $dir->close();
	}
	return $imagesarray;
}


/**
 * Robot for building forms' option or radio tags
 * this function will automatically generate XHTML forms
 *
 * @param useecho: 1=use echo else use a string
 * @param type: "option" or "radio"
 * @param name: control name
 * @param options_and_values: array of couples (value, label)
 * @param selected: selected element (example: 2 = 2nd element)
 *
 * @return a string if i$output!=0, false or '' on error
 * @author: Alessandro Pisani
 */
function form_options($useecho,$type,$name,$options_and_values,$selection)
{
$outstring='';

// need to be an array of couples (value,label)
if(!is_array($options_and_values) || !array_count_values($options_and_values) ||($how=count($options_and_values))%2)
  return ($useecho) ? false : '';

$select = ($type=="radio") ? "checked=\"checked\"" : "selected=\"selected\"";

switch(($type=strtolower($type))) {
 case "radio":
  $select = "checked=\"checked\"";
  $type = "<input type=\"radio\" name=\"$name\"";
  $endtype = "/>";
  $compose_flag=1;
  break;

 case "option":
  $select = "selected=\"selected\"";
  $type = "<option";
  $endtype = "</option>";
  $compose_flag=0;
  break;

 default:
  return ($useecho) ? false : '';
 }


if(!$compose_flag)
 {
 if($useecho)
	echo "<select name=\"$name\">\n";
 else
	$outstring .= "<select name=\"$name\">\n";
 }

for ($i=0; $i<$how/2; $i++)
{
$val = $options_and_values[$i*2];
$lab = $options_and_values[($i*2)+1];

if($selection==$val)
 {
	if(!$compose_flag)
         {
	 if($useecho)
	        echo "$type value=\"$val\" $select>$lab$endtype\n";
	 else
	        $outstring .= "$type value=\"$val\" $select>$lab$endtype\n";
         }
	else
         {
	 if($useecho)
	        echo "$type value=\"$val\" $select $endtype>$lab<br />\n";
	 else
		{
	        $outstring .= "$type value=\"$val\" $select $endtype$lab";
		if(($how/2) > 2) echo "<br />\n";
		else echo "\n";
		}
         }
 }
else
 {
	if(!$compose_flag)
         {
	 if($useecho)
	        echo "$type value=\"$val\">$lab$endtype\n";
	 else
	        $outstring .= "$type value=\"$val\">$lab$endtype\n";
         }
	else
         {
	 if($useecho)
	        echo "$type value=\"$val\" $endtype>$lab<br />\n";
	 else
		{
	        $outstring .= "$type value=\"$val\" $endtype$lab";
		if(($how/2) > 2) echo "<br />\n";
		else echo "\n";
		}
         }
 }
} // end for

if(!$compose_flag)
 {
 if($useecho)
	echo "</select>\n";
 else
	$outstring .= "</select>\n";
 }

if(!$useecho)
 return "$outstring";

} // end form_options()


// array_search function if phpversion is lower than php 4.0.5
if ( phpversion() < "4.0.5" )
{
        function array_search($needle, $haystackA)
        {
                if (in_array ($needle, $haystackA))
                {
                        foreach ($haystackA AS $key => $value)
                        {
                                if (ereg ($needle, $value))
                                {
                                        return $key;
                                }
                        }
                }
                else
                {
                        return FALSE;
                }
        }
}         // end of array_search function inclusion for php < 4.0.5


/**
 * Return a list of all installed modules,plugins and coremodules
 * 
 * Return a list of all installed modules,plugins and coremodules
 *
 * @author Alessandro Pisani <alextxm@users.sourceforge.net>
 */
function modules_list()
{
        include("config.php");

        // create modules/plug-ins list
        $result = mysql_query("SELECT plug_dir from " . $table_prefix."modules");
        if(!$result) $list = "";
        else
         while(list($v,)=mysql_fetch_row($result))
                $list .= "$v,";

        // create core modules list
        $result = mysql_query("SHOW TABLES");

        while(list($v,) = mysql_fetch_row($result)) {
         if(!strcasecmp(substr($v,0,4),"mod_"))
                $chk = "$v:mod_";
         else if(!strcasecmp(substr($v,0,5),"core_"))
                $chk = "$v:core_";
         else
                $chk = "";

         if(strlen($chk))
                {
                list($val,$mod) = explode(':',$chk);
		list(,$tmp) = explode($mod,$val);

		if(substr_count($tmp,"_"))
		 list($final,) = explode('_',$tmp);
		else
		 $final = $tmp;

		if(!substr_count($list,$final))
		 $list .= "$final,";
                }
         }
         
	$list = substr($list,0,strlen($list)-1);
	return $list;
}

function convert_to_links ($i_text)
{
 // This function converts web addresses and email addresses to
 //  hot links   If the text already contains a web link, the text
 // is returned unchanged
    // :w! ~/www/demo3/mainfile.php
    if ( preg_match("#<a *href.*http://.*>#i",$i_text) )
    { return $i_text; } 

    $v_text =
    preg_replace("/([^\w\/])(www\.[a-z0-9\-]+\.[a-z0-9\-]+)/i",
    "$1http://$2",
    $i_text); //make sure there is an http:// on all URLs

    $v_text =
    preg_replace("/([\w]+:\/\/[\w-?&;#~=\.\/\@]+[\w\/])/i",
    "<A TARGET=\"_blank\"
    HREF=\"$1\">$1</A>",
    $v_text); //make all URLs links

    if (!preg_match("#mailto:#",$v_text)) {
      $v_text =
      preg_replace("/([\w-?&;#~=\.\/]+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?))/i",
      "<A HREF=\"mailto:$1\">$1</A>",
      $v_text); //make all emails hot links
    }
    return $v_text;

}

?>
