<?php

/**
 * text Import/Export functions
 *
 * @version $Id: importexport.php,v 1.5 2002/02/16 21:13:37 alextxm Exp $
 * @package phpWebSite
 * @module importexport 
 * @modulegroup administration
 * @author Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 */

/*
 * Display the Import/Export control-panel in a page
 *
 * requires:
 * ifield=import field name
 * imfield=import mode field name
 * iscfield=import strict check field name
 * submitop=submit op field name
 * esource=export source
 * noexport=if set to 1 export-ui will not be displayed
 * eparams=export extra params
 */
function display_importexport_controls($ifield,$imfield,$iscfield,$submitop,$esource,$noexport,$eparams="")
{
	if($noexport && (!strlen($esource)))
	 return '';

        /* Import/export feature */
        $content = "<br />TRANSLATE[[Import contents from file]]
        <input type=\"file\" name=\"$ifield\" maxlength=\"80\" size=\"40\" />
        <br />
        TRANSLATE[[Import options]] [  TRANSLATE[[Mode]] : ";

        $content .= form_options(0,"option",$imfield,array("append","TRANSLATE[[Append]]","replace","TRANSLATE[[Replace]]"), "append");

        $content .= "|&nbsp;TRANSLATE[[Strict types check]] : <input type=\"checkbox\" name=\"$iscfield\" value=\"1\" checked=\"checked\"> ]
        <br />
        <input type=\"submit\" name=\"$submitop\" value=\"TRANSLATE[[Import contents]]\" />
        <br /><br />";

	if($noexport) return $content;

        // check if we need to convert \n to unix format or not
        $agent = (phpversion() > "4.1.0") ? $_SERVER[HTTP_USER_AGENT] : $HTTP_SERVER_VARS[HTTP_USER_AGENT];
        $conv = (!eregi("Win", $agent) && !eregi("Mac", $agent)) ? 0 : 1;

	$mod = (substr_count($esource,"?")) ? "&amp;" : "?";

	if(strlen($eparams))
	{
	$eparams = htmlspecialchars($eparams);
	if(strcasecmp(substr($eparams,0,5),"&amp;")) $eparams="&amp;$eparams";
	}

        $content .= "<a href=\"$esource$mod"."op=export&amp;export_mode=1&amp;conv=$conv$eparams\" target=\"_blank\">TRANSLATE[[Export in browser]]</a>&nbsp;-&nbsp;
        <a href=\"$esource$mod"."op=export&amp;export_mode=0&amp;conv=$conv$eparams\" target=\"_blank\">TRANSLATE[[Export as file]]</a><br />
	<br /><br />\n\n";

	return $content;
}


/*
 * Internal function which retrieves the target obj to be exported
 *
 * requires:
 * $location = string "dbtable:dbfield"
 * $id = id, if not applicable use FALSE
 * $oo_obj = if set to 1, obj will be considered an OO object
 * $objdesc = if oo_obj=1, string: "classname:" or "classname:classmember"
 */
function _export_retrieve_obj($location,$id,$oo_obj,$objdesc)
{
	include("config.php");

	list($table,$field) = explode(':',$location);
	if($oo_obj) list($objclass,$objmember) = explode(':',$objdesc);

	if(!strlen($objclass)) return NULL;

	$queryparam = ($id!==FALSE) ? "where id='$id'" : "";
	$result = mysql_query("SELECT $field FROM " . $table_prefix."$table $queryparam");

	if(!$result) return NULL;

	if($oo_obj) $tmpobj = new $objclass;
	list($data) = mysql_fetch_row($result);
	$tmpobj = ($oo_obj) ? unserialize($data) : $data;

	if($oo_obj && strlen($objmember))
	 return $tmpobj->$objmember;
	else
	 return $tmpobj;
}


/*
 * Export a text/HTML object 
 *
 * requires: 
 * object=source to be exported - this can also be a export_retrieve_obj() resource (see export_retrieve_obj() for more info)
 * mode=in broswer or as a file [automatically set by display_importexport_controls]
 * convert=change \n in dos format if needed [automatically set by display_importexport_controls]
 * hint= 1 for HTML output, 0 for plaintext output
 */
function export($object, $mode, $convert, $hint)
{
if(is_array($object)) {
 list($location,$id,$oo_obj,$objdesc) = $object;
 $object = _export_retrieve_obj($location,$id,$oo_obj,$objdesc);
 }

if($object==NULL) return;

if ($mode)
 $type = ($hint) ? 'text/html' : 'text/plain';
else
 $type = "application/octet-stream"; // dirty trick

header( "Content-type: $type" );

if (!$convert)
 echo $object;
else
 echo implode( '', explode( chr(0x0d), $object ) );
}


/*
 * Wrap around import() to deal with simply cases (i.e. mainpage)
 * requires: see import();
 */
function import_no_extra(&$target, $file, $strictcheck, $type, $size, $mode)
{
 $nullvar="-1";
 import($target, $file, $strictcheck, $type, $size, $mode, $nullvar, $nullvar, $nullvar);
}


/*
 * generalized import function
 *
 * requires:
 * target=where to import
 * file, strictcheck, type, size, mode= [automatically set by display_importexport_controls]
 * targetid_var = id
 * target_activation_var = need to activate target ?
 * target_swtcher_var = need to switch target type ?
 *
 * notes:
 * to deactivate the last three options (targetXXXX_var) see import_no_extra();
 */
function import(&$target, $file, $strictcheck, $type, $size, $mode, &$targetid_var, &$target_activation_var, &$type_switcher_var)
{
        global $error_type;

	include("config.php");

	if($targetid_var!="-1")
	 {
	 global $error_section;
	 $error_section = $targetid_var + 1;
	 }

        if($file && $file != "none" && $file != "")
        {
                $res = mysql_query("select allowed_imports,max_import_size from ".$table_prefix."flags");
                list($import_allowed_types,$max_import_size) = mysql_fetch_row($res);

                if($size > $max_import_size)
                {
                        $error_type = "file_size";
                        return;
                }

                if($strictcheck && !substr_count($import_allowed_types,$type)) 
                {
                        $error_type = "file_type";
                        return;
                }

                if($error_type != 'file_size' && $error_type != 'file_type')
                {
                        $fd=fopen($file,"r");
                        $contents = fread ($fd, $size);
                        fclose ($fd);

                        $contents = check_html($contents);

                        if ($mode == 'replace')
        			$target = $contents;
                        else
				$target .= $contents;        			

                        // adding HTML to PlainText turns all into HTML
                        if (($temp_type == 'text/html') && $type_switcher_var!="-1")
				$type_switcher_var = 1;

                        // import activate page
			if($target_activation_var!="-1")
				{
                        	if ($error_type == 'text')
                                        $error_type == 'none';

				$target_activation_var = 1;
				}
                }
        }
}


/*
 * Check for errors during import
 *
 * requires: output string container, error_variable to be parsed, [id]
 * 
 */
function check_import_errors(&$out, $errorvar, $id=-1)
{
	include("config.php");

        $res = mysql_query("select allowed_imports,max_import_size from ".$table_prefix."flags");
        list($import_allowed_types,$max_import_size) = mysql_fetch_row($res);

	switch($errorvar)
	{
                case "file_size":
		if($id>-1)
                $out = "TRANSLATE[[The file you selected for import]] TRANSLATE[[in section]] <b>$error_section</b> TRANSLATE[[is too large]]!<br />
                TRANSLATE[[The largest file size allowed on this server is]] $max_import_size TRANSLATE[[bytes]].<br />TRANSLATE[[Please select a smaller file to import now]].";
		else
                $out = "TRANSLATE[[The file you selected for import]] TRANSLATE[[is too large]]!<br />
                TRANSLATE[[The largest file size allowed on this server is]] $max_import_size TRANSLATE[[bytes]].<br />TRANSLATE[[Please select a smaller file to import now]].";
                break;

                case "file_type":
		if($id>-1)
                $out = "TRANSLATE[[You have not supplied a short description for image]] <b>$error_section</b>!<br />
                TRANSLATE[[Please enter a short description for image]] <b>$error_section</b>.";
		else
                $out = "TRANSLATE[[The file you selected for import]] TRANSLATE[[is not a valid import file type]]!<br />
                TRANSLATE[[Valid types are]]:<br /><br />$import_allowed_types<br /><br />
                TRANSLATE[[Maybe you want to try disabling the]] TRANSLATE[[Strict types check]].<br />
                TRANSLATE[[Please select a new file to import now]].";
                break;

		default:
		break;
	}
}

?>
