<?php

/**
 * Functions to list installable phpWebSite modules
 *
 * This file is included in the main admin.php administration page.
 * It provides the administrative user with an easy interface from which to
 * install any phpWebSite modules that are not currently installed.
 *
 * @version $Id: module_installer.php,v 1.29 2002/03/08 21:47:42 ryan Exp $
 * @author Philip McAllister <phil@liquidsand.co.uk>, Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 * @module module_installer
 * @modulegroup administration
 * @package phpWebSite
 */


/**
 *
 * Wrapper function for the front Admin Panel
 *
 * @author Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 */
function module_installer()
{
        $moduledirectories = findModuleDirs();

        $modulestoinstall = findNonInstalledModules($moduledirectories);

        moduleInstallLinks($modulestoinstall);
}


/**
 * A function to find module (plug-in) directories
 *
 * This small function is called to search for module directories within
 * phpWebSite's 'mod/' directory.
 *
 * It returns an array containing the directory nammes
 *
 * @author Philip McAllister <phil@liquidsand.co.uk>, Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 * @return array outputarray - Returns an array of module directories
 */
function findModuleDirs() {

  $outputarray=array();
  $prefix='./mod/';
  $uninstall="none";

  // Open the mod directory
  if ($dir = @opendir($prefix)) {

    // For each file entry in the directory
    while ($file=readdir($dir)) {
      $install = $uninstall = "";

      // If the file is a directory, is not the current or parent directories
      // and is readable

      // check only readable directories of non-core-modules and of plugins
      if(is_dir($prefix.$file)		 &&
	 $file!="."			 &&
	 $file!=".."			 &&
	 strcasecmp($file,"cvs")	 &&
	 strcasecmp($file,"blocks")	 &&
	 strcasecmp($file,"mainpage")	 &&
	 strcasecmp($file,"userpage")	 &&
	 strcasecmp($file,"poll")	 &&
	 strcasecmp($file,"weblink")	 &&
	 strcasecmp($file,"comments")	 &&
	 strcasecmp($file,"help")	 &&
	 is_readable($prefix.$file)		) {

	// check if modulename_setup.php or modulename_install.php
        // exists (and eventually take care of it)

	if(file_exists("$prefix$file/$file"."_setup.php"))
		$install="$prefix$file/$file"."_setup.php";
	else if(file_exists("$prefix$file/$file"."_install.php"))
		$install="$prefix$file/$file"."_install.php";

	//
	// This check will handle both the index.php only case and the
	// $file_setup.php/$file_install.php + index.php hybrid case
	//
	$fd = fopen("$prefix$file/index.php","r");
		 while (!feof ($fd)) {
		    $buffer = fgets($fd, 4096);
		    if(eregi("[[:space:]]*case[[:space:]]*([\'\"]){0,1}install([\'\"]){0,1}[[:space:]]*:", $buffer) || eregi("[[:space:]]*\\"."\$op[[:space:]]*==[[:space:]]*([\'\"]){0,1}install([\'\"]){0,1}", $buffer))
			{
				$install="./mod.php?mod=$file&op=install";
				break;
			}
	 	   }
	fclose ($fd);
	
	// Check if a modulename_uninstall.php exists (and eventually take care
        //  of it)
	if(file_exists("$prefix$file/$file"."_uninstall.php"))
		$uninstall="$prefix$file/$file"."_uninstall.php";
	
        
	// check for ./mod.php?mod=name&op=uninstall

	$fd = fopen("$prefix$file/index.php","r");
	while (!feof ($fd)) {
	    $buffer = fgets($fd, 4096);
	    if(eregi("[[:space:]]*case[[:space:]]*([\'\"]){0,1}uninstall([\'\"]){0,1}[[:space:]]*:", $buffer) || eregi("[[:space:]]*\\"."\$op[[:space:]]*==[[:space:]]*([\'\"]){0,1}uninstall([\'\"]){0,1}", $buffer))
		{
		$uninstall="./mod.php?mod=$file&op=uninstall";
		break;
		}
	    }
	fclose ($fd);

	// create the returned array
	if(!empty($install))
		array_push($outputarray,"$file:$install:$uninstall");
      }

    }

  } else {

    // Otherwise if we cannot change directory to ./mod/ give an error & die
    echo("TRANSLATE[[Could not read directory]] $prefix");

    die;

  }

  // Tidy up by closing the directory handle and mmoving back to the parent dir
  closedir($dir);

  // Return the list of directories
  return $outputarray;

}


/**
 * A function to find modules (plug-ins) that have not yet been installed
 *
 * This function is called with a list of module directories and returns
 * an array comprising those modules which have not yet been installed.
 *
 * @author Philip McAllister <phil@liquidsand.co.uk>, Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 * @param array filelist - An array of module directories
 * @return array outputarray - Returns an array of modules
 */
function findNonInstalledModules($filelist) {
  include("config.php");
 
  if(!is_array($filelist) || !array_count_values($filelist))
	return;

  $outputarray=array();

  // Select the directory name of each of the installed modules
  $foundmodules = mysql_query ("select plug_dir from " . $table_prefix."modules group by plug_dir");

  // If there are installed modules
  if (mysql_num_rows($foundmodules) > 0) {
    while( list($k,) = mysql_fetch_row($foundmodules) )
        $installed_list .= "$k,";

    // While we have a directory name from the './mod/' directory
    while (list ($index, $moduledir_a) = each ($filelist)) {
      list($moduledir,$install,$uninstall) = explode(':',$moduledir_a);

      // Set the variable to 0 unless it is installed
      $alreadyinstalled = 0;

      // While we have a module name from the list of installed modules
      if(substr_count($installed_list, $moduledir))
	$alreadyinstalled = 1;

      // Append already isntalled into to the array
      if (!$alreadyinstalled)
	array_push($outputarray,"$moduledir_a:0");
      else
	array_push($outputarray,"$moduledir_a:1");

      }//end while

    // Be nice and free the mySQL result
    mysql_free_result ($foundmodules);

  } else {

    // Else, if there are no installed modules, the list of module directories
    // will also be the list of modules to be installed.
    $outputarray = $filelist;

  }

  // Return the array of modules to be installed
  return $outputarray;

}


/**
 * A function to display links to set up phpWebSite modules
 *
 * This function sets the display XHTML to allow the administrator to install
 * any module, that is not currently installed, by clicking on a link.
 *
 * It takes an array of modules and calls thememainbox to display the resulting
 * XHTML.
 *
 * @author Philip McAllister <phil@liquidsand.co.uk>, Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 * @param array filelist - The list of modules that are available to be installed
 */
function moduleInstallLinks ($filelist) {
  include("header.php");
  include('config.php');                          // $table_prefix variable
  GraphicAdmin(0);

  // Set the title of the section
  $box_title = "TRANSLATE[[Modules Setup]]";

  // Set the content
  if(is_array($filelist) && array_count_values($filelist))
  {
	  $content = "TRANSLATE[[Available actions for each module are hyperlinked]]<br /><br />";

	  // For each module directory listed in $filelist
	  while (list ($index, $moduledir_a) = each ($filelist)) {
	    list($moduledir,$install,$uninstall,$alreadyinstalled) = explode(':',$moduledir_a);

	    $content .= "$moduledir: ( ";		

	    // Set the link to point to the install function for that module

	    // some modules requires conversion if upgrading from previous
	    // phpWebSite versions
	    if(!strcasecmp($moduledir,"calendar"))
		{
		$result = mysql_query("select coremods_update from " . $table_prefix."flags");

		if($result)
			list($toupdate) = mysql_fetch_row($result);
		else
			$toupdate=0;
		}
	    else
		$toupdate=0;

	    if($toupdate)
		$content .= "<a href=\"$install\">TRANSLATE[[update]]</a>";
	    else
		{
  	        if($install)
		    {
		    if($alreadyinstalled)
			    $content .= "TRANSLATE[[install]]";
		    else
			    $content .= "<a href=\"$install\">TRANSLATE[[install]]</a>";
		    }
		}

	    if($uninstall && $alreadyinstalled)
		    {
		    $content .= " | ";
		    if($uninstall=="none")
			    $content .= "TRANSLATE[[uninstall]]";
		    else
			    $content .= "<a href=\"$uninstall\">TRANSLATE[[uninstall]]</a>";
		    }

	    $content .= " ) <br />\n";
	  }
  }
  else
  {
	$content .= "TRANSLATE[[No modules found or no modules available for install]]<br />";
  }

  // Display the content
  thememainbox($box_title,$content);

  include ("footer.php");
}

?>
