<?

/*

   Autores:  Fabio Rabelo <frabelovix@ig.com.br>, Pablo Costa <pablo@shark.ib.usp.br>
   Data: 23/09/2000

   Voc pode distribuir, utilizar e alterar livremente estas rotinas desde
   que mantenha este comentrio que identifica o autor original.

   You should have received a copy of the GNU Public
   License along with this package; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

*/                  

/*

A febraban definiu a seguinte formatacao para o codigo de barras:

Posio         Contedo
1 a 3           Nmero do banco
4               Cdigo da Moeda - 9 para Real
5               Digito verificador do Cdigo de Barras
6  a 19         Valor (12 inteiros e 2 decimais)
20 a 44         Campo Livre definido por cada banco

Layout para o bradesco composto por 8 campos:

 1  | 2 | 3  |   4   |   5     | 6       |  7  |  8

237 | 9 | dv | valor | agencia |n. numero| conta| 0

1 = codigo do banco
2 = Moeda sempre 9
3 = 3 digito verificador geral
4 = valor com 14 digitos (colocar zeros a esquerda)
5 = agencia com 4 digitos
6 = nosso numero com 9 digitos
7 = conta do cedente com 7 digitos
8 = fixo zero


Ps: ate o campo 4 a regra eh a mesma para todos os bancos,
so mudando o codigo do banco.

*/


/* formatacao do numero para o codigo de barras  */

$v = ereg_replace("R\\$","",$vdoc);
$vdoc = $v;
$v = ereg_replace(chr(44),"",$v);
$valor = sprintf("%010d",$v);

/* vencimento */
if(!empty($dvence)){
$vcto = "$dvence/$mvence/$avence";
}
else {
$vence = explode("/", $vcto);
$dvence = $vence[0];
$mvence = $vence[1];
$avence = $vence[2];
$vcto = "$dvence/$mvence/$avence";
}
$fatorvcto = fatorvenc($avence,$mvence,$dvence);         

/*calculando modulo11 para o nosso numero
 ficando com 14 digitos - acrescentar o cod. da carteira ...
 com registro 19 ***** sem registro 06 ****
*/

 $ano  = date( "y", time());
 $cart = "05";
 $nnum = sprintf("%09d",$nnum);
 $nnum = "$cart$ano$nnum";
 $dv   =  dvbradesco($nnum);
 $nnum = "$nnum$dv";
 $zero = 0;

/* Montagem da agencia e conta cedente */
$agencia      = substr($agcod,0,4);
$contacedente = substr($agcod,4,7);     

$nn =  substr($nnum,0,13); //nosso numero sem o digito, com 13 caracteres
$moeda = "9";
$codbank = 237;
$dvcampo = "$codbank$moeda$fatorvcto$valor$agencia$nn$contacedente$zero"; // 43 numeros para o calculo do digito verificador *** 
$dv =  Modulo11($dvcampo);

$num = "$codbank$moeda$dv$fatorvcto$valor$agencia$nn$contacedente$zero";  // Numero para o codigo de barras com 44 digitos    

/* Devolve a linha digitavel */

$str = $num;
$linha =  MontaLinha ($str);


/*
- Codigo do banco que aparece no topo do boleto
- Devolve o codigo do banco com o seu digito verificador. Ex para 479, devolve 479-0
*/

$bankcode = ShowBankcode(237);


/*

Para os parametros abaixo vc pode estabelecer um padrao, caso
as variaves nao sejam fornecidas

*/


/* Nome do Banco */
$bank = "Bradesco";

/* cedente */
$cdte ? "":  $cdte = "PHPBoleto";

/* vencimento */
if(!empty($dvence)){
$vcto = "$dvence/$mvence/$avence";
}
else {
$datatual = Time();
$dia = (24 * 3600);
$depois = $datatual + (7 * $dia);
$vcto = date( "d/m/Y", $depois);
}


/* nosso numero */
$p1 = substr($nnum,0,2);
$p2 = substr($nnum,2,2);
$p3 = substr($nnum,4,9);
$p4 = substr($nnum,-1);
$nnum = "$p1/$p2/$p3-$p4";  

/* numero documento *
$ndoc ? "": $ndoc = "";

/* especie documento */
$edoc ? "": $edoc = "";

/* data do documento */

$useDate = Time();
$ddoc ? "": $ddoc = date( "d/m/Y", $useDate);


/* agencia/codigo cedente */
$p1 = dvbradesco($contacedente);
$agcod = "$agencia-$contacedente/$p1";

/* Valor do documento */
$vdoc ? "": $vdoc = "";

/* Valor cobrado */
$vcobr ? "": $vcobr = "";


/* Sacado */
$sacado ? "": $sacado = "";

/* CPF */
$cpf ? "": $cpf = "";

/* Local de Pagamento */
$lp ? "": $lp = "Pagavel em qualquer banco";


/* Sacador */
$sacador ? "": $sacador = "";


/* Aceite */
$act ? "": $act = "";


/* data do processamento */
$dproc ? "": $dproc = "";


/* carteira */
$cart ? "": $cart = "";


/*  Especificacao moeda */
$espmoed ? "": $espmoed = "R$";


/* quantidade */
$qtde ? "": $qtde = "";


/* valor da moeda */
$vmoed ? "": $vmoed = "";


/* descontos */
$desc ? "": $desc = "";


/* outras deducoes */
$ddc ? "": $ddc = "";


/* mora / multa */
$multa ? "": $multa = "";


/* outros acrescimos */
$acres ? "": $acres = "";


/* instrucoes */
$instr1 ? "": $instr1 = "";
$instr2 ? "": $instr2 = "";
$instr3 ? "": $instr3 = "";
$instr4 ? "": $instr4 = "";
$instr5 ? "": $instr5 = "";


/* Espcificacao do doc */
$edoc ? "": $edoc = "";

/* Uso do Banco */
$usobc ? "": $usobc = "";

?>
