<?

/*

   Autor:  Pablo Martins F. Costa <pablo@shark.ib.usp.br> 
   Data: 25/05/2000
   http://boleto.ivend.com.br 

   Voc pode distribuir, utilizar e alterar livremente estas rotinas desde
   que mantenha este comentrio que identifica o autor original.

   phpboleto: Copyright 2000 Pablo Martins F. Costa  <pablo@shark.ib.usp.br>  

   You should have received a copy of the GNU Public
   License along with this package; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

*/                             


/* 

A febraban definiu a seguinte formatacao para o codigo de barras:

Posio         Contedo
1 a 3           Nmero do banco
4               Cdigo da Moeda - 9 para Real
5               Digito verificador do Cdigo de Barras
6  a 19         Valor (12 inteiros e 2 decimais)
20 a 44         Campo Livre definido por cada banco           

Layout para o bankboston composto por 6 campos: 

 1  | 2 | 3  |   4   |   5      |      6       | 7

479 | 9 | dv | valor | convenio | nosso_numero | 9

1 = codigo do banco
2 = Moeda sempre 9
3 = 3 digito verificador geral
4 = valor com 14 digitos (colocar zeros a esquerda)
5 = convenio com o banco com 9 digitos  
6 = Numero do pedido 15 caracteres com zeros a esquerda 
7 = Numero 9 fixo


Ps: ate o campo 4 a regra eh a mesma para todos os bancos, 
so mudando o codigo do banco.

*/


/* formatacao do numero para o codigo de barras  */

$v = ereg_replace("R\\$","",$vdoc); 
$vdoc= $v;
$v = ereg_replace(chr(44),"",$v);
$valor = sprintf("%010d",$v);

/* vencimento */
if(!empty($dvence)){
$vcto = "$dvence/$mvence/$avence";
}
else {
$vence = explode("/", $vcto);
$dvence = $vence[0];
$mvence = $vence[1];
$avence = $vence[2];
$vcto = "$dvence/$mvence/$avence";
}
$fatorvcto = fatorvenc($avence,$mvence,$dvence);   

$nnum = intval($nnum);
$nn = sprintf("%015d",$nnum);	// formata o nosso numero para ter 14 campos com zeros a esquerda
$moeda = "9";
$codbank = 479;      
$dvcampo = "$codbank$moeda$fatorvcto$valor$agcod$nn$moeda"; // 43 numeros para o calculo do digito verificador
$dv =  Modulo11($dvcampo);

$num = "$codbank$moeda$dv$fatorvcto$valor$agcod$nn$moeda"; // Numero para o codigo de barras com 44 digitos


/* Devolve a linha digitavel */

$str = $num;
$linha =  MontaLinha ($str);


/* 
- Codigo do banco que aparece no topo do boleto
- Devolve o codigo do banco com o seu digito verificador. Ex para 479, devolve 479-0 
*/

$bankcode = ShowBankcode(479);  


/*

Para os parametros abaixo vc pode estabelecer um padrao, caso
as variaves nao sejam fornecidas

*/


/* Nome do Banco */
$bank = "BankBoston";

/* cedente */
$cdte ? "":  $cdte = "PHPBoleto";

/* vencimento */
if(!empty($dvence)){
$vcto = "$dvence/$mvence/$avence";
}
else {
$datatual = Time();
$dia = (24 * 3600);
$depois = $datatual + (7 * $dia);
$vcto = date( "d/m/Y", $depois);  
}


/* nosso numero */
$nnum ? "": $nnum = "";

/* numero documento *
$ndoc ? "": $ndoc = "";

/* especie documento */
$edoc ? "": $edoc = "";

/* data do documento */

$useDate = Time();
$ddoc ? "": $ddoc = date( "d/m/Y", $useDate);



/* agencia/codigo cedente */
$agcode ? "": $agcod = "";

/* Valor do documento */
$vdoc ? "": $vdoc = "";

/* Valor cobrado */
$vcobr ? "": $vcobr = "";


/* Sacado */
$sacado ? "": $sacado = "";

/* CPF */
$cpf ? "": $cpf = "";

/* Local de Pagamento */
$lp ? "": $lp = "Pagavel em qualquer banco";
                                         

/* Sacador */
$sacador ? "": $sacador = "";


/* Aceite */
$act ? "": $act = "";


/* data do processamento */
$dproc ? "": $dproc = "";


/* carteira */
$cart ? "": $cart = "";


/*  Especificacao moeda */
$espmoed ? "": $espmoed = "R$";


/* quantidade */
$qtde ? "": $qtde = "";


/* valor da moeda */
$vmoed ? "": $vmoed = "";


/* descontos */
$desc ? "": $desc = "";


/* outras deducoes */
$ddc ? "": $ddc = "";


/* mora / multa */
$multa ? "": $multa = "";


/* outros acrescimos */
$acres ? "": $acres = "";


/* instrucoes */
$instr1 ? "": $instr1 = "";
$instr2 ? "": $instr2 = "";
$instr3 ? "": $instr3 = "";
$instr4 ? "": $instr4 = "";
$instr5 ? "": $instr5 = "";


/* Espcificacao do doc */
$edoc ? "": $edoc = "";

/* Uso do Banco */
$usobc ? "": $usobc = "";

?>
