<?php
/*
 * The functions for each layout and some extra functions
 * that are better left not being class based reside here.
 *
 * @module userpage
 * @package phpWebSite
 * @author Adam Morton, adam@tux.appstate.edu
*/


/* LAYOUT FUNCTIONS: These are the template functions for creating layouts.
   If you add another layout, be sure to edit the userpage_config.php file
   and increment the $num_layouts variable as well ass adding a $layout_message
   for your new layout. */

/* TEMPLATE 1:
   Two-column layout with text and subtitles left justified in the
   left-hand column. Images are centered in the right-hand column. */
function template1($current_page)
{
	$page_title = stripslashes($current_page->main_title);
	$title = "<b>$page_title</b><br />
	<a href=\"./mod.php?mod=userpage&amp;op=Print\">
	<img src=\"images/print.gif\" border=\"0\" align=\"middle\" alt=\"TRANSLATE[[Printable Version]]\" /></a>&nbsp;&nbsp;
	<a href=\"./mod.php?mod=userpage&amp;op=Print\" class=\"smalltype\">
	TRANSLATE[[Printable Version]]</a>";

	$content = "<table width=\"100%\">\n";

	for($i=0; $i < $current_page->sections; $i++)
	{
		$sub = stripslashes($current_page->subtitle[$i]);
		$text = stripslashes($current_page->text[$i]);
		$alttag = stripslashes($current_page->alt[$i]);
		$img = $current_page->imagename[$i];

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text))
			$content .= "<tr><td class=\"type5\" width=\"90%\" valign=\"top\">\n";

		if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";

		if($current_page->text_active[$i] && $text) $content .= "<br />$text";

		if($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")) $content .= "</td>
		<td valign=\"top\" align=\"center\">
		<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text))
			$content .= "</td></tr>";
	}
	$content .= "</table></td>\n";
	thememainbox($title, $content);
}

/* TEMPLATE 2:
   Two-column layout with images centered in the left-hand column.
   Text and subtitles left justified in the right-hand column. */
function template2($current_page)
{
	$page_title = stripslashes($current_page->main_title);	
	$title = "<b>$page_title</b><br />
	<a href=\"./mod.php?mod=userpage&amp;op=Print\">
	<img src=\"images/print.gif\" border=\"0\" align=\"middle\" alt=\"TRANSLATE[[Printable Version]]\" /></a>&nbsp;&nbsp;
	<a href=\"./mod.php?mod=userpage&amp;op=Print\" class=\"smalltype\">
	TRANSLATE[[Printable Version]]</a>";

	$content = "<table width=\"100%\">\n";

	for($i=0; $i<$current_page->sections; $i++)
	{
		$sub = stripslashes($current_page->subtitle[$i]);
		$text = stripslashes($current_page->text[$i]);
		$alttag = stripslashes($current_page->alt[$i]);
		$img = $current_page->imagename[$i];

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text))
			$content .= "<tr><td class=\"type5\" width=\"10%\" valign=\"top\" align=\"center\">\n";

		if($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img"))
		$content .= "<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";

		if($current_page->sub_active[$i] && $sub) $content .= "</td><td valign=\"top\"><b>$sub</b><br />\n";
		if($current_page->text_active[$i] && $text) $content .= "<br />$text";

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text))
			$content .= "</td></tr>";
	}
	$content .= "</table>\n";
	thememainbox($title, $content);
}

/* TEMPLATE 3:
   Two-column layout with images centered in the left-hand column.
   Text and subtitles left justified in the right-hand column.
   Text without an associated image spans both columns. */
function template3($current_page)
{
	$page_title = stripslashes($current_page->main_title);
	$title = "<b>$page_title</b><br />
	<a href=\"./mod.php?mod=userpage&amp;op=Print\">
	<img src=\"images/print.gif\" border=\"0\" align=\"middle\" alt=\"TRANSLATE[[Printable Version]]\" /></a>&nbsp;&nbsp;
	<a href=\"./mod.php?mod=userpage&amp;op=Print\" class=\"smalltype\">
	TRANSLATE[[Printable Version]]</a>";

	$content = "<table width=\"100%\">\n";

	for($i=0; $i<$current_page->sections; $i++)
	{
		$sub = stripslashes($current_page->subtitle[$i]);
		$text = stripslashes($current_page->text[$i]);
		$alttag = stripslashes($current_page->alt[$i]);
		$img = $current_page->imagename[$i];

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) ||
		   ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "<tr>\n";

		if($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img"))
		{
			$content .= "<td width=\"10%\" valign=\"top\" align=\"center\">
			<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />
			</td><td class=\"type5\" valign=\"top\">\n";

			if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
			if($current_page->text_active[$i] && $text) $content .= "<br />$text";
		}
		else
		{
			if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text))
				$content .= "<td class=\"type5\" colspan=\"2\" valign=\"top\">\n";
			
			if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
			if($current_page->text_active[$i] && $text) $content .= "<br />$text";
		}

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) || ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "</td></tr>";
	}
	$content .= "</table>\n";
	thememainbox($title, $content);
}

/* TEMPLATE 4:
   Two-column layout with text and subtitles left justified in the left-hand column.
   Images are centered in the left-hand column. Text without an associated image spans
   both columns. */
function template4($current_page)
{
	$page_title = stripslashes($current_page->main_title);
	$title = "<b>$page_title</b><br />
	<a href=\"./mod.php?mod=userpage&amp;op=Print\">
	<img src=\"images/print.gif\" border=\"0\" align=\"middle\" alt=\"TRANSLATE[[Printable Version]]\" /></a>&nbsp;&nbsp;
	<a href=\"./mod.php?mod=userpage&amp;op=Print\" class=\"smalltype\">
	TRANSLATE[[Printable Version]]</a>";

	$content = "<table width=\"100%\">\n";

	for($i=0; $i<$current_page->sections; $i++)
	{
		$sub = stripslashes($current_page->subtitle[$i]);
		$text = stripslashes($current_page->text[$i]);
		$alttag = stripslashes($current_page->alt[$i]);
		$img = $current_page->imagename[$i];

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) || ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "<tr>\n";

		if($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img"))
		{
			$content .= "<td class=\"type5\" valign=\"top\">\n";

			if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
			if($current_page->text_active[$i] && $text) $content .= "<br />$text";
			
			$content .= "</td><td width=\"10%\" valign=\"top\" align=\"center\">
			<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";
		}
		else
		{
			$content .= "<td class=\"type5\" colspan=\"2\" valign=\"top\">\n";
			
			if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
			if($current_page->text_active[$i] && $text) $content .= "<br />$text";
		}

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) ||
		   ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "</td></tr>\n";
	}
	$content .= "</table>\n";
	thememainbox($title, $content);
}

/* TEMPLATE 5:
   Single column layout with left justified text Images alternate from right to left,
   text fills remaining space. Text without an associated image spans full column. */
function template5($current_page)
{
	$page_title = stripslashes($current_page->main_title);
	$title = "<b>$page_title</b><br />
	<a href=\"./mod.php?mod=userpage&amp;op=Print\">
	<img src=\"images/print.gif\" border=\"0\" align=\"middle\" alt=\"TRANSLATE[[Printable Version]]\" /></a>&nbsp;&nbsp;
	<a href=\"./mod.php?mod=userpage&amp;op=Print\" class=\"smalltype\">
	TRANSLATE[[Printable Version]]</a>";

	$content = "<table width=\"100%\">\n";

	for($i=0; $i<$current_page->sections; $i++)
	{
		$flipflop = $i % 2;
		
		$sub = stripslashes($current_page->subtitle[$i]);
		$text = stripslashes($current_page->text[$i]);
		$alttag = stripslashes($current_page->alt[$i]);
		$img = $current_page->imagename[$i];

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) ||
		   ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "<tr>\n";
	
		if ($flipflop == 0)
		{
			if($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img"))
			{
				$content .= "<td class=\"type5\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";

				$content .= "</td><td width=\"10%\" valign=\"top\" align=\"center\">
				<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";
			}
			else
			{
				$content .= "<td class=\"type5\" colspan=\"2\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";
			}
		}
		else
		{
			if($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img"))
			{
				$content .= "<td width=\"10%\" valign=\"top\" align=\"center\">
				<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";
				
				$content .= "</td><td class=\"type5\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";
			}
			else
			{
				$content .= "<td class=\"type5\" colspan=\"2\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";
			}
		}

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) ||
		   ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "</td></tr>";
	}
	$content .= "</table>\n";
	thememainbox($title, $content);
}

/* TEMPLATE 6:
   Single column layout with left justified text. Images alternate from left to right,
   text fills remaining space. Text without an associated image spans full column. */
function template6($current_page)
{
	$page_title = stripslashes($current_page->main_title);
	$title = "<b>$page_title</b><br />
	<a href=\"./mod.php?mod=userpage&amp;op=Print\">
	<img src=\"images/print.gif\" border=\"0\" align=\"middle\" alt=\"TRANSLATE[[Printable Version]]\" /></a>&nbsp;&nbsp;
	<a href=\"./mod.php?mod=userpage&amp;op=Print\" class=\"smalltype\">
	TRANSLATE[[Printable Version]]</a>";

	$content = "<table width=\"100%\">\n";

	for($i=0; $i<$current_page->sections; $i++)
	{
		$flipflop = $i % 2;
		
		$sub = stripslashes($current_page->subtitle[$i]);
		$text = stripslashes($current_page->text[$i]);
		$alttag = stripslashes($current_page->alt[$i]);
		$img = $current_page->imagename[$i];

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) ||
		   ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "<tr>\n";
	
		if ($flipflop == 1)
		{
			if($current_page->image_active[$i] && $img)
			{
				$content .= "<td class=\"type5\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";

				$content .= "</td><td width=\"10%\" valign=\"top\" align=\"center\">
				<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";
			}
			else
			{
				$content .= "<td class=\"type5\" colspan=\"2\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";
			}
		}
		else
		{
			if($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img"))
			{
				$content .= "<td width=\"10%\" valign=\"top\" align=\"center\">
				<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";
				
				$content .= "</td><td class=\"type5\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";
			}
			else
			{
				$content .= "<td class=\"type5\" colspan=\"2\" valign=\"top\">\n";

				if($current_page->sub_active[$i] && $sub) $content .= "<b>$sub</b><br />\n";
				if($current_page->text_active[$i] && $text) $content .= "<br />$text";
			}
		}

		if (($current_page->sub_active[$i] && $sub) || ($current_page->text_active[$i] && $text) ||
		   ($current_page->image_active[$i] && file_exists("./mod/userpage/images/$img")))
			$content .= "</td></tr>";
	}
	$content .= "</table>\n";
	thememainbox($title, $content);
}

/* EXTRA FUNCTIONS: These are the functions that are better
   left non-class based for now. */

/* The choose_menu function is basically needed to tie into
   the menu for now. Once the menu is a module this function
   shouldn't be needed or will be changed. */
function choose_menu($page_id)
{
	include('config.php');				// table prefix
	$title = "<b>Selecione a Colocao do Menu</b><br />
	          Por favor, selecione onde voc quer que esta pgina aparea no menu principal clicando no Link apropriado.";

	$result = mysql_query("SELECT menu_id, menu_text, menu_url, menu_active, menu_order FROM " . $table_prefix."menu WHERE menu_level = 1 ORDER BY menu_order");

	$content = "<table width=\"100%\" border=\"1\"><tr><td class=\"type5\">
	[<a href=\"admin.php?op=page_menu_post&amp;page_id=$page_id\">Adicionar Pgina no Nvel Topo</a>]
	</td></tr>\n";

	while(list($menu_id, $menu_text, $menu_url, $menu_active, $menu_order) = mysql_fetch_row($result))
	{
		$low_sub = $menu_id * 100;
		$high_sub = $low_sub + 99;

		$content .= "<tr><td class=\"type5\">
		<b>$menu_text</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		[<a href=\"admin.php?op=sub_page_menu_post&amp;low_sub=$low_sub&amp;page_id=$page_id\">Adicionar Pgina Abaixo $menu_text</a>]
		</td></tr>\n";

		$result_sub = mysql_query("SELECT menu_id, menu_text, menu_url, menu_active, menu_order FROM " . $table_prefix."menu WHERE menu_level = 2 AND menu_id >=  $low_sub AND menu_id <=  $high_sub ORDER BY menu_order");

		while(list($menu_id, $menu_text, $menu_url, $menu_active, $menu_order) = mysql_fetch_row($result_sub))
		{
			$low_sub2 = $menu_id * 100;
			$high_sub2 = $low_sub2 + 99;

			$content .= "<tr><td class=\"type5\"><span class=\"onebiggerred\">&gt;&gt;</span>
			<b>$menu_text</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			[<a href=\"admin.php?op=sub_page_menu_post&amp;low_sub=$low_sub2&amp;page_id=$page_id\">Adicionar Pgina Abaixo $menu_text</a>]
			</td></tr>\n";

			$result_sub2 = mysql_query("SELECT menu_id, menu_text, menu_url, menu_active, menu_order FROM " . $table_prefix."menu WHERE menu_level = 3 AND menu_id >=  $low_sub2 AND menu_id <=  $high_sub2 ORDER BY menu_order");

			while(list($menu_id, $menu_text, $menu_url, $menu_active, $menu_order) = mysql_fetch_row($result_sub2))
			{
				$content .= "<tr><td class=\"type5\"><span class=\"onebiggerred\">&gt;&gt;&gt;&gt;</span>
				<b>$menu_text</b>
				</td></tr>\n";
			}
		}
	}
	$content .= "</table>\n";
	thememainbox($title, $content);
}

/* This function lists all userpages currently in the database
   and gives the user the ability to edit, delete, or toggle active
   status. */
function list_userpages()
{
	global $admintest;
	include('config.php');				// table prefix
	$current_data = new userpage;
	if($admintest) back_to_admin();

	$title = "<b>TRANSLATE[[Edit Web Page]]</b>";

	$content = "<br />\n<a href=\"mod.php?mod=userpage&amp;op=create_userpage\">TRANSLATE[[New Web Page]]</a><br /><br />\n";

	$result = mysql_query("SELECT id, data FROM " . $table_prefix."mod_userpage_data ORDER BY title");
	if(mysql_num_rows($result))
	{
		$content .= "<table width=\"100%\" border=\"1\">\n";
		while(list($page_id, $data) = mysql_fetch_row($result))
		{
			$current_data = unserialize($data);

			$content .= "<tr><td><b>
			<a href=\"./mod.php?mod=userpage&amp;op=edit_userpage&amp;page_id=$page_id\">";
			$content .= stripslashes($current_data->main_title);
			$content .= "</a></b><br />\n";

			$content .= htmlspecialchars(stripslashes(substr($current_data->text[0], 0, 100)));
			$content .= "</td><td align=\"center\" width=\"15%\"><b>
			<a href=\"./mod.php?mod=userpage&amp;op=confirm_delete&amp;page_id=$page_id\">Apaga</a>
			</b></td>\n";

			if($current_data->page_active) $content .= "<td class=\"active\" align=\"center\" width=\"15%\">
			<b><a href=\"./mod.php?mod=userpage&amp;op=on_off&amp;page_id=$page_id&amp;switch=0\">LIGADO</a></b>
			</td></tr>\n";
			else
			$content .= "<td class=\"inactive\" align=\"center\" width=\"15%\">
			<b><a href=\"./mod.php?mod=userpage&amp;op=on_off&amp;page_id=$page_id&amp;switch=1\">DESLIGA</a></b>
			</td></tr>\n";
		}
		$content .= "</table>\n";
	}
	else $content .= "<center><b>TRANSLATE[[No pages found in database]]!</b></center>\n";

	thememainbox($title, $content);
}

/* Confirms the deletion of a userpage. */
function confirm_delete($page_id)
{
	include('config.php');				// table prefix
	$result = mysql_query("SELECT data FROM " . $table_prefix."mod_userpage_data WHERE id='$page_id'");
	list($data) = mysql_fetch_row($result);

	$current_data = new userpage;
	$current_data = unserialize($data);

	$title = "<font color=\"red\"><b>TRANSLATE[[WARNING]]! TRANSLATE[[Confirm page deletion]]!</b></font>";
	$content = "<center><b>TRANSLATE[[Are you sure you want to delete the page shown]]?<br />
	<table border=\"0\" width=\"50%\"><tr><td align=\"center\">
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"page_id\" value=\"$page_id\" />
	<input type=\"hidden\" name=\"mod\" value=\"userpage\" />
	<input type=\"hidden\" name=\"op\" value=\"delete_userpage\" />
	<input type=\"submit\" value=\"SIM\" />
	</form>
	</td>
	<td align=\"center\">
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"userpage\" />
	<input type=\"hidden\" name=\"op\" value=\"list_userpages\" />
	<input type=\"submit\" value=\"NO\" />
	</form>
	</td></tr></table>\n";

	thememainbox($title,$content);

	$current_data->view_page();
}

/* This function prints an error to the screen if someone trys to access
   an admin function without being logged in as an admin */
function admin_error()
{
	$title = "<font color=\"red\"><b>TRANSLATE[[ACCESS DENIED]]!!</b></font>";
	$content = "TRANSLATE[[You are currently NOT logged in as an administrator]]!
	TRANSLATE[[If you are an administrator follow the link below to log in now]].
	<br /><br /><center><a href=\"admin.php\">TRANSLATE[[Admin Login]]</a></center>\n";

	thememainbox($title, $content);
}

//bobt add function 
function user_owns_page($i_page,$i_user)
{
  // "user_owns_page is called to check if a user other than
  // the admin may edit the page. it depends on "sv_user_name"
 
  global $sv_user_name, $sv_user_id, $table_prefix;

  //authors.php gives edit privileges to users
  // and sets "$author_page_limit"
  include('./mod/userpage/authors.php');
 
  if (!$sv_user_id) 
   { return 0;
   } else if (($i_page) && ($i_user)) {
     $s_sql="select 1 
      from ".$table_prefix."mod_userpage_owner 
      where owner_id=$i_user 
      and page_id=$i_page";
     $result = mysql_query($s_sql);
     list($found) = mysql_fetch_row($result);
     return $found;
   } else if ($author_page_limit > 0 ) {
     $s_sql="select count(*) as page_count 
       from " . $table_prefix."mod_userpage_owner 
       where owner_id=$i_user";
     $result = mysql_query($s_sql);
     $row = mysql_fetch_array($result);
     //add one to force evaluation is numeric
     if ($row[page_count]+1 <= $author_page_limit+1 )
       {  return 1;  }
   } else {
     return 0 ;
   }
}
//end bobt add function


function printable($current_page, $current_id) {
	include("./config.php");

	$page_title = stripslashes($current_page->main_title);

echo "
<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"
\"DTD/xhtml1-transitional.dtd\">
<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">
<head>
<title>$sitename - $titletag</title>
</head>
<body>
<table width=\"640\" cellSpacing=\"0\" cellpadding=\"20\" bgcolor=\"#ffffff\">
<tr><td>
	<p align=\"right\"><font face=\"Arial\" size=\"2\">$sitename</font></p>
	<center><font face=\"Arial\" size=\"+3\"><b>$page_title</b></font></center><br />";
	echo "<table width=\"100%\">\n";

	for($i=0; $i<$current_page->sections; $i++)
	{
		$sub = stripslashes($current_page->subtitle[$i]);
		$text = stripslashes($current_page->text[$i]);
		$alttag = stripslashes($current_page->alt[$i]);
		$img = $current_page->imagename[$i];

		if ($current_page->sub_active[$i] || $current_page->text_active[$i] || ($current_page->image_active[$i] && $img))
			echo "<tr>\n";

		if($current_page->image_active[$i] && $img)
		{
			echo "<td class=\"type5\" valign=\"top\">\n";

			if($current_page->sub_active[$i]) echo "<b>$sub</b>\n";
			if($current_page->text_active[$i]) echo "<br />$text";
			
			echo "</td><td width=\"10%\" valign=\"top\" align=\"center\">
			<img src=\"./mod/userpage/images/$img\" alt=\"$alttag\" />\n";
		}
		else
		{
			echo "<td class=\"type5\" colspan=\"2\" valign=\"top\">\n";
			
			if($current_page->sub_active[$i]) echo "<b>$sub</b>\n";
			if($current_page->text_active[$i]) echo "<br />$text";
		}

		if ($current_page->sub_active[$i] || $current_page->text_active[$i] || ($current_page->image_active[$i] && $img))
			echo "</td></tr>\n";
	}

echo "</table>
<hr noshade><br />
<center>
<font face=\"Arial\" size=\"1\">TRANSLATE[[This userpage was printed from]] $sitename<br />
<a href=\"$phpws_url\">$phpws_url</a></br /><br />
TRANSLATE[[The URL for this userpage is]]:<br />
<a href=\"$phpws_url/mod.php?mod=userpage&amp;page_id=$current_id\">$phpws_url/mod.php?mod=userpage&amp;page_id=$current_id</a></br /><br />
</center></font>
</td></tr>
</table>
</body>
</html>";
}

?>
