<?php

/**
 * This file contains the html-header core function definitions for phpWebSite.
 *
 * The functions defined here are essential for the phpWebSite
 * system. This file gets included almost all the time, you should be
 * able to use the functions defined here everywhere in the code.
 *
 * @module mainfile
 * @modulegroup core
 * @package phpWebSite
 */

/**
 * Wrapper around header("Location: url") to deal also with IE
 *
 * @param URL
 * @author: Alessandro Pisani
 */
function html_header_location($url) {
 $agent = (phpversion() > "4.1.0") ? $_SERVER[HTTP_USER_AGENT] : $HTTP_SERVER_VARS[HTTP_USER_AGENT];

 // Both IE 5.x and Mozilla >= 0.9.8 now require header() to be postfixed by
 // exit, otherwise they do not execute headers send

 if (stristr($agent, 'msie'))
  { Header("Refresh: 0;url=$url"); exit; }
 else
  { Header("Location: $url"); exit; }
 }

?>
