<?php
// This file requires that 'db.php' is include ealier!!!!

//require_once("lang.class.php");

//******************** TIME FUNCTIONS

// convert Time to Index
function cTtI( $hour, $minute) {
// Convert the hour minute combination to an index between 0 and 48
// (In a day we have 24 hours and we represent it in 48 half hours)

        $index = $hour * 2;
        if( $minute >= 30 )
                $index += 1;
        return $index;
}

function getCurrentIndex() {
        $hour = date("G",time());
        $min = date("i",time());
        return cTtI(intval($hour),intval($min));
}

function isToday( $unixTimeStamp ) {
        $day   = date("j",$unixTimeStamp);
        $month = date("n",$unixTimeStamp);
        $year  = date("Y",$unixTimeStamp);
//        print "(".$day."-".$month."-".$year.")";
        $day2   = date("j",time());
        $month2 = date("n",time());
        $year2  = date("Y",time());
//        print "(".$day2."-".$month2."-".$year2.")";

        if( $day == $day2 && $month == $month2 && $year == $year2 )
                return 1;
        else
                return 0;
}

// convert Index to Time
function cItT( $index) {
        $index = $index % 48;
        $time = "" . intval($index/2);
        if( $index % 2 )
                $time .= ".30";
        else
                $time .= ".00";
        return $time;
}

function print_time( $time ) {
        return date("H:i",$time);
}

function get_week_nr( $date ) {
        return (intval(intval(date("z", $date ))/7) + 1);
}

function print_duration( $start_time , $end_time ) {
	$duration = $end_time - $start_time;
	$hours = intval($duration / 3600) ;
	$rest = intval(($duration - ( $hours * 3600 )) / 60 );
	return $hours."H ".$rest."m";
}


//********** APPOINTMENT FUNCTIONS

function get_user_appointments( $user_id , $dayTime , $short) {
// This is here for compliance to the adopted coding style
        return getUserAppointments( $user_id , $dayTime , $short );
}

function getUserAppointments( $user_id , $dayTime , $short ) {
// Get meetings of persons on their ID for a certain date
// $short is a flag which shows a special short description for
// week and month overviews.

        if( !isset($short) ) $short = 0;

        $appointments = array();

        pbcs_db_connect ();
        pbcs_db_select_db();

        $UID = getUIDfromSID($GLOBALS["SID"]);


        $date_start = mktime (0,0,0,date("m",$dayTime)  ,date("d",$dayTime),date("Y",$dayTime));
        $date_end   = mktime (0,0,0,date("m",$dayTime)  ,date("d",$dayTime)+1,date("Y",$dayTime));


        // First find all Appointments for the User and let the database do all the work!
        $result = pbcs_db_query("SELECT B.* FROM ".
                                "JoinTable_UserAppointment A, Appointment B WHERE ".
                                "A.UserID = '$user_id' AND ".
                                "B.ID = A.AppointmentID AND ".
                                "B.IsNote = 0 AND ".
                                "B.StartTime >= $date_start AND ".
                                "B.StartTime < $date_end");

        while( $row =  pbcs_db_fetch_row($result) ) {
                list($id, $start_time, $end_time , $description,
                                $is_note , $private) = $row;

                if( $private == 1 && $user_id != $UID ) {
                         // if the given user_id is not the session User we must
                        // protect private appointments
                        $description = "Private appointment";
                }

                $result2 = pbcs_db_query("SELECT B.Code FROM ".
                                        "JoinTable_AppointmentProject A, Project B ".
                                        "WHERE A.AppointmentID = '$id' AND ".
                                        "B.ID = A.AppointmentID");

                if( $result2  ) {
                        $row2 =  pbcs_db_fetch_array($result2);
                        $projectCode = $row2["Code"];
                        if( isset($projectCode) && $short != 1 )
                                $description = $projectCode . " <BR> " . $description;
                        else
                                $description = $description;
                }

                $start_hour = intval(date("H",$start_time));
                $start_minute = intval(date("i",$start_time));
                $end_hour = intval(date("H",$end_time));
                $end_minute = intval(date("i",$end_time));
                $appointments[] =  array( cTtI($start_hour,$start_minute),
                                         cTtI($end_hour, $end_minute),
                                         $description , $id, $user_id,
                                         $private );

        }
        return $appointments;
}

function get_user_notes( $user_id , $dayTime ) {
// This is here for compliance to the adopted coding style
        return getUserNotes( $user_id , $dayTime );
}

function getUserNotes( $user_id , $dayTime ) {
// Gives all notes for a user on a day.
// returns: description, note id and the user_id

        $notes = array();

        pbcs_db_connect ();
        pbcs_db_select_db();

        $UID = getUIDfromSID($GLOBALS["SID"]);


        $date_start = mktime (0,0,0,date("m",$dayTime)  ,date("d",$dayTime),date("Y",$dayTime));
        $date_end   = mktime (0,0,0,date("m",$dayTime)  ,date("d",$dayTime)+1,date("Y",$dayTime));


        // First find all Appointments for the User and let the database do all the work!
        $result = pbcs_db_query("SELECT B.* FROM ".
                                "JoinTable_UserAppointment A, Appointment B WHERE ".
                                "A.UserID = '$user_id' AND ".
                                "B.ID = A.AppointmentID AND ".
                                "B.IsNote = 1 AND ".
                                "B.StartTime >= $date_start AND ".
                                "B.StartTime < $date_end");

        while( ($row =  pbcs_db_fetch_row($result)) ) {
                list($id, $start_time, $end_time , $description,
                                $is_note , $private) = $row;

                if( $private == 1 && $user_id != $UID ) {
                         // if the given user_id is not the session User we must
                        // protect private appointments
                        $description = "Private note";
                }

                $start_hour = intval(date("H",$start_time));
                $start_minute = intval(date("i",$start_time));
                $notes[] =  array( $description , $id, $user_id , $private );

        }
        return $notes;

}


// This function is needed by sort_list
function sort_compare($a, $b) {
    if (intval($a["StartTime"]) == intval($b["StartTime"])) return 0;
    return (intval($a["StartTime"]) > intval($b["StartTime"])) ? 1 : -1;
}

// This is a sort function to sort meetings on start time!
// These meetings are returned by getUserAppointment
// For use with multiple users you must add all appointments
// seperately in an array (have a look at the list overview in day.php
function sort_list( $meetings) {
        usort($meetings, sort_compare);
        return $meetings;
}

//************************ HTML STUFF

function show_header() {
        global $username;
        global $g_msg;
        print "<TABLE BORDER=0><TR>";
        print "<TD WIDTH=200>".lang_get("User").": ".getFullNameFromLogin($username)." </TD>";
        // changed by MH
        print "<TD WIDTH=275>".$g_msg->get("Today").": ".
        strftime($g_msg->get('time_fmt'),time())."</TD>";
        print "<TD>".$g_msg->get('Week nr').": ".get_week_nr( time() )."</TD>";
        print "</TR></TABLE>\n";

}

function print_stylesheet() {
	global $pbcs_stylesheet;
	print "<style type=\"text/css\">";
	print "</style>";
	print "<link rel=\"stylesheet\" href=\"$pbcs_stylesheet\">";
}



function show_note( $the_note, $SID, $UID ) {
// This function shows notes to the session user.
// It will show Delete and Edit links for non-private notes
// and for private notes that are owned by the session user
	global $status_modification_protection;
	global $status_modification_level_difference;
	global $status_appointment_invisibility;
	global $status_appointment_level_difference;

	// We need the status of the appointment User
	if( $status_modification_protection ) {
		$AppStatus = getStatusFromUID( $the_note[2] );
		$UIDStatus = getStatusFromUID( $UID );
	} else {
		$AppStatus = 0;
		$UIDStatus = 0;
	}

        if( !($the_note[3] == 1 && $UID != $the_note[2]) && 
            $UIDStatus + $status_modification_level_difference >= $AppStatus ) {
                print "<A HREF=\"note-form.php?";
                print "AppointmentID=".$the_note[1] ."&SID=".$SID."&Del=1\">";
		print lang_get('Delete')."</a>";
                print "<A HREF=\"note-form.php?AppointmentID=";
                print $the_note[1] ."&SID=".$SID."\">";
                print " | ".lang_get('Edit')."</a><BR>";
        }
	if( $status_appointment_invisibility && 
	    ($AppStatus - $UIDStatus) >= $status_appointment_level_difference )
		print lang_get("A note");
	else
        	print htmlspecialchars($the_note[0]);
}

function show_day_appointment( $the_appointment, $SID, $UID ) {
// This function shows appointments to the session user.
// It will show Delete and Edit links for non-private appointments
// and for private appointments that are owned by the session user
	global $status_modification_protection;
	global $status_modification_level_difference;
	global $status_appointment_invisibility;
	global $status_appointment_level_difference;
	
	// We need the status of the appointment User
	if( $status_modification_protection ) {
		$AppStatus = getStatusFromUID( $the_appointment[4] );
		$UIDStatus = getStatusFromUID( $UID );
	} else {
		$AppStatus = 0;
		$UIDStatus = 0;
	}

        if( !($the_appointment[5] == 1 && $UID != $the_appointment[4]) && 
            $UIDStatus + $status_modification_level_difference >= $AppStatus ) {
                print "<A HREF=\"appointment-delete.php?";
                print "AppointmentID=".$the_appointment[3] ."&SID=".$SID."\">";
                print lang_get("Delete")."</a>";
                print " | ";
                print "<A HREF=\"appointment-form.php?AppointmentID=";
                print $the_appointment[3] ."&SID=".$SID."\">";
                print lang_get("Edit")."</a>";
                print "<BR>";
        }
	if( $status_appointment_invisibility && 
	    ($AppStatus - $UIDStatus) >= $status_appointment_level_difference )
		print lang_get("An appointment");
	else
	        print htmlspecialchars($the_appointment[2]);
}



function show_week_appointment( $the_appointment , $SID, $UID ) {
	global $status_modification_protection;
	global $status_modification_level_difference;
	global $status_appointment_invisibility;
	global $status_appointment_level_difference;
	
	// We need the status of the appointment User
	if( $status_modification_protection ) {
		$AppStatus = getStatusFromUID( $the_appointment[4] );
		$UIDStatus = getStatusFromUID( $UID );
	} else {
		$AppStatus = 0;
		$UIDStatus = 0;
	}
        if( !($the_appointment[5] == 1 && $UID != $the_appointment[4])  &&
            $UIDStatus + $status_modification_level_difference >= $AppStatus ) {
                print "<A HREF=\"appointment-delete.php?";
                print "AppointmentID=".$the_appointment[3] ."&SID=".$SID."\">";
                print lang_get('D')."</a>";
                print "|";
                print "<A HREF=\"appointment-form.php?AppointmentID=";
                print $the_appointment[3] ."&SID=".$SID."\">";
                print lang_get('E')."</a> ";
        }

	if( $status_appointment_invisibility && 
	    ($AppStatus - $UIDStatus) >= $status_appointment_level_difference )
		print lang_get("An appointment")."<p>";
	else {
	        print cItT($the_appointment[0])."-". cItT($the_appointment[1])."<BR>";
       		print htmlspecialchars($the_appointment[2])."<BR>\n";
	}

}

function show_week_date( $timestamp ) {

}

function array_to_string( $members ) {
	$mem_nr = count($members);
	$output = "";
	for( $index = 0 ; $index < $mem_nr ; $index++ ) {
		if( $index > 0 && $index < ($mem_nr -1 ) )
			$output .= ", ";
		if( $index == ( $mem_nr - 1) && $mem_nr > 1)
			$output .= " ".lang_get('and')." "; 
		$output .= $members[$index];
	}
	return $output;
}

//*********************** DATABASE STUFF

function getUIDfromSID( $SID ) {
         $result = pbcs_db_query("SELECT UserID FROM Session WHERE ID = $SID");
        $row = pbcs_db_fetch_row( $result );
        return $row[0];
}

function getLoginFromUID( $UID ) {
        $result = pbcs_db_query("SELECT Login FROM User WHERE ID = $UID");
        $row = pbcs_db_fetch_row( $result );
        return $row[0];
}

function getUIDFromLogin( $Login ) {
        $result = pbcs_db_query("SELECT ID FROM User WHERE Login = '$Login'");
        $row = pbcs_db_fetch_row( $result );
        return $row[0];
}

function getFullNameFromUID( $UID ) {
        $result = pbcs_db_query("SELECT Name, Surname FROM User WHERE ID = $UID");
        $row = pbcs_db_fetch_row( $result );
        return $row[0] ." ". $row[1];
}

function getFullNameFromLogin( $Login ) {
        $result = pbcs_db_query("SELECT Name, Surname FROM User WHERE Login = '$Login'");
        $row = pbcs_db_fetch_row( $result );
        return $row[0] ." ". $row[1];
}

function getStatusFromUID( $UID ) {
        $result = pbcs_db_query("SELECT Status FROM User WHERE ID = $UID");
        $row = pbcs_db_fetch_row( $result );
        return $row[0];
}

function getLang_TZFromUID( $UID ) {
        $result = pbcs_db_query("SELECT Timezone, Language FROM User WHERE ID = $UID");
        $row = pbcs_db_fetch_row( $result );
        return array( $row[0] , $row[1]);
}

function getDefaultEmailFromUID( $UID ) {
// Currently in v0.5 only one email address per user is supported.
// The tables are created to support multiple addresses, but that requires
// a more complex user interface
	$result = pbcs_db_query("SELECT EmailAddress FROM EmailAddress WHERE UserID = $UID");
	$row = pbcs_db_fetch_row( $result );
	return $row[0];

}



?>
