<?php
// themes php file
// wrapper for SM themes if needed
session_start();
if( file_exists("config/config.php") )
	require_once("config/config.php");
if( file_exists("../config/config.php") )
	require_once("../config/config.php");
if( file_exists("db.php") )
	require_once("db.php");
if( file_exists("../db.php") )
	require_once("../db.php");

if( file_exists("lang.php") )
	require_once("lang.php");
if( file_exists("../lang.php") )
	require_once("../lang.php");

lang_init();

// New feature since v0.5.
// In images you now can show html. A wrapper function show_image()
// handles showing plain images (for compatibility reasons) or HTML.
$show_html_theme = false;

pbcs_db_connect();
pbcs_db_select_db();
$result = pbcs_db_query("SELECT Theme FROM User WHERE Login = '$username'");
pbcs_db_close();
if( pbcs_db_num_rows( $result ) == 1 ) {
	$row = pbcs_db_fetch_row( $result );
	$pbcs_theme = $row[0];
}


if( !isset($pbcs_theme) )
	$pbcs_theme = "pbcs_theme.php";

if( isset($pbcs_themes_included ) )
    exit;

// Including themes from sub-directories won't go right
// so we have to checl if the to be include theme can
// be found first. If not we pre-pend '..'
if( file_exists("themes/$pbcs_theme") )
    require_once("themes/$pbcs_theme");
else
    require_once("../themes/$pbcs_theme");

if( count( $color ) == 12 ) {
    // We have an unmodified SM theme
    // Define the message background color
    $color[12] = $color[0];
    // Index 1 is undefined and mostly red in SM, so make it
    // equal to color index 5
    $color[1] = $color[5];

}

if( !isset( $images ) ) {

        // I don't know right now if it is smart to have theme stuff in
        // two places. This way I can move it around if needed.
	$images_dir = "images/themes/bw-buttons/";
        // images in the navigation frame
        $images[0] = $images_dir."nav-small-logo.gif";
        $images[1] = $images_dir."nav-single-overviews.gif";
        $images[2] = $images_dir."nav-multi-overviews.gif";
        $images[3] = $images_dir."nav-month-overview.gif";
        $images[4] = $images_dir."nav-week-overview.gif";
        $images[5] = $images_dir."nav-2-weekly-overview.gif";
        $images[6] = $images_dir."nav-list-overview.gif";
        $images[7] = $images_dir."nav-new-appointment.gif";
        $images[8] = $images_dir."nav-new-note.gif";
        $images[9] = $images_dir."nav-user-settings.gif";
        $images[10] = $images_dir."nav-admin.gif";
        $images[11] = $images_dir."nav-logout.gif";
        $images[12] = $images_dir."nav-day-overview.gif";

	// images in the calendar frame
        $images[13] = $images_dir."cal-month-calendar.gif";
        $images[14] = $images_dir."cal-go-to-today.gif";
        $images[15] = $images_dir."cal-user-picker.gif";
        $images[16] = $images_dir."cal-show-users.gif";

	// image(s) in the Appointment form
	$images[17] = $images_dir."apf-check-appointment.gif";
	$images[18] = ""; // reserved for a header image
	$images[25] = $images_dir."apf-make-recurrent.gif";

	// image(s) in the Appointment check page
	$images[19] = $images_dir."apc-book-appointment.gif";
	$images[20] = ""; // reserved for a header image

	// image(s) in the Note form
	$images[21] = $images_dir."nof-add-note.gif";
	$images[22] = ""; // reserved for a header image
	$images[23] = $images_dir."nof-update-note.gif";

	$images[24] = ""; // nss header



}
// This var is used to prevent double including
$pbcs_themes_included = true;

function show_image( $number , $alt_text) {
	global $images, $show_html_theme;
	if( $show_html_theme ) {
		print $images[$number];
	} else {	
		print "<IMG BORDER=0 SRC=\"".$images[$number]."\" ALT=\"$alt_text\"><BR>";
	}
}

function show_input_image( $number, $name , $alt_text ) {
	global $images, $show_html_theme;
	if( $show_html_theme ) {
		show_theme_input( $number , $name , $alt_text );
	} else {	
		print "<INPUT BORDER=0 TYPE=image NAME=\"$name\" SRC=\"".$images[$number]."\" ALT=\"$alt_text\"><BR>";
	}
}
?>