<?php
if( file_exists("db.php") )
	require_once("db.php");
else 
	require_once("../db.php");
if( file_exists("global.inc.php") )
	require_once("global.inc.php");
else
	require_once("../global.inc.php");
if( file_exists("util_funcs.php") )
	require_once("util_funcs.php");
else
	require_once("../util_funcs.php");
if( file_exists("lang.class.php") )
	require_once("lang.class.php");
else
	require_once("../lang.class.php");

function lang_init() {
	global $default_language;
	global $g_msg, $SID;

	pbcs_db_connect();
	pbcs_db_select_db();
	$UID = getUIDfromSID( $SID );
	// If we have no session ID... then we cannot fetch language
	// and timezone information. Assuming default values.
	if( $SID ) {
		list($timezone,$lang) =  getLang_TZFromUID( $UID );
		if( ! is_dir("lang") ) {
			if( ! is_dir("../lang") )
				$lang = $default_language;
			else
				if( !is_file("../lang/lang.".$lang.".inc.txt") )
					$lang = $default_lang;
		} else {
			if( !is_file("lang/lang.".$lang.".inc.txt") )
				$lang = $default_language;
		}
	} else {
     		$lang = $default_language;
	}
	$g_msg = new message($lang);
	return $g_msg;
}

function lang_get($str) {
	global $g_msg;
	return $g_msg->get($str);
}

function lang_check($str) {
	global $g_msg;
	return $g_msg->check($str);
}

function lang_show($str) {
	global $g_msg;
	return $g_msg->show($str);
}

?>