<?php
// File-name      : lang.php
// Purpose        : This file will handle translation of text in PBCS pages.
// Notes:           Marian Heddesheimer started the translaltion code and
//                  created the 'class message'. Roalt Zijlstra then created
//                  the 'lang.php' and wrote nice wrapper functions.
// Created on     : 05-08-2001
// Author         : Marian Heddesheimer and Roalt Zijlstra
// Updated on     : 08-08-2001
// Included since : v0.5

// inserted by MH
//*********************** language
class message
{
   var $msg_ary = array();

   function message($filename="en")
   {
	if( is_dir("lang") )
		$this->read_content("lang/lang.{$filename}.inc.txt", $this->msg_ary);
	if( is_dir("../lang") )
		$this->read_content("../lang/lang.{$filename}.inc.txt", $this->msg_ary);
   }

   function read_content($filename, &$ary)
   {
     $lines = file($filename);
     foreach($lines as $val)
     {
       // Skip empty lines
       if( $val == "" )
           continue;
       // Exclude # starting lines for simple comments
       if( $val[0] == '#' )
	continue;
       $items = explode("|", $val);
       if (isset($items[1]))
       {
         $ary[$items[0]] = trim($items[1]);
       }
     }
   }

   function show($req)
   {
     if (isset($this->msg_ary[$req]))
     {
        print($this->check($this->msg_ary[$req]));
     } else {
        print '** ' . $req . ' **';
     }
   }
   function get($req)
   {
     if (isset($this->msg_ary[$req]))
     {
        return $this->check($this->msg_ary[$req]);
     } else {
        return '** ' . $req . ' **';
     }
   }

   function check($text)
   {
     $text = str_replace('\n', "\n", $text);
     return $text;
   }

};

?>