<?php
session_start();

require_once("config/config.php");
require_once("db.php");
require_once("auth.php");
require_once("util_funcs.php");
require_once("lang.php");

// The language class must be initialized before we use it.
lang_init();


function drawDayTable( $SID , $persons , $start_index , $stop_index , $dayTime) {
        global $color;
        global $g_msg;

        print "<HTML>\n";
	print_stylesheet();
        print "<BODY BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]>";

        show_header();

        // Create a days appointments array with all given persons
        for( $i = 0 ; $i < count($persons) ; $i++ ) {
                $appointments[$persons[$i]] = get_user_appointments( $persons[$i] , $dayTime , 0);
                $notes[$persons[$i]] = get_user_notes(  $persons[$i] , $dayTime );
        }


        print "<TABLE border=1 CELLSPACING=0 CELLPADDING=1>";
        print "<TR><TD WIDTH=10 BGCOLOR=$color[1] ALIGN=CENTER>";

        print "<A HREF=\"".s_url("day.php?show_time=".($dayTime-86400))."\"><<</A>";
        print "</TD><TD BGCOLOR=$color[5] ALIGN=CENTER> ";
	print lang_get(date("l",$dayTime));
        print date(" j ",$dayTime);
	print lang_get(date("F",$dayTime));
	print date(" Y", $dayTime )." ".lang_get('Wk nr.')." ".get_week_nr( $dayTime );
        print "</TD><TD WIDTH=10 BGCOLOR=$color[1] ALIGN=CENTER>\n";
        print "<A HREF=\"".s_url("day.php?show_time=".($dayTime+86400))."\">>></A>";
        print "</TD></TR>\n";
        print "<TR><TD COLSPAN=3 ALIGN=CENTER>";
        print "<TABLE BORDER=1 CELLPADDING=0 CELLSPACING=0>\n";

        print "<TR HEIGHT=16><TD></TD>\n";
        for( $i = 0 ; $i < count($persons) ; $i++ ) {
                $result = pbcs_db_query("SELECT Surname FROM User WHERE ".
                              "ID = ".$persons[$i]);
                $row = pbcs_db_fetch_row($result);
                $username = $row[0];
                print "<TD ALIGN=CENTER BGCOLOR=$color[3]><FONT COLOR=$color[6]>$username</FONT></TD>\n";
        }
        print "</TR>\n";

        $UID = getUIDfromSID( $SID );

        // First show some notes!!
        print "<TR BGCOLOR=$color[0]><TD BGCOLOR=$color[0]>".lang_get("Notes")."</TD>\n";
        for( $person_index = 0 ; $person_index < count($persons) ;
                $person_index++ ) {
                print "<TD BGCOLOR=$color[0]>";
                for( $notes_index = 0 ; $notes_index <
                        sizeof( $notes[$persons[$person_index]]) ;
                                $notes_index++ ) {
                        if( $notes_index > 0 )
                                print "<HR>";
                             $the_note = $notes[$persons[$person_index]][$notes_index];
                        show_note( $the_note, $SID , $UID );
                       }
                print "&nbsp</TD>";
        }

          $toggle_color = 0;
        for( $i = 0 ; $i < count($persons) ; $i++ ) {
                $mask_during_appointment[$i] = -1;
        }
        for( $i = $start_index ; $i <= $stop_index ; $i++ ) {
                print "<TR >";

                // Show time
                print "<TD WIDTH=32 ALIGN=CENTER ";
                if( $toggle_color < 2 )
                        print "BGCOLOR=$color[10]>";
                else
                        print "BGCOLOR=$color[9]>";

                $month = date("n",$dayTime);
                $day = date("d",$dayTime);
                $year = date("Y",$dayTime);
                $j = intval($i/2);
                $composed_time = mktime( $j ,($i > ($j *2) ? 30 : 0 ) ,0 , $month, $day, $year);

                print "<a href=\"".s_url("appointment-form.php?start_time=$composed_time");
                print "\">".$j.":".($i > ($j *2) ? "30" : "00" )."</a>";
                print "</TD>\n";


                for( $person_index = 0 ; $person_index < count($persons) ;
                        $person_index++ ) {
                          #FFCC99
                        for( $appointment_index = 0 ; $appointment_index <
                                count($appointments[$persons[$person_index]]) ;
                                        $appointment_index++ ) {
                                $the_appointment = $appointments[$persons[$person_index]][$appointment_index];

                                // If a appointment happens earlier then the start_index but ends
                                // after it... then we should also display something.

                                if( $i == $the_appointment[0] ) {
                                        if( $the_appointment[1] < $the_appointment[0] )
                                                $the_appointment[1] = 48 + $the_appointment[1];
                                        $appointmentLength = ($the_appointment[1] - $the_appointment[0] ) ;
                                        $rowspan = $appointmentLength;

                                        // If the appointment exceeds the stop_index truncate the rowspan!
                                        if( $rowspan + $i > $stop_index )
                                                $rowspan = $stop_index - $i +1;

                                        print "<TD WIDTH=200 ROWSPAN=" . $rowspan . " ";
                                        print "BGCOLOR=$color[12] VALIGN=TOP>";
                                        show_day_appointment( $the_appointment , $SID , $UID );

                                        if( $rowspan < $appointmentLength )
                                                print "<BR>(".lang_get('until')." " . cItT($the_appointment[1]) . ")";
                                        print "</TD>";
//                                        if( ($the_appointment[1] - $the_appointment[0]) > 1 )
                                                $mask_during_appointment[$person_index] = $the_appointment[1];
//                                        else
//                                                $mask_during_appointment[$person_index] = $the_appointment[1] +1;
                                }
                        }
                        if( $i >= $mask_during_appointment[$person_index] ) {
                                print "<TD WIDTH=160 ";
                                if( isToday( intval($dayTime) ) == 1 && (getCurrentIndex() == $i) ) {
                                        if( ( $toggle_color % 2 ) == 0 )
                                                print "BGCOLOR=$color[5]>";
                                        else
                                                print "BGCOLOR=$color[5]>";
                                        print "&nbsp;</TD>\n";

                                } else {
                                        if( ( $toggle_color % 2 ) == 0 )
                                                print "BGCOLOR=$color[10]>";
                                        else
                                                print "BGCOLOR=$color[9]>";
                                        print "&nbsp;</TD>\n";
                                }
                        }
                }
                print "</TR>\n";
                $toggle_color = ($toggle_color + 1) % 4;
        }
        print "</TABLE>";
        print "</FORM>";
        print "</TD></TR></TABLE>";
        print "</BODY>";
}

function drawSingleUserWeek( $SID , $persons , $start_index , $stop_index , $dayTime) {
        global $color;
        global $g_msg;
        global $week_starts_on_monday;
        global $show_weekend;

        // Calculate the week number!
        $week_nr = get_week_nr( $dayTime );
        $day_of_week = intval( date("w", $dayTime ) );
        $sunday_time = $dayTime - ( $day_of_week * 86400 );

        // The SingleWeek Overview can only show one person. If multiple are selected
        // then the Calendar for the Session User is shown. If only one is selected
        // That person will be shown
        if( count( $persons ) == 1 ) {
                $S_UID = $persons[0];
        } else {
                $S_UID = getUIDfromSID( $SID );
        }

        print "<HTML>\n";
        print_stylesheet();                                                                                         
        print "<BODY BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]>";

        show_header();
        $time = $sunday_time;

        $full_name = getFullNameFromUID( $S_UID );
        print "<FONT COLOR=$color[11]>\n";
        print "<h2> ".str_replace('$full_name',$full_name,lang_get('Week_ov'))." ".intval(intval(date("z", $dayTime ))/7)."</h2>\n";
        print "</FONT>\n";

        // Create a days appointments array with all given persons
        for( $i = ($week_starts_on_monday?1:0) ; $i < ($week_starts_on_monday?6:5)+($show_weekend?2:0) ; $i++ ) {
		$app_time = $time + ( $i * 86400 ); 
                $appointments[$i] = get_user_appointments( $S_UID , $app_time , 0);
                $notes[$i] = get_user_notes(  $S_UID , $app_time );
        }

        print "<TABLE WIDTH=250>\n";
        print "<TR><TD ALIGN=LEFT>";
        print "<A HREF=\"day.php?SID=$SID&show_time=";
        print ($dayTime-604800);
        print "\"><< ".lang_get('Last week')."</a>";
        print "</TD><TD ALIGN=RIGHT>";
        print "<A HREF=\"day.php?SID=$SID&show_time=";
        print ($dayTime+604800);
        print "\"> ".lang_get('Next week')." >></a>";
        print "</TD></TR>\n";
        print "</TABLE>";

        print "<TABLE BORDER=1 CELLPADDING=0 CELLSPACING=0 WIDTH=800>\n";

        print "<TR HEIGHT=16><TD></TD>\n";
        $link_time = $sunday_time;
        for( $i = ($week_starts_on_monday?1:0) ; $i < ($week_starts_on_monday?6:5)+($show_weekend?2:0) ; $i++ ) {
//        for( $i = 0 ; $i < 7 ; $i++ ) {
		$ltime = $link_time + ($i * 86400 );
                print "<TD ALIGN=CENTER BGCOLOR=$color[3] WIDTH=250>";
                print "<A HREF=\"".s_url("day.php?show_time=$ltime&View=0")."\">";
                print "<FONT COLOR=$color[6]> ";
		print lang_get(date("D",$ltime));
		print date(" j ",$ltime);
		print lang_get(date("M",$ltime))."</FONT></A></TD>\n";
        }
        print "</TR>\n";

        $UID = getUIDfromSID( $SID );

        // First show some notes!!
        print "<TR BGCOLOR=$color[0]><TD BGCOLOR=$color[0]>".lang_get("Notes")."</TD>\n";
        for( $person_index = ($week_starts_on_monday?1:0) ; $person_index < ($week_starts_on_monday?6:5)+($show_weekend?2:0) ;
                $person_index++ ) {
                print "<TD BGCOLOR=$color[0]>";
                for( $notes_index = 0 ; $notes_index <
                        sizeof( $notes[$person_index]) ;
                                $notes_index++ ) {
                        if( $notes_index > 0 )
                                print "<HR>";
                             $the_note = $notes[$person_index][$notes_index];
                        show_note( $the_note, $SID , $UID );
                       }
                print "&nbsp;</TD>";
        }


          $toggle_color = 0;
        for( $i = ($week_starts_on_monday?1:0) ; $i < ($week_starts_on_monday?6:5)+($show_weekend?2:0) ; $i++ ) {
//        for( $i = 0 ; $i < 7 ; $i++ ) {
                $mask_during_appointment[$i] = -1;
        }
        for( $i = $start_index ; $i <= $stop_index ; $i++ ) {
                print "<TR >";

                // Show time
                print "<TD WIDTH=32 ALIGN=CENTER ";
                if( $toggle_color < 2 )
                        print "BGCOLOR=$color[10]>";
                else
                        print "BGCOLOR=$color[9]>";

                $month = date("n",$dayTime);
                $day = date("d",$dayTime);
                $year = date("Y",$dayTime);
                $j = intval($i/2);
                $composed_time = mktime( $j ,($i > ($j *2) ? 30 : 0 ) ,0 , $month, $day, $year);

                print "<a href=\"".s_url("appointment-form.php?start_time=$composed_time");
                print "\">".$j.":".($i > ($j *2) ? "30" : "00" )."</a>";

                print "</TD>\n";


//                for( $person_index = 0 ; $person_index < 7 ;
        for( $person_index = ($week_starts_on_monday?1:0) ; $person_index < ($week_starts_on_monday?6:5)+($show_weekend?2:0) ;
                        $person_index++ ) {

                        for( $appointment_index = 0 ; $appointment_index <
                                count($appointments[$person_index]) ;
                                        $appointment_index++ ) {
                                $the_appointment = $appointments[$person_index][$appointment_index];

                                // If a appointment happens earlier then the start_index but ends
                                // after it... then we should also display something.

                                if( $i == $the_appointment[0] ) {
                                        if( $the_appointment[1] < $the_appointment[0] )
                                                $the_appointment[1] = 48 + $the_appointment[1];
                                        $appointmentLength = ($the_appointment[1] - $the_appointment[0] ) ;
                                        $rowspan = $appointmentLength;

                                        // If the appointment exceeds the stop_index truncate the rowspan!
                                        if( $rowspan + $i > $stop_index )
                                                $rowspan = $stop_index - $i +1;

                                        print "<TD WIDTH=400 ROWSPAN=" . $rowspan . " ";
                                        print "BGCOLOR=$color[12] VALIGN=TOP>";
                                        show_day_appointment( $the_appointment , $SID , $UID );

                                        if( $rowspan < $appointmentLength )
                                                print "<BR>(".lang_get('until')." " . cItT($the_appointment[1]) . ")";
                                        print "</TD>";
//                                        if( ($the_appointment[1] - $the_appointment[0]) > 1 )
                                                $mask_during_appointment[$person_index] = $the_appointment[1];
//                                        else
//                                                $mask_during_appointment[$person_index] = $the_appointment[1] +1;
                                }
                        }
                        if( $i >= $mask_during_appointment[$person_index] ) {
                                print "<TD WIDTH=160 ";
                                if( isToday( intval($dayTime) ) == 1 && (getCurrentIndex() == $i) ) {
                                        if( ( $toggle_color % 2 ) == 0 )
                                                print "BGCOLOR=$color[5]>";
                                        else
                                                print "BGCOLOR=$color[5]>";
                                        print "&nbsp;</TD>\n";

                                } else {
                                        if( ( $toggle_color % 2 ) == 0 )
                                                print "BGCOLOR=$color[10]>";
                                        else
                                                print "BGCOLOR=$color[9]>";
                                        print "&nbsp;</TD>\n";
                                }
                        }
                }
                print "</TR>\n";
                $toggle_color = ($toggle_color + 1) % 4;
        }
        print "</TABLE>";
        print "</FORM>";
//        print "</TD></TR></TABLE>";
        print "</BODY>";
}

function drawWeekTable( $SID , $persons , $dayTime, $flag=0) {
        global $color;
        global $g_msg;
	global $week_starts_on_monday;
	global $show_weekend;

        // Calculate the week number!
        $week_nr = intval(intval(date("z", $dayTime ))/7);
        $day_of_week = intval( date("w", $dayTime ) );
        $sunday_time = $dayTime - ( $day_of_week * 86400 );
        $UID = getUIDfromSID( $SID );

        print "<HTML>\n";
	print_stylesheet();
        print "<BODY BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]>";

        if( $flag == 0 || $flag == 1 ) {
                // Display the header!
                show_header();
                print "<TABLE WIDTH=250>\n";
                print "<TR><TD ALIGN=LEFT>";
                print "<A HREF=\"day.php?SID=$SID&show_time=";
                print ($dayTime-604800);
                print "\"><< ".lang_get('Last week')."</a>";
                print "</TD><TD ALIGN=RIGHT>";
                print "<A HREF=\"day.php?SID=$SID&show_time=";
                print ($dayTime+604800);
                print "\"> ".lang_get('Next week')." >></a>";
                print "</TD></TR>\n";
                print "</TABLE>";
                print "<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2 WIDTH=800>\n";
        }
        if ( $flag == 3 ) {
                print "<TR><TD></TD></TR>\n";
        }

        print "<TR BGCOLOR=$color[5]><TD></TD>";
	if( !$week_starts_on_monday && $show_weekend )
	        print "<TD WIDTH=200>".lang_get('Sunday')."</TD>";
        print "<TD WIDTH=300>".lang_get('Monday')."</TD><TD WIDTH=300>".lang_get('Tuesday')."</TD>";
        print "<TD WIDTH=300>".lang_get('Wednesday')."</TD><TD WIDTH=300>".lang_get('Thursday')."</TD>";
        print "<TD WIDTH=300>".lang_get('Friday')."</TD>";
	if( $show_weekend ) {
		print "<TD WIDTH=200>".lang_get('Saturday')."</TD>\n";
		if( $week_starts_on_monday )
		        print "<TD WIDTH=200>".lang_get('Sunday')."</TD>";
	}
	print "</TR>";

        print "<TR BGCOLOR=$color[3]><TD></TD>";
        for( $i = ($week_starts_on_monday?1:0) ; $i < ($week_starts_on_monday?6:5)+($show_weekend?2:0) ; $i++ ) {
                 $time = $sunday_time + ( $i * 86400 );
                 print "<TD><a href=\"".s_url("day.php")."&show_time=".$time."&View=0\">";
                print "<FONT COLOR=$color[6]>".date("j ",$time ).lang_get(date("F",$time))."</FONT></A></TD>";
        }
        print "</TD>";


        $bg_color = 0;

        for( $person_index = 0 ; $person_index < sizeof( $persons ) ; $person_index ++ ) {
                $result = pbcs_db_query("SELECT Surname FROM User WHERE ".
                              "ID = ".$persons[$person_index]);
                $row = pbcs_db_fetch_row($result);
                $username = $row[0];

                if( $bg_color == 0 )
                        print "<TR BGCOLOR=$color[10]><TD BGCOLOR=$color[3] WIDTH=200><FONT COLOR=$color[6]>".$username."</FONT></TD>";
                else
                        print "<TR BGCOLOR=$color[9]><TD BGCOLOR=$color[3] WIDTH=200><FONT COLOR=$color[6]>".$username."</FONT></TD>";
                 for( $day = ($week_starts_on_monday?1:0) ; $day < ($week_starts_on_monday?6:5)+($show_weekend?2:0) ; $day++ ) {
                         $morning = 0;
                         $afternoon = 0;
                         $time = $sunday_time + ( $day * 86400 );
                        $appointments = getUserAppointments( $persons[$person_index] , $time , 1);
                        if( sizeof( $appointments ) > 0 ) {
                                print "<TD BGCOLOR=$color[12] VALIGN=top>";
                                $output = "";
                                for( $i=0 ; $i < 48 ; $i++ ) {
                                        foreach($appointments as $appointment ) {
                                                if( $i == $appointment[0] ) {
                                                        if( $appointment[0] < 24 )
                                                                $morning = 1;
                                                        if( $appointment[0] >= 24 )
                                                                $afternoon = 1;

                                                        show_week_appointment( $appointment , $SID, $UID);
                                                 }
                                         }
                                }
                                if( $morning == 0 )
                                        $output = "&nbsp;<br>". $output;
                                if( $afternoon == 0 )
                                        $output = $output . "&nbsp;<BR>";

                                print $output . "</TD>";

                        } else {
                                print "<TD>&nbsp;</TD>";
                        }


                }
                print "</TR>\n";
                if( $bg_color == 0 )
                        $bg_color = 1;
                else
                        $bg_color = 0;
        }
        if( $flag == 0 || $flag == 3 ) {
                 // Display the footer
                print "</TABLE>\n";
        }

}

function drawTwoWeekTable( $SID , $persons ,  $dayTime) {
        global $g_msg;

         $time = $dayTime;
        drawWeekTable( $SID , $persons , $time, 1);
        $time = $dayTime + 604800 ;
        drawWeekTable( $SID , $persons , $time, 3);

}


function drawList( $SID , $persons , $dayTime) {
        global $color;
        global $g_msg;
	global $status_modification_protection;
	global $status_modification_level_difference;
	global $status_appointment_invisibility;
	global $status_appointment_level_difference;

        print "<HTML>\n";
	print_stylesheet();
        print "<BODY BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]>";

        show_header();

	$UID = getUIDfromSID( $SID );

        print "<FONT COLOR=$color[11]>\n";
        print "<h2> " . lang_get('list_appt_since') ." ". date("j ",$dayTime).lang_get(date("F",$dayTime)).date(" Y",$dayTime)."</h2>\n";
        print "</FONT>\n";

        $dayTime = intval( $dayTime / 86400 ) * 86400;

        $appointments = array();
        foreach($persons as $person) {
                 $result = pbcs_db_query("SELECT C.*, A.Surname FROM User A, JoinTable_UserAppointment B, Appointment C ".
                                        "WHERE A.ID = $person AND B.UserID = $person AND B.AppointmentID = C.ID ".
                                        "AND C.StartTime >= $dayTime");
//                print mysql_error();
                while( ($row = pbcs_db_fetch_array( $result ) ) ) {
                       $with_person = array_merge( $row , array( "User" => $person) );
                       $appointments[] = $with_person ;
                }
        }
        print "<TABLE border=1 cellspacing=0>\n";
        print "<TR BGCOLOR=$color[5]>";
        print "<TD WIDTH=175>".lang_get('Date')."</TD>
              <TD WIDTH=100>".lang_get('Who')."</TD>
              <TD WIDTH=300>".lang_get('Appointment')."</TD>
              <TD WIDTH=75>".lang_get('Start Time')."</TD>
              <TD WIDTH=75>".lang_get('End Time')."</TD>";
        print "</TR>\n";

        // We keep the number of shown appointments so we can cut the list
        // at a specified number which by default is 100
        $appointment_nr = 0;

        $appointments2 = sort_list( $appointments );
        $toggle = 1;
        $old_date  = 1;
        foreach( $appointments2 as $appointment) {
                if( date("d",$appointment["StartTime"]) != date("d",$old_date) ) {
                    if( $toggle == 0)
                            $toggle = 1;
                    else
                            $toggle = 0;
                    $old_date = $appointment["StartTime"];
                }
                if( $toggle == 0 ) {
                        print "<TR BGCOLOR=$color[10]>";
                } else {
                        print "<TR BGCOLOR=$color[9]>";
                }
 
		// We need the status of the appointment User
		if( $status_modification_protection ) {
			$AppStatus = getStatusFromUID( $appointment["User"] );
			$UIDStatus = getStatusFromUID( $UID );
		} else {
			$AppStatus = 0;
			$UIDStatus = 0;
		}

                print "<TD> <a href=\"day.php?SID=$SID&View=0&show_time=".$appointment["StartTime"]."\"> ";
		print lang_get(date("D", $appointment["StartTime"]));
		print date(" j ", $appointment["StartTime"]);
		print lang_get(date("M", $appointment["StartTime"]));
		print date(" Y", $appointment["StartTime"])."</a> </TD>";
                print "<TD>".$appointment["Surname"]."</TD>";
                if( $appointment["Private"] == 0 ) {
                        if( $appointment["IsNote"] == 0 )  {
				if( $status_appointment_invisibility && 
				    ($AppStatus - $UIDStatus) >= $status_appointment_level_difference )
					print "<TD>".lang_get("An appointment")."</TD>";
				else
                        	        print "<TD>".($appointment["Description"]==""?"&nbsp;":htmlspecialchars($appointment["Description"]))."</TD>";
                                print "<TD ALIGN=CENTER>".print_time($appointment["StartTime"])."</TD>";
                                print "<TD ALIGN=CENTER>".print_time($appointment["EndTime"])."</TD>" ;
                        } else {
				if( $status_appointment_invisibility && 
				    ($AppStatus - $UIDStatus) >= $status_appointment_level_difference )
					print "<TD>".lang_get("A note")."</TD>";
				else
                                print "<TD>".($appointment["Description"]==""?"&nbsp;":htmlspecialchars($appointment["Description"]))."</TD>";
                                print "<TD>&nbsp;</TD><TD>&nbsp;</TD";
                        }
                } else {
                        if( $appointment["IsNote"] == 0 )  {
                                print "<TD>".lang_get('Private Appointment')."</TD>";
                                print "<TD ALIGN=CENTER>".print_time($appointment["StartTime"])."</TD>";
                                print "<TD ALIGN=CENTER>".print_time($appointment["EndTime"])."</TD>" ;
                        } else {
                                print "<TD>".lang_get('Private Note')."</TD>";
                                print "<TD>&nbsp;</TD><TD>&nbsp;</TD";
                        }
                }
                print "</TR>\n";
                // Currently we jump off at 100 shown appointments.. this will get user definable.
                if( $appointment_nr++ == 100 ) {
                    print "<TR><TD COLSPAN=7>".lang_get('list_truncated')."</TD></TR>";
                    break;
                }
        }
	// correction for doing ++ even if we reach the 100th appointment.
	if( $appointment_nr > 100 )
		$appointment_nr -= 1;
        print "</TABLE>\n";
        print str_replace('$appointment_nr', "$appointment_nr", lang_get('total_appts'));
        print "</BODY>\n";
}

function drawMonth( $SID , $persons , $dayTime) {
        global $color, $g_msg;
	global $week_starts_on_monday;
	global $show_weekend;


        if( !isset($url) ) $url=s_url("day.php") ."&View=0&show_time=";

        print "<HTML>\n";
	print_stylesheet();
        print "<BODY BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]>";

        show_header();

        pbcs_db_connect();
        pbcs_db_select_db();

        $UID = getUIDfromSID( $SID );

        // The Month Overview can only show one person. If multiple are selected
        // then the Calendar for the Session User is shown. If only one is selected
        // That person will be shown
        if( count( $persons ) == 1 ) {
                $S_UID = $persons[0];
        } else {
                $S_UID = getUIDfromSID( $SID );
        }
        $full_name = getFullNameFromUID( $S_UID );

        global $g_msg;
        print "<FONT COLOR=$color[11]>\n";
        print "<h2>".lang_get('Month')." ".lang_get(date("F",$dayTime))." ".lang_get('Overview for')." $full_name</h2>";
        print "</FONT>\n";

        print "<TABLE WIDTH=250>\n";
        print "<TR><TD ALIGN=LEFT>";
        print "<A HREF=\"day.php?SID=$SID&show_time=";
        print mktime(0,0,0,date("m",$dayTime)-1,1,date("Y",$dayTime));
        print "\"><< ".lang_get('Last Month')."</a>";
        print "</TD><TD ALIGN=RIGHT>";
        print "<A HREF=\"day.php?SID=$SID&show_time=";
        print mktime(0,0,0,date("m",$dayTime)+1,1,date("Y",$dayTime));
        print "\"> ".lang_get('Next Month')." >></a>";
        print "</TD></TR>\n";
        print "</TABLE>";
        print "<TABLE BORDER=1 CELLSPACING=0>\n";
	print "<TR BGCOLOR=$color[5]><TD ALIGN=CENTER COLSPAN=".($show_weekend?7:5)."><h3>".lang_get(date("F",$dayTime))."</h3></TD></TR>";
        print "<TR BGCOLOR=$color[3]>";
        if( !$week_starts_on_monday && $show_weekend )
	        print "<TD WIDTH=200>".lang_get('Sunday')."</TD>";
        print "<TD WIDTH=300>".lang_get('Monday')."</TD><TD WIDTH=300>".lang_get('Tuesday')."</TD>";
        print "<TD WIDTH=300>".lang_get('Wednesday')."</TD><TD WIDTH=300>".lang_get('Thursday')."</TD>";
        print "<TD WIDTH=300>".lang_get('Friday')."</TD>";
        if( $show_weekend ) {
                print "<TD WIDTH=300>".lang_get('Saturday')."</TD>\n";
                if( $week_starts_on_monday )
                        print "<TD WIDTH=300>".lang_get('Sunday')."</TD>";
        }
        $month = date("n",$dayTime);
        $year = date("Y",$dayTime);
        $month_day = mktime(0,0,0,intval($month),1,intval($year));
        $last_day_of_month = intval(date("j",mktime(0,0,0,intval($month)+1,0,intval($year))));



        $day_of_week = intval(date("w",$month_day));
        $day_counter = 1;
        print "<TR>";
        for($i=($week_starts_on_monday?1:0);$i<($week_starts_on_monday?6:5)+($show_weekend?2:0);$i++) {
                $current_date = mktime(0,0,0,intval($month),intval($day_counter),intval($year));
                $appointments = getUserAppointments( $S_UID , $current_date , 1);

                print "<TD WIDTH=20 ALIGN=LEFT VALIGN=TOP";
                if( count( $appointments ) > 0 && $i>=$day_of_week ) {
                         print " BGCOLOR=$color[12]";
                } else {
                        if( $i==0 || $i==6 || $i==7)
                                print " BGCOLOR=$color[10] ";
                                else
                                print " BGCOLOR=$color[9] ";
                }
                print ">";
                if($i>=$day_of_week) {
                        print "<A TARGET='main' HREF='$url". mktime(0,0,0,intval($month),$day_counter,intval($year))."'>";
                        print $day_counter++;
                        print "</A><BR>\n";
                        if( count( $appointments ) > 0 ) {
                                for( $j=0 ; $j < 48 ; $j++ ) {
                                        foreach($appointments as $appointment ) {
                                                if( $j == $appointment[0] ) {
                                                        show_week_appointment( $appointment , $SID, $UID);
                                                 }
                                         }
                                      }
                        } else {
                                print "&nbsp;<BR>&nbsp;<BR>";
                        }


                } else {
                        print "&nbsp;<BR>&nbsp;<BR>&nbsp;<BR>";
                }
                print "</TD>\n";
        }
	if( !$show_weekend )
		$day_counter += 2;
        while( $day_counter <= $last_day_of_month ) {
                print "<TR>";
	        for($i=($week_starts_on_monday?1:0);$i<($week_starts_on_monday?6:5)+($show_weekend?2:0);$i++) {
                        $current_date = mktime(0,0,0,intval($month),intval($day_counter),intval($year));
                        $appointments = getUserAppointments( $S_UID , $current_date , 1);
                        print "<TD WIDTH=160 ALIGN=LEFT VALIGN=TOP";
                        if( count( $appointments ) > 0 && $day_counter <= $last_day_of_month) {
                                 print " BGCOLOR=$color[12] ";
                        } else {
                                if( $i==0 || $i==6 || $i==7)
                                        print " BGCOLOR=$color[10] ";
                                       else
                                        print " BGCOLOR=$color[9] ";
                        }
                        print ">";
                        if($day_counter <= $last_day_of_month) {
                                print "<A TARGET='main' HREF='$url". mktime(0,0,0,intval($month),$day_counter,intval($year))."'>";
                                print $day_counter++;
                                print " </A><BR>\n";
                                if( count( $appointments ) > 0 ) {
                                        for( $j=0 ; $j < 48 ; $j++ ) {
                                                foreach($appointments as $appointment ) {
                                                        if( $j == $appointment[0] ) {
                                                                show_week_appointment( $appointment , $SID, $UID);
                                                         }
                                                 }
                                              }

                                } else         {
                                        print "&nbsp;<BR>&nbsp;<BR>";
                                }
                        } else {
                                print "&nbsp;<BR>&nbsp;<BR>&nbsp;<BR>";
                        }
                        print "</TD>\n";

                }
		if( !$show_weekend )
			$day_counter += 2;
                print "</TR>\n";
        }
        print "</TABLE>";



}



        // THIS IS THE MAIN CODE!

        pbcs_db_connect();
        pbcs_db_select_db();

        is_authenticated();


        // If we want a different set of people to be shown we get those
        // users in a $users[] from the calendar/people frame
        if( isset( $users ) ) {
                // Delete the old Viewer entries for the current SID
                $result = pbcs_db_query("DELETE FROM Viewers WHERE SessionID=$SID");
                foreach( $users as $id ) {
                        $persons[] = $id ;
                        $result = pbcs_db_query("INSERT INTO Viewers VALUES(0,$SID,$id)");
                }
        }

        // Let's see if this PHP_AUTH_USER already has a Viewers list
        // if it has and it did not created it (with the above 'if'
        // statement _then_ we will use the viewers list (if available)
        $result = pbcs_db_query("SELECT A.ViewerID, B.Surname FROM " .
                                "Viewers A , User B ".
                                "WHERE A.SessionID = $SID ".
                                "AND A.ViewerID = B.ID ".
				"ORDER BY B.Surname"
                                );
        if( pbcs_db_num_rows( $result ) > 0 && count($persons) == 0) {
                $person = 0;
                while( ($row = pbcs_db_fetch_row( $result ) ) ) {
                        $persons[] = $row[0];
                }
        }

        if( !isset( $persons ) ) {
                $result = pbcs_db_query("SELECT UserID FROM Session WHERE ID = $SID");
                $row = pbcs_db_fetch_row($result);
                if( isset($row) ) {
                        $persons = array( $row[0] );
                        $id = $row[0];
                        pbcs_db_query("INSERT INTO Viewers VALUES(0,$SID,$id)");
                }
        }


        if( !isset( $show_time ) ) {
                // First check if a viewing date was set, if so use this instead of today.
                $result = pbcs_db_query("SELECT ViewingDate FROM Session WHERE ID=$SID");
                if( pbcs_db_num_rows( $result ) > 0 ) {
                        $row = pbcs_db_fetch_row( $result );
                        $show_time = intval( $row[0] );

                        // If the timestamp is 0 then pick the time today!
                        if( $show_time == 0 )
                            $show_time = time();
                } else {
                        $show_time = time();
                }
        } else {
                // Update the viewing date if it is set by the user.
                pbcs_db_query("UPDATE Session SET ViewingDate=$show_time WHERE ID=$SID");
        }

        if( isset( $View ) ) {
                pbcs_db_query("UPDATE Session SET View = $View WHERE ID=$SID");
        } else {

                $result = pbcs_db_query("SELECT View FROM Session WHERE ID=$SID");
                if( pbcs_db_num_rows( $result ) > 0 ) {
                    $row = pbcs_db_fetch_row( $result );
                    $View = $row[0];
                }
        }


        if( $View == 0 ) {
                $result = pbcs_db_query("SELECT DayOverviewStartIndex, DayOverviewEndIndex FROM ".
                                        "User A, Session B WHERE B.ID = $SID AND A.ID = B.UserID");
                $row = pbcs_db_fetch_row( $result );

                drawDayTable( $SID , $persons, $row[0] , $row[1], $show_time );
        }
        if( $View == 1 ) {
                 drawWeekTable( $SID, $persons, $show_time);
        }
        if( $View == 2 ) {
                 drawTwoWeekTable( $SID, $persons, $show_time );
        }
        if( $View == 3 ) {
                 drawList( $SID, $persons, $show_time );
        }
        if( $View == 4 ) {
                 drawMonth( $SID, $persons, $show_time );
        }
        if( $View == 5 ) {
                $result = pbcs_db_query("SELECT DayOverviewStartIndex, DayOverviewEndIndex FROM ".
                                        "User A, Session B WHERE B.ID = $SID AND A.ID = B.UserID");
                $row = pbcs_db_fetch_row( $result );
                 drawSingleUserWeek( $SID, $persons, $row[0], $row[1], $show_time );
        }
        print "</HTML>";
?>
