<?php

   $strings_php = true;

   // Randomize the mt_rand() function.  Toss this in strings or
   // integers and it will seed the generator appropriately.
   // With strings, it is better to get them long. Use md5() to
   // lengthen smaller strings.
   function sq_mt_seed($Val)
   {
       // if mt_getrandmax() does not return a 2^n - 1 number,
       // this might not work well.  This uses $Max as a bitmask.
       $Max = mt_getrandmax();

       if (! is_int($Val))
       {
           if (function_exists("crc32"))
           {
               $Val = crc32($Val);
           }
           else
           {
               $Str = $Val;
               $Pos = 0;
               $Val = 0;
               $Mask = $Max / 2;
               $HighBit = $Max ^ $Mask;
               while ($Pos < strlen($Str))
               {
                   if ($Val & $HighBit)
                   {
                       $Val = (($Val & $Mask) << 1) + 1;
                   }
                   else
                   {
                       $Val = ($Val & $Mask) << 1;
                   }
                   $Val ^= $Str[$Pos];
                   $Pos ++;
               }
           }
       }

       if ($Val < 0)
         $Val *= -1;
       if ($Val = 0)
         return;

       mt_srand(($Val ^ mt_rand(0, $Max)) & $Max);
   }

   // This function initializes the random number generator fairly well.
   // It also only initializes it once, so you don't accidentally get
   // the same 'random' numbers twice in one session.
   function sq_mt_randomize()
   {
      global $REMOTE_PORT, $REMOTE_ADDR, $UNIQUE_ID;
      static $randomized;

      if ($randomized)
         return;

      // Global
      sq_mt_seed((int)((double) microtime() * 1000000));
      sq_mt_seed(md5($REMOTE_PORT . $REMOTE_ADDR . getmypid()));

      // getrusage
//      if (function_exists("getrusage")) {
//         $dat = getrusage();
//         sq_mt_seed(md5($dat["ru_nswap"] . $dat["ru_majflt"] .
//            $dat["ru_utime.tv_sec"] . $dat["ru_utime.tv_usec"]));
//      }

      // Apache-specific
      sq_mt_seed(md5($UNIQUE_ID));

      $randomized = 1;
   }


   function replace_spaces ($string) {
      return str_replace(" ", "&nbsp;", $string);
   }

   function replace_escaped_spaces ($string) {
      return str_replace("&nbsp;", " ", $string);
   }

   function get_location () {
      # This determines the location to forward to relative
      # to your server.  If this doesnt work correctly for
      # you (although it should), you can remove all this
      # code except the last two lines, and change the header()
      # function to look something like this, customized to
      # the location of SquirrelMail on your server:
      #
      #   http://www.myhost.com/squirrelmail/src/login.php

      global $PHP_SELF, $SERVER_NAME, $HTTPS, $HTTP_HOST, $SERVER_PORT;

      // Get the path
      $path = substr($PHP_SELF, 0, strrpos($PHP_SELF, '/'));

      // Check if this is a HTTPS or regular HTTP request
      $proto = "http://";
      if(isset($HTTPS) && $HTTPS == 'on' ) {
        $proto = "https://";
      }

      // Get the hostname from the Host header or server config.
      $host = "";
      if (isset($HTTP_HOST) && !empty($HTTP_HOST))
      {
          $host = $HTTP_HOST;
      }
      else if (isset($SERVER_NAME) && !empty($SERVER_NAME))
      {
          $host = $SERVER_NAME;
      }

      $port = '';
      if (! strstr($host, ':'))
      {
          if (isset($SERVER_PORT)) {
              if (($SERVER_PORT != 80 && $proto == "http://")
                      || ($SERVER_PORT != 443 && $proto == "https://")) {
                  $port = sprintf(':%d', $SERVER_PORT);
              }
          }
      }

      if ($host)
          return $proto . $host . $port . $path;

      // Fallback is to omit the server name and use a relative URI,
      // although this is not RFC 2616 compliant.
      return $path;
   }

   function sqStripSlashes($string) {
      if (get_magic_quotes_gpc()) {
         $string = stripslashes($string);
      }
      return $string;
   }


   // These functions are used to encrypt the passowrd before it is
   // stored in a cookie.
   function OneTimePadEncrypt ($string, $pad) {
      for ($i = 0; $i < strlen ($string); $i++) {
         $encrypted .= chr (ord($string[$i]) ^ ord($pad[$i]));
      }

      return base64_encode($encrypted);
   }

   function OneTimePadDecrypt ($string, $pad) {
      $encrypted = base64_decode ($string);

      for ($i = 0; $i < strlen ($encrypted); $i++) {
         $decrypted .= chr (ord($encrypted[$i]) ^ ord($pad[$i]));
      }

      return $decrypted;
   }


   function OneTimePadCreate ($length=100) {
      sq_mt_randomize();

      for ($i = 0; $i < $length; $i++) {
         $pad .= chr(mt_rand(0,255));
      }

      return $pad;
   }

   // Check if we have a required PHP-version. Return TRUE if we do,
   // or FALSE if we don't.
   // To check for 4.0.1, use sqCheckPHPVersion(4,0,1)
   // To check for 4.0b3, use sqCheckPHPVersion(4,0,-3)
   // Does not handle betas like 4.0.1b1 or development versions
   function sqCheckPHPVersion($major, $minor, $release) {

      $ver = phpversion();
      eregi("^([0-9]+)\.([0-9]+)(.*)", $ver, $regs);

      // Parse the version string
      $vmajor  = strval($regs[1]);
      $vminor  = strval($regs[2]);
      $vrel    = $regs[3];
      if($vrel[0] == ".")
         $vrel = strval(substr($vrel, 1));
      if($vrel[0] == "b" || $vrel[0] == "B")
         $vrel = - strval(substr($vrel, 1));
      if($vrel[0] == "r" || $vrel[0] == "R")
         $vrel = - strval(substr($vrel, 2))/10;

      // Compare major version
      if($vmajor < $major) return false;
      if($vmajor > $major) return true;

      // Major is the same. Compare minor
      if($vminor < $minor) return false;
      if($vminor > $minor) return true;

      // Major and minor is the same as the required one.
      // Compare release
      if($vrel >= 0 && $release >= 0) {       // Neither are beta
         if($vrel < $release) return false;
      } else if($vrel >= 0 && $release < 0){  // This is not beta, required is beta
         return true;
      } else if($vrel < 0 && $release >= 0){  // This is beta, require not beta
         return false;
      } else {                                // Both are beta
         if($vrel > $release) return false;
      }

      return true;
   }

   // Avoid warnings/errors
   if (! function_exists("_")) {
      function _($str) { return $str; };
   }
   if (! function_exists("bindtextdomain")) {
      function bindtextdomain() { return; }
   }
   if (! function_exists("textdomain")) {
      function textdomain() { return; }
   }

?>
