<?php
// global.inc.php and db.php must be included in the parent php-file

// This is the authentication file for the PBCS with session management.
// It should be possible to log in multiple times with the same user as of
// v0.2

if(!isset($auth_php))
    include("auth/auth.php");
if(!isset($strings_php))
    include("auth/strings.php");
if(!isset($pbcs_themes_included)) {
    if( file_exists("themes.php") )
        include("themes.php");
    else
        include("../themes.php");
}

function authenticate () {
        $location = get_location();
           header("Location: $location/auth/login.php\n\n");
        exit();
}

function show_logout() {
                global $images;
		print "<a href=\"auth/signout.php?SID=-$sid\" TARGET=\"_top\">";
		show_image(11,"Logout");
		print "</a>";
}

function create_session( $UserID ) {
// Creates a new session entry in the database for a user with 'userID'
// It returns the session ID

        $host = $GLOBALS["REMOTE_ADDR"];
//        print $host;
        $timeout = time() + SESSION_TIMEOUT;
        pbcs_db_connect();
        pbcs_db_select_db();
        pbcs_db_query("INSERT INTO Session (ID, UserID, Timeout, Hostname, View, ViewingDate)".
                      "VALUES ( 0, $UserID, $timeout, \"$host\", 0 , ".time().")" );
//        print "$SID-create: ".pbcs_db_insert_id();
        return pbcs_db_insert_id();
}

function cleanup_sessions( $UserID ) {
        pbcs_db_connect();
        pbcs_db_select_db();
        pbcs_db_query("DELETE FROM Session WHERE UserID = $UserID AND Timeout > SESSION_TIMEOUT" );
}

function s_url( $url ) {
// This function returns an URL with the session ID appended to it using the GET method.
// This saves a lot of typing for URLs
// The code checks if there are already arguments appended.

        $SID = $GLOBALS["SID"];
        if( !$SID ) $SID = 0;

        $pos = strpos( $url , "?");
        if( is_integer($pos) && $pos ) {
                // there are no arguments yet.
                return $url ."&SID=$SID";
        } else {
                return $url ."?SID=$SID";
        }
}

function check_authentication() {
// Check if PHP_AUTH_USER anf PHP_AUTH_PW are used and also see to it
// that there is a valid session for the user. If not create one.
// If a session is not timed out and there are multiple of a system available
// then the user is given a choice to pick a former session.
//
// If SID = 0  then there was no session ID given
// If SID < 0  then the user wants to log out and its session ID = -(SessionID)
// If SID > 0  then it could be a valid session ID
//
// The return value is session ID

        $PHP_AUTH_USER = $GLOBALS["username"];
        $SID = $GLOBALS["SID"];

        pbcs_db_connect() or die("Unable to connect to SQL server");
        pbcs_db_select_db() or die( "Unable to select database");

        // If the PHP AUTH USER is not set at all then we should urge the user
        // to enter a username and password!
        if(!isset($PHP_AUTH_USER)) {
                authenticate();
        } else {


                // Get all sessions for the user
                $result = pbcs_db_query("select * from User A, Session B where A.Login='$user' AND A.Password='$pass' AND A.ID = B.UserID AND B.ID = $session_id");

                // This is the logout sequence
                if( $SID < 0 ) {
//                        print "Logout dude!";
                        // If the Timeout time is larger then zero, then the user should, be
                        // logged out. If it is is zippo then a new login is attempted.
                        if( pbcs_db_num_rows($result) > 0 ) {
                                // Logging out the current user
                                pbcs_db_query("DELETE FROM Session WHERE ID = $session_id");
                                pbcs_db_free_result($result);
                                authenticate();
                                return 0;
                        }
                }

                if( $result ) pbcs_db_free_result($result);

                if( $SID > 0 ) {
                         $nowtime = time();
                        $result = pbcs_db_query("SELECT Timeout FROM Session WHERE ID=$session_id AND Timeout > $nowtime") or die("kuk2");

                         if (pbcs_db_num_rows($result) == "0") {
                                 $timeout = time() + SESSION_TIMEOUT ;
                                pbcs_db_free_result($result);
                                 pbcs_db_query("UPDATE Session SET Timeout='$timeout' WHERE ID=$session_id") or die("k auth again");
//                                print "time updated";
                                return $session_id;
                         }
                }  else {
                        // cleaning up existing sessions first
                        cleanup_sessions( $ID );

                        $result = pbcs_db_query("SELECT ID, Hostname FROM Session WHERE UserID = $ID");
                        if( pbcs_db_num_rows($result) > 0 ) {
                                // Valid sessions for this user exist
                                while( ($row = pbcs_db_fetch_row( $result) ) ) {
                                        if( $row[1] == $GLOBALS["REMOTE_ADDR"] )  {
                                                // Found first match... for now we thake that!
                                                return $row[0];
                                        }
                                }
                        }
                        return create_session( $ID );
                }
        }
}

function is_authenticated() {

         global $g_msg;
        $PHP_AUTH_USER = $GLOBALS["PHP_AUTH_USER"];
        $PHP_AUTH_PW = $GLOBALS["PHP_AUTH_PW"];
        $SID = $GLOBALS["SID"];

//        print "SID: $SID<br>Sorry! I am debugging a but in the demo version!";

        if( !is_logged_in() ) {
                //        authenticate();
                print $g_msg['auth_first'];
                exit();
        }

}

function is_admin() {

        global $SID, $username ;

        pbcs_db_connect() or die("Unable to connect to SQL server");
        pbcs_db_select_db() or die( "Unable to select database");


        $result = pbcs_db_query("select Status from User where Login='$username'") or die("Error getting status");

         if (pbcs_db_num_rows($result) > 0) {
                $row = pbcs_db_fetch_row( $result );
                $status = $row[0];
        } else {
                 $status = 0;
        }

        if( $status < 127 ) {
                print "<h1> You are not authorised to Administer </h1>";
                print "<a href=\"". s_url("..") ."\" target=_parent>Go to the calendar</a>";
                exit();
        }

}

// added by MH
// check if the bits in $level are also
// set in Status. This enables a very
// granular check of administration levels
function is_auth_level($level)
{
  global $SID, $username;
  pbcs_db_connect() or die("Unable to connect to SQL server");
  pbcs_db_select_db() or die( "Unable to select database");

  $result = pbcs_db_query("select Status from User where Login='$username'") or die("Error getting status");

  if (pbcs_db_num_rows($result) > 0) {
     $row = pbcs_db_fetch_row( $result );
     $status = $row[0];
  } else {
     $status = 0;
  }

  if( $status & $level ) {
    return true;
  } else {
    return false;
  }
}


?>
