<?php
// File-name      : appointment-edit.php
// Purpose        : This file will handle the GUI for: the creation of new
//                    appointments and the manipulation of existing appointments
//
// Created on     : 1-11-2000
// Author         : Roalt Zijlstra
// Updated on     : 11-11-2000
// Included since : v0.1
// The actual storage in the Database will be in appointment-check.php
session_start();
require_once("config/config.php");
require_once("db.php");
require_once("auth.php");
require_once("lang.php");

lang_init();

is_authenticated();

pbcs_db_connect ();
pbcs_db_select_db();

?>

<HTML>
<HEAD><TITLE><? $g_msg->show('Appointment Form') ?></TITLE>
<?php print_stylesheet(); ?>
</HEAD>
<BODY <?php print "BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]"; ?>>
<font color=<? print $color[11]; ?>>
<h1><? $g_msg->show('Appointment Form') ?></h1>
</font>
<p>
<? $g_msg->show('ap_explain1'); ?>
<p>
<FORM METHOD=POST ACTION="appointment-check.php" NAME="appointment_form">
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>
<TR bgcolor=<? print $color[5]; ?>><TD WIDTH=80>&nbsp;<? $g_msg->show('Date') ?></TD><TD ALIGN=RIGHT>
<SELECT NAME="day_nr">
<?php

        if( $AppointmentID ) {
                $result = pbcs_db_query("SELECT * FROM Appointment WHERE ID = $AppointmentID");
//                $appointment = pbcs_db_fetch_row( $result );
                list( $ID , $start_time, $end_time , $description,
                       $is_note, $private ) = pbcs_db_fetch_row( $result );
        } else {
                if( !isset( $start_time ) ) {
                        // First check if a viewing date was set, if so use this instead of today.
                        $result = pbcs_db_query("SELECT ViewingDate FROM Session WHERE ID=$SID");
                        if( pbcs_db_num_rows( $result ) > 0 ) {
                                $row = pbcs_db_fetch_row( $result );
                                $start_time = intval( $row[0] );
                        } else {
                                $start_time = time();
                        }
                }
                $end_time = $start_time;
                $description = "";
                $is_note = 0;
                $private = 0;
                $AppointmentID = 0;
        }

        $time = $start_time;

        $day_number = intval(date("j",$time));
        for( $i = 1 ; $i <= 31 ; $i++ ) {
                print "<OPTION VALUE='$i'";
                if( $i == $day_number ) print " SELECTED ";
                print ">$i\n";
        }
?>
</SELECT>

</TD><TD>
<SELECT NAME="month">
<?php
        $month=intval(date("n",$time));
        for( $i = 1 ; $i <= 12 ; $i++ ) {
                print "<OPTION VALUE='$i'";
                if( $i == $month ) print " SELECTED ";
                print ">".lang_get(date("F",mktime(0,0,0,$i,1,2000))) ."\n";
        }
?>
</SELECT>
</TD><TD>
<SELECT NAME="year">
<?php
        $year=intval(date("Y",$time));
        for( $i = 2000 ; $i <= 2010 ; $i++ ) {
                print "<OPTION VALUE='$i'";
                if( $i == $year ) print " SELECTED ";
                print ">$i\n";
        }
?>
</SELECT>
</TD>
</TR>

<TR><TD COLSPAN=2 VALIGN=top><BR>
<? $g_msg->show('Appointment Description') ?>:<BR>
<TEXTAREA NAME="description" ROWS=6 COLS=40>
<?php
print $description;
?>
</TEXTAREA>

</TD>
<TD VALIGN=top><BR><? $g_msg->show('Attendees') ?>:<BR>
<SELECT SIZE=10 NAME="attendees[]" MULTIPLE>
<?php

         //pbcs_db_free_result($result);
        if( $AppointmentID > 0 ) {
                $result = pbcs_db_query("SELECT UserID FROM " .
                                        "JoinTable_UserAppointment ".
                                        "WHERE AppointmentID = $AppointmentID");
        } else {
                $result = pbcs_db_query("SELECT ViewerID FROM " .
                                        "Viewers ".
                                        "WHERE SessionID = $SID");
        }
        if( pbcs_db_num_rows( $result ) > 0 && count($persons) == 0) {
                while( ($row = pbcs_db_fetch_row( $result ) ) ) {
                        $viewers[] = $row[0];
                }
        }
        pbcs_db_free_result($result);
        $result = pbcs_db_query("SELECT ID,Surname FROM User ORDER BY Surname");
        while( $row = pbcs_db_fetch_array($result) ) {
                print "<OPTION VALUE=\"".$row["ID"]."\" ";
                if( in_array($row["ID"],$viewers) )
                        print "SELECTED ";
                print ">".$row["Surname"];
        }
?>

</SELECT>
</TD>
<TD VALIGN=top><? $g_msg->show('relateProj') ?>
<SELECT NAME="projectcode" SIZE=10>
<?php
        pbcs_db_free_result($result);
        $project_result = pbcs_db_query("SELECT ProjectID FROM JoinTable_AppointmentProject ".
                                        "WHERE AppointmentID = $AppointmentID");
        if( pbcs_db_num_rows( $project_result ) > 0 ) {
                $row = pbcs_db_fetch_row( $project_result );
                $project_id = $row[0];
        } else
                $project_id = 0;

        $result = pbcs_db_query("SELECT ID,Code FROM Project");
        while( $row = pbcs_db_fetch_array($result) ) {
                print "<OPTION VALUE=\"".$row["ID"]."\" ";
                if( intval($row["ID"]) == $project_id )
                        print " SELECTED ";
                print ">".$row["Code"];
        }

?>
</SELECT>

</TD>
</TR>
<TR><TD WIDTH=150><? $g_msg->show('Start Time') ?>:
</TD><TD>
<?php
        $shown_hour = date("H",$start_time);
        print "<SELECT NAME=start_hour>";
        for( $i=0 ; $i<24 ; $i++ ) {
                if( $i == intval($shown_hour) )
                        print "<OPTION VALUE=\"$i\" SELECTED>$i\n";
                else
                        print "<OPTION VALUE=\"$i\">$i\n";
        }
        print "</SELECT> : ";
        $shown_minutes = date("i",$start_time);
        print "<SELECT NAME=start_minutes>";
        for( $i=0 ; $i<60 ; $i = $i + 15 ) {
                if( $i == intval($shown_minutes) )
                        print "<OPTION VALUE=\"$i\" SELECTED>$i\n";
                else
                        print "<OPTION VALUE=\"$i\">$i\n";
        }
        print "</SELECT>";
//        print "<INPUT TYPE=hidden VALUE=\"$shown_time\" NAME=start_minutes>\n";
        $duration = $end_time - $start_time;
        $dur_hour = intval( $duration / 3600 );
        $dur_minutes = intval(($duration - ( $dur_hour * 3600 ) ) / 60 );

        print "</TD><TD>";
        print $g_msg->get("Duration") .":<br>";
        print "</TD><TD>";

        print "<SELECT NAME=\"duration\" HEIGTH=32>";
        $dur_in_minutes = ($dur_hour * 60) + $dur_minutes;
	
	// If an appointment has no duration set the default duration.
	if( $dur_in_minutes == 0 && $default_appointment_duration > 0 )
		$dur_in_minutes = $default_appointment_duration;

        for($dur = 0 ; $dur <= 600 ; $dur = $dur + 30 ) {
                if( $dur > 240 ) $dur = $dur + 30;
                 print "<OPTION VALUE=\"".$dur."\"";
                 if( $dur_in_minutes == $dur )
                         print " SELECTED ";
                 print ">";
                 if( $dur == 0 )
                         print $g_msg->get("No Duration");
                 else {
                         $hour = intval($dur / 60 );
                         $minutes = $dur - ( $hour * 60 );
                         print "".$hour."H ".($minutes > 0 ? $minutes."m" : "");
                 }
                 print "\n";
        }
?>
</SELECT>
</TD></TR>
</TABLE>
<P>
<? $g_msg->show('privateApp?') ?>
<?php
        print "<INPUT TYPE=RADIO NAME=\"private\" VALUE=0";
        if( $private == 0 ) print " CHECKED ";
        print ">".$g_msg->get('No').".\n";
        print "<INPUT TYPE=RADIO NAME=\"private\" VALUE=1";
        if( $private == 1 ) print " CHECKED ";
        print ">".$g_msg->get('Yes').".";
?>
<P>
<? show_input_image(17, "Book_Appointment" ,lang_get('Book Appointment')); ?>
<hr><p>

<?php
	lang_show('ap_explain2');
        print "<INPUT TYPE=hidden NAME=AppointmentID VALUE=$AppointmentID>";
        print "<INPUT TYPE=hidden NAME=SID VALUE=$SID>";
?>
<p>
<font color=<? print $color[11]; ?>>
<h3><? $g_msg->show('Recurrence Type') ?>:</h3>
</font>

<SCRIPT language="Javascript">
function setRecurrenceType( type_val ) {
        if( document.forms[0].RecurrenceType[type_val].checked == false )
                document.forms[0].RecurrenceType[type_val].checked = true;
}

</SCRIPT>

<TABLE BORDER=1>
<TR><TD><INPUT TYPE=radio NAME=RecurrenceType VALUE="None" CHECKED><? lang_show('No Recurrence'); ?>
<TR><TD><INPUT TYPE=radio NAME=RecurrenceType VALUE="Daily"><? $g_msg->show('Daily') ?>
    </TD>
    <TD><INPUT TYPE=radio NAME=DailyType VALUE="WorkDays" onClick="setRecurrenceType(1); "><? $g_msg->show('Every workday') ?><br>
        <INPUT TYPE=radio NAME=DailyType VALUE="DaysInterval" onClick="setRecurrenceType(1); "><? $g_msg->show('Every') ?>
        <INPUT TYPE=text NAME="DailyInterval" VALUE="1" SIZE=4 onClick="document.forms[0].DailyType[1].checked = true; setRecurrenceType(1); "> <? $g_msg->show('day(s)') ?>
    </TD>
</TR>
<TR><TD><INPUT TYPE=radio NAME=RecurrenceType VALUE="Weekly"><? $g_msg->show('Weekly') ?>
    </TD>
    <TD><? $g_msg->show('Every') ?>
        <INPUT TYPE=text NAME="WeeklyInterval" VALUE="1" SIZE=4 onClick="setRecurrenceType(2); "> <? $g_msg->show('weeks(s) on') ?>:<br>
        <INPUT TYPE=checkbox NAME="Weekly[]" VALUE="0" onClick="setRecurrenceType(2); "><? $g_msg->show('Sunday') ?>
        <INPUT TYPE=checkbox NAME="Weekly[]" VALUE="1" onClick="setRecurrenceType(2); "><? $g_msg->show('Monday') ?>
        <INPUT TYPE=checkbox NAME="Weekly[]" VALUE="2" onClick="setRecurrenceType(2); "><? $g_msg->show('Tuesday') ?>
        <INPUT TYPE=checkbox NAME="Weekly[]" VALUE="3" onClick="setRecurrenceType(2); "><? $g_msg->show('Wednesday') ?><br>
        <INPUT TYPE=checkbox NAME="Weekly[]" VALUE="4" onClick="setRecurrenceType(2); "><? $g_msg->show('Thursday') ?>
        <INPUT TYPE=checkbox NAME="Weekly[]" VALUE="5" onClick="setRecurrenceType(2); "><? $g_msg->show('Friday') ?>
        <INPUT TYPE=checkbox NAME="Weekly[]" VALUE="6" onClick="setRecurrenceType(2); "><? $g_msg->show('Saturday') ?>

    </TD>
</TR>
<TR><TD><INPUT TYPE=radio NAME=RecurrenceType VALUE="Monthly"><? $g_msg->show('Monthly') ?>
    </TD>
    <TD><INPUT TYPE=radio NAME=MonthlyType VALUE="Absolute" onClick="setRecurrenceType(3); "><? $g_msg->show('Day') ?>
               <INPUT TYPE=text NAME="MonthlyAbsoluteDayNr" VALUE="1" SIZE=2 onClick="document.forms[0].MonthlyType.checked = true; setRecurrenceType(3); "> <? $g_msg->show('of every') ?>
               <INPUT TYPE=text NAME="MonthlyAbsoluteMonthInterval" VALUE="1" SIZE=2 onClick="document.forms[0].MonthlyType.checked = true; setRecurrenceType(3); "> <? $g_msg->show('month(s)') ?><br>
<!-- Will implement this a later version then v0.4
        <INPUT TYPE=radio NAME=MonthlyType VALUE="Relative"><? $g_msg->show('The') ?>
               <SELECT NAME=MonthlyRelativeNumerator>
                    <OPTION VALUE=1 SELECTED><? $g_msg->show('First') ?></OPTION>
                    <OPTION VALUE=2><? $g_msg->show('Second') ?></OPTION>
                    <OPTION VALUE=3><? $g_msg->show('Third') ?></OPTION>
                    <OPTION VALUE=4><? $g_msg->show('Fourth') ?></OPTION>
                    <OPTION VALUE=5><? $g_msg->show('Fifth') ?></OPTION>
                    <OPTION VALUE=-1><? $g_msg->show('Last') ?></OPTION>
               </SELECT>
               <SELECT NAME=MonthlyRelativeDay>
                    <OPTION VALUE=1 SELECTED>Monday<? $g_msg->show('Monday') ?></OPTION>
                    <OPTION VALUE=2><? $g_msg->show('Tuesday') ?></OPTION>
                    <OPTION VALUE=3><? $g_msg->show('Wednesday') ?></OPTION>
                    <OPTION VALUE=4><? $g_msg->show('Thursday') ?></OPTION>
                    <OPTION VALUE=5><? $g_msg->show('Friday') ?></OPTION>
                    <OPTION VALUE=6><? $g_msg->show('Saturday') ?></OPTION>
                    <OPTION VALUE=7><? $g_msg->show('Sunday') ?></OPTION>
               </SELECT> of every
               <INPUT TYPE=text NAME="MonthlyRelativeMonthInterval" VALUE="1" SIZE=2> <? $g_msg->show('month(s)') ?>
-->
    </TD>
</TR>
<TR><TD><INPUT TYPE=radio NAME=RecurrenceType VALUE="Yearly"><? $g_msg->show('Yearly') ?>
    </TD>
    <TD><INPUT TYPE=radio NAME=YearlyType VALUE="Absolute" onClick="setRecurrenceType(4); "><? $g_msg->show('Day') ?>
               <INPUT TYPE=text NAME="YearlyAbsoluteDayNr" VALUE=1 SIZE=2 onClick="document.forms[0].YearlyType.checked = true; setRecurrenceType(4); "> <? $g_msg->show('year_of') ?>
               <SELECT NAME=YearlyAbsoluteMonth onClick="document.forms[0].YearlyType.checked = true; setRecurrenceType(4); ">
                    <OPTION VALUE=1 SELECTED><? $g_msg->show('January') ?></OPTION>
                    <OPTION VALUE=2><? $g_msg->show('February') ?></OPTION>
                    <OPTION VALUE=3><? $g_msg->show('March') ?></OPTION>
                    <OPTION VALUE=4><? $g_msg->show('April') ?></OPTION>
                    <OPTION VALUE=5><? $g_msg->show('May') ?></OPTION>
                    <OPTION VALUE=6><? $g_msg->show('June') ?></OPTION>
                    <OPTION VALUE=7><? $g_msg->show('July') ?></OPTION>
                    <OPTION VALUE=8><? $g_msg->show('August') ?></OPTION>
                    <OPTION VALUE=9><? $g_msg->show('October') ?></OPTION>
                    <OPTION VALUE=10><? $g_msg->show('September') ?></OPTION>
                    <OPTION VALUE=11><? $g_msg->show('November') ?></OPTION>
                    <OPTION VALUE=12><? $g_msg->show('December') ?></OPTION>
               </SELECT><br>
<!-- Will implement this a later version then v0.4
        <INPUT TYPE=radio NAME=YearlyType VALUE="Relative"><? $g_msg->show('The') ?>
               <SELECT NAME=YearlyRelativeNumerator>
                    <OPTION VALUE=1 SELECTED><? $g_msg->show('First') ?></OPTION>
                    <OPTION VALUE=2><? $g_msg->show('Second') ?></OPTION>
                    <OPTION VALUE=3><? $g_msg->show('Third') ?></OPTION>
                    <OPTION VALUE=4><? $g_msg->show('Fourth') ?></OPTION>
                    <OPTION VALUE=5><? $g_msg->show('Fifth') ?></OPTION>
                    <OPTION VALUE=-1><? $g_msg->show('Last') ?></OPTION>
               </SELECT>
               <SELECT NAME=YearlyRelativeDay>
                    <OPTION VALUE=1 SELECTED><? $g_msg->show('Monday') ?></OPTION>
                    <OPTION VALUE=2><? $g_msg->show('Tuesday') ?></OPTION>
                    <OPTION VALUE=3><? $g_msg->show('Wednesday') ?></OPTION>
                    <OPTION VALUE=4><? $g_msg->show('Thursday') ?></OPTION>
                    <OPTION VALUE=5><? $g_msg->show('Friday') ?></OPTION>
                    <OPTION VALUE=6><? $g_msg->show('Saturday') ?></OPTION>
                    <OPTION VALUE=7><? $g_msg->show('Sunday') ?></OPTION>
               </SELECT> of
               <SELECT NAME=YearlyRelativeMonth>
                    <OPTION VALUE=1 SELECTED><? $g_msg->show('January') ?></OPTION>
                    <OPTION VALUE=2><? $g_msg->show('February') ?></OPTION>
                    <OPTION VALUE=3><? $g_msg->show('March') ?></OPTION>
                    <OPTION VALUE=4><? $g_msg->show('April') ?></OPTION>
                    <OPTION VALUE=5><? $g_msg->show('May') ?></OPTION>
                    <OPTION VALUE=6><? $g_msg->show('June') ?></OPTION>
                    <OPTION VALUE=7><? $g_msg->show('July') ?></OPTION>
                    <OPTION VALUE=8><? $g_msg->show('August') ?></OPTION>
                    <OPTION VALUE=9><? $g_msg->show('September') ?></OPTION>
                    <OPTION VALUE=10><? $g_msg->show('October') ?></OPTION>
                    <OPTION VALUE=11><? $g_msg->show('November') ?></OPTION>
                    <OPTION VALUE=12><? $g_msg->show('December') ?></OPTION>
               </SELECT>
-->
    </TD>
</TR>
</TABLE>
<font color=<? print $color[11]; ?>>
<h3><? $g_msg->show('Recurrence Period') ?>:</h3>
</font>
<TABLE>
<TR>
    <TD><INPUT TYPE=radio NAME=PeriodType VALUE="Repeat"><? $g_msg->show('Repeat') ?>
        <INPUT TYPE=text NAME="PeriodRepeatNr" VALUE="1" SIZE=2 onClick="document.forms[0].PeriodType[0].checked = true;"> <? $g_msg->show('time(s)') ?>
    </TD>
</TR>
<TR>
    <TD><INPUT TYPE=radio NAME=PeriodType VALUE="EndDate"><? $g_msg->show('End date is') ?>
<SELECT NAME="EndDayNr" onClick="document.forms[0].PeriodType[1].checked = true;">
<?php
        $day_number = intval(date("j",$start_time));
        for( $i = 1 ; $i <= 31 ; $i++ ) {
                print "<OPTION VALUE='$i'";
                if( $i == $day_number ) print " SELECTED ";
                print ">$i\n";
        }
?>
</SELECT>

</TD><TD>
<SELECT NAME="EndMonth" onClick="document.forms[0].PeriodType[1].checked = true;">
<?php
        $month=intval(date("n",$start_time));
        for( $i = 1 ; $i <= 12 ; $i++ ) {
                print "<OPTION VALUE='$i'";
                if( $i == $month ) print " SELECTED ";
                print ">".date("F",mktime(0,0,0,$i,1,2000)) ."\n";
        }
?>
</SELECT>
</TD><TD>
<SELECT NAME="EndYear" onClick="document.forms[0].PeriodType[1].checked = true;">
<?php
        $year=intval(date("Y",$start_time));
        for( $i = 2000 ; $i <= 2010 ; $i++ ) {
                print "<OPTION VALUE='$i'";
                if( $i == $year ) print " SELECTED ";
                print ">$i\n";
        }
?>
</SELECT>
    </TD>
</TR>
</TABLE>
<? show_input_image(25, "Make_Recurrent" ,lang_get('Make Recurrent')); ?>
</FORM>
</BODY>
</HTML>

