<?php
session_start();
require_once("config/config.php");
require_once("db.php");
require_once("auth.php");
require_once("lang.php");

lang_init();

function check_appointment( $appointment_unix_time ) {
	global $duration, $attendees, $AppointmentID;

	$i =0;
	while( isset($attendees[$i]) ) {
		$result = pbcs_db_query("SELECT Login FROM User WHERE ID=".$attendees[$i]);
		$row = pbcs_db_fetch_row($result);
		$login = $row[0];
		$attendeeIDs[$login] = $attendees[$i];
		$meetings[$login] = getUserAppointments( $attendees[$i] , $appointment_unix_time , 0);
		$i++;
	}

	$start_hour = intval( date("G",$appointment_unix_time) );
	$start_minutes = intval( date("i",$appointment_unix_time) );
	$month = intval( date("n",$appointment_unix_time) );
	$day_nr = intval( date("j",$appointment_unix_time) );
	$year = intval( date("Y",$appointment_unix_time) );

	$duration_hour = intval(($duration / 60));
	$duration_minutes = $duration - ($duration_hour * 60);

	// We use mkdate because php can do the date calculation for us. No, no
	// I am not a lazy bastard :-)
	$end_time = mktime(intval($start_hour) + intval($duration_hour),
				intval($start_minutes) + intval($duration_minutes),
				0,intval($month),intval($day_nr),intval($year));

	$end_hour = date("G",$end_time);
	$end_minutes = date("i",$end_time);

	// All meetings have index numbers instead of unix time stamps...
	// These indexes are easier to use for representation in the day overview.
	// Maybe I should not use it this way... but I want functionality fast..
	// so I leave this to be tuned later!
	$start_index = cTtI( $start_hour , $start_minutes);
	$end_index = cTtI( $end_hour , $end_minutes);

	$conflicting_persons = array();

	foreach($meetings as $name => $i) {
	 	foreach($i as $j) {
                        if( $AppointmentID == $j[3] )
	                        continue;
                        if( $start_index > $j[0] &&
	 		    $start_index < $j[1] ) {
//	 		    	print "Start time conflict for $name!<br>$j[2]<p>";
	 		    	if( !in_array($name,$conflicting_persons) )
	 		    		$conflicting_persons[] = $name;
		 	}
	 		if( $end_index > $j[0] &&
	 		    $end_index < $j[1] ) {
//	 		    	print "End time conflict for $name!<br>$j[2]<p>";
	 		    	if( !in_array($name,$conflicting_persons) )
	 		    		$conflicting_persons[] = $name;
	 		}
	 		if( $start_index <= $j[0] && $end_index >= $j[1] ) {
//	 			print "Overlapping appointment conflict for $name!<br>$j[2]<p>";
	 		    	if( !in_array($name,$conflicting_persons) )
	 		    		$conflicting_persons[] = $name;
	 		}
	 	}
	}
//	print_r($conflicting_persons);
	return $conflicting_persons;
}

function get_attendee_login_list( $attendees ) {
        $attendee_login_list = array();
	$i=0;
	while( isset($attendees[$i]) ) {
		$result = pbcs_db_query("SELECT Login FROM User WHERE ID=".$attendees[$i]);
		$row = pbcs_db_fetch_row($result);
		$login = $row[0];
		$attendee_login_list[$login] = $attendees[$i];
		$i++;
	}
	return $attendee_login_list;
}

/********************************** MAIN *************************/


	is_authenticated();

	// If the appointment is check then we book it reading all information from the
	// hidden form that we send at the end of this file. All appointment unix timestamps
	// and the corresponding users are in there.


	if( isset( $AppointmentChecked ) ) {

		pbcs_db_connect ();
		pbcs_db_select_db();

		print "<HTML>\n";
		print "<HEAD>\n";
		print "<META http-equiv=\"refresh\" content=\"0;url=".s_url("day.php")."\">\n";
		print "</HEAD>\n<BODY <BODY BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]>\n";
//		print "AppID: $AppointmentID";

		$duration_hour = intval(($Duration / 60));
		$duration_minutes = $Duration - ($duration_hour * 60);

		if( !isset( $AppointmentNumber ) )
			$AppointmentNumber = 1;

//		print "We have $AppointmentNumber to handle.<br>";
		if( $AppointmentNumber > 1 ) {
        	// For release v0.4 we only remember that we had a recurrent
			// appointent. Using the ID in all Appointments makes it easy
			// To undo recurrent appointments.
			pbcs_db_query("INSERT INTO RecurrentAppointment (ID, StartDate, EndDate, Type) ".
							"VALUES ('', '2', '2', '0')");
			$rec_id = pbcs_db_insert_id();
		} else
			$rec_id = 0;

		$mail_to = "";
		$mail_to_fullnames = "";
		$appointments_to_mail = "";

	    for( $index=0 ; $index < $AppointmentNumber ; $index++ ) {

		$varname = "Appointment$index";

//		print "varname: $varname<br>";
		$appointment_unix_time = $$varname;
//		print "On date ".date("j F Y",$appointment_unix_time)." at ".date("G:i",$appointment_unix_time)."<br>\n";

		$varname2 = "Attendees$index";

//		print "varname: $varname2<br>";
		$attendees = $$varname2;

		$start_hour = intval( date("G",$appointment_unix_time) );
		$start_minutes = intval( date("i",$appointment_unix_time) );
		$month = intval( date("n",$appointment_unix_time) );
		$day_nr = intval( date("j",$appointment_unix_time) );
		$year = intval( date("Y",$appointment_unix_time) );

		// We use mkdate because php can do the date calculation for us. No, no
		// I am not a lazy bastard :-)
		$end_time = mktime(intval($start_hour) + intval($duration_hour),
					intval($start_minutes) + intval($duration_minutes),
					0,intval($month),intval($day_nr),intval($year));
		$start_time = $appointment_unix_time;

		$result = pbcs_db_query(
				"INSERT INTO Appointment (ID, StartTime, EndTime," .
				"Description, IsNote, Private, RecAppID) VALUES ('', " .
				"'$start_time', '$end_time', " .
				"'$Description', '0', '$private', '$rec_id')"
				 );
		if( $result == 0 ) {
			 print pbcs_db_errno().": ".pbcs_db_error()."<BR>";
		}
		$query_id = pbcs_db_insert_id();
		$i = 0;

		while( isset($attendees[$i]) ) {
//			print "ID$i: ".$attendees[$i]."<br>";
			if( $AppointmentID > 0 ) {
				pbcs_db_query("DELETE FROM JoinTable_UserAppointment WHERE ".
					      "AppointmentID = $AppointmentID AND UserID = ".$attendees[$i]);
			}
			$result = pbcs_db_query("INSERT INTO JoinTable_UserAppointment " .
						"( ID, UserID, AppointmentID ) VALUES (" .
						"'', '$attendees[$i]', '$query_id')");
			$result = pbcs_db_query("SELECT EmailAddress FROM EmailAddress".
                                                " WHERE UserID='$attendees[$i]'");
			$row = pbcs_db_fetch_row($result);

			if( isset($row[0]) && $appointments_to_mail == "") {
//				print "mail to ".$row[0]."<br>";
				// Send mail only to someone that has an email address
				if( $mail_to_fullnames != "" ) {
					$mail_to_fullnames .= ", ";
				}
				$mail_to_fullnames .= getFullNameFromUID($attendees[$i]);
				if( sizeof($row[0]) > 0 ) {
					if( $mail_to != "" ) {
						$mail_to .= ", ";
					}
					$mail_to .= $row[0];
				}
			}

			$i++;
		}

		// Email notification mail body creation.
		if( $AppointmentNumber == 1 ) {
			// Special treatment for single appointments
 			$assigner_UID = getUIDfromSID( $SID );
			$assigner = getFullNameFromUID( $assigner_UID  );
			$reply_email = getDefaultEmailFromUID( $assigner_UID );
			$appointments_to_mail = "You have an appointment on ".date("l, j M Y G:i",$start_time).
				                "\nuntil ".date("l, j M Y G:i",$end_time)." (duration: ".
						print_duration($start_time, $end_time).").\n".
						"Attendees are:\n".$mail_to_fullnames."\n\n".
  			      	                "The appointment description is as follows:\n".
  			      	                "$Description\n\n".
						"This appointment was assigned to you by: ".$assigner."\n";
//			print "app: $appointments_to_mail<br>";
		} else {
			if( $index == 0 ) {
	 			$assigner_UID = getUIDfromSID( $SID );
				$assigner = getFullNameFromUID( $assigner_UID  );
				$reply_email = getDefaultEmailFromUID( $assigner_UID );
				$appointments_to_mail = "You have multiple appointments on:\n";
			}
			$appointments_to_mail .= date("D, j M Y G:i",$start_time)." duration: ". print_duration($start_time, $end_time).".\n";
			if( $index == ($AppointmentNumber -1) ) {
				$appointments_to_mail .=  "Attendees are:\n".$mail_to_fullnames."\n\n".
	  			      	                "The appointment description is as follows:\n".
  				      	                "$Description\n\n".
							"This appointment was assigned to you by: ".$assigner."\n";
			}
		}

		if( $AppointmentID > 0 ) {
			$result = pbcs_db_query("SELECT ID FROM JoinTable_UserAppointment WHERE AppointmentID = $AppointmentID");
			// Check if the existing appointment is still linked to another table
			// If not, then we can remove the appointment and an eventual project code
			if( pbcs_db_num_rows( $result ) == 0 ) {
				pbcs_db_query("DELETE FROM Appointment WHERE ID = $AppointmentID");
       	 			pbcs_db_query("DELETE FROM JoinTable_AppointmentProject WHERE AppointmentID = $AppointmentID");
                	}
		}

		if( isset($Projectcode) ) {
			print "Setting project dependencies.<br>";
			$result = pbcs_db_query("INSERT INTO JoinTable_AppointmentProject " .
						"( ID, AppointmentID, ProjectID ) VALUES (" .
						"'', '$query_id', '$Projectcode')", $link);

		}

	    } // End of for loop
		if( $mail_to !="" && $appointments_to_mail !=""  ) {
            		mail( $mail_to, "PBCS Appointment Notification", $appointments_to_mail , 
                              "From: PBCS Appointment System <pbcs@$server_domain>\r\nReply-to: $reply_email\r\n");

		}

		print "</BODY>\n</HTML>\n";
		exit();
	}

  	print "<HTML>\n";
	print_stylesheet();
	print "<BODY BGCOLOR=$color[4] TEXT=$color[8] LINK=$color[7] VLINK=$color[7] ALINK=$color[7]>\n";






/******* ERROR CHECKS IN FORM *****/

	if( !isset($attendees) ) {
		print "<font color=$color[11]>\n";
		print "<h2>".lang_get('ac_select_attendees')."</h2>";
		print "</font>";
		lang_show('ac_select_att_go_back');
		exit();

	}
	if( intval($duration) == 0 ) {
		print "<font color=$color[11]>\n";
		print "<h2>".lang_get('ac_select_duration')."</h2>";
		print "</font>";
		lang_show('ac_select_dur_go_back');
		exit();

	}
	if( !isset($description) || $description == "" ) {
		print "<font color=$color[11]>\n";
		print "<h2>".lang_get('ac_give_desc')."</h2>";
		print "</font>";
		lang_show('ac_give_desc_go_back');
		exit();

	}

/******* END OF ERROR CHECKS IN FORM *****/


	$appointments = array();

	if( isset($RecurrenceType)  && $RecurrenceType != "None" ) {
		$start_date = mktime(intval($start_hour), intval($start_minutes),0,
 				intval($month),intval($day_nr),intval($year));
		if( isset( $PeriodType ) ) {
			print "Period:";
			if( isset( $PeriodType ) ) {
				switch( $PeriodType ) {
					case "Repeat" :
						print "Repeat $PeriodRepeatNr time(s)<br>";
						$repeat_nr = $PeriodRepeatNr;
						$end_date = 0;
						break;
					case "EndDate" :
						print "End Date $EndDayNr $EndMonth $EndYear";
						$end_date = mktime(intval($start_hour), intval($start_minutes),0,
				 				intval($EndMonth),intval($EndDayNr),intval($EndYear));
                                                $repeat_nr = 0;
						break;
				}
			} else
				print "No Period selected.";
       		}
		// Necesary date info so we can use mkdate for correct date calculation
		$start_hour = intval( date("G",$start_date) );
		$start_minutes = intval( date("i",$start_date) );
		$month = intval( date("n",$start_date) );
		$day_nr = intval( date("j",$start_date) );
		$year = intval( date("Y",$start_date) );

		// Now create appointment dates depending on the given recurrence type
		switch( $RecurrenceType ) {
                       	case "Daily":
				print "Daily: ";
				if( isset( $DailyType ) ) {
					switch( $DailyType ) {
						case "WorkDays" :
							print "on Workdays<br>";
							if( $repeat_nr > 0 ) {
								// Repeat sequence
								$day_index = 0;
								$repeat_index = 0;
								while ( $repeat_index < $repeat_nr ) {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($month),intval($day_nr) + $day_index ,intval($year));
									$day_of_week = intval( date("w",$date ) );
									if( $day_of_week > 0 && $day_of_week < 6 ) {
										$appointments[] = $date;
										$repeat_index += 1;
									}
									$day_index += 1;
								}
							} else {
								// End date sequence
								$day_index = 0;
								do {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($month),intval($day_nr) + $day_index ,intval($year));
									$day_of_week = intval( date("w",$date ) );
									if( $day_of_week > 0 && $day_of_week < 6 )
										$appointments[] = $date;
									$day_index += 1;
								} while ( $date < $end_date );
							}
							break;
                                                case "DaysInterval" :
							print "every ".$DailyInterval." day(s).";
							if( $repeat_nr > 0 ) {
								// Repeat sequence
								$day_index = 0;
								$repeat_index = 0;
								while ( $repeat_index < $repeat_nr ) {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($month),intval($day_nr) + $day_index ,intval($year));
									$appointments[] = $date;
									$repeat_index += 1;
									$day_index += $DailyInterval;
								}
							} else {
								// End date sequence
								$day_index = 0;
								do {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($month),intval($day_nr) + $day_index ,intval($year));
									// print "On date ".date("j F Y",$date)." at ".date("G:i",$date)."<br>\n";
									// escape if the calculated date is beyond the end date
									if( $date > $end_date )
										break;
									$appointments[] = $date;
									$day_index += $DailyInterval;
								} while ( $date < $end_date );
							}
							break;
					}
				} else
					lang_show('ac_no_dialy_rec');
				break;
                       	case "Weekly":
				print "Weekly: every $WeeklyInterval week(s) on:<br>";
				//print_r($Weekly);
				// Calculate the week number!
				$week_nr = get_week_nr( $start_date );
				$day_of_week = intval( date("w", $start_date ) );
				$sunday_time = $start_date - ( $day_of_week * 86400 );
				$month = intval( date("n",$sunday_time) );
				$day_nr = intval( date("j",$sunday_time) );
				$year = intval( date("Y",$sunday_time) );


				//break;
				if( $repeat_nr > 0 ) {
					// Repeat sequence
					$day_index = 0;
					$repeat_index = 0;
					while ( $repeat_index < $repeat_nr ) {
						foreach( $Weekly as $week_day_nr ) {
							$date = mktime(intval($start_hour), intval($start_minutes),0,
					 				intval($month),intval($day_nr) + $day_index + $week_day_nr
									,intval($year));
						if( $date >= $start_date )
								$appointments[] = $date;
                                                }
						$repeat_index += 1;
						$day_index += ( $WeeklyInterval * 7);
					}
				} else {
					// End date sequence
					$day_index = 0;
					do {
						foreach( $Weekly as $week_day_nr ) {
							$date = mktime(intval($start_hour), intval($start_minutes),0,
					 				intval($month),intval($day_nr) + $day_index + $week_day_nr
									,intval($year));
							if( $date > $end_date )
								break;
                                                        if( $date >= $start_date )
								$appointments[] = $date;
                                                }
						$day_index += ( $WeeklyInterval * 7);
					} while ( $date < $end_date );
				}
				break;
                       	case "Monthly":
				print "Monthly:";
				if( isset( $MonthlyType ) ) {
					switch( $MonthlyType ) {
						case "Absolute" :
							print "Day $MonthlyAbsoluteDayNr of every $MonthlyAbsoluteMonthInterval<br>";
							if( $repeat_nr > 0 ) {
								// Repeat sequence
								$month_index = 0;
								$repeat_index = 0;
								while ( $repeat_index < $repeat_nr ) {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($month) + $month_index ,intval($MonthlyAbsoluteDayNr) ,intval($year));
									if( $date >= $start_date ) {
										$appointments[] = $date;
										$repeat_index += 1;
  									}
									$month_index += $MonthlyAbsoluteMonthInterval;
								}
							} else {
								// End date sequence
								$day_index = 0;
								$month_index = 0;
								$repeat_index = 0;
								do {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($month) + $month_index ,intval($MonthlyAbsoluteDayNr) ,intval($year));
									if( $date > $end_date )
										break;
									if( $date >= $start_date ) {
										$appointments[] = $date;
										$repeat_index += 1;
  									}
									$month_index += $MonthlyAbsoluteMonthInterval;
								} while ( $date < $end_date );
							}
							break;
                        			case "Relative" :
							print "The $MonthlyRelativeNumerator $MonthlyRelativeDay of every $MonthlyRelativeMonthInterval month(s)";
							// To be done later then v0.4
							break;
					}
				} else
					lang_show('ac_no_monthly_rec');
				break;
			case "Yearly":
				print "Yearly";
				if( isset( $YearlyType ) ) {
					switch( $YearlyType ) {
						case "Absolute" :
							print "Day $YearlyAbsoluteDayNr of month $YearlyAbsoluteMonth<br>";
							if( $repeat_nr > 0 ) {
								// Repeat sequence
								$year_index = 0;
								$repeat_index = 0;
								while ( $repeat_index < $repeat_nr ) {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($YearlyAbsoluteMonth) ,intval($YearlyAbsoluteDayNr) ,intval($year) + $year_index);
									if( $date >= $start_date ) {
										$appointments[] = $date;
										$repeat_index += 1;
  									}
									$year_index += 1;
								}
							} else {
								// End date sequence
								$year_index = 0;
								do {
									$date = mktime(intval($start_hour), intval($start_minutes),0,
							 				intval($YearlyAbsoluteMonth) ,intval($YearlyAbsoluteDayNr) ,intval($year) + $year_index);
									if( $date > $end_date )
										break;
									if( $date >= $start_date ) {
										$appointments[] = $date;
										$repeat_index += 1;
  									}
									$year_index += 1;
								} while ( $date < $end_date );
							}
							break;
						case "Relative" :
							print "The $YearlyRelativeNumerator $YearlyRelativeDay of month $YearlyRelativeMonthInterval";
							// to be implemented later then v0.4
							break;
					}
				} else
					lang_show('ac_no_yearly_rec');
				break;
		}
        }


	print "<font color=$color[11]>\n";
	print "<h1>".lang_get('Checking Appoinment')."</h1>";
	print "</font>\n";
	print "<TABLE BORDER=0>";
	if( $projectcode != "" ) {
		print "<TR><TD><B>".lang_get('Projectcode').":</B></TD><TD>$projectcode</TD></TR>\n";
	}
	if( $description != "" ) {
		print "<TR><TD><B>".lang_get('Description').":</B></TD><TD>$description</TD></TR>\n";
	}
	print "<TR><TD><B>".lang_get('Date').":</B></TD><TD>$day_nr-$month-$year</TD></TR>\n";
	print "<TR><TD><B>".lang_get('Start time').":</B></TD><TD>$start_hour : ".($start_minutes<10?"0":"").$start_minutes."</TD></TR>\n";
	print "<TR><TD><B>".lang_get('Duration').":</B></TD><TD>$duration min</TD></TR>\n";
	print "</TABLE>";

	$link = pbcs_db_connect ();
	if( $link == 0 ) {
		exit(0);
	}
	pbcs_db_select_db();

	$attendee_list = get_attendee_login_list( $attendees );
//	print_r( $attendee_list );

	$start_time = mktime(intval($start_hour), intval($start_minutes),0,
				intval($month),intval($day_nr),intval($year));


	if( count( $appointments ) == 0 ) {
		$appointments[] = mktime(intval($start_hour), intval($start_minutes),0,
	 				intval($month),intval($day_nr),intval($year));

	}

	$appointment_index = 0;
	$app_dates[] = array();
	$app_users[] = array();

	$has_conflicts = false;
	$valid_appointments = false;
	print "<p>";
	for( $index=0 ; $index < count( $appointments ) ; $index++ ) {

        	// check appointments
		$conflicting_persons = check_appointment($appointments[$index]);
		if( count( $conflicting_persons ) > 0 ) {
			if( $has_conflict == false ) {
				print "<font color=$color[11]>\n";
				print "<h2>".lang_get('ac_app_conflict')."</h2>\n";
				print "</font>";
				print "<UL>\n";
				$has_conflict = true;
                        }
			print "<LI><b>".date("j F Y",$appointments[$index])." ".lang_get('at')." ".date("G:i",$appointments[$index]).":</b> ";
			unset( $conf_persons );
			foreach( $conflicting_persons as $person ) {
				$conf_persons[] = getFullNameFromLogin( $person );
			}
			print array_to_string( $conf_persons );
//			print "</UL>\n";
                }
//		print_r( $attendee_list );
//		print_r( $conflicting_persons );

		// Well, if none of all appointments have available attendees then
		// We should give a message that the appointment is useless.
		// If there can be made an appointment for one or more attendees
		// we should leave the user the should to place the appointent
		if( count( $conflicting_persons) < count( $attendee_list ) ) {
			$valid_appointments = true;
			$app_dates[$appointment_index] = $appointments[$index];
			$app_users[$appointment_index] = array();
			foreach( $attendee_list as $login => $id ) {
				if( !in_array( $login , $conflicting_persons ) )
					$app_users[$appointment_index][$login] = $id;
			}
			$appointment_index += 1;
                }

	}
	print "</UL>\n";

	if( !$valid_appointments ) {
		print "<font color=$color[11]>\n";
	 	print "<h2>".lang_get("ac_no_valid_att")."</h2>";
		print "</font>\n";
		exit;
	}

	print "<FORM METHOD=POST ACTION=\"appointment-check.php\">\n";
	if( $RecurrenceType == "None") {
		print "<font color=$color[11]>\n";
	        print "<h2>".lang_get('ac_assign_app')."</h2>\n";
		print "</font><p>\n";
		print "<INPUT TYPE=hidden NAME=\"Appointment0\" VALUE=\"".$start_time."\">\n";
	        foreach( $app_users[0] as $person => $id) {
        		print "<INPUT TYPE=checkbox NAME=Attendees0[] VALUE=\"$id\" CHECKED>".getFullNameFromLogin($person)."</INPUT><BR>\n";
	        }
    } else {
		print "<h2>";
		print "<font color=$color[11]>\n";
		lang_show('ap_date_list');
		print "</font>\n";
		print "</h2>";
		print "<INPUT TYPE=hidden NAME=AppointmentNumber VALUE=\"".count($app_dates)."\">\n";
		PRINT "<UL>";
		for($index=0 ; $index < count($app_dates) ; $index++ ) {
			print "<LI><b>".date("j F Y",$app_dates[$index])." ".lang_get('at')." ".date("G:i",$app_dates[$index]).":</b> \n";
			print "<INPUT TYPE=hidden NAME=\"Appointment$index\" VALUE=\"".$app_dates[$index]."\">\n";
			unset( $fullnames );
			foreach( $app_users[$index] as $login => $id ) {
				$fullnames[] = getFullNameFromLogin( $login );
				print "<INPUT TYPE=hidden NAME=\"Attendees".$index."[]\" VALUE=\"$id\">\n";
			}
			print array_to_string( $fullnames )."</LI>";
		}
		print "</UL>";
    }

	print "<INPUT TYPE=hidden NAME=Description VALUE=\"".$description."\">\n";
	print "<INPUT TYPE=hidden NAME=Projectcode VALUE=\"$projectcode\">\n";
	print "<INPUT TYPE=hidden NAME=Duration VALUE=$duration>";
	print "<INPUT TYPE=hidden NAME=private VALUE=$private>";
	print "<INPUT TYPE=hidden NAME=AppointmentID VALUE=$AppointmentID>";
	print "<INPUT TYPE=hidden NAME=SID VALUE=$SID>";
	print "<INPUT TYPE=hidden NAME=AppointmentChecked VALUE=1>";
	print "<P>";
//	print "<INPUT BORDER=0 TYPE=image src=\"$images[19]\" name=\"Book_Appointment\" ALT=\"".lang_get('Book Appointment')."\">";
	show_input_image(19, "Book_Appointment" ,lang_get('Book Appointment'));  
        print "<BR>";

	print "</FORM>";

        print "</BODY>\n</HTML>";
?>
