<?php
####---------------------------------------------------------------------------
#### semtest.php
####
#### tests the semaphore connection (and can be used to artificially hold
#### the semaphore to see what happens to your server)
####
#### usage: php semtest.php
####
#### to hold the semaphore, adjust $holdsem to indicate the length of time
#### you want the semaphore held, in seconds.
####---------------------------------------------------------------------------

$holdsem = 0;

if (attach_sem ()) {
  if ($holdsem > 0) {
    print "sleeping for $holdsem seconds...\n";
    sleep ($holdsem);
  }
  sem_release ($OG_sem_id);
  print "released\n";
}

function attach_sem ()
{
  global $OG_sem_id, $OG_error_code;
  global $OG_shm_hour_ass, $OG_shm_hour_tar;

  #### grab a semaphore; we don't want to enter these shared memory
  #### segments when another instance of this script is in there
  #### or if they're being reloaded by the maintenance scripts
  #### identifier:           O A 0 0
  print "attempting to acquire '0x4f410000'...\n";
  if(!((@$sem_id_1 = sem_get(0x4f410000, 1)) && @sem_acquire($sem_id_1)))
  {
    print "$failed\n";
    $OG_error_code = 'no_sem_1';
    return 0;
  }
  print "acquired\n";

  #### attach to overflow flag shared memory segment to determine whether we're
  #### in overflow delivery mode
  #### identifier:     O A S 4
  @$smh = shm_attach(0x4f415304, 0);
  @$overflow_flag = shm_get_var($smh, 0);
  @shm_detach($smh);

  if ($overflow_flag) {
    print "in overflow delivery mode...\n";
    $sem_delivery = 0x4f410002;     // O A 0 2
    $OG_shm_hour_ass = 0x4f415305;     // O A S 5
    $OG_shm_hour_tar = 0x4f415306;     // O A S 6
  }
  else {
    print "not in overflow delivery mode...\n";
    $sem_delivery = 0x4f410001;     // O A 0 1
    $OG_shm_hour_ass = 0x4f415300;     // O A S 0
    $OG_shm_hour_tar = 0x4f415301;     // O A S 1
  }

  #### now we know which semaphore and shared memory segments to use...
  print "attempting to acquire '";
  printf ("0x%0x", $sem_delivery);
  print "'...\n";
  if(!((@$OG_sem_id = sem_get($sem_delivery, 1)) && @sem_acquire($OG_sem_id)))
  {
    print "failed\n";
    $OG_error_code = 'no_sem_2';
    sem_release ($sem_id_1);
    return 0;
  }
  sem_release ($sem_id_1);
  print "acquired\n";

  return 1;
}

?>
