#!/usr/local/bin/php -q
<?php

$setup = array();

$stdin = fopen('php://stdin', 'r');

check_php_install();

check_mysql();

get_setup_vals();

unload_mysql($setup);
delete_directories($setup);

#### reload MySQL so that the db_user cannot connect to the database
$command = "mysqladmin --user=$setup[mysql_admin_user] --password=$setup[mysql_admin_password] reload";
print "$command\n";
print `$command`;


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_php_install()
{
  $pversion = phpversion();
  #$pversion = "4.0.3pl1";
  $pversion = preg_replace('#pl.+#', '', $pversion);
  $comp = split('\.', $pversion);

  $comp = array_reverse($comp);
  $factor = 1;
  foreach($comp as $v)
  {
    $version_number += $v * $factor;

    $factor *= 100;
  }

  if($version_number < 40000)
  {
    print "OASIS requires PHP version 4.0.0 or greater\n";
    exit;
  }

  if(!((@$sem_id = sem_get(0x4f410000, 1)) && @sem_acquire($sem_id)))
  {
    print "Could not acquire semaphore: $php_errormsg\nYou must enable System V semaphores and shared memory to use OASIS.\n";
    exit;
  }
  @sem_release($sem_id);

  if(!(@$smh = shm_attach(0x4f415300, 1000)))
  {
    print "Could not attach to shared memory: $php_errormsg\nYou must enable System V semaphores and shared memory to use OASIS.\n";
    exit;
  }
  @shm_detach($smh);
  @shm_remove(0x4f415300);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_mysql()
{
  global $stdin, $setup;

  print "Enter MySQL hostname (blank for localhost): ";
  $hostname = chop(fgets($stdin, 65536));

  print "Enter MySQL username: ";
  $user = chop(fgets($stdin, 65536));

  print "Enter password for $user: ";
  $password = chop(fgets($stdin, 65536));

  if(!@mysql_pconnect($hostname, $user, $password))
  {
    print "Error: could not connect to MySQL server:\n" . mysql_error() . "\n";
    exit;
  }

  if(($result = mysql_query("select VERSION()"))
     && (list($v) = mysql_fetch_row($result)))
  {
    $v = preg_replace('#(\d+\.\d+).*#', '\1', $v);
    if($v < 3.23)
    {
      print "OASIS requires MySQL version 3.23 or greater\n";
      exit;
    }
  }
  else
  {
    print "Error: could not get MySQL version:\n" . mysql_error() . "\n";
    exit;
  }

  $setup[db_host] = $hostname;
  $setup[mysql_admin_user] = $user;
  $setup[mysql_admin_password] = $password;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_setup_vals()
{
  global $stdin, $setup;

  foreach(file('oasis.cfg') as $line)
  {
    $line = chop($line);

    #### remove comments
    $line = preg_replace('/\#.*/', '', $line);

    list($key, $val) = split(':', $line);
    $key = preg_replace('#\s+#', '', $key);
    $val = preg_replace('#\s+#', '', $val);

    if(!$key) continue;

    #print "$key => $val\n";
    $setup[$key] = $val;
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function unload_mysql($setup)
{
  #### delete oasis database
  if(!mysql_query("drop database oasis"))
  {
    print "Error dropping oasis database: " . mysql_error() . "\n";
  }

  @mysql_select_db("mysql");

  #### delete mysql user
  if(!mysql_query("delete from user where User='$setup[db_user]'"))
  {
    print "Error deleting mysql user: " . mysql_error() . "\n";
  }
}




####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function delete_directories($setup)
{
  `rm -rf $setup[oasis_root]`;
  `rm -rf $setup[log_dir]`;
}

?>
