<?php

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_creative($s, $w, $h, $frame_target, $c=0)
{
  global $OG_error_code, $OG_sem_id, $cr_id, $HTTP_USER_AGENT;

  $OG_sem_id = 0;
  $cr_id = 0;

  $remote_address = get_oasis_env("REMOTE_ADDR");
  $cl_id = get_client_id($remote_address);

  $OG_error_code = '';
  if($cr_id = $c)
  {
    if(attach_sem() && get_media_type($cr_id)
      && record_delivery($cr_id, $remote_address, $cl_id, $s, $HTTP_USER_AGENT))
    {
      @sem_release($OG_sem_id);
      return retrieve_creative($cr_id, $frame_target, $w, $h, $remote_address,
                          $cl_id, $s, $HTTP_USER_AGENT);
    }
    else
    {
      log_msg(0, $cl_id, $remote_address, $s, $cr_id, 'ierr', $OG_error_code, $HTTP_USER_AGENT);
      @sem_release($OG_sem_id);
      return '';
    }
  }
  else
  {
    if(select_creative($s, $w, $h)
      && record_delivery($cr_id, $remote_address, $cl_id, $s, $HTTP_USER_AGENT))
    {
      @sem_release($OG_sem_id);
      return retrieve_creative($cr_id, $frame_target, $w, $h, $remote_address,
                          $cl_id, $s, $HTTP_USER_AGENT);
    }
    else
    {
      #print "unable to select creative...<BR>\n";
      if($s == 0) $s = 0;
      log_msg(0, $cl_id, $remote_address, $s, $cr_id, 'ierr', $OG_error_code, $HTTP_USER_AGENT);
      @sem_release($OG_sem_id);
      return '';
    }
  }
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function get_oasis_env($name)
{
  $val = '';
  if ($val = $_SERVER[$name]) return $val;
  return getenv ($name);
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function get_client_id ($remote_address)
{
  global $HTTP_COOKIE_VARS;

  #### cookie is named OASISID
  if($id = $HTTP_COOKIE_VARS["OASISID"])
  {
    #### some poorly-coded browsers can barf up more than just our OASISID
    #### cookie (I've even seen some dump what looks like their entire
    #### cookie table!).  When this gets logged, it will wreak havoc on
    #### the log processor.  So just to be sure, we trim off everything past
    #### the 13-character unique ID.
    $id = substr($id, 0, 13);
  }
  else
  {
    $id = uniqid('');

    if ($pp = get_oasis_env('oasis_priv_pol')) header ("P3P: CP=\"$pp\"");

    #### 5-year expiration on cookie
    $cdomain = get_oasis_env('oasis_domain');
    if (!preg_match ('#(\d+\.){3}\d+#', $cdomain)) $cdomain = '.' . $cdomain;
    setcookie("OASISID", $id, time() + 157680000, "/", $cdomain);
  }

  return $id;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function get_media_type ($cr_id)
{
  global $media_type;
  global $OG_shm_hour_tar, $OG_error_code;

  #### DEBUG
  print "[get_media_type] attaching to shared memory...<BR>\n";
  #### /DEBUG
  #### attach to Hourly Targets shared memory segment
  #### identifier:     O A S 1
  if(!(@$smh = shm_attach($OG_shm_hour_tar, 0)))
  {
    $OG_error_code = "no_ht_shm ($php_errormsg)";
    return 0;
  }

  @$target_info = shm_get_var($smh, $cr_id);

  #### we really don't want/expect this to happen, but we also don't
  #### want to bring delivery to a halt just because one creative's
  #### target info isn't retrieved from shared memory
  if($target_info)
    list($target, $weight, $remaining, $clicks, $media_type) = $target_info;
  else
    return 0;

  #### DEBUG
  print "[get_media_type] got target info ($target, $weight, $remaining, $clicks, $media_type)...<BR>\n";
  #### /DEBUG

  @shm_detach($smh);

  return 1;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function attach_sem ()
{
  global $OG_sem_id, $OG_error_code;
  global $OG_shm_hour_ass, $OG_shm_hour_tar, $OG_shm_cr_cont, $OG_shm_cr_click;

  #### DEBUG
  print "[attach_sem] getting first semaphore...<BR>\n";
  #### /DEBUG

  #### grab a semaphore; we don't want to enter these shared memory
  #### segments when another instance of this script is in there
  #### or if they're being reloaded by the maintenance scripts
  #### identifier:           O A 0 0
  if(!((@$sem_id_1 = sem_get(0x4f410000, 1)) && @sem_acquire($sem_id_1)))
  {
    $OG_error_code = 'no_sem_1';
    return 0;
  }

  #### DEBUG
  print "[attach_sem] attaching to overflow flag shm segment...<BR>\n";
  #### /DEBUG

  #### attach to overflow flag shared memory segment to determine whether we're
  #### in overflow delivery mode
  #### identifier:     O A S 4
  @$smh = shm_attach(0x4f415304, 0); 
  @$overflow_flag = shm_get_var($smh, 0);
  @shm_detach($smh);

  #### DEBUG
  print "[attach_sem] overflow_flag: $overflow_flag...<BR>\n";
  #### /DEBUG

  if ($overflow_flag) {
    $sem_delivery    = 0x4f410002;     // O A 0 2
    $OG_shm_hour_ass = 0x4f415305;     // O A S 5
    $OG_shm_hour_tar = 0x4f415306;     // O A S 6
    $OG_shm_cr_cont  = 0x4f415307;     // O A S 7
    $OG_shm_cr_click = 0x4f415308;     // O A S 8
  }
  else {
    $sem_delivery    = 0x4f410001;     // O A 0 1
    $OG_shm_hour_ass = 0x4f415300;     // O A S 0
    $OG_shm_hour_tar = 0x4f415301;     // O A S 1
    $OG_shm_cr_cont  = 0x4f415302;     // O A S 2
    $OG_shm_cr_click = 0x4f415303;     // O A S 3
  }

  #### DEBUG
  print "[attach_sem] attaching to appropriate delivery semaphore ($sem_delivery)...<BR>\n";
  #### /DEBUG

  #### now we know which semaphore and shared memory segments to use...
  if(!((@$OG_sem_id = sem_get($sem_delivery, 1)) && @sem_acquire($OG_sem_id)))
  {
    $OG_error_code = 'no_sem_2';
    sem_release ($sem_id_1);
    return 0;
  }
  sem_release ($sem_id_1);

  #### DEBUG
  print "[attach_sem] released first semaphore...<BR>\n";
  #### /DEBUG

  return 1;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function test_delivery_controls ($cr_id, $dc)
{
  global $OG_blacklist, $OG_whitelist, $OG_kwlist;

  foreach ($dc as $d) {
    list ($del, $type, $sense, $regex_str) = $d;

    #### DEBUG
    print "[test_delivery_controls] $del, $type, $sense, $regex_str...<BR>\n";
    #### /DEBUG
    $testvar = '';
    if ($type == 'IP') {
      $testvar = $_SERVER['REMOTE_ADDR'];
    }
    elseif ($type == 'domain') {
      $testvar = @gethostbyaddr ($_SERVER['REMOTE_ADDR']);
    }
    elseif ($type == 'language') {
      $testvar = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    }
    elseif ($type == 'user_agent') {
      $testvar = $_SERVER['HTTP_USER_AGENT'];
    }
    elseif ($type == 'keyword') {
      $testvar = $_REQUEST['k'];
    }
    elseif ($type == 'gt_country') {
      $testvar = geotarget_country($_SERVER['REMOTE_ADDR']);
    }
    elseif ($type == 'gt_region') {
      $testvar = geotarget_region($_SERVER['REMOTE_ADDR']);
    }
    elseif ($type == 'gt_metro_area') {
      $testvar = geotarget_metro_area($_SERVER['REMOTE_ADDR']);
    }
    elseif ($type == 'gt_city') {
      $testvar = geotarget_city($_SERVER['REMOTE_ADDR']);
    }


    #### if we've got an arbitrary PHP expression, evaluate it
    if ($type == 'expr') {
      $regex_str = "\$control_satisfied = ($regex_str);";
      #### DEBUG
      print "[test_delivery_controls] eval-ing $regex_str...<BR>\n";
      #### /DEBUG
      eval ($regex_str);
      $control_satisfied = ($control_satisfied) ? 1 : 0;
    }
    #### otherwise, see if our test var we match any of the regexes
    else {
        $regexes = split (',', $regex_str);
        $control_satisfied = 0;
        foreach ($regexes as $regex) {
            #### DEBUG
            print "[test_delivery_controls] testing '$testvar' against '$regex'...<BR>\n";
            #### /DEBUG
            if (($sense && preg_match ("#$regex#i", $testvar))
                || (!$sense && !preg_match ("#$regex#i", $testvar))) {
                $control_satisfied = 1;
                break;
            }
        }
    }
    #### DEBUG
    print "[test_delivery_controls] control_satisfied = $control_satisfied...<BR>\n";
    #### /DEBUG

    if ($control_satisfied) {
      if ($del == 'deliver') {
        $OG_whitelist[$cr_id] = 1;
        if ($type == 'keyword') $OG_kwlist[$cr_id] = 1;
      }
      elseif ($del == 'deliver_only') {
        $OG_whitelist[$cr_id] = 1;
        if ($type == 'keyword') $OG_kwlist[$cr_id] = 1;
      }
      elseif ($del == 'no_deliver') {
        $OG_blacklist[$cr_id] = 1;
      }
    }
    else {
      if ($del == 'deliver_only') {
        $OG_blacklist[$cr_id] = 1;
      }
    }

  }
}


function silent ($errno, $errstr, $errfile, $errline) {}

####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function na_setup () 
{
    include_once ('geotargeting/netacuity/NetAcuity.inc');
    $na_server = get_oasis_env ('oasis_na_server');
    if ($na_server == '') $na_server = 'localhost';

    $na = new NetAcuity;
    $na->set_server_addr ($na_server);
    $na->set_id (99);
    $na->set_timeout (1);

    return $na;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function geotarget_country ($ipaddr) 
{
    static $country = 'XXX';

    if ($country == 'XXX') {
        $old_errh = set_error_handler ('silent');
        $gtss = get_oasis_env ('oasis_geotarget_subsys');
        if ($gtss == 'netacuity') {
            $na = na_setup();
            $na->na_query_geo($ipaddr);
            $country   = $na->get_country();
        }
        else {
            $country = '';
        }
        set_error_handler ($old_errh);
    }

    return $country;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function geotarget_region ($ipaddr) 
{
    static $country    = 'XXX';
    static $region     = 'XXX';

    if ($country == 'XXX') {
        $old_errh = set_error_handler ('silent');
        $gtss = get_oasis_env ('oasis_geotarget_subsys');
        if ($gtss == 'netacuity') {
            $na = na_setup();
            $na->na_query_geo($ipaddr);
            $country   = $na->get_country();
            $region    = $na->get_region();
        }
        else {
            $country = '';
            $region = '';
        }
        set_error_handler ($old_errh);
    }

    return "$country:$region";
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function geotarget_metro_area ($ipaddr) 
{
    static $country    = 'XXX';
    static $region     = 'XXX';
    static $metro_area = 'XXX';

    if ($country == 'XXX') {
        $old_errh = set_error_handler ('silent');
        $gtss = get_oasis_env ('oasis_geotarget_subsys');
        if ($gtss == 'netacuity') {
            $na = na_setup();
            $na->na_query_geo($ipaddr);
            $country    = $na->get_country();
            $region     = $na->get_region();
            $metro_area = $na->get_metro_code();
        }
        else {
            $country    = '';
            $region     = '';
            $metro_area = '';
        }
        set_error_handler ($old_errh);
    }

    return "$country:$region:$metro_area";
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function geotarget_city ($ipaddr) 
{
    static $country    = 'XXX';
    static $region     = 'XXX';
    static $metro_area = 'XXX';
    static $city       = 'XXX';

    if ($country == 'XXX') {
        $old_errh = set_error_handler ('silent');
        $gtss = get_oasis_env ('oasis_geotarget_subsys');
        if ($gtss == 'netacuity') {
            $na = na_setup();
            $na->na_query_geo($ipaddr);
            $country    = $na->get_country();
            $region     = $na->get_region();
            $metro_area = $na->get_metro_code();
            $city       = $na->get_city();
        }
        else {
            $country    = '';
            $region     = '';
            $metro_area = '';
            $city       = '';
        }
        set_error_handler ($old_errh);
    }

    return "$country:$region:$metro_area:$city";
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function select_creative ($section, $width, $height, $img_only=0)
{
  global $cr_id, $OG_sem_id, $OG_error_code;
  global $OG_shm_hour_ass, $OG_shm_hour_tar;
  global $OG_blacklist, $OG_whitelist, $OG_kwlist;
  global $media_type;

  #### DEBUG
  print "[select_creative] attaching to semaphore...<BR>\n";
  #### /DEBUG

  if (!attach_sem ()) return 0;

  #### attach to Hourly Assignments shared memory segment
  @$smh = shm_attach($OG_shm_hour_ass, 0); 
  @$section_creatives = shm_get_var($smh, $section);
  @shm_detach($smh);

  if(!$section_creatives)
  {
    $OG_error_code = 'no_sec_cr';
    return 0;
  }

  #### DEBUG
  print "[select_creative] got creatives for section $section...<BR>\n";
  #### /DEBUG

  $secdim_creatives = $section_creatives[$width . "x" . $height];

  if(!$secdim_creatives)
  {
    #### big problem -- no creatives scheduled for this hour for this section
    $OG_error_code = 'no_secdim_cr';
    return 0;
  }

  #### DEBUG
  print "[select_creative] got creatives for section $section, dim={$width}x{$height}...<BR>\n";
  #### /DEBUG

  #### attach to Hourly Targets shared memory segment
  #### identifier:     O A S 1
  if(!(@$smh = shm_attach($OG_shm_hour_tar, 0)))
  {
    $OG_error_code = "no_ht_shm ($php_errormsg)";
    return 0;
  }

  #### DEBUG
  print "[select_creative] attached to hourly targets shm...<BR>\n";
  #### /DEBUG

  list ($foo, $delivery_controls) = shm_get_var ($smh, 0);

  #### loop through creatives, looking for best candidate
  $cr_id = 0;
  $total_weight = 0;
  $total_remaining = 0;
  foreach ($secdim_creatives as $c)
  {
    @$target_info = shm_get_var($smh, $c);

    if ($dc = $delivery_controls[$c]) {
      test_delivery_controls ($c, $dc);
    }

    if ($OG_blacklist[$c]) continue;

    #### we really don't want/expect this to happen, but we also don't
    #### want to bring delivery to a halt just because one creative's
    #### target info isn't retrieved from shared memory
    if(!$target_info) continue;

    list($target, $weight, $remaining, $clicks, $mt) = $target_info;

    #### DEBUG
    print "[select_creative] creative $c: [$target, $weight, $remaining, $clicks, $mt]...<BR>\n";
    print "[select_creative] img_only: $img_only<BR>\n";
    #### /DEBUG

    if ($img_only && ($mt != 'Image')) continue;

    #print "creative $c: [$target, $weight, $remaining]<BR>\n";
    $media_types[$c] = $mt;
    if($remaining > 0)
    {
      $total_remaining += $remaining;
      $remaining_ads[$c] = $remaining;
    }
    elseif($target == 0)
    {
      $total_weight += $weight;
      $weight_ads[$c] = $weight;
    }
  }
  @shm_detach($smh);

  #### DEBUG
  print "[select_creative] total remaining: $total_remaining<BR>\n";
  #### /DEBUG

  #### should we select a 'remaining' ad or a 'weight' ad?
  if($total_remaining <= 0)
  {
    $rmax = $total_weight;
    $candidates = $weight_ads;
  }
  else
  {
    $rmax = $total_remaining;
    $candidates = $remaining_ads;
  }

  #### DEBUG
  print "[select_creative] rmax: $rmax<BR>\n";
  #### /DEBUG

  if($rmax > 0)
  {
    mt_srand((double)microtime()*1000000);
    $rand_num = mt_rand(0, $rmax);
    while(list($c, $w) = each($candidates))
    {
      #### immediately deliver an ad from the keyword whitelist
      if ($OG_kwlist[$c]) {
        $cr_id = $c;
        break;
      }

      #### immediately deliver an ad from the whitelist
      if ($OG_whitelist[$c]) {
        $cr_id = $c;
        break;
      }

      $rand_num -= $w;
      if($rand_num <= 0)
      {
        $cr_id = $c;
        break;
      }
    }
    #### DEBUG
    print "[select_creative] selected creative $cr_id<BR>\n";
    #### /DEBUG
  }
  else
  {
    #### DEBUG
    print "[select_creative] ARGHH!  all maxed out!<BR>\n";
    #### /DEBUG
    #### the creatives assigned to this section are maxed out (all have
    #### targets, and all have remaining = 0)
    $OG_error_code = 'secdim_cr_maxed_out';
    return 0;
  }

  $media_type = $media_types[$cr_id];

  return 1;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function record_delivery ($cr_id, $ra, $cl_id, $s, $ua)
{
  global $OG_error_code;
  global $OG_shm_hour_tar;

  #### decrement the "remaining" field; we have to do this here so that
  #### the selection and decrementing is atomic (we're still inside the
  #### protection of the semaphore).  Of course, we'd prefer to do it
  #### after we've actually sent the content of the creative, but we're
  #### going to send the creative immediately after this step.  This
  #### is as close to the actual delivery as we can get; if we try to
  #### hold the semaphore until after the delivery is complete, we'll
  #### create an enormous bottleneck as we wait for slow connections.

  #### attach to Hourly Targets shared memory segment
  if(!(@$smh = shm_attach($OG_shm_hour_tar, 0)))
  {
    $OG_error_code = "no_ht_shm_2 ($php_errormsg)";
    return 0;
  }

  #### retrieve the current target info
  if(!@$target_info = shm_get_var($smh, $cr_id))
  {
    $OG_error_code = "no_target_info ($php_errormsg)";
    return 0;
  }

  #### decrement "remaining" field and put back into SHM
  $target_info[2]--;
  if(@shm_put_var($smh, $cr_id, $target_info))
  {
    #### we log the delivery immediately so that it occurs right after
    #### the shared memory table is updated, reducing the chance that
    #### something might go wrong and the impression doesn't get logged.
    log_msg(0, $cl_id, $ra, $s, $cr_id, 'imp', '', $ua);
  }
  else
  {
    $OG_error_code = "no_target_info_put ($php_errormsg)";
    return 0;
  }

  return 1;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function retrieve_creative ($cr_id, $frame_target, $w, $h, $ra, $cl_id, $s, $ua)
{
  global $media_type;
  global $OG_error_code;
  global $HTTP_SERVER_VARS;
  global $OG_shm_cr_cont;

  $OG_error_code = '';
  $target_tag = ($frame_target) ? " TARGET=\"$frame_target\"" : "";

  #### DEBUG
  print "[retrieve_creative] attaching to shared memory<BR>\n";
  #### /DEBUG

  #### attach to the shared memory segment
  @$smh = shm_attach($OG_shm_cr_cont, 0); 
  @$creative_info = shm_get_var($smh, $cr_id);
  @shm_detach($smh);

  if(!$creative_info)
  {
    $OG_error_code = "no_cr_content ($php_errormsg)";
    return '';
  }

  #### DEBUG
  print "[retrieve_creative] got creative info<BR>\n";
  #### /DEBUG

  list($content, $redirect, $mime_type, $animated, $alt) = $creative_info;

  #### DEBUG
  print "[retrieve_creative] media_type = '$media_type'<BR>\n";
  print "[retrieve_creative] redirect = '$redirect'<BR>\n";
  print "[retrieve_creative] mime_type = '$mime_type'<BR>\n";
  print "[retrieve_creative] animated = '$animated'<BR>\n";
  print "[retrieve_creative] alt = '$alt'<BR>\n";
  #### /DEBUG

  $oasis_host = get_oasis_env('oasis_host');
  $oasis_url  = get_oasis_env('oasis_url');
  $oasisc     = get_oasis_env('oasis_script_c');
  $oasisi     = get_oasis_env('oasis_script_i');

  mt_srand((double)microtime()*1000000);
  $rand_num = mt_rand();
  #### DEBUG
  print "[retrieve_creative] rand_num = $rand_num<BR>\n";
  #### /DEBUG
  if($media_type == 'Image')
  {
    if($redirect == 'Y')
    {
      $content = preg_replace("#\[(OASIS)?CB\]#", $rand_num, $content);
      $content = preg_replace("#\[OASISTIMESTAMP\]#", time(), $content);
      $content = preg_replace("#\[OASISREFERER\]#",
                              $HTTP_SERVER_VARS['HTTP_REFERER'], $content);
      
      $cr_content = <<<__TEXT__
<A HREF="http://{$oasis_host}{$oasis_url}{$oasisc}?s=$s&c=$cr_id"$target_tag><IMG SRC="$content" WIDTH=$w HEIGHT=$h BORDER=0 ALT="$alt"></A>

__TEXT__;
    }
    else
    {
      $cr_content = <<<__TEXT__
<A HREF="http://{$oasis_host}{$oasis_url}{$oasisc}?s=$s&c=$cr_id"$target_tag><IMG SRC="http://{$oasis_host}{$oasis_url}{$oasisi}?s=$s&c=$cr_id&cb=$rand_num" WIDTH=$w HEIGHT=$h BORDER=0 ALT="$alt"></A>
__TEXT__;
    }
  }
  else
  {
    $cr_content = $content;
    $cr_content = preg_replace("#\[(OASIS)?CB\]#", $rand_num, $cr_content);
    $cr_content = preg_replace("#\[OASISTIMESTAMP\]#", time(), $cr_content);
    $cr_content = preg_replace("#\[OASISREFERER\]#",
                            $HTTP_SERVER_VARS['HTTP_REFERER'], $cr_content);
    while (preg_match('#\[OASISCLICK:(.+?)\]#i', $cr_content, $matches))
    {
      $url = $matches[1];
      $clickthru = array ('s' => $s, 'c' => $cr_id, 'url' => $url, 
                          'cb' => $rand_num);
      $clickthru = urlencode (serialize ($clickthru));
      $cr_content = preg_replace('#\[OASISCLICK:(.+?)\]#i', "http://{$oasis_host}{$oasis_url}{$oasisc}?ct=$clickthru", $cr_content, 1);
    }
    $cr_content = preg_replace('#A HREF#i', "A$target_tag HREF", $cr_content);
  }

  return $cr_content;
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function log_msg ($get_sem, $cl_id, $ra, $section, $cr_id, $event, $code, $ua)
{
  $log_message = time()
     . "\t$ra\t$cl_id\t$event\t$section\t$cr_id\t$code\t$ua\n";

  #### DEBUG
  print "Logging message: '$log_message'<BR>\n";
  print "Acquiring semaphore for log file...<BR>\n";
  #### /DEBUG

  #### grab a semaphore; we don't want to write to this log
  #### when another instance of this script is in there
  #### identifier:           O A 0 3
  if($get_sem)
  {
    if(!((@$sem_id = sem_get(0x4f410003, 1)) && @sem_acquire($sem_id)))
      return 0;
  }

  error_log($log_message, 3, get_oasis_env('oasis_log_dir') . "/oasis.log");
  #### DEBUG
  $logfile = get_oasis_env('oasis_log_dir') . "/oasis.log";
  print "Logged to: '$logfile'<BR>\n";
  #### /DEBUG

  if($get_sem) @sem_release($sem_id);
}



?>
