<?php

$fallthrough = 0;
$nocookie = 0;
$remote_address = get_oasis_env("REMOTE_ADDR");
$instance_id = get_instance_id();
$cl_id = $instance_id ? $instance_id : get_client_id();

#### if we're getting called by an embedded rich media ad serve, explode
#### out the clickthrough info
if ($ct) {
  $clickthru = unserialize (stripslashes ($ct));
  $s   = $clickthru['s'];
  $c   = $clickthru['c'];
  $url = $clickthru['url'];
}

#### are we getting called by an embedded ad serve?
if($cr_id = $c)
{
  #### rich media serves may send us a specific URL to click through to
  list($event, $code) = deliver_clickthrough($cr_id, $url);
  log_msg($cl_id, $remote_address, $s, $cr_id, $event, $code, $HTTP_USER_AGENT);
}
#### if we're getting called via an IMG-based ad serve, we need to
#### find out what creative was delivered
elseif($cr_id = retrieve_creative($cl_id, $remote_address, $s, $w, $h))
{
  list($event, $code) = deliver_clickthrough($cr_id);
  log_msg($cl_id, $remote_address, $s, $cr_id, $event, $code, $HTTP_USER_AGENT);
}
else
{
  log_msg($cl_id, $remote_address, $s, $cr_id, 'cerr', 'no_cr_found', $HTTP_USER_AGENT);
}

####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function get_oasis_env($name)
{
  $val = '';
  if ($val = $_SERVER[$name]) return $val;
  return getenv ($name);
}


####---------------------------------------------------------------------------
#### COMMON FUNCTION -- DO NOT EDIT DIRECTLY!!!  EDIT THE FILE IN functions/
#### INSTEAD AND USE assemblefcn.pl TO REBUILD THIS SCRIPT
####---------------------------------------------------------------------------
function get_instance_id ()
{
  global $iid;

  #### see if the value was passed on the URL
  if($iid)
  {
    #### Make sure that it's padded to exactly 12 characters
    return substr(str_pad($iid,24,"#"),0,24);
  }

  return NULL;
}


####---------------------------------------------------------------------------
#### look for a cookie; if found, return its ID number.  Otherwise, generate
#### a new ID.
####---------------------------------------------------------------------------
function get_client_id()
{
  global $HTTP_COOKIE_VARS;

  #### cookie is named OASISID
  if(!($id = $HTTP_COOKIE_VARS["OASISID"])) $id = '-';

  return $id;
}



####---------------------------------------------------------------------------
#### redirect to clickthrough URL
####---------------------------------------------------------------------------
function deliver_clickthrough($cr_id, $url='')
{
  global $fallthrough, $HTTP_SERVER_VARS;

  #### attach to overflow flag semaphore
  if(!(($sem_id_1 = sem_get(0x4f410000, 1)) && sem_acquire($sem_id_1)))
  {
    header("Location: ");
    return array('cerr', 'no_sem_1');
  }

  #### attach to overflow flag shared memory segment to determine whether we're
  #### in overflow delivery mode
  #### identifier:     O A S 4
  @$smh = shm_attach(0x4f415304, 0);
  @$overflow_flag = shm_get_var($smh, 0);
  @shm_detach($smh);

  if ($overflow_flag) {
    $sem_delivery = 0x4f410002;     // O A 0 2
    $shm_hour_tar = 0x4f415306;     // O A S 6
    $shm_cr_click = 0x4f415308;     // O A S 8
  }
  else {
    $sem_delivery = 0x4f410001;     // O A 0 1
    $shm_hour_tar = 0x4f415301;     // O A S 1
    $shm_cr_click = 0x4f415303;     // O A S 3
  }

  #### now we know which semaphore and shared memory segments to use...
  if(!((@$OG_sem_id = sem_get($sem_delivery, 1)) && @sem_acquire($OG_sem_id)))
  {
    sem_release ($sem_id_1);
    header("Location: ");
    return array ('cerr', 'no_sem_1');
  }
  sem_release ($sem_id_1);

  #### attach to Hourly Targets shared memory segment
  $smh = shm_attach($shm_hour_tar, 0);
  @$cr_info = shm_get_var($smh, $cr_id);

  #### if for some reason there is no array waiting for us (perhaps the
  #### database has been reloaded and a campaign is no longer active),
  #### we'll have to bail out
  if(!$cr_info)
  {
    header("Location: ");

    shm_detach($smh);
    sem_release($OG_sem_id);

    return array('cerr', "no_ht_array (overflow: $overflow_flag; php_errormsg: $php_errormsg)");
  }

  $cr_info[3]++;

  shm_put_var($smh, $cr_id, $cr_info);
  shm_detach($smh);

  sem_release($OG_sem_id);

  #### URL may be supplied as part of the URL to oasisc.php; if not,
  #### connect to shared memory segment to get URL
  #### identifier:     O A S 3
  if (!$url)
  {
    $smh = shm_attach($shm_cr_click, 0); 
    $url = shm_get_var($smh, $cr_id);
    if(!$url)
    {
      header("Location: ");
      return array('cerr', 'no_ct_array');
    }
    shm_detach($smh);
  }

  mt_srand((double)microtime()*1000000);
  $random_number = mt_rand();
  $url = preg_replace("#\[(OASIS)?CB\]#", $random_number, $url);
  $url = preg_replace("#\[OASISTIMESTAMP\]#", time(), $url);
  $url = preg_replace("#\[OASISREFERER\]#",
                       $HTTP_SERVER_VARS['HTTP_REFERER'], $url);


  header("Location: $url");
  header("Pragma: no-cache");
  header("Cache-Control: no-store, no-cache");

  if($fallthrough) return array('click', 'fallthru');
  if($nocookie)    return array('click', 'nocookie');
  else             return array('click', '');
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function retrieve_creative($client, $ipaddr, $sec, $w, $h)
{
  global $fallthrough, $nocookie;

  $cr_id = 0;
  $key_end = sprintf("%04x%04x%04x", $sec, $w, $h);

  mysql_pconnect(get_oasis_env('oasis_db_host'),
                 get_oasis_env('oasis_db_user'),
                 get_oasis_env('oasis_db_passwd'));

  mysql_select_db("oasis");

  #### ideally, we'd like to use the first key to retrieve the appropriate
  #### creative, but if the user is not accepting cookies, then our
  #### client ID is a bogus one, so we won't find anything in shared
  #### memory; we'll have to fall back on the IP address alone (this
  #### of course, is subject to all sorts of errors -- proxies, etc.)
  if($client != '-')
  {
    $bucket_key = $client . $key_end;
    if($result = mysql_query("select CreativeID from Delivery where IDString='$bucket_key'"))
    {
      list($cr_id) = mysql_fetch_row($result);
      if($cr_id) return $cr_id;

      $fallthrough = 1;
    }
  }
  else
  {
    $nocookie = 1;
  }

  #### OK, either we didn't get a cookie or the lookup based on the cookie
  #### we got didn't work.  So we fall through to using the IP address
  preg_match('#(\d+)\.(\d+)\.(\d+)\.(\d+)#', $ipaddr, $ip);
  $bucket_key = sprintf("%02x%02x%02x%02x", $ip[1], $ip[2], $ip[3], $ip[4])
               . $key_end;

  if($result = mysql_query("select CreativeID from Delivery where IDString='$bucket_key'"))
    list($cr_id) = mysql_fetch_row($result);

  return $cr_id;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function log_msg($user, $ipaddr, $section, $creative_id, $event, $code, $ua)
{
  $log_message = time()
       . "\t$ipaddr\t$user\t$event\t$section\t$creative_id\t$code\t$ua\n";

  #### grab a semaphore; we don't want to write to this log
  #### when another instance of this script is in there
  #### identifier:           O A 0 3
  if(!(($sem_id = sem_get(0x4f410003, 1)) && sem_acquire($sem_id)))
    return 0;

  error_log($log_message, 3, get_oasis_env('oasis_log_dir') . "/oasis.log");

  sem_release($sem_id);
}


?>
