<?php

require("lib-mgmt.inc");
require("lib-report.inc");
set_time_limit(0);

print_html_header($OASISmsg[Reports]);
print_header('Reports', '', '');

if($report_type == 'inventory')
{
  if($SectionID1 == '')
  {
    print "$OASISmsg[error_specify_section]";
    print_footer();
    exit;
  }
  if($Depth1 == '')
  {
    print "$OASISmsg[error_specify_depth]";
    print_footer();
    exit;
  }

  print inventory_report($SectionID1, $Depth1, $date);
}

elseif($report_type)
{
  if($StartDate_Year && $StartDate_Month && $StartDate_Day)
    $StartDate = "$StartDate_Year-$StartDate_Month-$StartDate_Day";
  else
  {
    print "$OASISmsg[error_select_start]";
    print_footer();
    exit;
  }
  if($EndDate_Year && $EndDate_Month && $EndDate_Day)
    $EndDate = "$EndDate_Year-$EndDate_Month-$EndDate_Day";
  else
  {
    print "$OASISmsg[error_select_end]";
    print_footer();
    exit;
  }

  if($report_type == 'revenue')
    print revenue_report($StartDate, $EndDate, get_prefs("RevenueReportClicks"));

  elseif($report_type == 'campaign')
  {
    if($CampaignID == '')
    {
      print "$OASISmsg[error_specify_campaign]";
      print_footer();
      exit;
    }
    print campaign_report($CampaignID, $StartDate, $EndDate);
  }

  elseif($report_type == 'section')
  {
    if($SectionID2 == '')
    {
      print "$OASISmsg[error_specify_section]";
      print_footer();
      exit;
    }
    if($Depth2 == '')
    {
      print "$OASISmsg[error_specify_depth]";
      print_footer();
      exit;
    }

    print section_report($SectionID2, $StartDate, $EndDate, $Depth2);
  }
}
else
{
  build_form_elements();

  print <<<__TEXT__

<TABLE WIDTH=615><TR><TD>
<FONT SIZE="+1"><STRONG>$OASISmsg[Reports]</STRONG></FONT><BR>
<P>

$date_mgmt_script

<FORM METHOD=POST ACTION=report.php NAME=form1>
<TABLE>
<TR>
<TD><INPUT TYPE=radio NAME=report_type VALUE=revenue></TD>
<TD>$OASISmsg[Revenue]</TD>
<TD></TD>
</TR>
<TR>
<TD><INPUT TYPE=radio NAME=report_type VALUE=inventory></TD>
<TD>$OASISmsg[Inventory]</TD>
<TD>$section_dropdown1
$OASISmsg[Depth]: 
<SELECT NAME=Depth1 onChange="document.form1.report_type[1].checked = 1;">
<OPTION SELECTED>
<OPTION VALUE=0>$OASISmsg[All]
<OPTION VALUE=1>1
<OPTION VALUE=2>2
<OPTION VALUE=3>3
<OPTION VALUE=4>4
<OPTION VALUE=5>5
</SELECT>
</TR>
<TR>
<TD><INPUT TYPE=radio NAME=report_type VALUE=campaign></TD>
<TD>$OASISmsg[Campaign]</TD>
<TD>$campaign_dropdown</TD>
</TR>
<TR>
<TD><INPUT TYPE=radio NAME=report_type VALUE=section></TD>
<TD>$OASISmsg[Section]</TD>
<TD>$section_dropdown2
$OASISmsg[Depth]: 
<SELECT NAME=Depth2 onChange="document.form1.report_type[3].checked = 1;">
<OPTION SELECTED>
<OPTION VALUE=0>$OASISmsg[All]
<OPTION VALUE=1>1
<OPTION VALUE=2>2
<OPTION VALUE=3>3
<OPTION VALUE=4>4
<OPTION VALUE=5>5
</SELECT>
</TD>
</TR>
<TR>
<TD></TD>
<TD>$OASISmsg[Start_Date]</TD>
<TD>$startdate_widget</TD>
</TR>
<TR>
<TD></TD>
<TD>$OASISmsg[End_Date]</TD>
<TD>$enddate_widget</TD>
</TR>
<TR>
<TD></TD>
<TD COLSPAN=2>
$date_mgmt_buttons
</TD>
</TR>
<TR>
<TD><BR>&nbsp;</TD>
</TR>
<TR>
<TD COLSPAN=3>
<INPUT TYPE=submit VALUE="$OASISmsg[Build_Report]">
</TD>
</TR>
</TABLE>
</FORM>
</TD></TR></TABLE>
__TEXT__;

}
?>

<?php

print_footer();

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_form_elements()
{
  global $campaign_dropdown, $section_dropdown1, $section_dropdown2;
  global $startdate_widget, $enddate_widget;
  global $OASISmsg;

  if($result = mysql_query("select CampaignID, Name from Campaigns where Status='Active' or Status='Suspended' or (Status='Completed' and EndDate > date_sub(now(), INTERVAL 90 DAY)) order by Name"))
  {
    $a = array();
    while(list($id, $name) = mysql_fetch_row($result)) $a[$id] = $name;
    $campaign_dropdown = build_select($a, 'CampaignID', '', '', '');
    $jscript = 'onChange="document.form1.report_type[2].checked = 1;"';
    $campaign_dropdown = preg_replace('#(<SELECT.+?)>#', "\\1$jscript>", $campaign_dropdown);
  }
  else print "$OASISmsg[MySQL_error]: " . mysql_error() . "<BR>\n";

  if($result = mysql_query("select SectionID, ReportName from Sections order by ReportName"))
  {
    $a = array();
    while(list($id, $name) = mysql_fetch_row($result)) $a[$id] = $name;

    $section_dropdown = build_select($a, 'SectionID1', '', '', '');
    $jscript = 'onChange="document.form1.report_type[1].checked = 1;"';
    $section_dropdown1 = preg_replace('#(<SELECT.+?)>#', "\\1$jscript>", $section_dropdown);

    $section_dropdown = build_select($a, 'SectionID2', '', '', '');
    $jscript = 'onChange="document.form1.report_type[3].checked = 1;"';
    $section_dropdown2 = preg_replace('#(<SELECT.+?)>#', "\\1$jscript>", $section_dropdown);
  }
  else print "$OASISmsg[MySQL_error]: " . mysql_error() . "<BR>\n";

  $now = time();
  if(date('d', $now) < 7)
  {
    $lm = $now - 14 * 86400;
    $sd = date('Y-m-d', mktime(0, 0, 0, date('m', $lm), 1, date('Y', $lm)));
    $ed = date('Y-m-d', mktime(0, 0, 0, date('m', $now), 0, date('Y', $now)));
  }
  else
  {
    $nm = $now + 28 * 86400;
    $sd = date('Y-m-d', mktime(0, 0, 0, date('m', $now), 1, date('Y', $now)));
    $ed = date('Y-m-d', mktime(0, 0, 0, date('m', $nm), 0, date('Y', $nm)));
  }

  $startdate_widget = build_date_widget('StartDate', $sd, 1);
  $enddate_widget   = build_date_widget('EndDate', $ed, 1);
}
?>
